/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.EntityModel;
import cerent.cms.model.IParserIfName;
import cerent.cms.model.InterfaceModel;

public class ParserIfName
implements IParserIfName {
    private int ifVal = 0;
    private int[] parserIfName = new int[]{0, 0, 0, 0, 0};
    private static final int MAX_PORT_TYPE = 3;
    private static final int SHELF_IDX = 0;
    private static final int SLOT_IDX = 1;

    public ParserIfName(EntityModel entityModel) {
        this.ifVal = entityModel.getIndex();
        this.parserIfName[0] = entityModel.getShelfId();
        this.parserIfName[1] = entityModel.getSlot();
        for (int i = 2; i < 5; ++i) {
            this.parserIfName[i] = this.shift(this.ifVal, 5 * (4 - i), 255);
        }
    }

    public ParserIfName(InterfaceModel interfaceModel) {
        this.ifVal = interfaceModel.getIndex();
        this.parserIfName[0] = interfaceModel.getShelfNum();
        this.parserIfName[1] = interfaceModel.getSlotNum();
        for (int i = 2; i < 5; ++i) {
            this.parserIfName[i] = this.shift(this.ifVal, 5 * (4 - i), 255);
        }
    }

    private int shift(int n, int n2, int n3) {
        return n >> n2 & n3;
    }

    public String getAID() {
        StringBuffer stringBuffer = new StringBuffer(this.getEntityType());
        stringBuffer.append("-");
        stringBuffer.append(this.getShelfNum());
        stringBuffer.append("-");
        stringBuffer.append(this.getSlotNum());
        stringBuffer.append("-");
        stringBuffer.append(this.getPortNum());
        stringBuffer.append("-");
        stringBuffer.append(this.getDir());
        return stringBuffer.toString();
    }

    public String getPortName() {
        StringBuffer stringBuffer = new StringBuffer(this.getEntityType());
        stringBuffer.append("-");
        stringBuffer.append(this.getPortNum());
        stringBuffer.append("-");
        stringBuffer.append(this.getDir());
        return stringBuffer.toString();
    }

    public String getEntityType() {
        int n = this.getEntityTypeId();
        if (n == 8) {
            return "LINE";
        }
        if (n == 32) {
            return "BAND";
        }
        return "CHAN";
    }

    public int getEntityTypeVal() {
        return this.getEntityTypeId();
    }

    private int getEntityTypeId() {
        int n = this.ifVal & 0xFFF;
        if (n >= 8 && n < 32) {
            return 8;
        }
        if (n >= 32 && n < 64) {
            return 32;
        }
        if (n >= 64 && n < 128) {
            return 64;
        }
        return 128;
    }

    public String getShelfNum() {
        return new Integer(this.parserIfName[0]).toString();
    }

    public String getSlotNum() {
        return new Integer(this.parserIfName[1]).toString();
    }

    public String getPortNum() {
        return this.getPortNumInt().toString();
    }

    public Integer getPortNumInt() {
        return new Integer(((this.ifVal & 0xFFF) - this.getEntityTypeId() - this.getDirId() + 3) / 2 + this.getDirId() / 3);
    }

    public String getDir() {
        switch (this.getDirId()) {
            case 1: {
                return "RX";
            }
            case 2: {
                return "TX";
            }
            case 3: {
                return "PT";
            }
        }
        return "TX";
    }

    public int getDirId() {
        int n = (this.ifVal - this.getEntityTypeId() & 0xF) % 2;
        if (this.getEntityTypeId() == 128) {
            return 3;
        }
        return n == 0 ? 1 : 2;
    }

    public boolean isPTport() {
        return this.getEntityTypeId() == 128;
    }

    public boolean isLINEport() {
        return this.getEntityTypeId() == 8;
    }

    public boolean isBANDport() {
        return this.getEntityTypeId() == 32;
    }

    public boolean isCHANport() {
        return this.getEntityTypeId() == 64;
    }
}

