/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds1LineModel;
import cerent.cms.model.HoVcatTermModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathTraceSupport;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoPathTraceSupport;
import cerent.cms.model.IPathInfo;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmHoModel;
import cerent.cms.model.ITdmLoModel;
import cerent.cms.model.IVcatTermMember;
import cerent.cms.model.IVcatTermModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidParms;
import cerent.cms.model.LinePathHolder;
import cerent.cms.model.LoVcatTermModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PathTraceInfo;
import cerent.cms.model.PortModel;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmLoModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.VcatTermModelsDelegate;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongPortType;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class PathTraceTable {
    private InterfaceModel[] lineModels;
    private ModuleModel model;
    private ArrayList blsrTdmLinesList;
    private ArrayList blsrLinesList;
    private ArrayList switchedLinePathList;
    private ArrayList hoLoModelsList;
    private static final SDebug db = new SDebug("PathTraceTable");
    private boolean containsVcatCkts = false;
    private HashMap vcatInterfacesMap = null;
    private HashMap portMap = new HashMap();

    public PathTraceTable(ModuleModel moduleModel, InterfaceModel[] interfaceModelArray) {
        this.model = moduleModel;
        this.lineModels = interfaceModelArray;
        this.vcatInterfacesMap = new HashMap();
    }

    public PathTraceInfo[] getJ1PathTraceInfo() throws UnsupportedOperation, InternalCommError, WrongInterfaceType, NoSuchInterface {
        ArrayList arrayList = this.getJ1PathTraceInfoList();
        return arrayList.toArray(new PathTraceInfo[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getJ1PathTraceInfoList() throws UnsupportedOperation, InternalCommError, WrongInterfaceType, NoSuchInterface {
        this.containsVcatCkts = false;
        this.updateBlsrTdmLinesList();
        this.blsrLinesList = new ArrayList();
        ArrayList arrayList = this.getPathTraceInterfaces();
        if (db.on()) {
            db.println("pathTraceLinesList, size = " + arrayList.size());
            db.println("pathTraceLinesList = " + arrayList);
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<PathTraceInfo> arrayList3 = new ArrayList<PathTraceInfo>();
        ArrayList<Object> arrayList4 = arrayList2;
        synchronized (arrayList4) {
            TdmLineModel tdmLineModel;
            int n = 0;
            while (true) {
                PathTraceInfo[] pathTraceInfoArray;
                if (n >= this.blsrLinesList.size()) break;
                tdmLineModel = (TdmLineModel)this.blsrLinesList.get(n);
                if (db.on()) {
                    db.println("need to call getPathTraces for " + tdmLineModel);
                }
                if ((pathTraceInfoArray = tdmLineModel.getPathTracesForPort()) == null) {
                    db.println("getPathTracesForPort() was null");
                } else {
                    int n2;
                    if (db.on()) {
                        db.println("via getPathTracesForPort(), got  " + pathTraceInfoArray.length + " traces");
                        for (n2 = 0; n2 < pathTraceInfoArray.length; ++n2) {
                            db.println("#" + n2 + "  " + pathTraceInfoArray[n2]);
                        }
                    }
                    for (n2 = 0; n2 < pathTraceInfoArray.length; ++n2) {
                        arrayList3.add(pathTraceInfoArray[n2]);
                        for (int i = 0; i < this.switchedLinePathList.size(); ++i) {
                            LinePathHolder linePathHolder = (LinePathHolder)this.switchedLinePathList.get(i);
                            if (linePathHolder.getLineModel() != tdmLineModel || linePathHolder.getHoNum() != pathTraceInfoArray[n2].getStartingNum()) continue;
                            pathTraceInfoArray[n2].setBlsrSwitched(true);
                        }
                        arrayList2.add(pathTraceInfoArray[n2]);
                    }
                }
                ++n;
            }
            n = 0;
            while (true) {
                if (n >= arrayList.size()) {
                    // MONITOREXIT @DISABLED, blocks:[20, 8, 28] lbl42 : MonitorExitStatement: MONITOREXIT : var4_4
                    this.vcatInterfacesMap.clear();
                    return arrayList2;
                }
                tdmLineModel = null;
                int n3 = 0;
                String string = "<unable to retrieve expected path trace from card>";
                String string2 = "<unable to retrieve received path trace from card>";
                char c = '?';
                int n4 = -1;
                IPortModel iPortModel = null;
                int n5 = 0;
                int n6 = -1;
                Object e = arrayList.get(n);
                if (e instanceof TdmHoModel && e instanceof IHoPathTraceSupport) {
                    n3 = 0;
                    tdmLineModel = ((IHoPathTraceSupport)e).getHoPathTraceModel();
                } else if (e instanceof TdmLoModel && e instanceof ILoPathTraceSupport) {
                    n3 = 1;
                    tdmLineModel = ((ILoPathTraceSupport)e).getLoPathTraceModel();
                }
                if (tdmLineModel == null) {
                    db.println("pathTraceModel = null o=" + e.getClass().getName());
                } else {
                    Object object;
                    Object object2;
                    block50: {
                        block49: {
                            block48: {
                                block47: {
                                    block46: {
                                        block45: {
                                            try {
                                                string = new String(tdmLineModel.getExpectedPathTrace());
                                            }
                                            catch (Exception exception) {
                                                if (!db.on()) break block45;
                                                SDebug.printStackTrace((Throwable)exception);
                                            }
                                        }
                                        try {
                                            string2 = new String(tdmLineModel.getReceivedPathTrace());
                                        }
                                        catch (Exception exception) {
                                            if (!db.on()) break block46;
                                            SDebug.printStackTrace((Throwable)exception);
                                        }
                                    }
                                    try {
                                        c = (char)tdmLineModel.getCurrentPayloadLabel();
                                    }
                                    catch (Exception exception) {
                                        if (!db.on()) break block47;
                                        SDebug.printStackTrace((Throwable)exception);
                                    }
                                }
                                try {
                                    n4 = tdmLineModel.getPathTraceMode();
                                }
                                catch (Exception exception) {
                                    if (!db.on()) break block48;
                                    SDebug.printStackTrace((Throwable)exception);
                                }
                            }
                            if (e instanceof ITdmHoModel) {
                                try {
                                    n6 = ((TdmHoModel)e).getStartingHoNumber();
                                }
                                catch (Exception exception) {
                                    if (db.on()) {
                                        SDebug.printStackTrace((Throwable)exception);
                                    }
                                    break block49;
                                }
                            }
                            if (e instanceof ITdmLoModel) {
                                try {
                                    int n7 = this.model.getEqType();
                                    if (n7 == 234) {
                                        IPortModel iPortModel2 = ((ITdmLoModel)e).getPortModel();
                                        if (iPortModel2 != null) {
                                            object2 = iPortModel2.getPortNum();
                                            n6 = object2[0];
                                            break block49;
                                        }
                                        if (db.on()) {
                                            db.println("WBE84 port model is null, using default VT #");
                                        }
                                        break block49;
                                    }
                                    n6 = ((TdmLoModel)e).getStartingLoNumber();
                                }
                                catch (Exception exception) {
                                    if (!db.on()) break block49;
                                    SDebug.printStackTrace((Throwable)exception);
                                }
                            }
                        }
                        if (this.vcatInterfacesMap.containsKey(e)) {
                            this.containsVcatCkts = true;
                            VcatPathTraceInfo vcatPathTraceInfo = (VcatPathTraceInfo)this.vcatInterfacesMap.get(e);
                            iPortModel = vcatPathTraceInfo.port;
                            n5 = vcatPathTraceInfo.memberNumber;
                        } else {
                            iPortModel = (IPortModel)this.portMap.get(e);
                            if (iPortModel == null) {
                                try {
                                    iPortModel = ((InterfaceModel)e).getPortModel();
                                }
                                catch (Exception exception) {
                                    if (!db.on()) break block50;
                                    SDebug.printStackTrace((Throwable)exception);
                                }
                            }
                        }
                    }
                    boolean bl = false;
                    for (int i = 0; i < arrayList3.size(); ++i) {
                        object2 = (PathTraceInfo)arrayList3.get(i);
                        object = ((PathTraceInfo)object2).getPort();
                        int n8 = ((PathTraceInfo)object2).getStartingNum();
                        if (iPortModel == null || !iPortModel.equals(object) || n6 != n8) continue;
                        if (db.on()) {
                            db.println("Ho # " + n6 + " EXP= " + string + " in use; " + " from BLSR fetch; this ho # may be " + " pre-empted, so not displaying");
                        }
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        char[] cArray = string.toCharArray();
                        object2 = string2.toCharArray();
                        if (iPortModel.getModuleModel().getEqType() == 218 && iPortModel.getPortNum()[0] > 28 && n3 == 0) {
                            n6 = 2;
                        }
                        object = new PathTraceInfo(n3, iPortModel, cArray, (char[])object2, c, n4, n6);
                        ((PathTraceInfo)object).setVcatMemberNum(n5);
                        arrayList2.add(object);
                    }
                }
                ++n;
            }
        }
    }

    public boolean containsVcatCkts() {
        return this.containsVcatCkts;
    }

    private void updateBlsrTdmLinesList() {
        int n;
        this.switchedLinePathList = new ArrayList();
        this.blsrTdmLinesList = new ArrayList();
        Set set = ((NodeModelDelegate)this.model.getNodeModel()).getElementModelsDelegate().getBlsrElements();
        BlsrModel[] blsrModelArray = set.toArray(new BlsrModel[set.size()]);
        for (n = 0; n < blsrModelArray.length; ++n) {
            LinePathHolder linePathHolder;
            int n2;
            IPathInfo[] iPathInfoArray;
            TdmLineModel tdmLineModel;
            TdmPortModel tdmPortModel;
            IEntityModel iEntityModel;
            block19: {
                block18: {
                    block17: {
                        if (db.on()) {
                            db.println("BLSR MODEL #" + n);
                        }
                        iEntityModel = null;
                        tdmPortModel = null;
                        try {
                            iEntityModel = blsrModelArray[n].getEastEntityModel();
                            if (iEntityModel instanceof TdmPortModel) {
                                tdmPortModel = (TdmPortModel)iEntityModel;
                                this.blsrTdmLinesList.add(tdmPortModel.getTdmLineModel());
                            }
                        }
                        catch (Exception exception) {
                            if (!db.on()) break block17;
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                    try {
                        iEntityModel = blsrModelArray[n].getWestEntityModel();
                        if (iEntityModel instanceof TdmPortModel) {
                            tdmPortModel = (TdmPortModel)iEntityModel;
                            this.blsrTdmLinesList.add(tdmPortModel.getTdmLineModel());
                        }
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block18;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
                try {
                    iEntityModel = blsrModelArray[n].getEastProtectEntityModel();
                    if (iEntityModel instanceof TdmPortModel) {
                        tdmPortModel = (TdmPortModel)iEntityModel;
                        tdmLineModel = tdmPortModel.getTdmLineModel();
                        this.blsrTdmLinesList.add(tdmLineModel);
                        iPathInfoArray = blsrModelArray[n].getEastProtectHoPaths();
                        for (n2 = 0; n2 < iPathInfoArray.length; ++n2) {
                            linePathHolder = new LinePathHolder(tdmLineModel, iPathInfoArray[n2]);
                            this.switchedLinePathList.add(linePathHolder);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block19;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            try {
                iEntityModel = blsrModelArray[n].getWestProtectEntityModel();
                if (!(iEntityModel instanceof TdmPortModel)) continue;
                tdmPortModel = (TdmPortModel)iEntityModel;
                tdmLineModel = tdmPortModel.getTdmLineModel();
                this.blsrTdmLinesList.add(tdmLineModel);
                iPathInfoArray = blsrModelArray[n].getWestProtectHoPaths();
                for (n2 = 0; n2 < iPathInfoArray.length; ++n2) {
                    linePathHolder = new LinePathHolder(tdmLineModel, iPathInfoArray[n2]);
                    this.switchedLinePathList.add(linePathHolder);
                }
                continue;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (db.on()) {
            db.println("blsrTdmLinesList Contents:");
            for (n = 0; n < this.blsrTdmLinesList.size(); ++n) {
                db.println(n + "\t" + this.blsrTdmLinesList.get(n));
            }
        }
    }

    private ArrayList getPathTraceInterfaces() {
        ArrayList arrayList = new ArrayList();
        if (this.model != null && this.lineModels.length > 0 && this.model.supportsJ1PathTrace(this.lineModels)) {
            int n = this.model.getEqType();
            switch (n) {
                case 157: {
                    if (this.lineModels[0] instanceof Ds1LineModel) {
                        arrayList = this.getDs1Ho((Ds123LineModel[])this.lineModels);
                        break;
                    }
                    arrayList = this.getGenericHo(this.lineModels);
                    break;
                }
                case 233: 
                case 234: {
                    if (this.lineModels[0] instanceof Ds1LineModel) {
                        arrayList = this.getDs1E1Ho((Ds123LineModel[])this.lineModels);
                        break;
                    }
                    arrayList = this.getGenericHo(this.lineModels);
                    break;
                }
                case 4: 
                case 5: 
                case 34: 
                case 47: {
                    arrayList = this.getDs1Ho((Ds123LineModel[])this.lineModels);
                    break;
                }
                case 218: {
                    arrayList = this.getDs1E1Ho((Ds123LineModel[])this.lineModels);
                    break;
                }
                case 108: 
                case 109: {
                    arrayList = this.getE1_42Interfaces((Ds123LineModel[])this.lineModels);
                    break;
                }
                case 8: 
                case 145: {
                    arrayList = this.getDs3XmHo((Ds123LineModel[])this.lineModels);
                    break;
                }
                case 62: 
                case 63: 
                case 102: 
                case 103: 
                case 143: 
                case 163: 
                case 164: 
                case 187: 
                case 221: 
                case 229: 
                case 238: {
                    arrayList = this.getGenericAndVcatModels(this.lineModels);
                    break;
                }
                default: {
                    arrayList = this.getGenericHo(this.lineModels);
                }
            }
        }
        return arrayList;
    }

    private ArrayList getDs1E1Ho(Ds123LineModel[] ds123LineModelArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<ITdmHoModel> arrayList2 = new ArrayList<ITdmHoModel>();
        if (ds123LineModelArray != null && ds123LineModelArray.length > 0) {
            for (int i = 0; i < ds123LineModelArray.length; ++i) {
                List list = ds123LineModelArray[i].getConnectionsList();
                ITdmHoModel iTdmHoModel = null;
                boolean bl = false;
                for (int j = 0; j < list.size(); ++j) {
                    if (list.get(j) instanceof IHoConnectionModel && !bl) {
                        try {
                            int n = Model.getFramingType(this.model.getNodeModel()).getEnum();
                            IPortModel iPortModel = ds123LineModelArray[i].getPortModel();
                            IHoNum iHoNum = HoLoFactory.ho2HoNum(n, i / 28 + 1);
                            iTdmHoModel = iPortModel.getTdmHoModel(iHoNum);
                            if (iTdmHoModel == null || arrayList.contains(iTdmHoModel)) continue;
                            arrayList.add(iTdmHoModel);
                        }
                        catch (Exception exception) {
                            db.println("Caught exception in getDs1E1Ho!");
                            if (!db.on()) continue;
                            SDebug.printStackTrace((Throwable)exception);
                        }
                        continue;
                    }
                    if (!(list.get(j) instanceof ILoConnectionModel)) continue;
                    InterfaceModel[] interfaceModelArray = ds123LineModelArray[i].getHigherLayerModels();
                    for (int k = 0; k < interfaceModelArray.length; ++k) {
                        if (!(interfaceModelArray[k] instanceof ITdmLoModel) || arrayList.contains(interfaceModelArray[k])) continue;
                        arrayList.add(interfaceModelArray[k]);
                        if (iTdmHoModel != null) {
                            arrayList2.add(iTdmHoModel);
                            continue;
                        }
                        bl = true;
                    }
                }
            }
            arrayList.removeAll(arrayList2);
        }
        return arrayList;
    }

    private ArrayList getDs3XmHo(Ds123LineModel[] ds123LineModelArray) {
        ArrayList<ITdmHoModel> arrayList = new ArrayList<ITdmHoModel>();
        if (ds123LineModelArray != null && ds123LineModelArray.length > 0) {
            for (int i = 0; i < ds123LineModelArray.length; ++i) {
                List list;
                block6: {
                    list = ds123LineModelArray[i].getConnectionsList();
                    if (list.size() <= 0) continue;
                    if (list.get(0) instanceof IHoConnectionModel || this.model.getEqType() == 8) {
                        try {
                            int n = Model.getFramingType(this.model.getNodeModel()).getEnum();
                            IPortModel iPortModel = ds123LineModelArray[i].getPortModel();
                            IHoNum iHoNum = HoLoFactory.ho2HoNum(n, 1);
                            ITdmHoModel iTdmHoModel = iPortModel.getTdmHoModel(iHoNum);
                            if (iTdmHoModel != null) {
                                arrayList.add(iTdmHoModel);
                            }
                        }
                        catch (Exception exception) {
                            db.println("Caught exception in getDs3XmHo!");
                            if (!db.on()) break block6;
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                }
                if (this.model.getEqType() != 145 || !(list.get(0) instanceof ILoConnectionModel) && (i <= 11 || i % 2 != 0)) continue;
                this.hoLoModelsList = new ArrayList();
                this.recursiveGetHoLo(this.lineModels[i]);
                arrayList.addAll(this.hoLoModelsList);
            }
        }
        return arrayList;
    }

    private ArrayList getE1_42Interfaces(Ds123LineModel[] ds123LineModelArray) {
        InterfaceModel[] interfaceModelArray;
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (ds123LineModelArray == null || ds123LineModelArray.length == 0) {
            return arrayList;
        }
        for (n = 0; n < ds123LineModelArray.length; ++n) {
            interfaceModelArray = ds123LineModelArray[n].getConnectionsList();
            if (interfaceModelArray.size() <= 0 || !(interfaceModelArray.get(0) instanceof IHoConnectionModel)) continue;
            try {
                int n2 = Model.getFramingType(this.model.getNodeModel()).getEnum();
                IPortModel iPortModel = ds123LineModelArray[n].getPortModel();
                IHoNum iHoNum = HoLoFactory.ho2HoNum(n2, 1);
                ITdmHoModel iTdmHoModel = iPortModel.getTdmHoModel(iHoNum);
                arrayList.add(iTdmHoModel);
                break;
            }
            catch (Exception exception) {
                db.println("Caught exception in getE1_42Interfaces!");
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        for (n = 0; n < ds123LineModelArray.length; ++n) {
            interfaceModelArray = ds123LineModelArray[n].getHigherLayerModels();
            if (interfaceModelArray == null || interfaceModelArray.length == 0 || !(interfaceModelArray[0] instanceof ITdmLoModel)) continue;
            arrayList.add(interfaceModelArray[0]);
        }
        return arrayList;
    }

    private ArrayList getDs1Ho(Ds123LineModel[] ds123LineModelArray) {
        ArrayList<ITdmHoModel> arrayList;
        block5: {
            arrayList = new ArrayList<ITdmHoModel>();
            if (ds123LineModelArray != null && ds123LineModelArray.length > 0) {
                List list;
                int n;
                int n2 = 0;
                for (n = 0; n < ds123LineModelArray.length; ++n) {
                    list = ds123LineModelArray[n].getConnectionsList();
                    if (list.size() <= 0 || !(list.get(0) instanceof IHoConnectionModel)) continue;
                    ++n2;
                }
                if (n2 == ds123LineModelArray.length) {
                    try {
                        n = Model.getFramingType(this.model.getNodeModel()).getEnum();
                        list = ds123LineModelArray[0].getPortModel();
                        IHoNum iHoNum = HoLoFactory.ho2HoNum(n, 1);
                        ITdmHoModel iTdmHoModel = list.getTdmHoModel(iHoNum);
                        arrayList.add(iTdmHoModel);
                    }
                    catch (Exception exception) {
                        db.println("Caught exception in getDs1Ho");
                        if (!db.on()) break block5;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
        }
        return arrayList;
    }

    private ArrayList getGenericLineHo(InterfaceModel[] interfaceModelArray) {
        ArrayList<InterfaceModel> arrayList = new ArrayList<InterfaceModel>();
        if (interfaceModelArray != null && interfaceModelArray.length > 0) {
            for (int i = 0; i < interfaceModelArray.length; ++i) {
                List list = interfaceModelArray[i].getConnectionsList();
                if (list.size() <= 0) continue;
                arrayList.add(interfaceModelArray[i]);
            }
        }
        return arrayList;
    }

    private ArrayList getGenericAndVcatModels(InterfaceModel[] interfaceModelArray) {
        this.portMap = new HashMap();
        ArrayList<IInterfaceModel> arrayList = new ArrayList<IInterfaceModel>();
        this.vcatInterfacesMap.clear();
        for (int i = 0; i < interfaceModelArray.length; ++i) {
            VcatPathTraceInfo vcatPathTraceInfo;
            IVcatTermMember[] iVcatTermMemberArray;
            IPortModel iPortModel = null;
            try {
                iPortModel = interfaceModelArray[i].getPortModel();
            }
            catch (Exception exception) {
                db.println("Caught exception in getGenericAndVcatModels");
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
                continue;
            }
            NodeModelDelegate nodeModelDelegate = this.model.getNodeModelDelegate();
            VcatTermModelsDelegate vcatTermModelsDelegate = (VcatTermModelsDelegate)nodeModelDelegate.getVcatTermModels();
            IVcatTermModel iVcatTermModel = vcatTermModelsDelegate.getVcatTermModelForPort(iPortModel.getIndex());
            if (iVcatTermModel == null) {
                iVcatTermMemberArray = interfaceModelArray[i].getConnectionsList();
                if (iVcatTermMemberArray.size() <= 0) continue;
                IInterfaceModel iInterfaceModel = null;
                iInterfaceModel = iVcatTermMemberArray.get(0) instanceof IHoConnectionModel ? interfaceModelArray[i].getHoIfModelFromMemberId((short)0) : interfaceModelArray[i].getLoIfModelFromMemberId((short)0);
                if (iInterfaceModel == null) continue;
                arrayList.add(iInterfaceModel);
                this.portMap.put(iInterfaceModel, iPortModel);
                continue;
            }
            short s = 0;
            IInterfaceModel iInterfaceModel = null;
            if (iVcatTermModel instanceof HoVcatTermModel) {
                try {
                    iVcatTermMemberArray = ((HoVcatTermModel)iVcatTermModel).getMembersOfTheVcatTerm(2);
                }
                catch (InvalidParms invalidParms) {
                    iVcatTermMemberArray = null;
                    if (!db.on()) continue;
                    db.println("getGenericAndVcatModels(): Members list empty for term model -" + iVcatTermModel);
                    SDebug.printStackTrace((Throwable)invalidParms);
                    continue;
                }
                for (int j = 0; j < iVcatTermMemberArray.length; ++j) {
                    s = iVcatTermMemberArray[j].getMemberNumber();
                    iInterfaceModel = interfaceModelArray[i].getHoIfModelFromMemberId(s);
                    if (iInterfaceModel == null) continue;
                    arrayList.add(iInterfaceModel);
                    vcatPathTraceInfo = new VcatPathTraceInfo(s, iPortModel);
                    this.vcatInterfacesMap.put(iInterfaceModel, vcatPathTraceInfo);
                }
                continue;
            }
            if (!(iVcatTermModel instanceof LoVcatTermModel)) continue;
            try {
                iVcatTermMemberArray = ((LoVcatTermModel)iVcatTermModel).getMembersOfTheVcatTerm(2);
            }
            catch (InvalidParms invalidParms) {
                iVcatTermMemberArray = null;
                if (!db.on()) continue;
                db.println("getGenericAndVcatModels(): Members list empty for term model -" + iVcatTermModel);
                SDebug.printStackTrace((Throwable)invalidParms);
                continue;
            }
            for (int j = 0; j < iVcatTermMemberArray.length; ++j) {
                s = iVcatTermMemberArray[j].getMemberNumber();
                iInterfaceModel = interfaceModelArray[i].getLoIfModelFromMemberId(s);
                if (iInterfaceModel == null) continue;
                arrayList.add(iInterfaceModel);
                vcatPathTraceInfo = new VcatPathTraceInfo(s, iPortModel);
                this.vcatInterfacesMap.put(iInterfaceModel, vcatPathTraceInfo);
            }
        }
        return arrayList;
    }

    private void recursiveGetHoLo(InterfaceModel interfaceModel) {
        if (interfaceModel == null) {
            return;
        }
        InterfaceModel[] interfaceModelArray = interfaceModel.getHigherLayerModels();
        if (interfaceModel instanceof ITdmLoModel) {
            block12: {
                try {
                    IPortModel iPortModel;
                    if (interfaceModelArray.length > 1) {
                        db.println("more than one TdmLoModel mapped to by a non-optical port model: " + interfaceModelArray.length);
                    }
                    if ((iPortModel = ((ITdmLoModel)interfaceModel).getPortModel()) instanceof PortModel) {
                        ((PortModel)iPortModel).supportsLoCircuitsCheck();
                    }
                    this.hoLoModelsList.add(interfaceModel);
                    if (db.on()) {
                        db.println(" added ITdmLoModel: " + interfaceModel);
                    }
                }
                catch (WrongPortType wrongPortType) {
                    db.println(" failed to add ITdmLoModel: " + interfaceModel + "\t" + "but is ok; it is not right port type");
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.println("Caught NoSuchEntity in recursiveGetHoLo");
                    if (!db.on()) break block12;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            return;
        }
        if (interfaceModelArray == null || interfaceModelArray.length == 0) {
            if (interfaceModel instanceof ITdmHoModel) {
                this.hoLoModelsList.add(interfaceModel);
                if (db.on()) {
                    db.println(" added ITdmHoModel: " + interfaceModel);
                }
            }
            return;
        }
        for (int i = 0; i < interfaceModelArray.length; ++i) {
            this.recursiveGetHoLo(interfaceModelArray[i]);
        }
    }

    private ArrayList getGenericHo(InterfaceModel[] interfaceModelArray) {
        int n;
        ArrayList arrayList = new ArrayList();
        if (interfaceModelArray != null && interfaceModelArray.length > 0) {
            for (n = 0; n < interfaceModelArray.length; ++n) {
                if (this.blsrTdmLinesList.contains(interfaceModelArray[n])) {
                    this.blsrLinesList.add(interfaceModelArray[n]);
                    if (db.on()) {
                        db.println("added " + interfaceModelArray[n] + " as a BLSR " + "line to use the getPathTracesForPort()");
                    }
                }
                this.hoLoModelsList = new ArrayList();
                this.recursiveGetHoLo(interfaceModelArray[n]);
                arrayList.addAll(this.hoLoModelsList);
            }
        }
        if (db.on()) {
            for (n = 0; n < arrayList.size(); ++n) {
                db.println("holomodel #" + n + "\t" + arrayList.get(n) + "\t" + arrayList.get(n).toString());
            }
        }
        return arrayList;
    }

    public synchronized void refreshMyLines(InterfaceModel[] interfaceModelArray) {
        this.lineModels = interfaceModelArray;
    }

    private class VcatPathTraceInfo {
        int memberNumber = 0;
        IPortModel port;

        public VcatPathTraceInfo(int n, IPortModel iPortModel) {
            this.memberNumber = n;
            this.port = iPortModel;
        }
    }
}

