/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.idl.SonetMedia.Pool;
import cerent.cms.idl.SonetMedia.sBundleInfo;
import cerent.cms.idl.SonetMedia.sPathInfo;
import cerent.cms.idl.SonetMedia.sPoolAttributes;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.BundleInfoFactory;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CloneHelper;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.ElementModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.FramingType;
import cerent.cms.model.IBundleInfo;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathInfo;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.LoConnectionModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PathInfo;
import cerent.cms.model.PathInfoFactory;
import cerent.cms.model.PoolModelsDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.model.ucp.IUcpCircuitOriginModel;
import cerent.cms.model.ucp.IUcpCircuitTerminationModel;
import cerent.util.EnumStrings;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeSet;
import org.omg.CORBA.UserException;

public class PoolModel
extends Model
implements IPoolModel {
    private static final short UNIT_HO_WIDTH = 1;
    private static final short STS1_WIDTH = 1;
    private static final short STS3C_WIDTH = 3;
    private static final int[] sts6cRemovals = new int[]{10, 22, 34, 46, 58, 70, 82, 94, 106, 118, 130, 142, 154, 166, 178, 190};
    private static final int[] sts9cRemovals = new int[]{7, 10, 19, 22, 31, 34, 43, 46, 55, 58, 67, 70, 79, 82, 91, 94, 103, 106, 115, 118, 127, 130, 139, 142, 151, 154, 163, 166, 175, 178, 187, 190};
    private static final int[] sts9c192Removals = new int[]{7, 22, 31, 34, 43, 58, 67, 70, 79, 94, 103, 106, 115, 130, 139, 142, 151, 166, 175, 178, 187, 190};
    private static final int[] sts24cRemovals = new int[]{28, 31, 34, 37, 40, 43, 46, 76, 79, 82, 85, 88, 91, 94, 124, 127, 130, 133, 136, 139, 142, 172, 175, 178, 181, 184, 187, 190};
    protected static final Integer[] integerArrayTemplate = new Integer[0];
    protected static final HoLoComparator holoComp = HoLoComparator.instance();
    private ContainerName containerName;
    private Bundle1 bundle1;
    private BundleOnePlusOne bundleOnePlusOne;
    private ObjIndex objIndex = null;
    private ConnectedPaths connectedPaths;
    private BiggestPathAvailable biggestPathAvailable;
    private IncludedPath includedPath;
    private AvailablePaths availablePaths;
    private AvailableVcatPaths availableVcatPaths;
    private AddConnectedPath addConnectedPath;
    private RemoveConnectedPath removeConnectedPath;
    private NodeModelDelegate node;
    private Pool poolRef;
    private EventDispatcher dispatcher;
    private EntityModel protectEntity = null;
    private ElementModel container = null;
    private ILoAditModel[] aditModels = null;
    private IPathInfo[] availPaths = null;
    private short cachedWidth = (short)-1;
    private List portsList = new LinkedList();
    private boolean isInitedRealState;

    public PoolModel(NodeModelDelegate nodeModelDelegate, sPoolAttributes sPoolAttributes2, ElementModel elementModel) {
        super(nodeModelDelegate.getChildDebug(PoolModel.class));
        this.node = nodeModelDelegate;
        this.poolRef = sPoolAttributes2.poolRef;
        this.setContainer(elementModel);
        this.containerName = new ContainerName(nodeModelDelegate, "PoolModel.containerName");
        this.bundle1 = new Bundle1(nodeModelDelegate, "PoolModel.bundle1");
        this.bundleOnePlusOne = new BundleOnePlusOne(nodeModelDelegate, "PoolModel.bundleOnePlusOne");
        this.connectedPaths = new ConnectedPaths(nodeModelDelegate, "PoolModel.connectedPaths");
        this.biggestPathAvailable = new BiggestPathAvailable(nodeModelDelegate, "PoolModel.biggestPathAvailable");
        this.includedPath = new IncludedPath(nodeModelDelegate, "PoolModel.includedPath");
        this.availablePaths = new AvailablePaths(nodeModelDelegate, "PoolModel.availablePaths");
        this.availableVcatPaths = new AvailableVcatPaths(nodeModelDelegate, "PoolModel.AvailableVcatPaths");
        this.addConnectedPath = new AddConnectedPath(nodeModelDelegate, "PoolModel.addConnectedPath");
        this.removeConnectedPath = new RemoveConnectedPath(nodeModelDelegate, "PoolModel.removeConnectedPath");
        this.objIndex = new ObjIndex(nodeModelDelegate, "PoolModel.ObjIndex");
        this.setAttributes(sPoolAttributes2);
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initReal() {
        block8: {
            if (this.db.on()) {
                this.db.println("PoolModel::init() Entry");
            }
            this.isInitedRealState = true;
            this.dispatcher = this.node.getDispatcher();
            PoolModel poolModel = this;
            synchronized (poolModel) {
                this.setContainer(null);
                this.aditModels = null;
                this.availPaths = null;
                this.cachedWidth = (short)-1;
            }
            this.index = this.getObjIndex();
            this.init0();
            try {
                if (this.dispatcher != null) {
                    this.dispatcher.addObserver(ObjectType.ObjectSonetPool, this.getObjIndex(), (Observer)this);
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!this.db.on()) break block8;
                this.db.println("IO Exception while initializing Pool " + (Object)((Object)abstractCmsIOException));
            }
        }
        if (this.db.on()) {
            this.db.println("PoolModel::init() Exit");
        }
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLocal() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        if (this.db.on) {
            this.db.println("PoolModel Update Local called:" + Integer.toHexString(this.index));
        }
        PoolModel poolModel = this;
        synchronized (poolModel) {
            this.setContainer(null);
            this.aditModels = null;
            this.availPaths = null;
            this.cachedWidth = (short)-1;
            this.protectEntity = null;
        }
        this.biggestPathAvailable.update();
        this.bundle1.update();
        this.bundleOnePlusOne.update();
        this.connectedPaths.update();
        this.containerName.update();
        this.includedPath.update();
    }

    private ElementModel getContainer() throws AbstractCmsNoSuchElementException {
        if (this.db.on) {
            this.db.println("[" + Integer.toHexString(this.index) + "] calling getContainer");
        }
        if (this.container == null) {
            this.setContainer(this.node.getElementModelsDelegate().getElementModel(this));
            if (this.db.on) {
                this.db.println("found container " + this.container);
            }
        } else if (this.db.on) {
            this.db.println("Using cached container: " + this.container);
        }
        return this.container;
    }

    public Pool getPoolRef() throws CmsObjectNotExistException {
        if (this.poolRef == null) {
            throw new CmsObjectNotExistException("Pool reference is null");
        }
        return this.poolRef;
    }

    public IBundleInfo bundle1() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            sBundleInfo sBundleInfo2 = (sBundleInfo)this.bundle1.get();
            return BundleInfoFactory.getIBundleInfo(sBundleInfo2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IBundleInfo bundleOnePlusOne() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            sBundleInfo sBundleInfo2 = (sBundleInfo)this.bundleOnePlusOne.get();
            return BundleInfoFactory.getIBundleInfo(sBundleInfo2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IEntityModel getEntityModel() throws AbstractCmsNoSuchEntityException {
        ElementModel elementModel;
        try {
            elementModel = this.getContainer();
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            throw new CmsNoSuchEntityException("Entity not exist because its container could not be found:" + abstractCmsNoSuchElementException.toString());
        }
        EntityModel entityModel = elementModel instanceof BlsrModel ? ((BlsrModel)elementModel).getEntityModelForPool(this) : (EntityModel)elementModel.getEntityModel();
        this.updatePortsList(entityModel);
        return entityModel;
    }

    public int getEntityIndex() {
        int n = -1;
        try {
            IEntityModel iEntityModel = this.getEntityModel();
            if (iEntityModel != null) {
                return iEntityModel.getIndex();
            }
            return n;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on) {
                this.db.println("Cannot find Entity Index for pool" + this);
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return n;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.db.on) {
                this.db.println("Cannot find Entity Index for pool" + this);
                SDebug.printStackTrace((Throwable)illegalArgumentException);
            }
            return n;
        }
    }

    public IEntityModel getProtectEntity() throws AbstractCmsNoSuchEntityException {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        if (this.protectEntity == null && this.bundleOnePlusOne() != null) {
            this.protectEntity = (EntityModel)this.node.getEntityTableModel().getEntityModelByIndex(this.bundleOnePlusOne().getIndex());
        }
        return this.protectEntity;
    }

    public int getProtectEntityIndex() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        if (this.bundleOnePlusOne() != null) {
            return this.bundleOnePlusOne().getIndex();
        }
        return -1;
    }

    public boolean containsEntity(int n) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return this.getEntityIndex() == n || this.getProtectEntityIndex() == n;
    }

    public int getObjIndex() throws AbstractCmsIOException {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            return (Integer)this.objIndex.get();
        }
        catch (UserException userException) {
            this.db.println("user exception in getObjIndex");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    private synchronized void setContainer(ElementModel elementModel) {
        if (this.db.on) {
            this.db.println("[" + Integer.toHexString(this.index) + "] setContainer(" + elementModel + ")");
        }
        if (this.container != null) {
            this.container.deleteObserver(this);
        }
        this.container = elementModel;
        if (this.container != null) {
            this.container.addObserver(this);
        }
    }

    public void setAttributes(sPoolAttributes sPoolAttributes2) {
        this.objIndex.setValueExternally(new Integer(sPoolAttributes2.objIndex));
        if (!this.isInitedRealState) {
            this.initReal();
        }
        this.biggestPathAvailable.setValueExternally(new Short(sPoolAttributes2.biggestPathAvailable));
        this.bundle1.setValueExternally(sPoolAttributes2.bundle1);
        this.bundleOnePlusOne.setValueExternally(sPoolAttributes2.bundleOnePlusOne);
        this.includedPath.setValueExternally(sPoolAttributes2.includedPath);
        this.connectedPaths.setValueExternally(sPoolAttributes2.connectedPaths);
        this.poolRef = sPoolAttributes2.poolRef;
    }

    public IPathInfo[] connectedPaths() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            sPathInfo[] sPathInfoArray = (sPathInfo[])this.connectedPaths.get();
            int n = this.getNodeModel().getFramingType();
            return PathInfoFactory.getIPathInfoArray(sPathInfoArray, n);
        }
        catch (UserException userException) {
            return null;
        }
    }

    protected List getConnectionsList(IPortModel iPortModel) {
        int n;
        this.db.info("getConns on Port = " + iPortModel);
        if (!this.isInitedRealState) {
            this.initReal();
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        IConnectionModels iConnectionModels = this.node.getConnectionModels();
        IHoConnectionModel[] iHoConnectionModelArray = iConnectionModels.getHoConnectionModels();
        int n2 = iHoConnectionModelArray.length;
        for (int i = 0; i < n2; ++i) {
            try {
                IHoPathDefModel[] iHoPathDefModelArray = iHoConnectionModelArray[i].getPaths();
                n = iHoPathDefModelArray.length;
                for (int j = 0; j < n; ++j) {
                    IPoolModel iPoolModel = iHoPathDefModelArray[j].getPool();
                    if (!this.equals(iPoolModel)) continue;
                    hashSet.add(iHoConnectionModelArray[i]);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.db.info("Found " + hashSet.size() + " STS Conns");
        ILoConnectionModel[] iLoConnectionModelArray = iConnectionModels.getLoConnectionModels();
        int n3 = iLoConnectionModelArray.length;
        block10: for (n = 0; n < n3; ++n) {
            if (iPortModel == null) {
                ILoDefModel[] iLoDefModelArray;
                try {
                    iLoDefModelArray = iLoConnectionModelArray[n].getPaths();
                }
                catch (Exception exception) {
                    continue;
                }
                int n4 = iLoDefModelArray.length;
                for (int i = 0; i < n4; ++i) {
                    try {
                        ILoAditModel iLoAditModel = iLoDefModelArray[i].getLoAdit();
                        IHoPathDefModel iHoPathDefModel = iLoAditModel.getHo();
                        IPoolModel iPoolModel = iHoPathDefModel.getPool();
                        if (!this.equals(iPoolModel) && this.getEntityIndex() != iLoDefModelArray[i].getPortIndex()) continue;
                        if (iPortModel == null) {
                            hashSet.add(iLoConnectionModelArray[n]);
                            continue block10;
                        }
                        PortModel portModel = null;
                        try {
                            portModel = (PortModel)this.node.getEntityTableModel().getEntityModelByIndex(iLoDefModelArray[i].getPortIndex());
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            hashSet.add(iLoConnectionModelArray[n]);
                            continue block10;
                        }
                        if (portModel == null) {
                            hashSet.add(iLoConnectionModelArray[n]);
                            continue block10;
                        }
                        if (!iPortModel.getPortNum().equals(portModel.getPortNum())) continue;
                        hashSet.add(iLoConnectionModelArray[n]);
                        continue block10;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                continue;
            }
            List list = ((LoConnectionModel)iLoConnectionModelArray[n]).getPortModels();
            if (!list.contains(iPortModel)) continue;
            this.db.info("VtConn contains actualPort");
            hashSet.add(iLoConnectionModelArray[n]);
        }
        this.db.info("getConnectionsList returned " + hashSet.size());
        return new LinkedList(hashSet);
    }

    protected List getConnectionsList() {
        return this.getConnectionsList(null);
    }

    public short biggestPathAvailable() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            return (Short)this.biggestPathAvailable.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public IPathInfo includedPath() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            sPathInfo sPathInfo2 = (sPathInfo)this.includedPath.get();
            sPathInfo2.startingSts = (short)(sPathInfo2.startingSts + 1);
            int n = this.getNodeModel().getFramingType();
            return PathInfoFactory.getIPathInfo(sPathInfo2, n);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public synchronized IPathInfo[] getAvailablePaths(short s) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        if (this.db.on) {
            this.db.println("GetAvailablePaths called for width " + s + " for Pool with Index " + Integer.toHexString(this.getEntityIndex()));
        }
        if (s != this.cachedWidth || this.availPaths == null) {
            try {
                sPathInfo[] sPathInfoArray = (sPathInfo[])this.availablePaths.get(new Short(s));
                if (this.db.on) {
                    this.db.println("sPathInfo[] size = " + sPathInfoArray.length);
                }
                int n = this.getNodeModel().getFramingType();
                this.availPaths = PathInfoFactory.getIPathInfoArray(sPathInfoArray, n);
                this.cachedWidth = s;
            }
            catch (UserException userException) {
                SDebug.printStackTrace((Throwable)userException);
                this.cachedWidth = (short)-1;
                this.availPaths = null;
            }
            catch (RuntimeException runtimeException) {
                this.cachedWidth = (short)-1;
                this.availPaths = null;
                throw runtimeException;
            }
        }
        return this.availPaths;
    }

    public synchronized IPathInfo[] getAvailableVcatPaths(short s, short s2) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        if (this.db.on) {
            this.db.println("GetAvailableVcatPaths called for width " + s + " and numOfMems " + s2 + " for Pool with Index " + Integer.toHexString(this.getEntityIndex()));
        }
        IPathInfo[] iPathInfoArray = null;
        try {
            Object[] objectArray = new Object[]{new Short(s), new Short(s2)};
            sPathInfo[] sPathInfoArray = (sPathInfo[])this.availableVcatPaths.get(objectArray);
            if (this.db.on) {
                this.db.println("sPathInfo[] size = " + sPathInfoArray.length);
            }
            int n = this.getNodeModel().getFramingType();
            iPathInfoArray = PathInfoFactory.getIPathInfoArray(sPathInfoArray, n);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        return iPathInfoArray;
    }

    protected ICircuitSize width2Size(int n) {
        int n2 = this.getNodeModel().getFramingType();
        return CircuitSize.width2sizeOfHoCircuit((int)n, (int)n2);
    }

    public IHoNum getLUBHoSize() {
        int n = this.getNodeModel().getFramingType();
        IFramingType iFramingType = FramingType.getFramingType((int)n);
        short s = (short)iFramingType.getMinimumHoPathWidth();
        IHoNum iHoNum = this.getLUBHoSizeConnectedAvailable(s);
        return iHoNum;
    }

    protected IHoNum getLUBHoSizeConnectedAvailable(int n) {
        int n2;
        IPathInfo[] iPathInfoArray = this.getAvailablePaths((short)n);
        IPathInfo[] iPathInfoArray2 = this.connectedPaths();
        IUcpCircuitOriginModel[] iUcpCircuitOriginModelArray = this.node.getUcpCircuits().getCircuitOriginList();
        IUcpCircuitTerminationModel[] iUcpCircuitTerminationModelArray = this.node.getUcpCircuits().getCircuitTerminationList();
        IHoNum iHoNum = null;
        for (n2 = 0; n2 < iPathInfoArray.length; ++n2) {
            if (holoComp.compare(iPathInfoArray[n2].getEndingHo(), iHoNum) <= 0) continue;
            iHoNum = iPathInfoArray[n2].getEndingHo();
        }
        for (n2 = 0; n2 < iPathInfoArray2.length; ++n2) {
            if (holoComp.compare(iPathInfoArray2[n2].getEndingHo(), iHoNum) <= 0) continue;
            iHoNum = iPathInfoArray2[n2].getEndingHo();
        }
        return iHoNum;
    }

    public int getMaxStsSize() {
        throw new DeprecatedMethodCalled("FTG deprecated IPoolModel.getMaxStsSize()");
    }

    public Integer[] getSizeArray() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        IHoNum iHoNum = this.getLUBHoSize();
        int n = 1;
        try {
            n = this.getEntityModel().getMediumType();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            // empty catch block
        }
        ICircuitSize[] iCircuitSizeArray = CircuitSize.getAllCircuitSizes();
        int n2 = this.getNodeModel().getFramingType();
        for (int i = 0; i < iCircuitSizeArray.length; ++i) {
            ICircuitSize iCircuitSize = iCircuitSizeArray[i];
            if (iCircuitSize.isLo(n2) || !(n != 1 ^ iCircuitSize.isSonetTerminationSize()) || iHoNum.getHoNum() < iCircuitSize.getFramingTypeHoPathWidth(n2)) continue;
            treeSet.add(new Integer(iCircuitSize.getEnum()));
        }
        return treeSet.toArray(integerArrayTemplate);
    }

    private static void removeIntersecting(List list, List list2, int n, int n2, int n3) {
        int n4 = n + n2 - 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IPathInfo iPathInfo = (IPathInfo)iterator.next();
            short s = iPathInfo.getStartingHo().getIdlHoNum();
            int n5 = s + iPathInfo.getPathWidth() * n3 - 1;
            if (!(n4 >= s && s >= n || n4 >= n5 && n5 >= n || n5 >= n && n >= s) && (n5 < n4 || n4 < s) || list2.contains(iPathInfo)) continue;
            list2.add(iPathInfo);
        }
    }

    private boolean needToRemove(int n, int n2) {
        short s = this.getLUBHoSize().getHoNum();
        int n3 = 0;
        int n4 = 0;
        n3 = n == 6 ? sts6cRemovals.length : (n == 9 ? (s == 192 ? sts9c192Removals.length : sts9cRemovals.length) : sts24cRemovals.length);
        for (int i = 0; i < n3; ++i) {
            n4 = n == 6 ? sts6cRemovals[i] : (n == 9 ? (s == 192 ? sts9c192Removals[i] : sts9cRemovals[i]) : sts24cRemovals[i]);
            if (n2 != n4) continue;
            return true;
        }
        return false;
    }

    public IPathInfo[] getUcpAvailablePaths(short s) {
        int n;
        int n2;
        IPathInfo iPathInfo;
        short s2;
        IUcpCircuitOriginModel[] iUcpCircuitOriginModelArray = this.node.getUcpCircuits().getCircuitOriginList();
        IUcpCircuitTerminationModel[] iUcpCircuitTerminationModelArray = this.node.getUcpCircuits().getCircuitTerminationList();
        IHoNum iHoNum = this.getLUBHoSizeConnectedAvailable(s);
        IFramingType iFramingType = this.node.getFramingTypeObj();
        int n3 = iFramingType.getEnum();
        int n4 = iFramingType.getMinimumHoPathWidth();
        int n5 = iFramingType.getFramingTypeHoPathWidth((int)s);
        int n6 = 1;
        n6 = s == 12 || s == 48 ? n5 : (s > 1 && n4 == 1 ? 3 : 1);
        ArrayList<PathInfo> arrayList = new ArrayList<PathInfo>();
        IHoNum iHoNum2 = HoLoFactory.addOffset(iHoNum, -n5 + 1);
        Object object = HoLoFactory.createFirstHoNum(n3);
        while (holoComp.compare(iHoNum2, object) >= 0) {
            arrayList.add(new PathInfo((short)n5, (IHoNum)object, n3));
            object = HoLoFactory.addOffset((IHoNum)object, n6);
        }
        object = new ArrayList();
        if (s == 6 || s == 9 || s == 24) {
            Iterator iterator = arrayList.iterator();
            s2 = 0;
            while (iterator.hasNext()) {
                iPathInfo = (IPathInfo)iterator.next();
                s2 = iPathInfo.getStartingHo().getIdlHoNum();
                if (!this.needToRemove(s, s2)) continue;
                ((ArrayList)object).add(iPathInfo);
            }
        }
        for (n2 = 0; n2 < iUcpCircuitOriginModelArray.length; ++n2) {
            if (iUcpCircuitOriginModelArray[n2].getOriginInterface() != this.getEntityIndex()) continue;
            s2 = iUcpCircuitOriginModelArray[n2].getLabel().getS();
            iPathInfo = CircuitSize.getCircuitSize((int)iUcpCircuitOriginModelArray[n2].getCktSize());
            n = iPathInfo.getHoPathWidth();
            PoolModel.removeIntersecting(arrayList, (List)object, s2, n, n4);
        }
        for (n2 = 0; n2 < iUcpCircuitTerminationModelArray.length; ++n2) {
            if (iUcpCircuitTerminationModelArray[n2].getTerminationInterface() != this.getEntityIndex()) continue;
            s2 = iUcpCircuitTerminationModelArray[n2].getLabel().getS();
            iPathInfo = CircuitSize.getCircuitSize((int)iUcpCircuitTerminationModelArray[n2].getCktSize());
            n = iPathInfo.getHoPathWidth();
            PoolModel.removeIntersecting(arrayList, (List)object, s2, n, n4);
        }
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            IPathInfo iPathInfo2 = (IPathInfo)iterator.next();
            arrayList.remove(iPathInfo2);
        }
        IPathInfo[] iPathInfoArray = new IPathInfo[arrayList.size()];
        iPathInfoArray = arrayList.toArray(iPathInfoArray);
        return iPathInfoArray;
    }

    public int getStsCount() {
        return this.bundle1().getStsCount();
    }

    public boolean addConnectedPath(short s, short s2) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            Object[] objectArray = new Object[]{new Short(s), new Short(s2)};
            return (Boolean)this.addConnectedPath.get(objectArray);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void removeConnectedPath(short s, short s2) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            Object[] objectArray = new Object[]{new Short(s), new Short(s2)};
            this.removeConnectedPath.set(objectArray);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void update(Observable observable, Object object) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        if (observable instanceof ElementModel) {
            this.setContainer(null);
        } else if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            if (this.db.on()) {
                this.db.println("PoolModel::update(): Observable = " + observable + ", arg = " + EnumStrings.getStrings((Class)eUpdateType.class)[n]);
            }
            switch (n) {
                case 1: {
                    this.updateLocal();
                    break;
                }
                case 0: {
                    if (this.db.on) {
                        this.db.println("Deleting the Pool from parent's list " + this);
                    }
                    ((PoolModelsDelegate)this.node.getPoolModels()).remove(this);
                    this.dispose();
                    break;
                }
                case 2: {
                    this.updateLocal();
                    break;
                }
                default: {
                    String string = "Unknown update message (" + n + ") on a pool";
                    this.db.println(string);
                    SDebug.printStackTrace((Throwable)new IllegalArgumentException(string));
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    public synchronized ILoAditModel[] getLoAdits() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        if (this.aditModels == null) {
            this.aditModels = ((ConnectionModelsDelegate)this.node.getConnectionModels()).loAdits.getAditsInPool(this);
        }
        if (this.aditModels != null) {
            if (this.db.on()) {
                this.db.println("getLoAdits(): Returning " + this.aditModels.length + " LoAdits for Pool:" + Integer.toHexString(this.index));
            }
        } else if (this.db.on()) {
            this.db.println("getLoAdits(): Returning  NULL  LoAdits for Pool:" + Integer.toHexString(this.index));
        }
        return this.aditModels;
    }

    public void dispose() {
        block5: {
            if (this.db.on()) {
                this.db.println("dispose(): entered");
            }
            if (this.dispatcher != null) {
                try {
                    this.dispatcher.deleteObserver(ObjectType.ObjectSonetPool, this.getObjIndex(), (Observer)this);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (!this.db.on()) break block5;
                    this.db.println("Exception in disposing of Pool " + (Object)((Object)abstractCmsIOException));
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        }
        this.containerName.dispose();
        this.bundle1.dispose();
        this.bundleOnePlusOne.dispose();
        this.connectedPaths.dispose();
        this.biggestPathAvailable.dispose();
        this.includedPath.dispose();
        this.aditModels = null;
        this.availPaths = null;
        this.cachedWidth = (short)-1;
        this.isInitedRealState = false;
        super.dispose();
        if (this.db.on()) {
            this.db.println("dispose(): exited");
        }
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy(): entered");
        }
        super.destroy();
        this.poolRef = null;
        if (this.db.on()) {
            this.db.println("destroy(): exited");
        }
    }

    public boolean isSharedPool(IPoolModel iPoolModel) {
        return !this.equals(iPoolModel) && ((PoolModel)iPoolModel).bundle1().getIndex() == this.bundle1().getIndex() && holoComp.isEqual(((PoolModel)iPoolModel).includedPath().getStartingHo(), this.includedPath().getStartingHo());
    }

    public PoolModel getSharedPool() {
        Iterator iterator = ((PoolModelsDelegate)this.node.getPoolModels()).getPoolModels().iterator();
        while (iterator.hasNext()) {
            PoolModel poolModel = (PoolModel)iterator.next();
            if (!this.isSharedPool(poolModel)) continue;
            if (this.db.on()) {
                this.db.println("getSharedPool(): Returning Shared Pool:" + Integer.toHexString(poolModel.getIndex()) + " for Original Pool:" + Integer.toHexString(this.index));
            }
            return poolModel;
        }
        if (this.db.on()) {
            this.db.println("getSharedPool(): Found no shared pool for Pool:" + Integer.toHexString(this.index));
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof PoolModel) {
            PoolModel poolModel = (PoolModel)object;
            return poolModel.getObjIndex() == this.getObjIndex();
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        block3: {
            try {
                if (this.container != null) {
                    return "Pool[" + this.container.getName() + "]" + "Entity " + Integer.toHexString(this.getEntityIndex());
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return "Pool[deleted/inaccessible]:" + Integer.toHexString(this.index);
    }

    public List getPortModels() throws AbstractCmsNoSuchEntityException {
        this.getEntityModel();
        return this.portsList;
    }

    private void updatePortsList(EntityModel entityModel) {
        EntityModel entityModel2 = entityModel;
        if (entityModel2 == null) {
            return;
        }
        boolean bl = false;
        this.portsList = new LinkedList();
        if (entityModel2 instanceof IPortModel) {
            boolean bl2 = bl = entityModel2.getEqType() == 34;
            if (bl) {
                entityModel2 = entityModel2.getModuleModel();
            } else {
                this.portsList.add(entityModel2);
            }
        }
        if (entityModel2 instanceof IModuleModel) {
            if (bl) {
                int n;
                List list = entityModel2.getDescendantsOfEqType(34);
                int n2 = list.indexOf(entityModel);
                if (list.size() > n && n2 != -1) {
                    ListIterator listIterator = list.listIterator(n2);
                    for (n = 28; listIterator.hasNext() && n > 0; --n) {
                        this.portsList.add(listIterator.next());
                    }
                } else {
                    this.portsList.addAll(list);
                }
            } else {
                this.portsList.addAll(entityModel2.getDescendantsOfClassType(7));
            }
        }
    }

    class RemoveConnectedPath
    extends NonCachedValue {
        public RemoveConnectedPath(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            PoolModel.this.getPoolRef().removeConnectedPath((Short)objectArray[0], (Short)objectArray[1]);
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class AddConnectedPath
    extends NonCachedValue {
        public AddConnectedPath(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return null;
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class AvailableVcatPaths
    extends NonCachedValue {
        public AvailableVcatPaths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return PoolModel.this.getPoolRef().getAvailableVcatPaths((Short)objectArray[0], (Short)objectArray[1]);
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class AvailablePaths
    extends NonCachedValue {
        public AvailablePaths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return PoolModel.this.getPoolRef().getAvailablePaths((Short)object);
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class IncludedPath
    extends CachedValue {
        public IncludedPath(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return PoolModel.this.getPoolRef().includedPath();
        }

        protected Object cloneValue() {
            sPathInfo sPathInfo2 = (sPathInfo)this.value;
            sPathInfo sPathInfo3 = new sPathInfo(sPathInfo2.pathWidth, sPathInfo2.startingSts);
            return sPathInfo3;
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class BiggestPathAvailable
    extends CachedValue {
        public BiggestPathAvailable(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return new Short(PoolModel.this.getPoolRef().biggestPathAvailable());
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class ConnectedPaths
    extends CachedValue {
        public ConnectedPaths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return PoolModel.this.getPoolRef().connectedPaths();
        }

        protected Object cloneValue() {
            sPathInfo[] sPathInfoArray = (sPathInfo[])this.value;
            sPathInfo[] sPathInfoArray2 = new sPathInfo[sPathInfoArray.length];
            for (int i = 0; i < sPathInfoArray.length; ++i) {
                sPathInfoArray2[i] = new sPathInfo(sPathInfoArray[i].pathWidth, sPathInfoArray[i].startingSts);
            }
            return sPathInfoArray2;
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class BundleOnePlusOne
    extends CachedValue {
        public BundleOnePlusOne(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return PoolModel.this.getPoolRef().bundleOnePlusOne();
        }

        protected Object cloneValue() {
            sBundleInfo sBundleInfo2 = (sBundleInfo)this.value;
            sBundleInfo sBundleInfo3 = new sBundleInfo(sBundleInfo2.index, sBundleInfo2.stsCount, sBundleInfo2.bundleType);
            return sBundleInfo3;
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class Bundle1
    extends CachedValue {
        public Bundle1(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return PoolModel.this.getPoolRef().bundle1();
        }

        protected Object cloneValue() {
            sBundleInfo sBundleInfo2 = (sBundleInfo)this.value;
            sBundleInfo sBundleInfo3 = new sBundleInfo(sBundleInfo2.index, sBundleInfo2.stsCount, sBundleInfo2.bundleType);
            return sBundleInfo3;
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class ObjIndex
    extends CachedValue {
        public ObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return new Integer(PoolModel.this.getPoolRef().objIndex());
        }

        protected Object cloneValue() {
            return CloneHelper.clone((Integer)this.value);
        }

        public void update() {
        }

        public void dispose() {
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class ContainerName
    extends CachedValue {
        public ContainerName(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return PoolModel.this.getPoolRef().containerName();
        }

        public Object outer() {
            return PoolModel.this;
        }
    }
}

