/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.idl.SonetMedia.Pool;
import cerent.cms.idl.SonetMedia.sPoolAttributes;
import cerent.cms.idl.SonetTopology.eElementType;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ElementModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IPoolModels;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchPoolException;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.PoolModel;
import cerent.cms.model.UnprotectedLineModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.ComparisonUtil;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.omg.CORBA.UserException;

public class PoolModelsDelegate
extends Model
implements IPoolModels {
    private SonetPools sonetPools;
    private ObjIndex objIndex;
    private EventDispatcher dispatcher;
    private NodeModelDelegate nmd;
    private TreeMap poolModels;
    private static ModelSingletonCollection poolModelsDelegateSingletons;

    public static synchronized PoolModelsDelegate getInstance(NodeModelDelegate nodeModelDelegate) {
        PoolModelsDelegate poolModelsDelegate;
        if (poolModelsDelegateSingletons == null) {
            poolModelsDelegateSingletons = ModelSingletonCollection.getMSCInstanceByName((String)"PoolModelsDelegate");
        }
        if ((poolModelsDelegate = (PoolModelsDelegate)poolModelsDelegateSingletons.get((Object)nodeModelDelegate)) == null) {
            poolModelsDelegate = new PoolModelsDelegate(nodeModelDelegate);
            poolModelsDelegateSingletons.add((Object)nodeModelDelegate, (Object)poolModelsDelegate);
        }
        return poolModelsDelegate;
    }

    private PoolModelsDelegate(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(PoolModelsDelegate.class));
        this.nmd = nodeModelDelegate;
        this.index = 0;
        this.dispatcher = null;
        this.poolModels = new TreeMap();
        this.sonetPools = new SonetPools(this.nmd, "PoolModels::sonetPools");
        this.objIndex = new ObjIndex(this.nmd, "PoolModels.objIndex");
        this.db.addCommand(this, "dump", "List the PoolModels in the cache");
        this.db.addCommand(this, "rebuild", "Rebuild the PoolModels cache");
    }

    public void init() {
        super.init0();
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectSonetPoolList, 0, (Observer)this);
        }
        this.updateStructure();
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStructure() {
        if (this.db.on) {
            this.db.println("updateStructure START ---");
        }
        PoolModelFactory poolModelFactory = new PoolModelFactory(this.nmd);
        TreeSet treeSet = new TreeSet(new PoolComparator());
        TreeSet treeSet2 = new TreeSet(new PoolComparator());
        TreeMap treeMap = this.poolModels;
        synchronized (treeMap) {
            Object object;
            poolModelFactory.captureChanges(this.poolModels, treeSet, treeSet2);
            Iterator iterator = treeSet2.iterator();
            while (iterator.hasNext()) {
                object = (PoolModel)iterator.next();
                ((PoolModel)object).destroy();
                this.remove((PoolModel)object);
            }
            iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                object = (sPoolAttributes)iterator.next();
                PoolModel poolModel = new PoolModel(this.nmd, (sPoolAttributes)object, null);
                poolModel.init();
                this.poolModels.put(new Integer(((sPoolAttributes)object).objIndex), poolModel);
            }
        }
        if (this.db.on) {
            this.db.println("# added " + treeSet.size() + ", # deleted " + treeSet2.size());
        }
        if (!treeSet.isEmpty() || !treeSet2.isEmpty()) {
            if (this.db.on) {
                this.db.fine("sending UPDATE_STRUCTURE (ADDED)");
            }
            this.setChanged();
            this.notifyObservers(ModelUpdateType.ADDED);
        }
        if (this.db.on) {
            this.db.println("updateStructure --- FINISH");
        }
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            if (this.db.on) {
                this.db.println(this.nmd.dbName() + " update(" + observable + ", " + EnumStrings.getStrings((Class)eUpdateType.class)[n] + ")");
            }
            switch (n) {
                case 1: {
                    this.setChanged();
                    this.updateLocal();
                    break;
                }
                case 0: {
                    break;
                }
                case 2: {
                    this.updateStructure();
                    break;
                }
                default: {
                    String string = "Unknown update message (" + n + ") on pool models";
                    this.db.severe(string);
                    if (this.db.on) {
                        SDebug.printStackTrace((Throwable)new IllegalArgumentException(string));
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (this.db.on) {
            this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.db.on) {
            this.db.fine("dispose");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectSonetPoolList, 0, (Observer)this);
        }
        TreeMap treeMap = this.poolModels;
        synchronized (treeMap) {
            Iterator iterator = this.poolModels.values().iterator();
            while (iterator.hasNext()) {
                ((PoolModel)iterator.next()).dispose();
            }
            this.poolModels.clear();
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.db.on) {
            this.db.fine("destroy");
        }
        super.destroy();
        if (this.poolModels != null) {
            TreeMap treeMap = this.poolModels;
            synchronized (treeMap) {
                Iterator iterator = this.poolModels.values().iterator();
                while (iterator.hasNext()) {
                    ((PoolModel)iterator.next()).destroy();
                }
                this.poolModels.clear();
                this.poolModels = null;
            }
        }
        this.dispatcher = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized PoolModel addPool(PoolModel poolModel) {
        PoolModel poolModel2 = null;
        TreeMap treeMap = this.poolModels;
        synchronized (treeMap) {
            Integer n = new Integer(poolModel.getObjIndex());
            if (!this.poolModels.containsKey(n)) {
                this.poolModels.put(n, poolModel);
            }
            poolModel2 = (PoolModel)this.poolModels.get(n);
        }
        return poolModel2;
    }

    public PoolModel add(PoolModel poolModel) {
        PoolModel poolModel2 = this.addPool(poolModel);
        if (poolModel2 != poolModel) {
            this.setChanged();
            this.notifyObservers(ModelUpdateType.ADDED);
        }
        return poolModel2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getPoolModels() {
        Collection collection = null;
        TreeMap treeMap = this.poolModels;
        synchronized (treeMap) {
            collection = ((Map)this.poolModels.clone()).values();
        }
        return collection;
    }

    public IPoolModel[] getPoolModels(int n) {
        ArrayList<IPoolModel> arrayList;
        block6: {
            arrayList = new ArrayList<IPoolModel>();
            try {
                ElementModel elementModel = this.nmd.getElementModelsDelegate().getElementModel(n);
                if (this.db.on()) {
                    this.db.println("Element Model type = " + EnumStrings.getStrings((Class)eElementType.class)[elementModel.getType()]);
                }
                arrayList.add(this.getPoolModel(n));
                if (elementModel.getType() == 2) {
                    if (this.db.on()) {
                        this.db.println("Adding protect pool of 2F BlsrModel line model");
                    }
                    arrayList.add(this.getProtectPoolModel(n));
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!this.db.on()) break block6;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
        if (this.db.on()) {
            this.db.println("returnPoolList: " + arrayList.size() + "(size), " + arrayList);
        }
        return arrayList.toArray(new IPoolModel[0]);
    }

    public IPoolModel getPoolModel(int n) {
        ElementModel elementModel;
        try {
            elementModel = this.nmd.getElementModelsDelegate().getElementModel(n);
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            if (this.db.on()) {
                this.db.println("Could not find ElementModel for entityIndex");
            }
            return null;
        }
        if (elementModel instanceof UnprotectedLineModel) {
            if (this.db.on()) {
                this.db.println("EntityIndex of unprotected line model");
            }
            return ((UnprotectedLineModel)elementModel).getPoolModel();
        }
        if (elementModel instanceof OnePlusOneModel) {
            if (this.db.on()) {
                this.db.println("EntityIndex of OnePlusOne line model");
            }
            return ((OnePlusOneModel)elementModel).getPoolModel();
        }
        if (elementModel instanceof BlsrModel) {
            if (this.db.on()) {
                this.db.println("EntityIndex of BlsrModel line model");
            }
            return ((BlsrModel)elementModel).getPoolModel(n);
        }
        return null;
    }

    public IPoolModel getProtectPoolModel(int n) {
        ElementModel elementModel;
        try {
            elementModel = this.nmd.getElementModelsDelegate().getElementModel(n);
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            if (this.db.on()) {
                this.db.println("Not found ElementModel for entityIndex " + n);
            }
            return null;
        }
        if (this.db.on()) {
            this.db.println("Found ElementModel for entityIndex " + n);
        }
        if (elementModel instanceof UnprotectedLineModel) {
            if (this.db.on()) {
                this.db.println("No Protect Pool for Unprotected LineModel");
            }
            return null;
        }
        if (elementModel instanceof OnePlusOneModel) {
            if (this.db.on()) {
                this.db.println("getProtectPoolModel: Unspported for OnePlusOneModel");
            }
            return null;
        }
        if (elementModel instanceof BlsrModel) {
            boolean bl = false;
            boolean bl2 = false;
            BlsrModel blsrModel = (BlsrModel)elementModel;
            if (elementModel.getTypeEnum() == eElementType.BLSR_4_WIRE) {
                if (blsrModel.getEastProtectEntityIndex() == n) {
                    bl = true;
                } else if (blsrModel.getWestProtectEntityIndex() == n) {
                    bl2 = true;
                } else if (this.db.on()) {
                    this.db.println("Wrong entity Index for Protect Pool of 4F Blsr");
                }
            } else if (blsrModel.getEastEntityIndex() == n) {
                bl = true;
            } else if (blsrModel.getWestEntityIndex() == n) {
                bl2 = true;
            } else if (this.db.on()) {
                this.db.println("Wrong entity Index for Protect Pool of 2F Blsr");
            }
            if (bl) {
                if (this.db.on()) {
                    this.db.println("Returning Protect Pool of Blsr East");
                }
                return blsrModel.getEastProtectPoolModel();
            }
            if (bl2) {
                if (this.db.on()) {
                    this.db.println("Returning Protect Pool of Blsr West");
                }
                return blsrModel.getWestProtectPoolModel();
            }
            if (this.db.on()) {
                this.db.println("Wrong entity Index for Protect Pool of Blsr");
            }
            return null;
        }
        if (this.db.on()) {
            this.db.println("Unknown element model type for entityIndex " + n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolModel find(Pool pool) throws AbstractCmsIOException {
        try {
            TreeMap treeMap = this.poolModels;
            synchronized (treeMap) {
                Iterator iterator = this.poolModels.values().iterator();
                while (iterator.hasNext()) {
                    PoolModel poolModel = (PoolModel)iterator.next();
                    if (!pool._is_equivalent(poolModel.getPoolRef())) continue;
                    if (this.db.on) {
                        this.db.println("Found Pool based on _is_equivalent");
                    }
                    return poolModel;
                }
            }
            if (this.db.on) {
                this.db.println("Cannot find Pool based on _is_equivalent using Index");
            }
            return this.find((Integer)this.objIndex.get(pool));
        }
        catch (UserException userException) {
            if (this.db.on) {
                this.db.println("user exception in find " + (Object)((Object)userException));
            }
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolModel find(Integer n) {
        PoolModel poolModel = null;
        TreeMap treeMap = this.poolModels;
        synchronized (treeMap) {
            poolModel = (PoolModel)this.poolModels.get(n);
        }
        return poolModel;
    }

    public Integer getObjIndexFromPool(Pool pool) throws NoSuchPoolException {
        try {
            return (Integer)this.objIndex.get(pool);
        }
        catch (UserException userException) {
            throw new NoSuchPoolException("No such pool");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(PoolModel poolModel) {
        if (this.db.on) {
            this.db.println("remove(" + poolModel + ")");
        }
        TreeMap treeMap = this.poolModels;
        synchronized (treeMap) {
            this.poolModels.remove(new Integer(poolModel.getObjIndex()));
        }
    }

    public String toString() {
        return "PMD[" + this.nmd.dbName() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dump() {
        TreeMap treeMap = this.poolModels;
        synchronized (treeMap) {
            if (this.poolModels == null || this.poolModels.size() == 0) {
                this.db.println("No Pool Models!");
            } else {
                Iterator iterator = this.poolModels.values().iterator();
                while (iterator.hasNext()) {
                    this.db.println(iterator.next().toString());
                }
            }
        }
    }

    public final void rebuild() {
        boolean bl = this.db.on();
        if (!bl) {
            this.db.set(true);
        }
        this.updateStructure();
        this.db.set(bl);
    }

    private class PoolComparator
    implements Comparator {
        private PoolComparator() {
        }

        public boolean equals(Object object) {
            return object instanceof PoolComparator;
        }

        public int compare(Object object, Object object2) {
            if (object instanceof sPoolAttributes) {
                if (object2 instanceof sPoolAttributes) {
                    return ComparisonUtil.compare((int)((sPoolAttributes)object).objIndex, (int)((sPoolAttributes)object2).objIndex);
                }
                return 1;
            }
            return -1;
        }
    }

    private class PoolModelFactory {
        private NodeModelDelegate nmd;
        private sPoolAttributes[] poolArray;

        public PoolModelFactory(NodeModelDelegate nodeModelDelegate) {
            this.nmd = nodeModelDelegate;
        }

        private void fetchPoolsFromNode() {
            block3: {
                try {
                    this.poolArray = (sPoolAttributes[])PoolModelsDelegate.this.sonetPools.get();
                    if (PoolModelsDelegate.this.db.on) {
                        PoolModelsDelegate.this.db.println("Got " + this.poolArray.length + " pools from node.");
                    }
                }
                catch (UserException userException) {
                    PoolModelsDelegate.this.db.fine("Caught " + (Object)((Object)userException) + " in PoolModelFactory.fetchPoolsFromNode");
                    if (!PoolModelsDelegate.this.db.on) break block3;
                    SDebug cfr_ignored_0 = PoolModelsDelegate.this.db;
                    SDebug.printStackTrace((Throwable)userException);
                }
            }
        }

        public void captureChanges(TreeMap treeMap, Set set, Set set2) {
            this.fetchPoolsFromNode();
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            for (int i = 0; i < this.poolArray.length; ++i) {
                Integer n = new Integer(this.poolArray[i].objIndex);
                if (!treeMap.containsKey(n)) {
                    set.add(this.poolArray[i]);
                }
                treeSet.add(n);
            }
            Map map = (Map)treeMap.clone();
            map.keySet().removeAll(treeSet);
            set2.addAll(map.values());
        }
    }

    private class SonetPools
    extends NonCachedValue {
        public SonetPools(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue() throws UserException {
            return this.node.getIorRepository().getSonetRef().getSonetPools();
        }

        public Object outer() {
            return PoolModelsDelegate.this;
        }
    }

    private class ObjIndex
    extends NonCachedValue {
        public ObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue(Object object) throws UserException {
            return new Integer(((Pool)object).objIndex());
        }

        public Object outer() {
            return PoolModelsDelegate.this;
        }
    }
}

