/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.IPlatform;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISonetStsModel;
import cerent.cms.model.ITdmHoModel;
import cerent.cms.model.ITdmLoModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InterfaceModels;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.RanSvcModuleModel;
import cerent.cms.model.SimpleMuxIndex;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.helper.PluggableHelper;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.LinkedList;
import java.util.List;

public class PortModel
extends EntityModel
implements IPortModel {
    private InterfaceModels ifModels;
    protected int[] portNum;

    public PortModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        this(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(PortModel.class));
    }

    public PortModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2, SDebug sDebug) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, sDebug);
        this.ifModels = nodeModelDelegate.getIfModels();
        if (this.db.on()) {
            this.db.println("PortModel.<init>");
        }
    }

    public void init() {
        if (this.db.on()) {
            this.db.println("init");
        }
        super.init();
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy");
        }
        if (this.ifModels != null) {
            this.ifModels.deleteInterfaces(this.getChassis(), this);
        }
        super.destroy();
        this.ifModels = null;
    }

    public IInterfaceModel getInterfaceModel() {
        InterfaceModel interfaceModel = null;
        if (this.ifModels != null) {
            interfaceModel = this.ifModels.getInterfaceModel(this);
        }
        if (interfaceModel == null) {
            throw new CmsObjectNotExistException("Unable to find Line Interface for index = " + Integer.toHexString(this.getIndex()));
        }
        return interfaceModel;
    }

    public List getConnectionsList() {
        InterfaceModel interfaceModel = (InterfaceModel)this.getInterfaceModel();
        if (interfaceModel != null) {
            return interfaceModel.getConnectionsList();
        }
        return new LinkedList();
    }

    public boolean isOptical() {
        return false;
    }

    public boolean hasOpticalProtection() {
        return false;
    }

    public boolean isSpecial() {
        return false;
    }

    public int getAdminState() throws NoSuchInterface {
        InterfaceModel interfaceModel = (InterfaceModel)this.getInterfaceModel();
        if (interfaceModel != null) {
            return interfaceModel.getAdminState();
        }
        return -1;
    }

    public int getServiceStateType() throws NoSuchInterface {
        InterfaceModel interfaceModel = (InterfaceModel)this.getInterfaceModel();
        if (interfaceModel != null) {
            if (this.getModuleModel() instanceof RanSvcModuleModel) {
                return interfaceModel.getServiceSt().equals(0) ? 100 : 101;
            }
            return interfaceModel.getServiceSt().getType();
        }
        return -1;
    }

    public eAdminState getAdminStateEnum() throws NoSuchInterface {
        return eAdminState.from_int(this.getAdminState());
    }

    private int getNumberOfCircuits() throws NoSuchInterface {
        int n;
        int n2 = 0;
        InterfaceModel interfaceModel = (InterfaceModel)this.getInterfaceModel();
        if (interfaceModel != null) {
            n2 = interfaceModel.getNumberOfCircuitInterfaces();
            this.db.info(this.node.getName() + ": candidate: number of circuit interfaces: " + n2);
        }
        if ((n = n2) > 0) {
            n = this.getConnectionsList().size();
            this.db.info(this.node.getName() + ": candidate: number of circuits: " + n);
        }
        this.db.info(this.node.getName() + ": final number of circuits: " + n);
        return n;
    }

    public boolean maybeSetAdminState(int n, int n2, int n3) throws NoSuchInterface, LoopbackActive, UnsupportedOperation, SyncProvError, InvalidState {
        InterfaceModel interfaceModel;
        int n4;
        if (this.getModuleModel() instanceof RanSvcModuleModel) {
            this.db.info("maybeSetAdminState(): cannot set state - RAN_SVC");
            return false;
        }
        int n5 = this.getAdminState();
        this.db.info("PortModel" + this + ".maybeSetAdminState(): targetState: " + n + ", current state: " + n5 + ", policy: " + n2 + ", circuitSize: " + n3);
        if (n5 == n) {
            return true;
        }
        if (n != 0 && n5 != 1) {
            if (this.isTimingSource()) {
                this.db.info(this.node.getName() + ": maybeSetAdminState: cannot set state - port is timing source");
                return false;
            }
            n4 = this.getNumberOfCircuits();
            if (n2 == 2) {
                if (n4 > 1) {
                    this.db.info(this.node.getName() + ": maybeSetAdminState: cannot set state - port has other circuits");
                    n = -1;
                }
            } else if (n4 > 0) {
                this.db.info(this.node.getName() + ": maybeSetAdminState: cannot set state - port has circuits");
                n = -1;
            }
        }
        n4 = 0;
        if (n != -1 && (interfaceModel = (InterfaceModel)this.getInterfaceModel()) != null) {
            this.db.info(this.node.getName() + ": maybeSetAdminState: passing on to NE");
            interfaceModel.setAdminState(n);
            n4 = 1;
        }
        return n4 != 0;
    }

    public boolean setAdminState(int n) throws Exception {
        InterfaceModel interfaceModel = (InterfaceModel)this.getInterfaceModel();
        if (interfaceModel != null) {
            interfaceModel.setAdminState(n);
            return true;
        }
        return false;
    }

    public String toString() {
        return "Port[" + super.toShortString() + "]";
    }

    public ITdmHoModel getTdmHoModel(IHoNum iHoNum) {
        short s = iHoNum == null ? (short)0 : iHoNum.getIdlHoNum();
        try {
            boolean bl = this.isOptical();
            InterfaceModel interfaceModel = (InterfaceModel)this.getInterfaceModel();
            while (interfaceModel != null) {
                InterfaceModel[] interfaceModelArray = interfaceModel.getHigherLayerModels();
                if (this.db.on()) {
                    this.db.println("IntModel: " + interfaceModel);
                    this.db.println("IntModel Class: " + interfaceModel.getClass());
                    if (interfaceModelArray != null && interfaceModelArray.length > 0) {
                        this.db.println("higher[0]: " + interfaceModelArray[0]);
                        this.db.println("higher is tdmHomodel? " + (interfaceModelArray[0] instanceof ITdmHoModel));
                        this.db.println("higher/length: " + interfaceModelArray.length);
                        this.db.println("seeking STS: " + s);
                    }
                }
                if (interfaceModelArray == null || interfaceModelArray.length == 0) {
                    if (this.db.on()) {
                        this.db.println("getTdmHoModel:ran out of higher interfaces!");
                    }
                    break;
                }
                if (interfaceModelArray[0] instanceof ITdmHoModel) {
                    if (bl) {
                        for (int i = 0; i < interfaceModelArray.length; ++i) {
                            int n = interfaceModelArray[i].getInfo().muxIndex;
                            if (this.db.on()) {
                                this.db.print(this.getChassis().getNodeModel().getHostName() + ", " + this.getSlot() + "/" + PortHelper.getConcatenatedString((int[])this.getPortNum()));
                                this.db.println("sonet model #" + i + " maps to STS #" + n + " (want " + s + ")");
                            }
                            if (n != s) continue;
                            return (ITdmHoModel)interfaceModelArray[i];
                        }
                    } else {
                        if (interfaceModelArray.length > 1) {
                            if (this.db.on()) {
                                this.db.println("more than one TdmHoModel mapped to by a non-optical port model: " + interfaceModelArray.length);
                            }
                            break;
                        }
                        if (this.db.on()) {
                            this.db.print(this.getChassis().getNodeModel().getHostName() + ", " + this.getSlot() + "/" + PortHelper.getConcatenatedString((int[])this.getPortNum()));
                            this.db.println("sonet model <0> --> STS " + s);
                        }
                        return (ITdmHoModel)interfaceModelArray[0];
                    }
                }
                if (this.db.on()) {
                    this.db.println("Going higher.");
                }
                interfaceModel = interfaceModelArray[0];
            }
        }
        catch (Exception exception) {
            this.db.println("Caught exception in getTdmHoModel");
            SDebug.printStackTrace((Throwable)exception);
        }
        return null;
    }

    public ISonetStsModel getSonetStsModel(int n) {
        throw new DeprecatedMethodCalled("FTG deprecated ConnectionModelsDelegate.getStsStsModel(int sts)");
    }

    public boolean isInLoopback() {
        return false;
    }

    public boolean supportsMonitorCircuits() {
        int n = this.getEqType();
        return n != eEqType.ETHER_10_100_T.value() && n != eEqType.ETHER_1000_F.value() && n != eEqType.EPOS_100_LINE_CARD.value() && n != eEqType.EPOS_1000_LINE_CARD.value();
    }

    public boolean supportsSplitRouting() {
        return false;
    }

    public void supportsLoCircuitsCheck() throws WrongPortType {
        int n = this.getEqType();
        if (this.node.getFramingType() == 1) {
            if (n != eEqType.E1_PORT.value() && n != eEqType.E3_PORT.value() && n != eEqType.DS1_VT_MAPPED.value() && n != eEqType.DS3I_PORT.value()) {
                throw new WrongPortType("Port type does not support LO circuits");
            }
        } else if (this.node.getFramingType() == 0) {
            IPlatform iPlatform = ((NodeModelDelegate)this.getNodeModel()).getPlatform();
            if (!(n == eEqType.DS1_VT_MAPPED.value() || n == eEqType.DS3_TRANS_MUX.value() || n == eEqType.EC1_PORT.value() && iPlatform.supportsJ2PathTraceOnEc1())) {
                throw new WrongPortType("Port type does not support LO circuits");
            }
        }
    }

    private boolean isTransMux() {
        int n = this.getEqType();
        return this.node.getFramingType() == 0 && n == eEqType.DS3_TRANS_MUX.value();
    }

    public ITdmLoModel getTdmLoModel(ILoNum iLoNum) throws WrongPortType {
        int n = 0;
        if (this.isTransMux()) {
            n = iLoNum.getIdlFlatNum() - 1;
        }
        this.supportsLoCircuitsCheck();
        try {
            InterfaceModel interfaceModel = (InterfaceModel)this.getInterfaceModel();
            while (interfaceModel != null) {
                InterfaceModel[] interfaceModelArray = interfaceModel.getHigherLayerModels();
                if (interfaceModelArray == null || interfaceModelArray.length == 0) {
                    if (this.db.on()) {
                        this.db.println("getTdmLoModel:ran out of higher interfaces!");
                    }
                    break;
                }
                if (interfaceModelArray[0] instanceof ITdmLoModel) {
                    IPlatform iPlatform = ((NodeModelDelegate)this.getNodeModel()).getPlatform();
                    if (interfaceModelArray.length == 1 && !iPlatform.supportsJ2PathTraceOnEc1()) {
                        return (ITdmLoModel)interfaceModelArray[0];
                    }
                    if (!iPlatform.supportsJ2PathTraceOnEc1()) {
                        if (this.db.on()) {
                            this.db.println("more than one TdmLoModel mapped to a non-optical port model and no J2 support on EC1 ports: " + interfaceModelArray.length);
                        }
                        break;
                    }
                    if (this.db.on()) {
                        this.db.println("J2 supported on EC1 ports, find TdmLoModel in TdmLoModel[" + interfaceModelArray.length + "]");
                    }
                    for (int i = 0; i < interfaceModelArray.length; ++i) {
                        int n2 = new SimpleMuxIndex(interfaceModelArray[i]).getExternalMuxIndex();
                        if (iLoNum.getIdlFlatNum() != n2) continue;
                        if (this.db.on) {
                            this.db.println("ILoNum.flatNum= " + iLoNum.getIdlFlatNum() + " SimpleMuxIndex.muxIndex= " + n2 + ", returning " + interfaceModelArray[i].toString());
                        }
                        return (ITdmLoModel)interfaceModelArray[i];
                    }
                }
                interfaceModel = interfaceModelArray[n];
            }
        }
        catch (Exception exception) {
            this.db.println("Caught exception in getTdmHoModel");
            SDebug.printStackTrace((Throwable)exception);
        }
        return null;
    }

    public int[] getPortNum() {
        if (this.portNum == null) {
            this.portNum = PluggableHelper.getHierarchyNums(this);
        }
        return this.portNum;
    }

    public boolean isMutable() {
        ModuleModel moduleModel = (ModuleModel)this.getModuleModel();
        if (moduleModel instanceof PluggableCarrierModel) {
            return true;
        }
        if (moduleModel != null) {
            return moduleModel.isComboModule() && !moduleModel.isProtectModule();
        }
        return false;
    }

    public boolean isPortNumUnique() {
        ModuleModel moduleModel = (ModuleModel)this.getModuleModel();
        return moduleModel != null && moduleModel.isPortNumUnique(this.getEqType());
    }

    public boolean isTimingSource() throws NoSuchInterface {
        return this.getChassis().getSyncModel().isTimingSource(this.getIndex());
    }
}

