/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.PluggableModule;
import cerent.cms.idl.Equipment.PluggableModuleHelper;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractPortContainer;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IPpmModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PimModel;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.omg.CORBA.UserException;

public class PpmModel
extends PluggableModel
implements IPpmModel,
IPortContainer {
    protected PluggableModule pluggableModuleRef = null;
    protected GetAllPPMPortTypeList getAllPPMPortTypeList;
    protected ChangePPMPortType changePPMPortType;

    public PpmModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(PpmModel.class));
        this.index = n;
        this.pluggableModuleRef = PluggableModuleHelper.narrow(entity);
        this.getAllPPMPortTypeList = new GetAllPPMPortTypeList(nodeModelDelegate, "PpmModel.getAllPPMPortTypeList");
        this.changePPMPortType = new ChangePPMPortType(nodeModelDelegate, "PpmModel.changePPMPortType");
    }

    public PluggableModule getPluggableModuleRef() {
        return this.pluggableModuleRef;
    }

    public eEqType[] getAllPPMPortTypeList(int n) {
        try {
            return (eEqType[])this.getAllPPMPortTypeList.get(new Integer(n));
        }
        catch (UserException userException) {
            throw this.doUnknown("getAllPPMPortTypeList", userException);
        }
    }

    public void changePPMPortType(PortModel portModel, eEqType eEqType2) throws ProvisionError, ResourceInUse {
        try {
            Object[] objectArray = new Object[]{new Integer(portModel.getEntityIndex()), eEqType2};
            this.changePPMPortType.set(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw this.doUnknown("changePPMPortType", userException);
        }
    }

    public void provisionPort(int n, eEqType eEqType2) throws ProvisionError, ResourceInUse {
        EntityTableModel entityTableModel = this.getNodeModelDelegate().getEntityTableModel();
        entityTableModel.provisionPort(this, n, eEqType2);
    }

    public void unprovisionPort(PortModel portModel) throws ProvisionError, ResourceInUse {
        EntityTableModel entityTableModel = this.getNodeModelDelegate().getEntityTableModel();
        entityTableModel.unprovisionPort(portModel);
    }

    public int getMaxPorts() {
        int n = 0;
        switch (this.getEqType()) {
            case 150: {
                n = 1;
                break;
            }
        }
        return n;
    }

    public boolean allowsPortCreation() {
        return !this.isDeleted();
    }

    public boolean allowsPortDeletion() {
        return true;
    }

    public boolean allowsPortEditing() {
        return ((ModuleModel)this.getModuleModel()).allowsPortEditing(this);
    }

    public List getAvailablePortNumbers() {
        return AbstractPortContainer.getAvailPortNumbers(this);
    }

    public boolean supportPortType(int n, int n2) throws ProvisionError {
        eEqType[] eEqTypeArray = this.getPortTypeList(n);
        if (eEqTypeArray == null) {
            return false;
        }
        if (this.db.on()) {
            this.db.fine("Supported port types: " + Arrays.asList(eEqTypeArray));
        }
        for (int i = 0; i < eEqTypeArray.length; ++i) {
            if (eEqTypeArray[i].value() != n2) continue;
            return true;
        }
        return false;
    }

    public void changePortType(IPortModel iPortModel, int n) throws ProvisionError, ResourceInUse {
        this.changePPMPortType((PortModel)iPortModel, eEqType.from_int(n));
    }

    public List getContainedPorts() {
        List list = this.getDescendantsOfClassType(7);
        Iterator iterator = list.iterator();
        PortModel portModel = null;
        while (iterator.hasNext()) {
            portModel = (PortModel)iterator.next();
            try {
                if (portModel.getEqType() == 165) {
                    iterator.remove();
                    continue;
                }
                portModel.getInterfaceModel();
            }
            catch (Exception exception) {
                iterator.remove();
            }
        }
        return list;
    }

    public PimModel getPimModel() {
        PimModel pimModel;
        block3: {
            pimModel = null;
            try {
                IEntityModel iEntityModel = this.getParent().getParent();
                if (iEntityModel instanceof PimModel) {
                    pimModel = (PimModel)iEntityModel;
                }
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                this.db.println("Caught ObjectNotExist in getPimModel");
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
            }
        }
        return pimModel;
    }

    public eEqType[] getPortTypeList(int n) throws ProvisionError {
        eEqType[] eEqTypeArray = null;
        EntityTableModel entityTableModel = this.getNodeModelDelegate().getEntityTableModel();
        eEqTypeArray = entityTableModel.getPortTypeList(this.getEntityIndex(), n);
        return eEqTypeArray;
    }

    public boolean isSoftResettable() {
        return false;
    }

    public boolean isHardResettable() {
        return false;
    }

    public boolean isResettable() {
        return false;
    }

    class ChangePPMPortType
    extends NonCachedValue {
        public ChangePPMPortType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            eEqType eEqType2 = (eEqType)objectArray[1];
            PpmModel.this.getPluggableModuleRef().changePPMPortType(n, eEqType2);
        }
    }

    class GetAllPPMPortTypeList
    extends NonCachedValue {
        public GetAllPPMPortTypeList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return PpmModel.this.getPluggableModuleRef().getAllPPMPortTypeList(n);
        }
    }
}

