/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.FramingType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.IosModuleModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProtectionGroupModel;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import java.util.LinkedList;
import java.util.List;

public class RanSvcModuleModel
extends IosModuleModel {
    private static final int MAX_DS1_PER_STS = 21;
    private static final int OC3_PORT_NUM = 8;
    private ILoNum _maxLoNum;

    public RanSvcModuleModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2);
        int n3 = nodeModelDelegate.getFramingType();
        if (FramingType.isSonet((int)n3)) {
            ILoNum iLoNum = HoLoFactory.createFirstLoNum(n3, 0);
            this._maxLoNum = HoLoFactory.addGroupOffset(iLoNum, 20);
        }
    }

    public PortModel[] getDs1PortModels() {
        PortModel[] portModelArray = this.getPortModels(eEqType.DS1_VT_MAPPED);
        if (portModelArray.length == 0) {
            portModelArray = this.getPortModels(eEqType.E1_PORT);
        }
        return portModelArray;
    }

    public InterfaceModel[] getDs1LineModels() {
        InterfaceModel[] interfaceModelArray = this.getLineModels(eEqType.DS1_VT_MAPPED);
        if (interfaceModelArray.length == 0) {
            interfaceModelArray = this.getLineModels(eEqType.E1_PORT);
        }
        return interfaceModelArray;
    }

    public PortModel[] getOc3PortModels() {
        return this.getPortModels(eEqType.OC3_PORT);
    }

    public InterfaceModel[] getOc3LineModels() {
        return this.getLineModels(eEqType.OC3_PORT);
    }

    public String toString() {
        return "RanSvc" + super.toString();
    }

    private IHoLoNum getHoLoNumForPort(int n, int n2) {
        if (n <= 8) {
            return null;
        }
        int n3 = n - 8 - 1;
        int n4 = this.getNodeModel().getFramingType();
        int n5 = CircuitSize.width2sizeOfLoCircuit((int)n2).getEnum();
        IHoNum iHoNum = HoLoFactory.createFirstHoNum(n4);
        ILoNum iLoNum = HoLoFactory.createFirstLoNum(n4, n5);
        IHoLoNum iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
        if (this._maxLoNum != null) {
            n3 += n3 / 21 * 7;
        }
        HoLoFactory.increaseGroupOffset(iHoLoNum, n3);
        return iHoLoNum;
    }

    public ILoNum getLoNumForPort(int n, int n2) {
        IHoLoNum iHoLoNum = this.getHoLoNumForPort(n, n2);
        return iHoLoNum != null ? iHoLoNum.getLoNum() : null;
    }

    public IHoNum getHoNumForPort(int n, int n2) {
        IHoLoNum iHoLoNum = this.getHoLoNumForPort(n, n2);
        return iHoLoNum != null ? iHoLoNum.getHoNum() : null;
    }

    protected IPortModel getPortModelForLoPath(IEntityModel iEntityModel, IHoNum iHoNum, ILoNum iLoNum) {
        PortModel portModel = null;
        int n = iLoNum.getLoPathWidth();
        IHoLoNum iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
        PortModel[] portModelArray = this.getDs1PortModels();
        for (int i = 0; i < portModelArray.length; ++i) {
            PortModel portModel2 = portModelArray[i];
            int[] nArray = portModel2.getPortNum();
            if (nArray == null || nArray.length != 1 || !iHoLoNum.equals(this.getHoLoNumForPort(nArray[0], n))) continue;
            portModel = portModel2;
            break;
        }
        return portModel;
    }

    public boolean isSupportingBLSR() {
        return false;
    }

    public boolean supportsClearPM() {
        return false;
    }

    public List getConnectionsList() {
        List list = new LinkedList();
        if (this.isProtectModule()) {
            ProtectionGroupModel protectionGroupModel = this.getProtectionGroupModel();
            ModuleModel moduleModel = protectionGroupModel.getProtectedModuleModel();
            if (moduleModel != null) {
                list = moduleModel.getConnectionsList();
            }
        } else {
            RanSvcModuleModel.addConnectionList(list, this.getOc3LineModels());
            RanSvcModuleModel.addConnectionList(list, this.getDs1LineModels());
        }
        return list;
    }

    public ILoNum getMaxLo(int n) {
        return this._maxLoNum;
    }

    private static void addConnectionList(List list, InterfaceModel[] interfaceModelArray) {
        for (int i = 0; i < interfaceModelArray.length; ++i) {
            try {
                list.addAll(interfaceModelArray[i].getConnectionsList());
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

