/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eMultishelfLanConfig;
import cerent.cms.idl.Equipment.eShelfRole;
import cerent.cms.idl.Equipment.sShelfInfo;
import cerent.cms.idl.Node.sPwrMonVoltage;

public final class ShelfInfo {
    private short shelfId;
    private short rackNum;
    private short rackPos;
    private eShelfRole role;
    private eMultishelfLanConfig msLanConfig;
    private sPwrMonVoltage pwrMonValues;
    private boolean isMultishelf;

    public ShelfInfo() {
    }

    public ShelfInfo(sShelfInfo sShelfInfo2, boolean bl) {
        this(sShelfInfo2.shelfId, sShelfInfo2.role, sShelfInfo2.position.rackNumber, sShelfInfo2.position.positionInRack, sShelfInfo2.msLanConfig, sShelfInfo2.pwrMonValues, bl);
    }

    public ShelfInfo(short s, eShelfRole eShelfRole2, short s2, short s3, eMultishelfLanConfig eMultishelfLanConfig2, sPwrMonVoltage sPwrMonVoltage2, boolean bl) {
        this.shelfId = s;
        this.role = eShelfRole2;
        this.rackNum = s2;
        this.rackPos = s3;
        this.msLanConfig = eMultishelfLanConfig2;
        this.pwrMonValues = sPwrMonVoltage2;
        this.isMultishelf = bl;
    }

    public short getShelfId() {
        return this.shelfId;
    }

    public void setShelfId(short s) {
        this.shelfId = s;
    }

    public IShelfRole getShelfRole() {
        if (!this.isMultishelf) {
            return IShelfRole.SHELF_ROLE_SINGLE;
        }
        switch (this.role.value()) {
            case 0: {
                return IShelfRole.SHELF_ROLE_NC;
            }
            case 1: {
                return IShelfRole.SHELF_ROLE_SC;
            }
        }
        return IShelfRole.SHELF_ROLE_SINGLE;
    }

    public void setShelfRole(IShelfRole iShelfRole) {
        this.role = iShelfRole.getShelfRoleEnum();
    }

    public short getRackNum() {
        return this.rackNum;
    }

    public void setRackNum(short s) {
        this.rackNum = s;
    }

    public short getRackPos() {
        return this.rackPos;
    }

    public void setRackPos(short s) {
        this.rackPos = s;
    }

    public eMultishelfLanConfig getLanConfig() {
        return this.msLanConfig;
    }

    public void setLanConfig(eMultishelfLanConfig eMultishelfLanConfig2) {
        this.msLanConfig = eMultishelfLanConfig2;
    }

    public sPwrMonVoltage getPwrMonVoltage() {
        return this.pwrMonValues;
    }

    public void setPwrMonVoltage(sPwrMonVoltage sPwrMonVoltage2) {
        this.pwrMonValues = sPwrMonVoltage2;
    }

    public boolean equals(Object object) {
        if (object instanceof ShelfInfo) {
            ShelfInfo shelfInfo = (ShelfInfo)object;
            return this.shelfId == shelfInfo.shelfId;
        }
        return false;
    }

    public int hashCode() {
        return this.shelfId;
    }

    public static class IShelfRole {
        private final int value;
        public static final int _SHELF_ROLE_NC = 0;
        public static final int _SHELF_ROLE_SC = 1;
        public static final int _SHELF_ROLE_SINGLE = 2;
        public static final IShelfRole SHELF_ROLE_NC = new IShelfRole(0);
        public static final IShelfRole SHELF_ROLE_SC = new IShelfRole(1);
        public static final IShelfRole SHELF_ROLE_SINGLE = new IShelfRole(2);

        private IShelfRole(int n) {
            this.value = n;
        }

        public String toString() {
            return this.value == 0 ? "Node Controller" : (this.value == 1 ? "Shelf Controller" : "Single Shelf Node");
        }

        public int value() {
            return this.value;
        }

        public static IShelfRole from_int(int n) {
            switch (n) {
                case 2: {
                    return SHELF_ROLE_SINGLE;
                }
                case 0: {
                    return SHELF_ROLE_NC;
                }
                case 1: {
                    return SHELF_ROLE_SC;
                }
            }
            throw new IllegalArgumentException("" + n);
        }

        public eShelfRole getShelfRoleEnum() {
            return eShelfRole.from_int(this.value);
        }
    }
}

