/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Optics.eRingDirection;
import cerent.cms.idl.OpticsTopology.sSpanLossInfo;
import cerent.cms.model.ANS.NeANSModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.SpanCheckModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Observable;
import org.omg.CORBA.UserException;

public class SpanCheckModels
extends Model {
    private NodeModelDelegate nmd;
    private boolean inited = false;
    protected static final SDebug db = new SDebug("SpanCheckModels");
    private static ModelSingletonCollection spanCheckModelsSingletons;
    private ArrayList objModels;
    private sSpanLossInfo[] spanLossList;
    private SpanLossInfo spanLossInfoRef;
    private NeANSModel neAnsModel;

    private SpanCheckModels(NodeModelDelegate nodeModelDelegate) {
        super(db);
        this.nmd = nodeModelDelegate;
        this.index = 0;
        this.spanLossInfoRef = new SpanLossInfo(this.nmd, "SpanCheckModels::SpanLossInfo");
        this.objModels = new ArrayList();
    }

    public static synchronized SpanCheckModels getInstance(NodeModelDelegate nodeModelDelegate) {
        SpanCheckModels spanCheckModels;
        if (spanCheckModelsSingletons == null) {
            spanCheckModelsSingletons = ModelSingletonCollection.getMSCInstanceByName((String)"SpanCheckModels");
        }
        if ((spanCheckModels = (SpanCheckModels)spanCheckModelsSingletons.get((Object)nodeModelDelegate)) == null) {
            spanCheckModels = new SpanCheckModels(nodeModelDelegate);
            spanCheckModelsSingletons.add((Object)nodeModelDelegate, (Object)spanCheckModels);
        }
        return spanCheckModels;
    }

    protected void updateLocal() {
        super.updateLocal();
    }

    private void delSpanCheckModel(SpanCheckModel spanCheckModel) {
        spanCheckModel.deleteObserver(this);
        for (int i = 0; i < this.objModels.size(); ++i) {
            if (((SpanCheckModel)this.objModels.get(i)).getIdx() != spanCheckModel.getIdx()) continue;
            this.objModels.remove(i);
        }
        spanCheckModel.dispose();
    }

    private void delSpanCheckModel() {
        for (int i = 0; i < this.objModels.size(); ++i) {
            SpanCheckModel spanCheckModel = (SpanCheckModel)this.objModels.get(i);
            spanCheckModel.deleteObserver(this);
            spanCheckModel.dispose();
        }
        this.objModels.removeAll(this.objModels);
    }

    public synchronized void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("Got update from " + observable + " arg=" + object);
        }
        if (observable instanceof SpanCheckModel) {
            int n = object instanceof IObjectMessageInfo ? ((IObjectMessageInfo)object).getUpdateType() : ((Integer)object).intValue();
            switch (n) {
                case 2: {
                    break;
                }
                case 0: {
                    this.delSpanCheckModel((SpanCheckModel)((Object)observable));
                    this.reloadModel();
                    this.updateLocal();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.DELETED);
                    break;
                }
                case 1: {
                    this.updateLocal();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
            }
        } else if (observable instanceof NeANSModel) {
            int n = object instanceof IObjectMessageInfo ? ((IObjectMessageInfo)object).getUpdateType() : ((Integer)object).intValue();
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    this.delSpanCheckModel();
                    this.reloadModel();
                    this.updateLocal();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
            }
        }
    }

    public void init() {
        super.init0();
        if (!this.inited) {
            this.reloadModel();
            this.neAnsModel = this.nmd.getANSManager().getNeANSModel();
            if (this.neAnsModel != null) {
                this.neAnsModel.addObserver(this);
            }
            this.inited = true;
        }
    }

    public String[] getSpanLoss(int n) {
        return this.getSpanLossByDirection(eRingDirection.from_int(n));
    }

    private String[] getSpanLossByDirection(eRingDirection eRingDirection2) {
        SpanCheckModel spanCheckModel = null;
        for (int i = 0; i < this.objModels.size(); ++i) {
            spanCheckModel = (SpanCheckModel)this.objModels.get(i);
            int n = spanCheckModel.getNodeSide().value();
            if (n != 0) {
                --n;
            }
            if (n == eRingDirection2.value()) break;
        }
        return spanCheckModel.getSpanLoss();
    }

    public void dispose() {
        block5: {
            if (this.objModels != null && this.objModels.size() > 0) {
                for (int i = 0; i < this.objModels.size(); ++i) {
                    SpanCheckModel spanCheckModel = (SpanCheckModel)this.objModels.get(i);
                    spanCheckModel.deleteObserver(this);
                    spanCheckModel.dispose();
                }
                this.objModels.clear();
            }
            if (this.neAnsModel != null) {
                this.neAnsModel.deleteObserver(this);
                try {
                    this.neAnsModel.dispose();
                }
                catch (Exception exception) {
                    db.println("Unexpected exception occurred while trying to dispose " + this.neAnsModel);
                    if (!db.on()) break block5;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        this.inited = false;
        super.dispose();
    }

    public void destroy() {
        block4: {
            super.destroy();
            if (this.neAnsModel != null) {
                try {
                    this.neAnsModel.destroy();
                }
                catch (Exception exception) {
                    db.println("Unexpected exception occurred while trying to destroy " + this.neAnsModel);
                    if (!db.on()) break block4;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        SpanCheckModel spanCheckModel = null;
        for (int i = 0; i < this.objModels.size(); ++i) {
            spanCheckModel = (SpanCheckModel)this.objModels.get(i);
            spanCheckModel.destroy();
        }
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public ArrayList getSpanCheckModel() {
        return this.objModels;
    }

    private void reloadModel() {
        this.spanLossList = this.getAllSpanLossInfo();
        SpanCheckModel spanCheckModel = null;
        for (int i = 0; i < this.spanLossList.length; ++i) {
            if (!this.modelExists(this.spanLossList[i])) {
                spanCheckModel = new SpanCheckModel(this.nmd, this.spanLossList[i].side, this.spanLossList[i].index);
                spanCheckModel.init();
                spanCheckModel.addObserver(this);
                this.objModels.add(spanCheckModel);
                continue;
            }
            ((SpanCheckModel)this.objModels.get(i)).forceUpdate();
        }
    }

    private boolean modelExists(sSpanLossInfo sSpanLossInfo2) {
        for (int i = 0; i < this.objModels.size(); ++i) {
            if (((SpanCheckModel)this.objModels.get(i)).getIdx() != sSpanLossInfo2.index) continue;
            return true;
        }
        return false;
    }

    private sSpanLossInfo[] getAllSpanLossInfo() {
        try {
            return (sSpanLossInfo[])this.spanLossInfoRef.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "getAllSpanLossInfo", userException);
        }
    }

    private class SpanLossInfo
    extends NonCachedValue {
        public SpanLossInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            if (SpanCheckModels.db.on) {
                db.println(this.getClass() + "::getValue");
            }
            return this.node.getIorRepository().getDwdmOpticalSetupRef().getSpanLoss();
        }

        public Object outer() {
            return SpanCheckModels.this;
        }
    }
}

