/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Epos.sSpanningTreeAdminInfo;
import cerent.cms.idl.Epos.sSpanningTreeInfo;
import cerent.cms.idl.Epos.xNoSuchSpanningTree;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EtherBridgeModel;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OspfLanConfigFactory;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class SpanningTreeModel
extends Model {
    private NodeModelDelegate nmd;
    private SpanningTreeAdminInfo adminInfo;
    private SpanningTreeInfo info;
    private EventDispatcher dispatcher;

    public SpanningTreeModel(NodeModelDelegate nodeModelDelegate, short s) {
        super(nodeModelDelegate.getChildDebug(SpanningTreeModel.class));
        this.nmd = nodeModelDelegate;
        this.index = OspfLanConfigFactory.ushortToInt(s);
        this.info = new SpanningTreeInfo(nodeModelDelegate, "SpanningTreeModel::info");
        this.adminInfo = new SpanningTreeAdminInfo(nodeModelDelegate, "SpanningTreeModel::adminInfo");
        this.dispatcher = null;
    }

    public INodeModel getNodeModel() {
        return this.getNodeModelDelegate();
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nmd;
    }

    public void init() {
        super.init0();
        if (this.db.on()) {
            this.db.println("SpanningTree::init()");
        }
        this.dispatcher = this.getNodeModelDelegate().getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectSpanningTree, this.index, (Observer)this);
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectSpanningTree, this.index, (Observer)this);
        }
        super.dispose();
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("SpanningTree::destroy()");
        }
        super.destroy();
    }

    public sSpanningTreeInfo getSpanningTreeInfo() throws IllegalArgumentException {
        if (this.db.on()) {
            this.db.println("SpanningTree::getSpanningTreeInfo()");
        }
        try {
            return (sSpanningTreeInfo)this.info.get();
        }
        catch (xNoSuchSpanningTree xNoSuchSpanningTree2) {
            throw new IllegalArgumentException("Attempted to access a non-existent spanning tree [ SpanningTreeModel.getSpanningTreeInfo(" + this.index + ", ...) ].");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public sSpanningTreeAdminInfo getSpanningTreeAdminInfo() throws IllegalArgumentException {
        if (this.db.on()) {
            this.db.println("SpanningTree::getSpanningTreeAdminInfo()");
        }
        try {
            return (sSpanningTreeAdminInfo)this.adminInfo.get();
        }
        catch (xNoSuchSpanningTree xNoSuchSpanningTree2) {
            throw new IllegalArgumentException("Attempted to access a non-existent spanning tree [ SpanningTreeModel.getSpanningTreeAdminInfo(" + this.index + ", ...) ].");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setSpanningTreeAdminInfo(sSpanningTreeAdminInfo sSpanningTreeAdminInfo2) throws IllegalArgumentException {
        if (this.db.on()) {
            this.db.println("SpanningTree::setSpanningTreeAdminInfo()");
        }
        try {
            this.adminInfo.set(sSpanningTreeAdminInfo2);
        }
        catch (xNoSuchSpanningTree xNoSuchSpanningTree2) {
            throw new IllegalArgumentException("Attempted to access a non-existent spanning tree [ SpanningTreeModel.setSpanningTreeAdminInfo(" + this.index + ", ...) ].");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public EtherLineModel[] getEtherLineModel() {
        if (this.db.on()) {
            this.db.println("SpanningTree::getEtherLineModel()");
        }
        return null;
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("SpanningTree::update()");
        }
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            if (this.db.on()) {
                this.db.println("update(): this=" + this.toString() + ", From=" + observable + ", arg=" + EnumStrings.getStrings((Class)eUpdateType.class)[n]);
            }
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.println("Object deleted.");
                    }
                    ((EtherBridgeModel)this.nmd.getEtherBridgeModel()).removeSpanningTree(this);
                    this.destroy();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println("Making local changes.");
                    }
                    this.adminInfo.update();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    class SpanningTreeInfo
    extends NonCachedValue {
        public SpanningTreeInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getEtherBridgeRef().getSpanningTreeInfo((short)SpanningTreeModel.this.index);
        }

        public Object outer() {
            return SpanningTreeModel.this;
        }
    }

    class SpanningTreeAdminInfo
    extends CachedValue {
        public SpanningTreeAdminInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            this.node.getIorRepository().getEtherBridgeRef().setSpanningTreeAdminInfo((short)SpanningTreeModel.this.index, (sSpanningTreeAdminInfo)object);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getEtherBridgeRef().getSpanningTreeAdminInfo((short)SpanningTreeModel.this.index);
        }

        protected Object cloneValue() {
            sSpanningTreeAdminInfo sSpanningTreeAdminInfo2 = (sSpanningTreeAdminInfo)this.value;
            sSpanningTreeAdminInfo sSpanningTreeAdminInfo3 = new sSpanningTreeAdminInfo(sSpanningTreeAdminInfo2.priority, sSpanningTreeAdminInfo2.bridgeMaxAge, sSpanningTreeAdminInfo2.bridgeHelloTime, sSpanningTreeAdminInfo2.bridgeForwardDelay);
            return sSpanningTreeAdminInfo3;
        }

        public Object outer() {
            return SpanningTreeModel.this;
        }
    }
}

