/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.xInvalidRange;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.OSI.SubnetManager;
import cerent.cms.idl.OSI.eLinkType;
import cerent.cms.idl.OSI.sSubnet;
import cerent.cms.idl.OSI.xExistingSubnet;
import cerent.cms.idl.OSI.xMaxSubnets;
import cerent.cms.idl.OSI.xNoSuchRouter;
import cerent.cms.idl.OSI.xNoSuchSubnet;
import cerent.cms.idl.OSI.xRouterNotEnabled;
import cerent.cms.idl.SonetMedia.xInvalidDcc;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConfigError;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ExistingSubnet;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidDcc;
import cerent.cms.model.InvalidRange;
import cerent.cms.model.MaxSubnets;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchRouter;
import cerent.cms.model.NoSuchSubnet;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class SubnetModel
extends Model {
    private final int CREATING = 1;
    private final int DELETING = 2;
    private NodeModelDelegate nodeModel;
    private int maxRouters;
    private SubnetBody subnetBody;
    private ISHTimer iSHTimer;
    private ESHTimer eSHTimer;
    private IIHTimer iIHTimer;
    private ProvisionLanSubnet provLanSubnet;
    private RetrieveLanSubnet retrieveLanSubnet;
    private SubnetList[] subnetListArray;
    private EventDispatcher dispatcher;
    private static ModelSingletonCollection subnetModelSingletons;

    public static synchronized SubnetModel getInstance(NodeModelDelegate nodeModelDelegate) {
        SubnetModel subnetModel;
        if (subnetModelSingletons == null) {
            subnetModelSingletons = ModelSingletonCollection.getMSCInstanceByName((String)"SubnetModel");
        }
        if ((subnetModel = (SubnetModel)subnetModelSingletons.get((Object)nodeModelDelegate)) == null) {
            subnetModel = new SubnetModel(nodeModelDelegate);
            subnetModelSingletons.add((Object)nodeModelDelegate, (Object)subnetModel);
        }
        return subnetModel;
    }

    private SubnetModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(SubnetModel.class));
        this.nodeModel = nodeModelDelegate;
        if (nodeModelDelegate.getPlatform().is310cl() || nodeModelDelegate.getPlatform().is327() || nodeModelDelegate.getPlatform().is310ma()) {
            this.maxRouters = 1;
        } else if (nodeModelDelegate.getPlatform().is454() || nodeModelDelegate.getPlatform().is455()) {
            this.maxRouters = 3;
        } else if (nodeModelDelegate.getPlatform().is600()) {
            this.maxRouters = 12;
        }
        this.subnetBody = new SubnetBody(nodeModelDelegate);
        this.iSHTimer = new ISHTimer(nodeModelDelegate);
        this.eSHTimer = new ESHTimer(nodeModelDelegate);
        this.iIHTimer = new IIHTimer(nodeModelDelegate);
        this.provLanSubnet = new ProvisionLanSubnet(nodeModelDelegate, "SubnetModel::provLanSubnet");
        this.retrieveLanSubnet = new RetrieveLanSubnet(nodeModelDelegate, "SubnetModel::retrieveLanSubnet");
        this.subnetListArray = new SubnetList[this.maxRouters];
        for (int i = 0; i < this.maxRouters; ++i) {
            this.subnetListArray[i] = new SubnetList(nodeModelDelegate, "SubnetModel::subnetList");
        }
    }

    public INodeModel getNodeModel() {
        return this.getNodeModelDelegate();
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nodeModel;
    }

    private SubnetManager getOSISubnetRef() {
        return this.nodeModel.getIorRepository().getOSISubnetRef();
    }

    public void init() {
        int n;
        super.init0();
        this.dispatcher = this.nodeModel.getDispatcher();
        if (this.dispatcher != null) {
            for (n = 1; n <= this.maxRouters; ++n) {
                this.dispatcher.addObserver(ObjectType.ObjectOsiSubnetList, n, (Observer)this);
            }
        }
        this.retrieveLanSubnet.init();
        for (n = 0; n < this.subnetListArray.length; ++n) {
            this.subnetListArray[n].init();
        }
    }

    public sSubnet getSubnetBody(int n, eLinkType eLinkType2, int n2) throws NoSuchRouter, NoSuchSubnet {
        try {
            Object[] objectArray = new Object[]{new Short((short)n), eLinkType2, new Integer((short)n2)};
            return (sSubnet)this.subnetBody.get(objectArray);
        }
        catch (xNoSuchRouter xNoSuchRouter2) {
            throw new NoSuchRouter((UserException)xNoSuchRouter2);
        }
        catch (xNoSuchSubnet xNoSuchSubnet2) {
            throw new NoSuchSubnet((UserException)xNoSuchSubnet2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void createSubnetBody(sSubnet sSubnet2) throws MaxSubnets, ExistingSubnet, NoSuchRouter, ConfigError, InvalidDcc {
        Object[] objectArray = new Object[]{new Integer(1), sSubnet2};
        try {
            this.subnetBody.set(objectArray);
        }
        catch (xMaxSubnets xMaxSubnets2) {
            throw new MaxSubnets((UserException)xMaxSubnets2);
        }
        catch (xExistingSubnet xExistingSubnet2) {
            throw new ExistingSubnet((UserException)xExistingSubnet2);
        }
        catch (xNoSuchRouter xNoSuchRouter2) {
            throw new NoSuchRouter((UserException)xNoSuchRouter2);
        }
        catch (xInvalidDcc xInvalidDcc2) {
            throw new InvalidDcc((UserException)xInvalidDcc2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError("Subnet Configuration Error", (UserException)xConfigError2);
        }
        catch (xRouterNotEnabled xRouterNotEnabled2) {
            this.db.severe("trying to create subnet on a disabled router");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void removeSubnetBody(int n, eLinkType eLinkType2) throws NoSuchSubnet {
        try {
            Object[] objectArray = new Object[]{new Integer(2), new Integer(n), eLinkType2};
            this.subnetBody.set(objectArray);
        }
        catch (xNoSuchSubnet xNoSuchSubnet2) {
            throw new NoSuchSubnet((UserException)xNoSuchSubnet2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public sSubnet getSubnetByIndex(int n) throws NoSuchRouter {
        for (int i = 0; i < this.subnetListArray.length; ++i) {
            sSubnet[] sSubnetArray = this.getSubnetList((short)(i + 1));
            for (int j = 0; j < sSubnetArray.length; ++j) {
                if (sSubnetArray[j].dccIndex != n) continue;
                return sSubnetArray[j];
            }
        }
        return null;
    }

    public sSubnet[] getSubnetList(short s) throws NoSuchRouter {
        Short s2 = new Short(s);
        try {
            return (sSubnet[])this.subnetListArray[s - 1].get(s2);
        }
        catch (xNoSuchRouter xNoSuchRouter2) {
            throw new NoSuchRouter((UserException)xNoSuchRouter2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void provisionLanSubnet(sSubnet sSubnet2) throws ConfigError, InvalidRange {
        try {
            sSubnet2.dccIndex = 0;
            sSubnet2.routerNumber = 1;
            sSubnet2.type = eLinkType.LINK_TYPE_LAN;
            this.provLanSubnet.set(sSubnet2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (xRouterNotEnabled xRouterNotEnabled2) {
            this.db.severe("trying to provision subnet on a disabled router");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void deprovisionLanSubnet() throws NoSuchSubnet {
        try {
            this.provLanSubnet.get();
        }
        catch (xNoSuchSubnet xNoSuchSubnet2) {
            throw new NoSuchSubnet((UserException)xNoSuchSubnet2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public sSubnet getLanSubnet() throws NoSuchSubnet {
        try {
            return (sSubnet)this.retrieveLanSubnet.get();
        }
        catch (xNoSuchSubnet xNoSuchSubnet2) {
            throw new NoSuchSubnet((UserException)xNoSuchSubnet2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setISHTimer(int n, eLinkType eLinkType2, int n2, int n3) throws NoSuchRouter, NoSuchSubnet, InvalidRange {
        try {
            Object[] objectArray = new Object[]{new Short((short)n), eLinkType2, new Integer(n2), new Short((short)n3)};
            this.iSHTimer.set(objectArray);
        }
        catch (xNoSuchRouter xNoSuchRouter2) {
            throw new NoSuchRouter((UserException)xNoSuchRouter2);
        }
        catch (xNoSuchSubnet xNoSuchSubnet2) {
            throw new NoSuchSubnet((UserException)xNoSuchSubnet2);
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setESHTimer(int n, eLinkType eLinkType2, int n2, int n3) throws NoSuchRouter, NoSuchSubnet, InvalidRange {
        try {
            Object[] objectArray = new Object[]{new Short((short)n), eLinkType2, new Integer(n2), new Short((short)n3)};
            this.eSHTimer.set(objectArray);
        }
        catch (xNoSuchRouter xNoSuchRouter2) {
            throw new NoSuchRouter((UserException)xNoSuchRouter2);
        }
        catch (xNoSuchSubnet xNoSuchSubnet2) {
            throw new NoSuchSubnet((UserException)xNoSuchSubnet2);
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setIIHTimer(int n, eLinkType eLinkType2, int n2, int n3) throws NoSuchRouter, NoSuchSubnet, InvalidRange {
        try {
            Object[] objectArray = new Object[]{new Short((short)n), eLinkType2, new Integer(n2), new Short((short)n3)};
            this.iIHTimer.set(objectArray);
        }
        catch (xNoSuchRouter xNoSuchRouter2) {
            throw new NoSuchRouter((UserException)xNoSuchRouter2);
        }
        catch (xNoSuchSubnet xNoSuchSubnet2) {
            throw new NoSuchSubnet((UserException)xNoSuchSubnet2);
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void dispose() {
        int n;
        if (this.dispatcher != null) {
            for (n = 1; n <= this.maxRouters; ++n) {
                this.dispatcher.deleteObserver(ObjectType.ObjectOsiSubnetList, n, (Observer)this);
            }
        }
        this.retrieveLanSubnet.dispose();
        for (n = 0; n < this.subnetListArray.length; ++n) {
            this.subnetListArray[n].dispose();
        }
        super.dispose();
    }

    public void update(Observable observable, Object object) {
        this.db.fine("update()");
        if (observable instanceof CmsObservable) {
            int n = ((ObjectMessageInfo)object).getIndex();
            if (n > 0 && n <= this.maxRouters) {
                this.subnetListArray[n - 1].update();
                if (n == 1) {
                    this.retrieveLanSubnet.update();
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.CHANGED);
            } else {
                this.db.fine("update(): ignoring update for router: " + n);
            }
        }
    }

    class RetrieveLanSubnet
    extends CachedValue {
        public RetrieveLanSubnet(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return SubnetModel.this.getOSISubnetRef().getLanSubnet();
        }

        public Object outer() {
            return SubnetModel.this;
        }
    }

    class ProvisionLanSubnet
    extends NonCachedValue {
        public ProvisionLanSubnet(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            SubnetModel.this.getOSISubnetRef().provisionLanSubnet((sSubnet)object);
        }

        protected Object getValue() throws UserException {
            SubnetModel.this.getOSISubnetRef().removeLanSubnet();
            return null;
        }

        public Object outer() {
            return SubnetModel.this;
        }
    }

    class SubnetList
    extends CachedValue {
        public SubnetList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return SubnetModel.this.getOSISubnetRef().getSubnetList((Short)object);
        }

        public Object outer() {
            return SubnetModel.this;
        }
    }

    class IIHTimer
    extends NonCachedValue {
        public IIHTimer(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            SubnetModel.this.getOSISubnetRef().setIih((Short)objectArray[0], (eLinkType)objectArray[1], (Integer)objectArray[2], (Short)objectArray[3]);
        }

        public Object outer() {
            return SubnetModel.this;
        }
    }

    class ESHTimer
    extends NonCachedValue {
        public ESHTimer(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            SubnetModel.this.getOSISubnetRef().setEsh((Short)objectArray[0], (eLinkType)objectArray[1], (Integer)objectArray[2], (Short)objectArray[3]);
        }

        public Object outer() {
            return SubnetModel.this;
        }
    }

    class ISHTimer
    extends NonCachedValue {
        public ISHTimer(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            SubnetModel.this.getOSISubnetRef().setIsh((Short)objectArray[0], (eLinkType)objectArray[1], (Integer)objectArray[2], (Short)objectArray[3]);
        }

        public Object outer() {
            return SubnetModel.this;
        }
    }

    class SubnetBody
    extends NonCachedValue {
        public SubnetBody(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return SubnetModel.this.getOSISubnetRef().getInfo((Short)objectArray[0], (eLinkType)objectArray[1], (Integer)objectArray[2]);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            switch ((Integer)objectArray[0]) {
                case 1: {
                    SubnetModel.this.db.info("Creating subnet " + ((sSubnet)objectArray[1]).dccIndex);
                    SubnetModel.this.getOSISubnetRef().createSubnet((sSubnet)objectArray[1]);
                    break;
                }
                case 2: {
                    SubnetModel.this.db.info("Deleting subnet " + objectArray[1]);
                    SubnetModel.this.getOSISubnetRef().removeSubnetByIndex((Integer)objectArray[1], (eLinkType)objectArray[2]);
                    break;
                }
            }
        }

        public Object outer() {
            return SubnetModel.this;
        }
    }
}

