/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.SonetTopology.UnprotectedLine;
import cerent.cms.idl.SonetTopology.UnprotectedLineHelper;
import cerent.cms.idl.SonetTopology.eElementType;
import cerent.cms.idl.SonetTopology.sUnprotectedLineItem;
import cerent.cms.idl.SonetTopology.sUnprotectedLineProvision;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.NoSuchPoolException;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PoolModel;
import cerent.cms.model.PoolModelsDelegate;
import cerent.util.EnumStrings;
import cerent.util.EventBus;
import cerent.util.SDebug;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.UserException;

public class UnprotectedLineModel
extends ElementModel {
    private Pool poolCV;
    private Provision provision;
    private IsPoolless isPoolless;
    private UnprotectedLine unprotectedRef = null;
    private String myString;
    private IEntityModel main;

    public UnprotectedLineModel(NodeModelDelegate nodeModelDelegate, int n, sUnprotectedLineItem sUnprotectedLineItem2) {
        super(nodeModelDelegate, n, sUnprotectedLineItem2.element, nodeModelDelegate.getChildDebug(UnprotectedLineModel.class));
        if (this.db.on()) {
            this.db.println("<init>: entry of " + this);
        }
        this.poolCV = new Pool(nodeModelDelegate, "UnprotectedLineModel.pool");
        this.provision = new Provision(nodeModelDelegate, "UnprotectedLineModel.provision");
        if (!nodeModelDelegate.getPlatform().is600()) {
            this.isPoolless = new IsPoolless(nodeModelDelegate, "UnprotectedLineModel.isPoolless");
        }
        this.setAttributes(sUnprotectedLineItem2);
        this.setIndex(this.getMainEntityIndex());
        this.myString = null;
        if (this.db.on()) {
            this.db.println("<init>: exit of " + this);
        }
    }

    public void init() {
        block2: {
            super.init();
            try {
                this.main = this.getMainEntityModel();
                EventBus.instance().notifyEvent((Object)"UNPROTECTED_LINE_CREATED_ON_PORT", (Object)this.main);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on) break block2;
                this.db.println("AbstractCmsNoSuchEntityException caught: " + (Object)((Object)abstractCmsNoSuchEntityException));
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
    }

    private UnprotectedLine getUnprotectedRef() {
        if (this.unprotectedRef == null) {
            this.unprotectedRef = UnprotectedLineHelper.narrow(this.getElementRef());
        }
        return this.unprotectedRef;
    }

    private PoolModelsDelegate getPoolModels() {
        return (PoolModelsDelegate)this.node.getPoolModels();
    }

    boolean referencesEntityIndex(int n) {
        return n == this.getMainEntityIndex();
    }

    int[] getIndices() {
        return new int[]{this.getMainEntityIndex()};
    }

    public void setAttributes(sUnprotectedLineItem sUnprotectedLineItem2) {
        block3: {
            super.setAttributes(sUnprotectedLineItem2.elementData);
            this.provision.setValueExternally(sUnprotectedLineItem2.provision);
            if (sUnprotectedLineItem2.pool != null) {
                try {
                    this.poolCV.setValueExternally(this.getPoolModels().getObjIndexFromPool(sUnprotectedLineItem2.pool));
                }
                catch (NoSuchPoolException noSuchPoolException) {
                    if (!this.db.on) break block3;
                    this.db.println("Couldn't find Pool in cache. Will stay UNINITIALIZED");
                }
            }
        }
    }

    protected IPoolModel getPoolModel(int n) {
        if (this.getPoolModel() == null) {
            return null;
        }
        if (this.getPoolModel().getEntityIndex() == n) {
            return this.getPoolModel();
        }
        return null;
    }

    private Integer getPoolIndex() {
        try {
            return (Integer)this.poolCV.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IPoolModel getPoolModel() {
        if (this.db.on) {
            this.db.println("Called getPoolModel");
        }
        return this.getPoolModels().find(this.getPoolIndex());
    }

    protected boolean containsPool(PoolModel poolModel) {
        if (this.isPoolless()) {
            return false;
        }
        return poolModel.getObjIndex() == this.getPoolIndex().intValue();
    }

    private sUnprotectedLineProvision getProvision() {
        try {
            return (sUnprotectedLineProvision)this.provision.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private boolean isPoolless() {
        if (this.isPoolless == null) {
            return false;
        }
        boolean bl = false;
        try {
            bl = (Boolean)this.isPoolless.get();
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            if (this.db.on()) {
                this.db.println("The Network Element does not support the isPoolless function. Returning false.");
            }
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return bl;
    }

    public int getMainEntityIndex() throws AbstractCmsIOException {
        return this.getProvision().main;
    }

    public int getProtectEntityIndex() {
        return -1;
    }

    public IEntityModel getProtectEntityModel() {
        return null;
    }

    protected void updateLocal() {
        this.poolCV.update();
        this.provision.update();
        if (this.isPoolless != null) {
            this.isPoolless.update();
        }
        this.setChanged();
        super.updateLocal();
    }

    public void dispose() {
        if (this.main != null) {
            EventBus.instance().notifyEvent((Object)"UNPROTECTED_LINE_DELETED_ON_PORT", (Object)this.main);
        } else if (this.db.on) {
            this.db.println("Main entity is null. Couldn't notify on EventBus");
        }
        this.poolCV.dispose();
        this.provision.dispose();
        if (this.isPoolless != null) {
            this.isPoolless.dispose();
        }
        this.myString = null;
        super.dispose();
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy(): entry");
        }
        super.destroy();
    }

    public String toString() {
        if (this.myString == null) {
            try {
                this.myString = "UnprotectedLine[" + this.getName() + "/" + Integer.toHexString(this.getIndex()) + "/" + EnumStrings.getStrings((Class)eElementType.class)[this.getType()] + "]";
            }
            catch (Exception exception) {
                return "UnprotectedLine[deleted/inaccessible]";
            }
        }
        return this.myString;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof UnprotectedLineModel)) {
            return false;
        }
        return super.equals(object);
    }

    class IsPoolless
    extends CachedValue {
        public IsPoolless(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Boolean(UnprotectedLineModel.this.getUnprotectedRef().isPoolless());
        }

        public Object outer() {
            return UnprotectedLineModel.this;
        }
    }

    class Provision
    extends CachedValue {
        public Provision(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return UnprotectedLineModel.this.getUnprotectedRef().provision();
        }

        protected Object cloneValue() {
            sUnprotectedLineProvision sUnprotectedLineProvision2 = (sUnprotectedLineProvision)this.value;
            sUnprotectedLineProvision sUnprotectedLineProvision3 = new sUnprotectedLineProvision(sUnprotectedLineProvision2.main);
            return sUnprotectedLineProvision3;
        }

        public Object outer() {
            return UnprotectedLineModel.this;
        }
    }

    class Pool
    extends CachedValue {
        public Pool(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            cerent.cms.idl.SonetMedia.Pool pool = UnprotectedLineModel.this.getUnprotectedRef().pool();
            try {
                return UnprotectedLineModel.this.getPoolModels().getObjIndexFromPool(pool);
            }
            catch (NoSuchPoolException noSuchPoolException) {
                if (UnprotectedLineModel.this.db.on()) {
                    UnprotectedLineModel.this.db.println("Couldn't find Pool in cache. Getting it from the Node");
                }
                return new Integer(pool.objIndex());
            }
        }

        public Object outer() {
            return UnprotectedLineModel.this;
        }
    }
}

