/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.SonetTopology.sStatusStsConn;
import cerent.cms.idl.SonetTopology.sStatusVtConn;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.IVcatTermMember;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.VcatTermMember;
import cerent.util.SDebug;
import java.util.ArrayList;

public class VcatTermMemberFactory {
    private static final SDebug db = new SDebug("VcatTermMemberFactory");

    public static IVcatTermMember getIHoVcatTermMember(NodeModelDelegate nodeModelDelegate, sStatusStsConn sStatusStsConn2) {
        IHoConnectionModel iHoConnectionModel = ((ConnectionModelsDelegate)nodeModelDelegate.getConnectionModels()).findHoConnectionModel(sStatusStsConn2.connObjIndex);
        if (iHoConnectionModel == null) {
            String string = Integer.toHexString(sStatusStsConn2.connObjIndex);
            db.println("Cannot find Connection Index = " + string);
            throw new CmsObjectNotExistException("Cannot find Connection Index = " + string);
        }
        return new VcatTermMember((IConnectionModel)iHoConnectionModel, sStatusStsConn2.status.value(), sStatusStsConn2.memNum);
    }

    public static IVcatTermMember getILoVcatTermMember(NodeModelDelegate nodeModelDelegate, sStatusVtConn sStatusVtConn2) {
        ILoConnectionModel iLoConnectionModel = ((ConnectionModelsDelegate)nodeModelDelegate.getConnectionModels()).findLoConnectionModel(sStatusVtConn2.connObjIndex);
        if (iLoConnectionModel == null) {
            String string = Integer.toHexString(sStatusVtConn2.connObjIndex);
            db.println("Cannot find Connection Index = " + string);
            throw new CmsObjectNotExistException("Cannot find Connection Index = " + string);
        }
        return new VcatTermMember((IConnectionModel)iLoConnectionModel, sStatusVtConn2.status.value(), sStatusVtConn2.memNum);
    }

    public static IVcatTermMember[] getIHoVcatTermMemberArray(NodeModelDelegate nodeModelDelegate, sStatusStsConn[] sStatusStsConnArray) {
        ArrayList<IVcatTermMember> arrayList = new ArrayList<IVcatTermMember>(sStatusStsConnArray.length);
        for (int i = 0; i < sStatusStsConnArray.length; ++i) {
            try {
                if (sStatusStsConnArray[i].stsConn != null) {
                    arrayList.add(VcatTermMemberFactory.getIHoVcatTermMember(nodeModelDelegate, sStatusStsConnArray[i]));
                    continue;
                }
                String string = Integer.toHexString(sStatusStsConnArray[i].connObjIndex);
                if (!db.on()) continue;
                db.println("Not adding member with connIndex = " + string + " as its connRef is null");
                continue;
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
            }
        }
        return arrayList.toArray(new VcatTermMember[0]);
    }

    public static IVcatTermMember[] getILoVcatTermMemberArray(NodeModelDelegate nodeModelDelegate, sStatusVtConn[] sStatusVtConnArray) {
        ArrayList<IVcatTermMember> arrayList = new ArrayList<IVcatTermMember>(sStatusVtConnArray.length);
        for (int i = 0; i < sStatusVtConnArray.length; ++i) {
            try {
                if (sStatusVtConnArray[i].vtConn != null) {
                    arrayList.add(VcatTermMemberFactory.getILoVcatTermMember(nodeModelDelegate, sStatusVtConnArray[i]));
                    continue;
                }
                String string = Integer.toHexString(sStatusVtConnArray[i].connObjIndex);
                if (!db.on()) continue;
                db.println("Not adding member with connIndex = " + string + " as its connRef is null");
                continue;
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
            }
        }
        return arrayList.toArray(new VcatTermMember[0]);
    }
}

