/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.SDebug;

public class VirtualLinkModel
implements IVirtualLinkModel {
    private short origVLID;
    private IIpAddr origNode;
    private IEntityModel origEntity;
    private short termVLID;
    private IIpAddr termNode;
    private IEntityModel termEntity;
    private String cachedStr = null;
    private static final SDebug db = new SDebug("VirtualLinkModel");

    public VirtualLinkModel(short s, IIpAddr iIpAddr, IEntityModel iEntityModel, short s2, IIpAddr iIpAddr2, IEntityModel iEntityModel2) {
        this.origVLID = s;
        this.origNode = iIpAddr;
        this.origEntity = iEntityModel;
        this.termVLID = s2;
        this.termNode = iIpAddr2;
        this.termEntity = iEntityModel2;
    }

    public short getOrigVLID() {
        return this.origVLID;
    }

    public IIpAddr getOrigNode() {
        return this.origNode;
    }

    public IEntityModel getOrigEntity() {
        return this.origEntity;
    }

    public IEntityModel getTermEntity() {
        return this.termEntity;
    }

    public IIpAddr getTermNode() {
        return this.termNode;
    }

    public short getTermVLID() {
        return this.termVLID;
    }

    public short getOrigShelfId() {
        if (this.origEntity != null) {
            return (short)this.origEntity.getShelfId();
        }
        return 1;
    }

    public short getTermShelfId() {
        if (this.termEntity != null) {
            return (short)this.termEntity.getShelfId();
        }
        return 1;
    }

    public void setOrigVLID(short s) {
        this.origVLID = s;
        this.cachedStr = null;
    }

    public void setOrigNode(IIpAddr iIpAddr) {
        this.origNode = iIpAddr;
        this.cachedStr = null;
    }

    public void setOrigEntity(IEntityModel iEntityModel) {
        this.origEntity = iEntityModel;
        this.cachedStr = null;
    }

    public void setTermEntity(IEntityModel iEntityModel) {
        this.termEntity = iEntityModel;
        this.cachedStr = null;
    }

    public void setTermNode(IIpAddr iIpAddr) {
        this.termNode = iIpAddr;
        this.cachedStr = null;
    }

    public void setTermVLID(short s) {
        this.termVLID = s;
        this.cachedStr = null;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        if (object != null && object instanceof IVirtualLinkModel) {
            IVirtualLinkModel iVirtualLinkModel = (IVirtualLinkModel)object;
            if (db.on()) {
                db.fine("compareTo: this is " + this);
                db.fine("          other is " + iVirtualLinkModel);
            }
            if (iVirtualLinkModel.getOrigVLID() == this.origVLID) {
                if (iVirtualLinkModel.getOrigNode().compareTo((Object)this.origNode) == 0) {
                    if (iVirtualLinkModel.getOrigEntity() != null && iVirtualLinkModel.getOrigEntity().equals(this.origEntity) || iVirtualLinkModel.getOrigEntity() == null && this.origEntity == null) {
                        if (iVirtualLinkModel.getTermVLID() == this.origVLID) {
                            if (iVirtualLinkModel.getTermNode().compareTo((Object)this.termNode) == 0) {
                                if (iVirtualLinkModel.getTermEntity() == null && this.termEntity == null || iVirtualLinkModel.getTermEntity().equals(this.termEntity)) {
                                    return 0;
                                }
                                if (iVirtualLinkModel.getTermEntity() != null && this.termEntity == null) {
                                    return -1;
                                }
                                return 1;
                            }
                            return iVirtualLinkModel.getTermNode().compareTo((Object)this.termNode);
                        }
                        return new Integer(this.termVLID).compareTo(new Integer(iVirtualLinkModel.getTermVLID()));
                    }
                    if (iVirtualLinkModel.getOrigEntity() != null && this.origEntity == null) {
                        return -1;
                    }
                    return 1;
                }
                return iVirtualLinkModel.getOrigNode().compareTo((Object)this.origNode);
            }
            return new Integer(this.origVLID).compareTo(new Integer(iVirtualLinkModel.getOrigVLID()));
        }
        return 1;
    }

    private boolean shouldSwap() {
        boolean bl = true;
        if (this.origEntity != null && (this.origEntity.getEqType() == 139 || this.origEntity.getEqType() == 141) || this.termEntity != null && (this.termEntity.getEqType() == 139 || this.termEntity.getEqType() == 141)) {
            IModuleModel iModuleModel;
            IModuleModel iModuleModel2 = this.origEntity != null ? this.origEntity.getModuleModel() : null;
            IModuleModel iModuleModel3 = iModuleModel = this.termEntity != null ? this.termEntity.getModuleModel() : null;
            if (iModuleModel2 != null && iModuleModel != null && (iModuleModel2.getEqType() == 132 || iModuleModel.getEqType() == 131 || (iModuleModel2.getEqType() == 133 || this.origEntity.getEqType() == 141) && this.origEntity.getPositionInParent() % 2 == 0 || (iModuleModel.getEqType() == 133 || this.termEntity.getEqType() == 141) && this.termEntity.getPositionInParent() % 2 != 0)) {
                bl = false;
            }
        }
        return bl;
    }

    public void swap() {
        if (this.shouldSwap()) {
            short s = this.origVLID;
            IIpAddr iIpAddr = this.origNode;
            IEntityModel iEntityModel = this.origEntity;
            this.origVLID = this.termVLID;
            this.origNode = this.termNode;
            this.origEntity = this.termEntity;
            this.termVLID = s;
            this.termNode = iIpAddr;
            this.termEntity = iEntityModel;
            this.cachedStr = null;
        }
    }

    public String toString() {
        if (this.cachedStr == null) {
            StringBuffer stringBuffer = new StringBuffer("[");
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            stringBuffer.append(Short.toString(this.origVLID) + ", ");
            stringBuffer.append(IpAddrFactory.ipToString(this.origNode) + ", ");
            stringBuffer.append(entityCellRenderer.getString(this.origEntity, "shelf ") + ", ");
            stringBuffer.append(Short.toString(this.termVLID) + ", ");
            stringBuffer.append(IpAddrFactory.ipToString(this.termNode) + ", ");
            stringBuffer.append(entityCellRenderer.getString(this.termEntity, "shelf ") + "]");
            this.cachedStr = stringBuffer.toString();
        }
        return this.cachedStr;
    }
}

