/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.BbeSlot;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds123ModuleModel;
import cerent.cms.model.Ds123PortModel;
import cerent.cms.model.EntityContainer;
import cerent.cms.model.IDs1Retiming;
import cerent.cms.model.IDs1Timing;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PathTraceInfo;
import cerent.cms.model.PortModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.WbeSlot;
import cerent.util.AnnotatedException;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WbeModuleModel
extends Ds123ModuleModel
implements IDs1Timing,
IDs1Retiming {
    public WbeModuleModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2);
    }

    private PortModel[] toPortArray(List list) {
        return list.toArray(new PortModel[list.size()]);
    }

    private Ds123PortModel[] toDs123PortArray(List list) {
        return list.toArray(new Ds123PortModel[list.size()]);
    }

    private TdmPortModel[] toTdmPortArray(List list) {
        return list.toArray(new TdmPortModel[list.size()]);
    }

    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        InterfaceModel[] interfaceModelArray = null;
        if (eEqType2 == null) {
            interfaceModelArray = super.getLineModels(eEqType2);
        } else {
            PortModel[] portModelArray = this.getPortModels(eEqType2);
            if (this.db.on()) {
                this.db.println("Found " + portModelArray.length + " ports");
            }
            switch (eEqType2.value()) {
                case 32: 
                case 34: {
                    if (this.db.on()) {
                        this.db.println("Finding lines for Ds123 ports...");
                    }
                    interfaceModelArray = new Ds123LineModel[portModelArray.length];
                    for (int i = 0; i < portModelArray.length; ++i) {
                        interfaceModelArray[i] = (Ds123LineModel)portModelArray[i].getInterfaceModel();
                    }
                    break;
                }
                case 31: {
                    if (this.db.on()) {
                        this.db.println("Finding lines for Tdm ports...");
                    }
                    interfaceModelArray = new TdmLineModel[portModelArray.length];
                    for (int i = 0; i < portModelArray.length; ++i) {
                        interfaceModelArray[i] = (TdmLineModel)portModelArray[i].getInterfaceModel();
                    }
                    break;
                }
                default: {
                    this.db.println("Could not get lines for WBE Card!");
                    if (!this.db.on()) break;
                    SDebug.printStackTrace((Throwable)new Exception());
                }
            }
        }
        return interfaceModelArray == null ? new InterfaceModel[]{} : interfaceModelArray;
    }

    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        if (eEqType2 == null) {
            portModelArray = this.toPortArray(this.getDescendantsOfClassType(7));
        } else {
            switch (eEqType2.value()) {
                case 32: 
                case 34: {
                    portModelArray = this.toDs123PortArray(this.getDescendantsOfType(eEqType2));
                    break;
                }
                case 31: {
                    portModelArray = this.toTdmPortArray(this.getDescendantsOfType(eEqType2));
                    break;
                }
                default: {
                    this.db.println("Could not get ports for WBE Card!");
                    if (!this.db.on()) break;
                    SDebug.printStackTrace((Throwable)new Exception());
                }
            }
        }
        return portModelArray == null ? new PortModel[]{} : portModelArray;
    }

    public Ds123LineModel[] getDs1Lines() {
        return (Ds123LineModel[])this.getLineModels(eEqType.DS1_VT_MAPPED);
    }

    public Ds123LineModel[] getDs3Lines() {
        return (Ds123LineModel[])this.getLineModels(eEqType.DS3);
    }

    public TdmLineModel[] getEc1Lines() {
        return (TdmLineModel[])this.getLineModels(eEqType.EC1_PORT);
    }

    private int getStsNumFromDs1PortNum(int[] nArray) {
        int n = 0;
        if (nArray != null && nArray.length == 1) {
            n = (nArray[0] - 1) / 28 + 1;
        }
        return n;
    }

    public List getPortsInGroup(IPortModel iPortModel, int n) {
        List<PortModel> list;
        block5: {
            list = new ArrayList();
            try {
                int n2 = iPortModel.getEqType();
                boolean bl = CircuitSize.getCircuitSize((int)n).isLo(Model.getFramingType(this.getNodeModel()).getEnum());
                if (!bl && n2 == 34) {
                    int n3 = this.getStsNumFromDs1PortNum(((PortModel)iPortModel).getPortNum());
                    int n4 = (n3 - 1) * 28;
                    int n5 = n4 + 28 + 1;
                    int[] nArray = null;
                    PortModel[] portModelArray = this.getPortModels(eEqType.DS1_VT_MAPPED);
                    for (int i = 0; i < portModelArray.length; ++i) {
                        int n6;
                        nArray = portModelArray[i].getPortNum();
                        if (nArray == null || nArray.length != 1 || (n6 = nArray[0]) <= n4 || n6 >= n5) continue;
                        list.add(portModelArray[i]);
                    }
                } else {
                    list = super.getPortsInGroup(iPortModel, n);
                }
            }
            catch (AnnotatedException annotatedException) {
                this.db.println("In getPortsInGroup, could not get framing type!");
                if (!this.db.on()) break block5;
                SDebug.printStackTrace((Throwable)annotatedException);
            }
        }
        return list;
    }

    public String toString() {
        return "DS1_N_DS3_EC1_3" + super.toString();
    }

    protected IPortModel getPortModelForHoPath(IEntityModel iEntityModel, IHoNum iHoNum) {
        return (IPortModel)iEntityModel;
    }

    protected IPortModel getPortModelForLoPath(IEntityModel iEntityModel, IHoNum iHoNum, ILoNum iLoNum) {
        int[] nArray = ((IPortModel)iEntityModel).getPortNum();
        int[] nArray2 = null;
        if (nArray != null && nArray.length == 1) {
            nArray2 = new int[]{nArray[0] + iLoNum.getIdlFlatNum() - 1};
        }
        return this.getPortByNumberAndType(eEqType.DS1_VT_MAPPED, nArray2);
    }

    public boolean isComboModule() {
        return true;
    }

    boolean isPortNumUnique(int n) {
        return false;
    }

    public BbeSlot getBbeSlot() throws CmsNoSuchEntityException {
        return (BbeSlot)this.getSlot(eEqType.BBE_SLOT);
    }

    public WbeSlot getWbeSlot() throws CmsNoSuchEntityException {
        return (WbeSlot)this.getSlot(eEqType.WBE_SLOT);
    }

    public int getMaxBbePorts() {
        int n;
        block2: {
            n = 0;
            try {
                BbeSlot bbeSlot = this.getBbeSlot();
                n = bbeSlot.getMaxPorts();
            }
            catch (CmsNoSuchEntityException cmsNoSuchEntityException) {
                this.db.println("getMaxBbePorts(): caught CmsNoSuchEntityException");
                if (!this.db.on()) break block2;
                SDebug.printStackTrace((Throwable)((Object)cmsNoSuchEntityException));
            }
        }
        return n;
    }

    public int getMaxWbePorts() {
        int n;
        block2: {
            n = 0;
            try {
                WbeSlot wbeSlot = this.getWbeSlot();
                n = wbeSlot.getMaxPorts();
            }
            catch (CmsNoSuchEntityException cmsNoSuchEntityException) {
                this.db.println("getMaxWbePorts(): caught CmsNoSuchEntityException");
                if (!this.db.on()) break block2;
                SDebug.printStackTrace((Throwable)((Object)cmsNoSuchEntityException));
            }
        }
        return n;
    }

    private EntityContainer getSlot(eEqType eEqType2) throws CmsNoSuchEntityException {
        List list = this.getChildrenOfType(eEqType2);
        if (list.size() != 1) {
            this.db.println("Found " + list.size() + " Slots!");
            throw new CmsNoSuchEntityException("Wrong number of Slots!");
        }
        return (EntityContainer)list.get(0);
    }

    public boolean supportsLoopbackAis() {
        return true;
    }

    public boolean supportsTermLoopbackAis(IPortModel iPortModel) {
        return true;
    }

    public PathTraceInfo[] getJ1PathTraceInfo() throws CTCUserException {
        ArrayList<PathTraceInfo> arrayList = new ArrayList<PathTraceInfo>();
        PathTraceInfo[] pathTraceInfoArray = this.getJ1PathTraceInfo(this.getDs1Lines());
        arrayList.addAll(Arrays.asList(pathTraceInfoArray));
        pathTraceInfoArray = this.getJ1PathTraceInfo(this.getDs3Lines());
        arrayList.addAll(Arrays.asList(pathTraceInfoArray));
        pathTraceInfoArray = this.getJ1PathTraceInfo(this.getEc1Lines());
        arrayList.addAll(Arrays.asList(pathTraceInfoArray));
        return arrayList.toArray(new PathTraceInfo[arrayList.size()]);
    }

    public boolean supportsAutoTrace() {
        return true;
    }

    public boolean supportsDs1Timing() {
        return true;
    }

    public boolean supportsDs1Retiming() {
        return this.getEqType() != 234;
    }
}

