/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.enum;

import cerent.cms.idl.EtherMedia.eCardFpgaMode;
import cerent.cms.idl.EtherMedia.eEncapCrcType;
import cerent.cms.idl.EtherMedia.eEtherDuplex;
import cerent.cms.idl.EtherMedia.eEtherSpeed;
import cerent.cms.idl.EtherMedia.eFlowControlNegotiated;
import cerent.cms.idl.EtherMedia.ePosFramingType;
import cerent.cms.model.Attribute;
import cerent.cms.model.enum.AbstractEnumStrings;
import java.util.TreeMap;

public class EtherEnumStrings
extends AbstractEnumStrings {
    public static int[] ML2_ETHER_SPEED = new int[]{0, 1, 3};
    public static int[] ML2_ENCAP_CRC = new int[]{0, 2};
    public static int[] ML2_FLOW_CONTROL = new int[]{1, 2, 0, 3};
    public static int[] ML2_GIGE_FLOW_CONTROL = new int[]{0, 4, 3};
    public static int[] POS_FRAMING_NO_X86 = new int[]{0, 1};

    private static void createMap(Class clazz) {
        if (clazz == eEncapCrcType.class) {
            EtherEnumStrings.getEncapCrcType(clazz);
        } else if (clazz == ePosFramingType.class) {
            EtherEnumStrings.getPosFramingType(clazz);
        } else if (clazz == eEtherDuplex.class) {
            EtherEnumStrings.getEtherDuplex(clazz);
        } else if (clazz == eEtherSpeed.class) {
            EtherEnumStrings.getEtherSpeed(clazz);
        } else if (clazz == eFlowControlNegotiated.class) {
            EtherEnumStrings.getFlowControlNegotiated(clazz);
        } else if (clazz == eCardFpgaMode.class) {
            EtherEnumStrings.getFpgaMode(clazz);
        }
    }

    private static void getEncapCrcType(Class clazz) {
        TreeMap treeMap = new TreeMap();
        EtherEnumStrings.putAttribute(treeMap, 0, "none");
        EtherEnumStrings.putAttribute(treeMap, 1, "16-Bit");
        EtherEnumStrings.putAttribute(treeMap, 2, "32-Bit");
        attributeMap.put(clazz.getName(), treeMap);
    }

    private static void getPosFramingType(Class clazz) {
        TreeMap treeMap = new TreeMap();
        EtherEnumStrings.putAttribute(treeMap, 0, "GFP-F");
        EtherEnumStrings.putAttribute(treeMap, 1, "HDLC");
        EtherEnumStrings.putAttribute(treeMap, 2, "X.86");
        EtherEnumStrings.putAttribute(treeMap, 3, "GFP-NOCRC");
        EtherEnumStrings.putAttribute(treeMap, 4, "802.17 RPR");
        attributeMap.put(clazz.getName(), treeMap);
    }

    private static void getEtherDuplex(Class clazz) {
        TreeMap treeMap = new TreeMap();
        EtherEnumStrings.putAttribute(treeMap, 0, "Full");
        EtherEnumStrings.putAttribute(treeMap, 1, "Half");
        EtherEnumStrings.putAttribute(treeMap, 2, "Auto");
        attributeMap.put(clazz.getName(), treeMap);
    }

    private static void getEtherSpeed(Class clazz) {
        TreeMap treeMap = new TreeMap();
        EtherEnumStrings.putAttribute(treeMap, 0, "10 Mbps");
        EtherEnumStrings.putAttribute(treeMap, 1, "100 Mbps");
        EtherEnumStrings.putAttribute(treeMap, 2, "1000 Mbps");
        EtherEnumStrings.putAttribute(treeMap, 3, "Auto");
        attributeMap.put(clazz.getName(), treeMap);
    }

    private static void getFlowControlNegotiated(Class clazz) {
        TreeMap treeMap = new TreeMap();
        EtherEnumStrings.putAttribute(treeMap, 1, "Asymmetric");
        EtherEnumStrings.putAttribute(treeMap, 2, "Asymmetric Local");
        EtherEnumStrings.putAttribute(treeMap, 0, "None");
        EtherEnumStrings.putAttribute(treeMap, 4, "Pass Through");
        EtherEnumStrings.putAttribute(treeMap, 3, "Symmetric");
        attributeMap.put(clazz.getName(), treeMap);
    }

    private static void getFpgaMode(Class clazz) {
        TreeMap treeMap = new TreeMap();
        EtherEnumStrings.putAttribute(treeMap, 1, "HDLC");
        EtherEnumStrings.putAttribute(treeMap, 2, "GFP-F");
        attributeMap.put(clazz.getName(), treeMap);
    }

    public static Attribute[] get(Class clazz) {
        if (!attributeMap.containsKey(clazz.getName())) {
            EtherEnumStrings.createMap(clazz);
        }
        return EtherEnumStrings.getAttributeArray(clazz);
    }

    public static Attribute[] get(Class clazz, int[] nArray) {
        if (!attributeMap.containsKey(clazz.getName())) {
            EtherEnumStrings.createMap(clazz);
        }
        return EtherEnumStrings.getFilteredAttributeArray(clazz, nArray);
    }

    public static Attribute[] get(Class clazz, int[] nArray, boolean bl) {
        if (!attributeMap.containsKey(clazz.getName())) {
            EtherEnumStrings.createMap(clazz);
        }
        return EtherEnumStrings.getFilteredAttributeArray(clazz, nArray, bl);
    }

    public static Attribute get(Class clazz, int n) {
        if (!attributeMap.containsKey(clazz.getName())) {
            EtherEnumStrings.createMap(clazz);
        }
        return EtherEnumStrings.getAttribute(clazz, n);
    }

    public static String getString(Class clazz, int n) {
        return EtherEnumStrings.get(clazz, n).getKey();
    }
}

