/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.event;

import cerent.cms.model.CmsObservable;
import cerent.cms.model.event.AbstractEventStore;
import cerent.cms.model.event.AlarmCorrelator;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.model.event.ICardAlarmStore;
import cerent.cms.model.event.SimpleAlarmCorrelator;
import cerent.cms.model.event.StoreObservable;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

public abstract class AbstractAlarmStore
extends AbstractEventStore
implements IAlarmStore {
    private static final String PREFS_AUTODELETE = "autoDelete";
    private static final String PREFS_SHOW_EVENTS = "showEvents";
    private static boolean autoDeleteCleared = Preferences.instance().getBoolean("ctc", "autoDelete", false);
    private static boolean showEvents = Preferences.instance().getBoolean("ctc", "showEvents", false);
    protected AlarmCorrelator correlator;
    protected AlarmStatus alrStatus;
    protected CmsObservable alarmStatusObservable;
    protected ArrayList shortArrayList = new ArrayList();

    public AbstractAlarmStore(String string) {
        this.name = string;
        this.alarmStatusObservable = new StoreObservable(this.name);
        this.storeObservable = new StoreObservable(this.name);
        this.correlator = new SimpleAlarmCorrelator();
        this.alrStatus = new AlarmStatus();
    }

    public EventInfo storeEvent(EventInfo eventInfo) {
        int n;
        if (eventInfo.getState() != 'T' && (n = this.findCorrelatedAlarm(this.arrayList, eventInfo)) >= 0) {
            return this.addCorrelatedAlarm(n, eventInfo);
        }
        if (this.db.on()) {
            this.db.fine(this.name + " storeEvent:" + eventInfo + " corl=null");
        }
        this.addNonCorrelatedAlarm(eventInfo);
        return null;
    }

    public EventInfo correlateAlarm(EventInfo eventInfo, EventInfo eventInfo2) {
        if (eventInfo2 != null) {
            int n = this.findCorrelatedAlarm(this.arrayList, eventInfo2);
            if (n >= 0) {
                return this.addCorrelatedAlarm(n, eventInfo);
            }
            this.db.info("Expected correlated alarm not found");
            this.addNonCorrelatedAlarm(eventInfo);
            return null;
        }
        this.addNonCorrelatedAlarm(eventInfo);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClearedAlarms() {
        boolean bl;
        Object object = this;
        synchronized (object) {
            bl = this.removeClearedAlarmsAndSetNotNew(this.arrayList);
            if (bl) {
                this.removeClearedAlarmsAndSetNotNew(this.filteredArrayList);
            }
        }
        if (this.children != null) {
            object = this.children.values().iterator();
            while (object.hasNext()) {
                AbstractAlarmStore abstractAlarmStore = (AbstractAlarmStore)object.next();
                abstractAlarmStore.removeClearedAlarms();
            }
        }
        this.db.info(this.name + " removeClearedAlarms: changed=" + bl);
        if (bl) {
            this.fireDataSourceChanged();
        }
    }

    private boolean removeClearedAlarmsAndSetNotNew(ArrayList arrayList) {
        boolean bl = false;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            EventInfo eventInfo = (EventInfo)iterator.next();
            if (eventInfo.getState() == 'C') {
                iterator.remove();
                bl = true;
            }
            if (!eventInfo.getNewAlm()) continue;
            eventInfo.setNewAlm(false);
            bl = true;
        }
        return bl;
    }

    public IAlarmStatus getAlarmStatus() {
        return this.alrStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAlarmByCondition(int n) {
        ArrayList<EventInfo> arrayList = new ArrayList<EventInfo>();
        AbstractAlarmStore abstractAlarmStore = this;
        synchronized (abstractAlarmStore) {
            for (int i = 0; i < this.arrayList.size(); ++i) {
                EventInfo eventInfo = (EventInfo)this.arrayList.get(i);
                if (eventInfo.getCondition() != n) continue;
                arrayList.add(eventInfo);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAlarmByService(boolean bl) {
        ArrayList<EventInfo> arrayList = new ArrayList<EventInfo>();
        AbstractAlarmStore abstractAlarmStore = this;
        synchronized (abstractAlarmStore) {
            for (int i = 0; i < this.arrayList.size(); ++i) {
                EventInfo eventInfo = (EventInfo)this.arrayList.get(i);
                if (eventInfo.getSrvAffecting() != bl) continue;
                arrayList.add(eventInfo);
            }
        }
        return arrayList;
    }

    public void addAlarmStatusObserver(Observer observer) {
        this.alarmStatusObservable.addObserver(observer);
    }

    public void deleteAlarmStatusObserver(Observer observer) {
        this.alarmStatusObservable.deleteObserver(observer);
    }

    public Observable getAlarmStatusObservable() {
        return this.alarmStatusObservable;
    }

    public ICardAlarmStore getCardAlarmStore(int n) {
        return null;
    }

    public ICardAlarmStore getCardAlarmStore(int n, int n2) {
        return null;
    }

    public void destroy() {
        super.destroy();
        this.alarmStatusObservable.deleteObservers();
    }

    protected synchronized void localFlushStore() {
        this.alrStatus.reset();
    }

    public boolean isAutoDeleteCleared() {
        autoDeleteCleared = Preferences.instance().getBoolean("ctc", PREFS_AUTODELETE, false);
        return autoDeleteCleared;
    }

    public void setAutoDeleteCleared(boolean bl) {
        autoDeleteCleared = bl;
        Preferences.instance().setBoolean("ctc", PREFS_AUTODELETE, autoDeleteCleared);
    }

    public boolean isShowEvents() {
        boolean bl = Preferences.instance().getBoolean("ctc", PREFS_SHOW_EVENTS, false);
        if (bl != showEvents) {
            showEvents = bl;
            this.fireDataSourceChanged();
        }
        return showEvents;
    }

    public void setShowEvents(boolean bl) {
        if (showEvents != bl) {
            showEvents = bl;
            Preferences.instance().setBoolean("ctc", PREFS_SHOW_EVENTS, showEvents);
            this.fireDataSourceChanged();
        }
    }

    public String toString() {
        return "AlarmStore " + this.name + " " + this.arrayList.size() + " items " + this.alrStatus.toString();
    }

    protected abstract void localUpdateStatus(EventInfo var1);

    protected void localUpdateView() {
        if (this.alrStatus.isDirty()) {
            this.db.info(this.name + " localUpdateView: sending status=" + this.alrStatus + " obs-count=" + this.alarmStatusObservable.countObservers());
            this.alarmStatusObservable.setChanged();
            this.alarmStatusObservable.notifyObservers(this.alrStatus);
            this.alrStatus.resetDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventInfo addCorrelatedAlarm(int n, EventInfo eventInfo) {
        int n2 = -1;
        EventInfo eventInfo2 = null;
        boolean bl = false;
        AbstractAlarmStore abstractAlarmStore = this;
        synchronized (abstractAlarmStore) {
            int n3;
            block15: {
                n3 = -1;
                if (!this.arrayList.isEmpty()) {
                    try {
                        n2 = this.translateRowIndex(n);
                        eventInfo2 = (EventInfo)this.arrayList.remove(n);
                        n3 = eventInfo2.getSeverity();
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        if (!this.db.on()) break block15;
                        this.db.fine("Alarm not found at correlated index " + n);
                    }
                }
            }
            char c = eventInfo2.getState();
            char c2 = eventInfo.getState();
            int n4 = eventInfo.getSeverity();
            if (c != c2) {
                switch (c2) {
                    case 'R': {
                        this.alrStatus.incrementSeverity(n4);
                        break;
                    }
                    case 'C': {
                        this.alrStatus.decrementSeverity(n3);
                    }
                }
                this.localUpdateStatus(eventInfo);
            }
            if (!autoDeleteCleared || c2 != 'C') {
                this.arrayList.add(eventInfo);
                bl = true;
            }
        }
        this.addCorrelatedFilteredAlarm(eventInfo, eventInfo2);
        if (n2 >= 0) {
            this.fireBulkRowDeleted(n2, eventInfo2);
        } else {
            this.fireBulkDataSourceChanged();
        }
        if (bl) {
            this.fireBulkRowAdded(0, eventInfo);
        }
        return eventInfo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCorrelatedFilteredAlarm(EventInfo eventInfo, EventInfo eventInfo2) {
        if (this.eventFilter.doesMatch(eventInfo)) {
            AbstractAlarmStore abstractAlarmStore = this;
            synchronized (abstractAlarmStore) {
                this.filteredArrayList.remove(eventInfo2);
                char c = eventInfo.getState();
                if (!autoDeleteCleared || c != 'C') {
                    this.filteredArrayList.add(eventInfo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNonCorrelatedAlarm(EventInfo eventInfo) {
        char c = eventInfo.getState();
        int n = eventInfo.getSeverity();
        if (c != 'C') {
            AbstractAlarmStore abstractAlarmStore = this;
            synchronized (abstractAlarmStore) {
                this.arrayList.add(eventInfo);
                super.filterEvent(eventInfo);
                if (c == 'R') {
                    this.alrStatus.incrementSeverity(n);
                    this.localUpdateStatus(eventInfo);
                } else {
                    this.transientAdded();
                }
            }
            this.fireBulkRowAdded(0, eventInfo);
        }
    }

    protected void transientAdded() {
    }

    private synchronized int findCorrelatedAlarm(ArrayList arrayList, EventInfo eventInfo) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            EventInfo eventInfo2 = (EventInfo)arrayList.get(i);
            if (!this.correlator.areCorrelated(eventInfo, eventInfo2)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAlarms(Set set) {
        AbstractAlarmStore abstractAlarmStore;
        List list = this.removeAlarms((AbstractCollection)((Object)set), this.arrayList);
        if (list != null) {
            abstractAlarmStore = this;
            synchronized (abstractAlarmStore) {
                this.arrayList.clear();
                this.arrayList = (ArrayList)list;
            }
            this.fireBulkDataSourceChanged();
        }
        if ((list = this.removeAlarms((AbstractCollection)((Object)set), this.filteredArrayList)) != null) {
            abstractAlarmStore = this;
            synchronized (abstractAlarmStore) {
                this.filteredArrayList.clear();
                this.filteredArrayList = (ArrayList)list;
            }
            this.fireBulkDataSourceChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAlarms(AbstractCollection abstractCollection) {
        AbstractAlarmStore abstractAlarmStore;
        List list = this.removeAlarms(abstractCollection, this.arrayList);
        if (list != null) {
            abstractAlarmStore = this;
            synchronized (abstractAlarmStore) {
                this.arrayList.clear();
                this.arrayList = (ArrayList)list;
            }
            this.fireBulkDataSourceChanged();
            this.localUpdateView();
        }
        if ((list = this.removeAlarms(abstractCollection, this.filteredArrayList)) != null) {
            abstractAlarmStore = this;
            synchronized (abstractAlarmStore) {
                this.filteredArrayList.clear();
                this.filteredArrayList = (ArrayList)list;
            }
            this.fireBulkDataSourceChanged();
            this.localUpdateView();
        }
    }

    protected synchronized List removeAlarms(AbstractCollection abstractCollection, List list) {
        if (abstractCollection.size() == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList(list.size());
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (abstractCollection.contains(e)) {
                if (this.db.on()) {
                    this.db.fine("Dropping event " + i + ": " + e);
                }
                ++n;
                continue;
            }
            if (this.db.on()) {
                this.db.fine("Keeping event " + i + ": " + e);
            }
            arrayList.add(e);
        }
        if (n > 0) {
            return arrayList;
        }
        return null;
    }

    public class AsDebug
    extends SDebug {
        public AsDebug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        public final void dump() {
            this.println("-- DUMPING ALARM STORE: " + AbstractAlarmStore.this.name);
            for (int i = 0; i < AbstractAlarmStore.this.getRowCount(); ++i) {
                this.println(AbstractAlarmStore.this.arrayList.get(i).toString());
            }
            this.println("-- DUMPING ALARM STORE: " + AbstractAlarmStore.this.name + ":= end =:");
        }
    }
}

