/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.event;

import cerent.cms.IPlatform;
import cerent.cms.idl.Common.sNames;
import cerent.cms.idl.Rmon.eStatsId;
import cerent.cms.model.EnvAlarmTable;
import cerent.cms.model.FramingType;
import cerent.cms.model.IFramingType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.EventInfo;
import cerent.cms.ui.event.IAlarmDecoder;
import cerent.util.SDebug;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.omg.CORBA.UserException;

public class AlarmDecoder
implements IAlarmDecoder {
    private ArrayList neConditionCodeList = new ArrayList();
    private String[][] NEconditionLabels;
    private static final String[] updateType = new String[]{"Deleted", "Changed", "Added"};
    private static final String[] objTypeNames = new String[]{"None", "EntityTable", "Entity", "Interface", "Ospf", "ProtectionGroup", "SdccTerm", "Sync", "Security", "TopologyElement", "TopologyElementList", "System", "ProtectionGroupList", "StsConnection", "StsConnectionList", "VtConnection", "VtConnectionList", "SonetPool", "SonetPoolList", "EtherBridge", "SpanningTree", "Vlan", "Circuit", "CircuitList", "NodeStatusList", "RmonAlarm", "AlarmManager", "Tap", "TapList", "EtherTrunkConnection", "OwireTunnelXcList", "OverheadTerm", "OverheadTermList", "OverheadXcon", "OverheadXconList", "UcpNode", "UcpNeighbor", "UcpNeighborList", "IpccList", "Ipcc", "UcpInterfaceList", "UcpInterface", "UcpOriginList", "UcpOrigin", "UcpTerminationList", "UcpTermination", "OverheadCircuit", "OverheadCircuitList", "VirtualTrunkConnection", "IosConfig", "LoggedOnUserList", "StsRoll", "RollList", "Loopback", "LoopbackList", "PmReptSched", "OpticalPatchCord", "OpticalPatchCordList", "DwdmOpticalSetup", "DwdmOpticalParam", "DwdmOpticalParamList", "OchncConnection", "OchncConnectionList", "OchTrailConnection", "OchTrailConnectionList", "StsVcatTerm", "StsVcatTermList", "VtVcatTerm", "VtVcatTermList", "FCTrunkConnection", "FCAlarm", "VirtualLink", "VirtualLinkList", "VtRoll", "LapdTermList", "TarpConfig", "OsiRouterList", "OsiSubnetList", "OsiConfig", "ChassisList", "OchTrailAdit", "OchTrailAditList", "StsTrailCTPList", "VtTrailCTPList"};
    private static final String[] locationText = new String[]{"", " FAR", " NEAR", " ??"};
    private static final String[] periodText = new String[]{"", " 15MIN", " 1DAY", " ??", " 1HOUR", " ??", " ??", " ??"};
    private static final String[] directionText = new String[]{"", " RX", " TX"};
    public static final String COND_EXTERNAL = "EXT";
    public static final String COND_PM_TCA = "PM-TCA";
    public static final String COND_BRIDGE_RMON_ALARM = "RMON-ALARM";
    public static final String COND_INTSFT_UCP_CKT_DOWN = "CKTDOWN";
    public static final String COND_INTSFT_UCP_CKT_DOWN_EV = "CKTDOWNEV";
    public static final String[] ucpCauseCodes = new String[]{"", "RSVP Reservation message timeout", "Failed to send RSVP Path message", "RSVP Path Error message received", "RSVP Reservation Tear message received", "RSVP Reservation (Admin A&R) message received", "IPCC unavailable", "RSVP Reservation (Admin D&R) message received", "RSVP Path Ack timeout", "RSVP Path state timeout", "RSVP Path Tear received", "RSVP Path (Admin D&R) message received", "RSVP Path (Admin A&R) message received", "RSVP Reservation Error message received", "Reservation Confirm timer expiration", "RSVP Reservation Ack timeout", "RSVP Reservation state timeout", "Neighbor does not support RSVP recovery procedure", "RSVP recovery failed for circuit", "Invalid Path message for Path State"};
    private AlarmCondList alarmCondList;
    private NodeModelDelegate nmd;
    private IFramingType fType;
    private SDebug db;
    private static ModelSingletonCollection alarmDecoderSingletons;
    private static final String MON_PREFIX = "T-";
    private static final String TX_PWR_MIN = "TX-PWR-MIN";
    private static final String RX_PWR_MIN = "RX-PWR-MIN";
    private static final String LASER_BIAS_MAX = "LASER-BIAS-MAX";
    private static final String TX_PWR_MAX = "TX-PWR-MAX";
    private static final String RX_PWR_MAX = "RX-PWR-MAX";
    private static final String OPWR_MAX = "OPWRMAX";
    private static final String OPWR_MIN = "OPWRMIN";
    private static final int OPT_PWR_OFFSET = 400;
    private static final float OPT_SCALE_FACTOR = 10.0f;
    private static final float OPT_PWR_FACTOR = 10.0f;

    public static synchronized AlarmDecoder getInstance(NodeModelDelegate nodeModelDelegate) {
        AlarmDecoder alarmDecoder;
        if (alarmDecoderSingletons == null) {
            alarmDecoderSingletons = ModelSingletonCollection.getMSCInstanceByName((String)"AlarmDecoder");
        }
        if ((alarmDecoder = (AlarmDecoder)alarmDecoderSingletons.get((Object)nodeModelDelegate)) == null) {
            alarmDecoder = new AlarmDecoder(nodeModelDelegate);
            alarmDecoderSingletons.add((Object)nodeModelDelegate, (Object)alarmDecoder);
        }
        return alarmDecoder;
    }

    private AlarmDecoder(NodeModelDelegate nodeModelDelegate) {
        this.nmd = nodeModelDelegate;
        this.fType = FramingType.getFramingType((int)this.nmd.getFramingType());
        this.db = nodeModelDelegate.getChildDebug(AlarmDecoder.class);
    }

    public void getNeConditionLabels() {
        if (this.NEconditionLabels == null) {
            this.alarmCondList = new AlarmCondList(this.nmd, "AlarmCondList");
            try {
                this.NEconditionLabels = (String[][])this.alarmCondList.get();
            }
            catch (UserException userException) {
                SDebug.printStackTrace((Throwable)userException);
            }
        }
    }

    public String getObjectTypeName(int n) {
        try {
            return objTypeNames[n];
        }
        catch (Exception exception) {
            return "???";
        }
    }

    public String getConditionCode(int n) {
        try {
            if (n >= 1024) {
                return this.getCTCconditionLabels(n - 1024, 0);
            }
            return this.getNEconditionLabels(n, 0);
        }
        catch (Exception exception) {
            return "??? " + n;
        }
    }

    public String getConditionDescription(int n) {
        try {
            if (n >= 1024) {
                return this.getCTCconditionLabels(n - 1024, 1);
            }
            return this.getNEconditionLabels(n, 1);
        }
        catch (Exception exception) {
            return "??? " + n;
        }
    }

    public int getConditionCodeSize() {
        return this.getNEconditionLabelsSize();
    }

    public String getUpdateTypeText(int n) {
        try {
            return updateType[n];
        }
        catch (Exception exception) {
            return "???";
        }
    }

    public String getTcaConditionCode(int n, long l, long l2) {
        int n2 = n & 0x3F;
        n2 |= (n & 0x3C00) >> 4;
        String[] stringArray = this.fType.isSdh() ? this.nmd.getPlatform().getSdhMonTypeNames() : this.nmd.getPlatform().getSonetMonTypeNames();
        try {
            return MON_PREFIX + stringArray[n2];
        }
        catch (Exception exception) {
            return "???";
        }
    }

    private String convertMonValueToDbm(String string, long l) {
        String string2 = String.valueOf(l);
        IPlatform iPlatform = this.nmd.getPlatform();
        if (!iPlatform.is310cl() && !iPlatform.is310ma()) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(1);
            if (string.equals("T-TX-PWR-MIN") || string.equals("T-TX-PWR-MAX") || string.equals("T-RX-PWR-MIN") || string.equals("T-RX-PWR-MAX")) {
                string2 = String.valueOf(numberFormat.format((float)(l - 400L) / 10.0f));
            } else if (string.equals("T-LASER-BIAS-MAX")) {
                string2 = String.valueOf(numberFormat.format((float)l / 10.0f));
            } else if (string.equals("T-OPWRMAX") || string.equals("T-OPWRMIN")) {
                string2 = String.valueOf(numberFormat.format((float)l / 10.0f));
            }
        }
        return string2;
    }

    private boolean isOpticalTcaInDbm(int n) {
        boolean bl = true;
        if (this.nmd.getPlatform().is310cl()) {
            bl = false;
        } else if ((this.nmd.getPlatform().is454() || this.nmd.getPlatform().is455()) && (n == 106 || n == 60 || n == 220 || n == 219)) {
            bl = false;
        }
        return bl;
    }

    public String getTcaConditionDescription(int n, long l, long l2, int n2) {
        String string;
        String string2;
        int n3 = (n & 0xC0) >> 6;
        int n4 = (n & 0x300) >> 8;
        int n5 = (n & 0xC000) >> 14;
        int n6 = (n & 0x30000) >> 16;
        String string3 = this.getTcaConditionCode(n, l, l2);
        if (this.isOpticalTcaInDbm(n2)) {
            string2 = this.convertMonValueToDbm(string3, l);
            string = this.convertMonValueToDbm(string3, l2);
        } else {
            string2 = String.valueOf(l);
            string = String.valueOf(l2);
        }
        String string4 = "";
        if (n5 == 1) {
            string4 = " (MON)";
        } else if (n5 == 2) {
            string4 = " (TERM)";
        }
        try {
            return "PM " + locationText[n3] + periodText[n4] + directionText[n6] + " TCA" + string4 + ", threshold=" + string2 + ", current value= " + string;
        }
        catch (Exception exception) {
            return "???";
        }
    }

    public String getRmonConditionDescription(int n, long l, long l2) {
        String string = (l2 & 0xFL) == 1L ? "falling" : "rising";
        int n2 = (int)(l2 >> 4);
        if (n2 != 0) {
            string = string + " " + this.nmd.getRmonThresholdMgr().getStatsIdStr(eStatsId.from_int(n2));
        }
        return "RMON Alarm # " + l + " (" + string + ") fired.";
    }

    public String getCondCode(INodeModel iNodeModel, EventInfo eventInfo) {
        String string = null;
        string = this.getConditionCode(eventInfo.getCondition());
        if (COND_PM_TCA.equals(string)) {
            string = this.getTcaConditionCode(eventInfo.getSubTypeInt(), eventInfo.getData1(), eventInfo.getData2());
        } else if (COND_EXTERNAL.equals(string)) {
            string = iNodeModel.getEnvAlarmCode(eventInfo.getSubTypeInt());
        }
        return string;
    }

    public String getUcpCauseCodeDescription(long l) {
        if (l > 0L && l < (long)ucpCauseCodes.length) {
            return " - " + ucpCauseCodes[(int)l];
        }
        return ucpCauseCodes[0];
    }

    public String getCondDesc(INodeModel iNodeModel, EventInfo eventInfo) {
        String string = null;
        String string2 = null;
        string2 = this.getConditionCode(eventInfo.getCondition());
        string = this.getConditionDescription(eventInfo.getCondition());
        if (COND_PM_TCA.equals(string2)) {
            string = this.getTcaConditionDescription(eventInfo.getSubTypeInt(), eventInfo.getData1(), eventInfo.getData2(), eventInfo.getEqType());
        } else if (COND_BRIDGE_RMON_ALARM.equals(string2)) {
            string = this.getRmonConditionDescription(eventInfo.getSubTypeInt(), eventInfo.getData1(), eventInfo.getData2());
        } else if (COND_EXTERNAL.equals(string2)) {
            string = iNodeModel.getEnvAlarmDesc(eventInfo.getPort());
        } else if (COND_INTSFT_UCP_CKT_DOWN_EV.equals(string2)) {
            string = string + this.getUcpCauseCodeDescription(eventInfo.getData1());
        }
        return string;
    }

    public String getNEconditionLabels(int n, int n2) {
        return this.NEconditionLabels[n][n2];
    }

    public int getCondition(String string, int n) {
        for (int i = 0; i < this.NEconditionLabels.length; ++i) {
            if (!this.NEconditionLabels[i][n].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public ArrayList getAlarmConditionList() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.fType.isSdh() ? this.nmd.getPlatform().getSdhMonTypeNames() : this.nmd.getPlatform().getSonetMonTypeNames();
        arrayList.addAll(this.neConditionCodeList);
        int n2 = EnvAlarmTable.getEnvAlarmCodeSize();
        for (n = 0; n < n2; ++n) {
            arrayList.add(EnvAlarmTable.getEnvAlarmCode(n));
        }
        n = 0;
        while (true) {
            if (n >= CTCconditionLabels.length) break;
            arrayList.add(CTCconditionLabels[n][0]);
            ++n;
        }
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(MON_PREFIX + stringArray[n]);
        }
        return arrayList;
    }

    public String getCTCconditionLabels(int n, int n2) {
        return CTCconditionLabels[n][n2];
    }

    public int getNEconditionLabelsSize() {
        return this.NEconditionLabels.length;
    }

    public int getCTCconditionLabelsSize() {
        return CTCconditionLabels.length;
    }

    class AlarmCondList
    extends NonCachedValue {
        public AlarmCondList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            sNames[] sNamesArray = AlarmDecoder.this.nmd.getIorRepository().getAlarmRef().alarmCondList();
            String[][] stringArray = new String[sNamesArray.length][2];
            for (int i = 0; i < sNamesArray.length; ++i) {
                stringArray[i][0] = sNamesArray[i].first;
                stringArray[i][1] = sNamesArray[i].second;
                AlarmDecoder.this.neConditionCodeList.add(sNamesArray[i].first);
            }
            return stringArray;
        }

        public Object outer() {
            return AlarmDecoder.this;
        }
    }
}

