/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.event;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SingletonCollection;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.SDebug;
import java.lang.ref.WeakReference;
import java.util.Observable;
import java.util.Observer;

public class InterfaceUpdateManager
extends CmsObservable
implements Observer {
    private WeakReference nmd;
    private SDebug db;
    private String name;
    private static SingletonCollection interfaceUpdateManagerSingletons;
    private EventDispatcher _dispatcher;

    public static synchronized InterfaceUpdateManager getInstance(NodeModelDelegate nodeModelDelegate) throws CTCUserException {
        InterfaceUpdateManager interfaceUpdateManager = null;
        if (interfaceUpdateManagerSingletons == null) {
            interfaceUpdateManagerSingletons = SingletonCollection.getSCInstanceByName((String)"InterfaceUpdateManager");
        }
        if ((interfaceUpdateManager = (InterfaceUpdateManager)interfaceUpdateManagerSingletons.get((Object)nodeModelDelegate)) == null) {
            interfaceUpdateManager = new InterfaceUpdateManager(nodeModelDelegate);
            interfaceUpdateManagerSingletons.add((Object)nodeModelDelegate, (Object)interfaceUpdateManager);
        }
        return interfaceUpdateManager;
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("Received an update From=" + observable.getClass().getName());
        }
        if (object instanceof ObjectMessageInfo) {
            int n = ((ObjectMessageInfo)object).getObjectType();
            int n2 = ((ObjectMessageInfo)object).getUpdateType();
            int n3 = ((ObjectMessageInfo)object).getIndex();
            int n4 = ((ObjectMessageInfo)object).getModuleIndex();
            boolean bl = false;
            boolean bl2 = false;
            EntityModel entityModel = null;
            ModuleModel moduleModel = null;
            if (this.db.on()) {
                this.db.println("Message From objectType= " + n + ", updateType= " + n2 + ", index= " + n3 + ", moduleIndex= " + n4);
            }
            try {
                NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.nmd.get();
                bl2 = nodeModelDelegate.isCtcInCtmMode();
                entityModel = (EntityModel)nodeModelDelegate.getEntityTableModel().getEntityModelByIndex(n4);
                moduleModel = (ModuleModel)entityModel.getModuleModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.db.on()) {
                    this.db.println("AbstractCmsNoSuchEntityException " + (Object)((Object)abstractCmsNoSuchEntityException));
                    if (entityModel == null) {
                        this.db.println("EntityModel Not found for moduleIndex= " + n4);
                    }
                    if (moduleModel == null) {
                        this.db.println("ModuleModel Not found for moduleIndex= " + n4);
                    }
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                moduleModel = null;
            }
            if (bl2) {
                if (this.db.on()) {
                    this.db.println("CTM mode is ture");
                }
                if (moduleModel != null && !moduleModel.areInterfacesInited()) {
                    if (this.db.on()) {
                        this.db.println("The module model for slot " + moduleModel.getSlot() + ", is NOT initialized");
                        this.db.println("Calling sendNotificaton.");
                    }
                    moduleModel.sendInitNeededNotification();
                } else if (this.db.on()) {
                    this.db.println("The module in slot " + moduleModel.getSlot() + " is initialized");
                }
            } else if (this.db.on()) {
                this.db.println("Init Needed Notification was NOT set, Not in CTM mode.");
            }
        }
    }

    private InterfaceUpdateManager(NodeModelDelegate nodeModelDelegate) throws CTCUserException {
        if (nodeModelDelegate == null) {
            throw new CTCUserException("NodeModelDelegate is NULL");
        }
        this.nmd = new WeakReference<NodeModelDelegate>(nodeModelDelegate);
        this._dispatcher = null;
        this.db = nodeModelDelegate.getChildDebug(InterfaceUpdateManager.class);
    }

    public void init() {
        if (this._dispatcher == null) {
            NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.nmd.get();
            this._dispatcher = nodeModelDelegate.getDispatcher();
            this._dispatcher.addObserver(ObjectType.ObjectInterface, (Observer)this);
        }
    }

    public void dispose() {
        if (this._dispatcher != null) {
            this._dispatcher.deleteObserver(ObjectType.ObjectInterface, (Observer)this);
            this._dispatcher = null;
        }
    }

    public void destroy() {
        if (interfaceUpdateManagerSingletons != null) {
            interfaceUpdateManagerSingletons.remove(this.nmd.get());
        }
        this.dispose();
    }
}

