/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.nedefaults;

import cerent.cms.idl.OSI.eOsiMode;
import cerent.cms.model.Attribute;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.nedefaults.DefaultsEdit;
import cerent.cms.model.nedefaults.DefaultsNode;
import cerent.cms.model.nedefaults.IAccessor;
import cerent.cms.model.nedefaults.IDefaultsElement;
import cerent.cms.model.nedefaults.IDefaultsNode;
import cerent.cms.model.nedefaults.ValueAccessor;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultsElement
extends DefaultsNode
implements IDefaultsElement {
    private String myUnits = null;
    private String myValue = null;
    private String originalValue = null;
    private String presetValue = null;
    private int sideEffects = 0;
    private String comment = "";
    private DefaultsEdit edit = null;
    private NonCachedValue nonCachedValue;
    private VariableAccessor accessor = new VariableAccessor();
    static SDebug db = new SDebug("DefaultsElement");

    public DefaultsElement(String string, DefaultsNode defaultsNode, String string2, String string3, DefaultsEdit defaultsEdit, NonCachedValue nonCachedValue, int n) {
        super(string, defaultsNode);
        this.originalValue = this.myValue = string2;
        this.presetValue = null;
        this.myUnits = string3;
        this.sideEffects = n;
        this.edit = defaultsEdit;
        this.nonCachedValue = nonCachedValue;
        if (this.myUnits != null && this.myUnits.length() == 0) {
            this.myUnits = null;
        }
        this.comment = "";
        this.dirty = false;
        if (string2 != null) {
            if (this.isNumericallyEnumerated()) {
                this.initEnumValue(Integer.parseInt(string2));
            } else {
                this.initValue(string2);
            }
        } else {
            this.myValue = "";
        }
        this.originalValue = this.myValue;
    }

    public void setValue(String string) throws ProvisionError {
        if (this.presetValue != null && this.presetValue != string) {
            db.severe("Pre-edited " + this.presetValue + " but setting " + string);
        }
        if (!this.myValue.equals(string = this.edit.checkValue(string, this.accessor))) {
            db.fine("set Element to: " + string + ", and set dirty");
            this.myValue = string;
            this.setDirty();
            db.finest(" Updated default element" + this.toString());
        } else {
            db.finest("setValue called, but values are the same as: " + this.myValue);
        }
        this.presetValue = null;
        this.crossCheckValue();
    }

    public void presetValue(String string) {
        if (string == null || this.myValue.equals(string)) {
            this.presetValue = null;
        } else if (!this.neverEditable()) {
            this.presetValue = string;
        }
    }

    public boolean isDisplacedProperty() {
        boolean bl = false;
        switch (this.sideEffects) {
            case 6: 
            case 8: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean reprovisions() {
        boolean bl = false;
        switch (this.sideEffects) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean disconnects() {
        boolean bl = false;
        switch (this.sideEffects) {
            case 3: 
            case 4: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean causesReboot() {
        boolean bl = false;
        switch (this.sideEffects) {
            case 4: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean neverEditable() {
        boolean bl = false;
        switch (this.sideEffects) {
            case 5: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void resetValue() {
        this.myValue = this.originalValue;
        this.makeClean();
        this.recalcDirty();
    }

    public void initValue(String string) {
        this.myValue = string;
    }

    public IDefaultsElement getSiblingElement(String string) {
        IDefaultsElement iDefaultsElement = null;
        if (string != this.getName()) {
            iDefaultsElement = (IDefaultsElement)((DefaultsNode)this.getParent()).getChild(string);
        }
        return iDefaultsElement;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("NE DefaultsElement: \n");
        stringBuffer.append(", Full Name: " + this.getFullName());
        stringBuffer.append(", Name: " + this.getName());
        stringBuffer.append(", Value: " + this.myValue);
        stringBuffer.append(", preset Value: " + this.presetValue);
        stringBuffer.append(", original Value: " + this.originalValue);
        stringBuffer.append(", Units: " + this.myUnits);
        stringBuffer.append(", myClass: " + this.edit.getDefaultsEnumClass());
        stringBuffer.append(" sideEffects: " + this.sideEffects);
        return stringBuffer.toString();
    }

    protected IDefaultsElement getCousinElement(String string) {
        IDefaultsNode iDefaultsNode = null;
        if (string != null && string != this.getName()) {
            String[] stringArray = string.split("\\.");
            iDefaultsNode = this.getParent();
            if (iDefaultsNode == null) {
                db.severe("data initialization error on " + this.getFullName() + ": no parent");
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    db.fine(this.getName() + " getCousinElement(): " + iDefaultsNode.getName() + " getting " + stringArray[i]);
                    if (stringArray[i].equals("//")) {
                        iDefaultsNode = iDefaultsNode.getParent();
                    } else if (!stringArray[i].equals("/")) {
                        iDefaultsNode = ((DefaultsNode)iDefaultsNode).getChild(stringArray[i]);
                    }
                    if (iDefaultsNode == null) break;
                }
            }
        }
        if (iDefaultsNode == null) {
            db.severe("data initialization error on " + this.getFullName() + ": no cousin");
        } else if (db.isFineEnabled()) {
            db.fine("getCousinElement() : result for " + this.getFullName() + " is " + iDefaultsNode.getName() + " " + iDefaultsNode.getClass().getName());
        }
        return (IDefaultsElement)iDefaultsNode;
    }

    public boolean isNumericallyEnumerated() {
        return this.edit.isNumericallyEnumerated(this.accessor);
    }

    private void crossCheckValue() throws ProvisionError {
        this.edit.crossCheckValue(this.accessor);
    }

    public void checkValue(String string) throws ProvisionError {
        this.edit.checkValue(string, this.accessor);
    }

    public void checkValue(String string, ValueAccessor valueAccessor) throws ProvisionError {
        this.edit.checkValue(string, new ConstantAccessor(valueAccessor));
    }

    public void checkValue() throws ProvisionError {
        this.checkValue(this.getValue());
        this.crossCheckValue();
    }

    public String getValue() {
        String string = this.presetValue == null || this.presetValue.length() == 0 ? this.myValue : this.presetValue;
        db.finest("getValue returning: " + string);
        return string;
    }

    public int getEnumValue() {
        int n = Integer.MIN_VALUE;
        Attribute attribute = this.edit.toAttribute(this.myValue, (IAccessor)this.accessor);
        if (attribute == null) {
            db.severe(this.getFullName() + ": \"" + this.myValue + "\" is not a valid value");
        } else {
            n = attribute.getValue();
        }
        return n;
    }

    public void setEnumValue(int n) throws ProvisionError {
        Attribute attribute = this.edit.toAttribute(n, (IAccessor)this.accessor);
        if (attribute == null) {
            throw new ProvisionError(this.getFullName() + ": \"" + n + "\" is not a valid value");
        }
        this.setValue(attribute.getKey());
    }

    public void initEnumValue(int n) {
        Attribute attribute = this.edit.toAttribute(n, (IAccessor)this.accessor);
        if (attribute == null) {
            if (db.isSevereEnabled()) {
                db.severe("Coding error: \"" + n + "\" is not a valid enumerated value for " + this.getFullName() + "(valid list has " + this.getCurrentlyValidEnumValues().size() + ")");
                db.severe("Edit is " + this.getEdit());
                Iterator iterator = this.getCurrentlyValidEnumValues().iterator();
                while (iterator.hasNext()) {
                    Attribute attribute2 = (Attribute)iterator.next();
                    db.severe(attribute2.getKey() + " (" + attribute2.getValue() + ")");
                }
            }
            this.initValue("UNKNOWN (" + n + ")");
            this.setDirty();
        } else {
            this.initValue(attribute.getKey());
        }
    }

    public String getUnits() {
        return this.myUnits;
    }

    public String getEdit() {
        return this.edit.toString(this.accessor);
    }

    public String getSideEffects() {
        String string = "Side effects unavailable";
        switch (this.sideEffects) {
            case 4: {
                string = "May reboot node";
                break;
            }
            case 3: {
                string = "May disconnect CTC from node";
                break;
            }
            case 1: {
                string = "Reprovisions node";
                break;
            }
            case 2: {
                string = "Reprovisions node; clears timing references ";
                break;
            }
            case 0: {
                string = "";
                break;
            }
            case 8: {
                string = "CTC client property";
                break;
            }
            case 6: 
            case 7: {
                string = "Default used by client at item creation";
                break;
            }
            case 5: {
                string = "Uneditable field";
            }
        }
        return string;
    }

    public int getDefElemClass() {
        return this.edit.getDefaultsEnumClass();
    }

    private List getCurrentlyValidEnumValues() {
        return this.edit.getCurrentlyValidEnumValues(this.accessor);
    }

    public Object[] getValidEnumValues() {
        List list = this.getCurrentlyValidEnumValues();
        if (list != null) {
            return list.toArray(new Object[list.size()]);
        }
        return new Object[0];
    }

    public boolean hasIndependentValidity() {
        return this.edit.hasIndependentValidity();
    }

    public void applyToNode() {
        this.dirty = false;
    }

    public String getFullName() {
        return this.name;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        int n = this.name.lastIndexOf(".");
        return this.name.substring(n + 1);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string == null ? "" : string;
    }

    public void makeClean() {
        this.dirty = false;
    }

    public void handleChange(boolean bl) throws Exception {
        if (this.nonCachedValue == null) {
            db.severe("Cannot handle change on " + this.getName());
            throw new Exception("Cannot handle change on " + this.getName());
        }
        Object[] objectArray = this.pathToArgs(this, bl);
        if (bl) {
            db.fine("handleChange(): applying " + this.getName() + " " + objectArray.length);
            if (this.isDirty()) {
                if (objectArray.length > 1) {
                    this.nonCachedValue.set(objectArray);
                    this.makeClean();
                } else if (objectArray.length > 0) {
                    this.nonCachedValue.set(objectArray[0]);
                    this.makeClean();
                } else {
                    db.severe("Cannot handle change on " + this.getName() + "(argument production)");
                }
            }
        } else {
            db.fine("handleChange(): retrieving " + this.getName() + " from " + this.nonCachedValue.getAttributeName());
            Object object = null;
            object = objectArray.length == 0 ? this.nonCachedValue.get() : this.nonCachedValue.get(objectArray);
            this.resultToValue(this, object);
        }
    }

    public Object[] pathToArgs(IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl) {
            if (iDefaultsElement.getName().equals("NodeRoutingMode")) {
                arrayList.add(new eOsiModeAndStringConverter().toObject(iDefaultsElement.getValue()));
            } else if (iDefaultsElement.getName().equals("L1LSPBufferSize") || iDefaultsElement.getName().equals("L1L2LSPBufferSize") || iDefaultsElement.getName().equals("LDBEntry") || iDefaultsElement.getName().equals("LDBFlush") || iDefaultsElement.getName().equals("T1Timer") || iDefaultsElement.getName().equals("T2Timer") || iDefaultsElement.getName().equals("T3Timer") || iDefaultsElement.getName().equals("T4Timer") || iDefaultsElement.getName().equals("Type4PDUDelay")) {
                arrayList.add(new ShortAndStringConverter().toObject(iDefaultsElement.getValue()));
            } else if (iDefaultsElement.getName().equals("PDUsL1Propagation") || iDefaultsElement.getName().equals("PDUsL2Propagation") || iDefaultsElement.getName().equals("PDUsOrigination") || iDefaultsElement.getName().equals("L1DataCache") || iDefaultsElement.getName().equals("L2DataCache") || iDefaultsElement.getName().equals("LDB") || iDefaultsElement.getName().equals("MAT1") || iDefaultsElement.getName().equals("MAT2") || iDefaultsElement.getName().equals("LANStormSuppression")) {
                arrayList.add(new BooleanAndStringConverter().toObject(iDefaultsElement.getValue()));
            }
        }
        return arrayList.toArray(new Object[0]);
    }

    public void resultToValue(IDefaultsElement iDefaultsElement, Object object) throws Exception {
        if (object != null) {
            if (iDefaultsElement.getName().equals("NodeRoutingMode")) {
                iDefaultsElement.initValue(new eOsiModeAndStringConverter().toString(object));
            } else if (iDefaultsElement.getName().equals("L1LSPBufferSize") || iDefaultsElement.getName().equals("L1L2LSPBufferSize") || iDefaultsElement.getName().equals("Type4PDUDelay") || iDefaultsElement.getName().equals("LDBEntry") || iDefaultsElement.getName().equals("LDBFlush") || iDefaultsElement.getName().equals("T1Timer") || iDefaultsElement.getName().equals("T2Timer") || iDefaultsElement.getName().equals("T3Timer") || iDefaultsElement.getName().equals("T4Timer")) {
                iDefaultsElement.initValue(new ShortAndStringConverter().toString(object));
            } else if (iDefaultsElement.getName().equals("PDUsL1Propagation") || iDefaultsElement.getName().equals("PDUsL2Propagation") || iDefaultsElement.getName().equals("PDUsOrigination") || iDefaultsElement.getName().equals("L1DataCache") || iDefaultsElement.getName().equals("L2DataCache") || iDefaultsElement.getName().equals("LDB") || iDefaultsElement.getName().equals("MAT1") || iDefaultsElement.getName().equals("MAT2") || iDefaultsElement.getName().equals("LANStormSuppression")) {
                iDefaultsElement.initValue(new BooleanAndStringConverter().toString(object));
            } else {
                db.severe("Unknown element " + iDefaultsElement.getName());
            }
        } else {
            db.severe("Raw Value is null on " + iDefaultsElement.getName());
        }
    }

    public class eOsiModeAndStringConverter
    implements ObjectAndStringConverter {
        public String toString(Object object) {
            String string = "";
            int n = ((eOsiMode)object).value();
            Attribute attribute = DefaultsElement.this.edit.toAttribute(n, (IAccessor)DefaultsElement.this.accessor);
            if (attribute == null) {
                db.severe("Uninterpretable osi mode: " + ((eOsiMode)object).value());
                string = "UNKNOWN";
            } else {
                string = attribute.toString();
            }
            return string;
        }

        public Object toObject(String string) {
            eOsiMode eOsiMode2 = eOsiMode.OSI_MODE_ES;
            Attribute attribute = DefaultsElement.this.edit.toAttribute(string, (IAccessor)DefaultsElement.this.accessor);
            if (attribute == null) {
                db.severe("Uninterpretable osi mode string: " + string);
                eOsiMode2 = null;
            } else {
                eOsiMode2 = eOsiMode.from_int(attribute.getValue());
            }
            return eOsiMode2;
        }
    }

    public class ShortAndStringConverter
    implements ObjectAndStringConverter {
        public String toString(Object object) {
            return String.valueOf((Short)object);
        }

        public Object toObject(String string) {
            return new Short(Short.parseShort(string));
        }
    }

    public class BooleanAndStringConverter
    implements ObjectAndStringConverter {
        public String toString(Object object) {
            return ((Boolean)object).toString().toUpperCase();
        }

        public Object toObject(String string) {
            return string.equalsIgnoreCase(Boolean.TRUE.toString());
        }
    }

    static interface ObjectAndStringConverter {
        public String toString(Object var1);

        public Object toObject(String var1);
    }

    private class ConstantAccessor
    extends VariableAccessor {
        private ValueAccessor accessor;

        ConstantAccessor(ValueAccessor valueAccessor) {
            this.accessor = valueAccessor;
        }

        public String getValue(DefaultsElement defaultsElement) {
            return this.accessor.getValue(defaultsElement.getFullName());
        }
    }

    private class VariableAccessor
    implements IAccessor {
        private VariableAccessor() {
        }

        public String getFullName() {
            return DefaultsElement.this.getFullName();
        }

        public boolean neverEditable() {
            return DefaultsElement.this.neverEditable();
        }

        public String getPreset() {
            return DefaultsElement.this.presetValue;
        }

        public String getCurrent() {
            return DefaultsElement.this.myValue;
        }

        public DefaultsElement getCousinElement(String string) {
            return (DefaultsElement)DefaultsElement.this.getCousinElement(string);
        }

        public DefaultsElement getCousinElement(String string, int n) {
            DefaultsElement defaultsElement = (DefaultsElement)DefaultsElement.this.getCousinElement(string);
            return defaultsElement.edit.getDefaultsEnumClass() == n ? defaultsElement : null;
        }

        public String getValue(DefaultsElement defaultsElement) {
            return defaultsElement.getValue();
        }

        public long getDivisor(DefaultsElement defaultsElement) {
            return defaultsElement.edit.getDivisor();
        }
    }
}

