/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.nedefaults;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.Attribute;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.CtcTimeZone;
import cerent.cms.model.CtcTimeZoneFactory;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.model.nedefaults.DefaultsEdit;
import cerent.cms.model.nedefaults.DefaultsElement;
import cerent.cms.model.nedefaults.DefaultsNode;
import cerent.cms.model.nedefaults.DefaultsTree;
import cerent.cms.model.nedefaults.IDefaultsElement;
import cerent.cms.model.nedefaults.IDefaultsNode;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.cms.model.nedefaults.ValueAccessor;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.launcher.CmsClassLoader;
import cerent.util.BuildInfo;
import cerent.util.DetailedLog;
import cerent.util.KDebug;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import cerent.util.SortableProperties;
import cerent.util.TDMTerminology;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Properties;
import java.util.TreeMap;

public class DefaultsManager
extends Model {
    private static final String INV_VALUE = "Defaults with invalid values (";
    private static final String MISSING_DEFAULTS = "Missing defaults (";
    private static final String UNKNOWN_DEFAULTS = "Unknown defaults (";
    private static final String UNEXPECTED_ERROR = "Unexpected Error (";
    private static ModelSingletonCollection defaultsManagerSingletons;
    private NodeModelDelegate node;
    private DefaultsNode lastParent;
    private static final int ELEMENT_FULL_NAME = 0;
    private static final int ELEMENT_SIDE_EFFECTS = 1;
    private static final int ELEMENT_TYPE = 2;
    private static final int ELEMENT_UOM = 3;
    private static final int ELEMENT_VARIABLE_LENGTH_START = 4;
    private static final int ELEMENT_TREELESS_NON_CACHED_VALUE = 3;
    private static final int ELEMENT_TREELESS_UOM = 4;
    private static final int ELEMENT_TREELESS_VARIABLE_LENGTH_START = 5;
    private Map validationMap = null;
    private SDebug phase1db;
    private SDebug phase2db;
    private SDebug phase3db;
    private DefaultsTree defaultsTree;
    private int nodesVisited;
    private int elementsVisited;

    public static synchronized DefaultsManager getInstance(NodeModelDelegate nodeModelDelegate) {
        DefaultsManager defaultsManager;
        if (defaultsManagerSingletons == null) {
            defaultsManagerSingletons = ModelSingletonCollection.getMSCInstanceByName((String)"DefaultsManager");
        }
        if ((defaultsManager = (DefaultsManager)defaultsManagerSingletons.get((Object)nodeModelDelegate)) == null) {
            defaultsManager = new DefaultsManager(nodeModelDelegate);
            defaultsManagerSingletons.add((Object)nodeModelDelegate, (Object)defaultsManager);
        }
        return defaultsManager;
    }

    private DefaultsManager(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.setDebug(new DefaultsManagerDebug(nodeModelDelegate.getDebug(), "DefaultsManager"));
        this.node = nodeModelDelegate;
        this.index = 0;
    }

    public NeDefaultsModel getNeDefaultsModel() {
        return this.defaultsTree.getNeDefaultsModel();
    }

    private String[] getLastLevel(String string) {
        if (string == "") {
            return null;
        }
        String[] stringArray = new String[2];
        int n = string.lastIndexOf(".");
        stringArray[0] = string.substring(n + 1);
        stringArray[1] = string.substring(0, n);
        this.phase1db.fine("lastlevel:outstr0 = " + stringArray[0] + " outstr1 = " + stringArray[1]);
        return stringArray;
    }

    private String[] getFirstLevel(String string) {
        String[] stringArray = new String[2];
        if (string == null || string == "") {
            this.phase1db.fine("firstlevel:anystring was null or empty");
            stringArray[0] = null;
            stringArray[1] = null;
        } else {
            int n = string.indexOf(".");
            if (n < 0) {
                this.phase1db.fine("firstlevel:Hit End of Line....str = " + string);
                stringArray[0] = string;
                stringArray[1] = null;
            } else {
                stringArray[0] = string.substring(0, n);
                stringArray[1] = string.substring(n + 1);
                this.phase1db.fine("firstlevel:outstr0 = " + stringArray[0] + " outstr1 = " + stringArray[1]);
            }
        }
        return stringArray;
    }

    private DefaultsNode childExistsAlready(DefaultsNode defaultsNode, String string) {
        DefaultsNode[] defaultsNodeArray = (DefaultsNode[])defaultsNode.getChildren();
        if (defaultsNodeArray == null) {
            this.phase1db.fine("childExistsAlready:children == null");
            return null;
        }
        if (defaultsNodeArray.length == 0) {
            this.phase1db.fine("childExistsAlready:children length == 0");
            return null;
        }
        for (int i = 0; i < defaultsNodeArray.length; ++i) {
            if (!defaultsNodeArray[i].getName().equals(string)) continue;
            this.phase1db.fine("childExistsAlready:found child of name - " + string);
            return defaultsNodeArray[i];
        }
        this.phase1db.info("childExistsAlready:didnt find child of name - " + string);
        return null;
    }

    private void makeElementPath(DefaultsNode defaultsNode, String string, DefaultsElement defaultsElement) {
        if (this.lastParent != null && this.lastParent.getFullName().equals(string)) {
            this.phase1db.fine("makeElementPath:end of line...added element sibling " + defaultsElement.getName());
            this.lastParent.addChild(defaultsElement);
            defaultsElement.setParent(this.lastParent);
            return;
        }
        if (string == null) {
            this.phase1db.fine("makeElementPath:end of line ...added element first born " + defaultsElement.getName());
            defaultsNode.addChild(defaultsElement);
            defaultsElement.setParent(defaultsNode);
            this.lastParent = defaultsNode;
            return;
        }
        this.lastParent = null;
        String[] stringArray = this.getFirstLevel(string);
        DefaultsNode defaultsNode2 = this.childExistsAlready(defaultsNode, stringArray[0]);
        if (defaultsNode2 == null) {
            defaultsNode2 = new DefaultsNode(stringArray[0]);
            this.phase1db.fine("makeElementPath:created new child " + stringArray[0]);
            defaultsNode.addChild(defaultsNode2);
        }
        this.makeElementPath(defaultsNode2, stringArray[1], defaultsElement);
    }

    public String getDefaultValue(String string) throws NoSuchDefault {
        return this.getNeDefaultsModel().getClientDefaultFromCache(string);
    }

    public void clearDefaultValueCache() {
        this.getNeDefaultsModel().clearClientDefaultsCache();
    }

    private int makeEnumValuesForEnumType(String[] stringArray, List list) {
        int n = 2;
        String string = stringArray[4];
        String string2 = string + ": ";
        for (int i = 4; i < stringArray.length; ++i) {
            list.add(stringArray[i]);
            if (!this.phase1db.isInfoEnabled()) continue;
            string2 = string2 + " " + stringArray[i];
        }
        this.phase1db.info("ENUMLIST: " + string2);
        return n;
    }

    private int makeEnumValuesForRangeEnumType(int n, String[] stringArray, List list) {
        int n2 = 2;
        int n3 = Integer.parseInt(stringArray[n]);
        int n4 = Integer.parseInt(stringArray[n + 1]);
        int n5 = Integer.parseInt(stringArray[n + 2]);
        int n6 = Integer.parseInt(stringArray[n + 3]);
        for (int i = n3; i <= n4; i += n5) {
            if (n6 == 1) {
                list.add(String.valueOf(i));
                continue;
            }
            list.add(String.valueOf((float)i / (float)n6));
        }
        return n2;
    }

    private int makeEnumValuesForVariableRangeEnumType(String[] stringArray, List list) {
        int n = 7;
        int n2 = Integer.parseInt(stringArray[4]);
        int n3 = Integer.parseInt(stringArray[5]);
        int n4 = Integer.parseInt(stringArray[6]);
        int n5 = Integer.parseInt(stringArray[7]);
        list.add(stringArray[8]);
        list.add(stringArray[9]);
        for (int i = n2; i <= n3; i += n4) {
            list.add(String.valueOf((float)i / (float)n5));
        }
        return n;
    }

    private String getTimeNotation(int n) {
        int n2 = n / 60;
        int n3 = n % 60;
        String string = "";
        String string2 = "";
        string = n2 < 10 ? "0" + String.valueOf(n2) : String.valueOf(n2);
        string2 = n3 < 10 ? "0" + String.valueOf(n3) : String.valueOf(n3);
        return string + ":" + string2;
    }

    private int makeEnumValuesForTimeRangeEnumType(String[] stringArray, List list) {
        int n = 2;
        int n2 = Integer.parseInt(stringArray[4]);
        int n3 = Integer.parseInt(stringArray[5]);
        int n4 = Integer.parseInt(stringArray[6]);
        for (int i = n2; i <= n3; i += n4) {
            list.add(this.getTimeNotation(i));
        }
        return n;
    }

    private int makeEnumValuesForTimeZoneEnumType(String[] stringArray, List list) {
        int n = 2;
        CtcTimeZoneFactory ctcTimeZoneFactory = this.node.getCtcTimeZoneFactory();
        for (int i = 0; i < ctcTimeZoneFactory.getNumberofTimeZones(); ++i) {
            CtcTimeZone ctcTimeZone = ctcTimeZoneFactory.getCtcTimeZone(i);
            list.add(ctcTimeZone.toString());
        }
        return n;
    }

    private void getEnumValues(String string, List list) {
        Attribute[] attributeArray = ElementDefaults.getAttributeMap(this.node).getAttributeArray(string);
        String string2 = string + ": ";
        for (int i = 0; i < attributeArray.length; ++i) {
            list.add(attributeArray[i]);
            if (!this.phase1db.isInfoEnabled()) continue;
            string2 = string2 + " " + attributeArray[i].toString();
        }
        this.phase1db.info("NAMED ENUMLIST: " + string2);
    }

    private int makeEnumValuesForNamedEnumType(String[] stringArray, List list) {
        int n = 2;
        this.getEnumValues(stringArray[4], list);
        return n;
    }

    private int makeEnumValuesForTreelessNamedEnumType(String[] stringArray, List list) {
        int n = 2;
        this.getEnumValues(stringArray[5], list);
        return n;
    }

    private int makeEnumValuesForVariableRangeType(String[] stringArray, List list) {
        int n = 0;
        int n2 = stringArray.length - 4;
        if (n2 != 4 && n2 != 6) {
            this.phase1db.severe("expected 2 ranges, optionally a step and divisor (for floats): 2 override fields (one probably empty), got " + n2 + " elements!");
        }
        for (int i = 4; i < stringArray.length; ++i) {
            list.add(stringArray[i]);
        }
        return n;
    }

    private int makeEnumValuesForVariableNamedEnumMasterType(Object[] objectArray, List list) {
        int n = 10;
        list.add(objectArray[4]);
        String[] stringArray = new String[objectArray.length - 1];
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (i == 4) continue;
            stringArray[n2++] = (String)objectArray[i];
        }
        this.makeEnumValuesForNamedEnumType(stringArray, list);
        return n;
    }

    private int makeEnumValuesForVariableNamedEnumSlaveType(String[] stringArray, List list) {
        int n = 11;
        String string = stringArray[4];
        list.add(string);
        for (int i = 5; i < stringArray.length; i += 2) {
            String string2 = stringArray[i];
            String string3 = stringArray[i + 1];
            List[] listArray = new List[]{ElementDefaults.getAttributeMap(this.node).getAttributeList(string2), ElementDefaults.getAttributeMap(this.node).getAttributeList(string3)};
            list.add(listArray);
        }
        return n;
    }

    private int makeEnumValuesForVariableRangeEnumSlaveType(String[] stringArray, List list) {
        int n = 12;
        String string = stringArray[4];
        list.add(string);
        for (int i = 5; i < stringArray.length; i += 5) {
            String string2 = stringArray[i];
            int n2 = i + 1;
            List[] listArray = new List[]{ElementDefaults.getAttributeMap(this.node).getAttributeList(string2), new ArrayList()};
            this.makeEnumValuesForRangeEnumType(n2, stringArray, listArray[1]);
            list.add(listArray);
        }
        return n;
    }

    private DefaultsElement makeDefaultElement(DefaultsNode defaultsNode, Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        int n2 = 0;
        NonCachedValue nonCachedValue = null;
        String string = (String)objectArray[0];
        this.phase1db.info(string);
        try {
            n2 = Integer.parseInt((String)objectArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            this.phase1db.severe(string + " Bad Element Type " + objectArray[2]);
        }
        String[] stringArray = null;
        if (n2 != 10) {
            stringArray = new String[objectArray.length];
            System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = (String)objectArray[i];
            }
        }
        String string2 = (String)objectArray[3];
        String string3 = null;
        switch (n2) {
            case 2: {
                n = this.makeEnumValuesForEnumType(stringArray, arrayList);
                break;
            }
            case 3: {
                n = this.makeEnumValuesForRangeEnumType(4, stringArray, arrayList);
                break;
            }
            case 7: {
                n = this.makeEnumValuesForVariableRangeEnumType(stringArray, arrayList);
                break;
            }
            case 4: {
                n = this.makeEnumValuesForTimeRangeEnumType(stringArray, arrayList);
                break;
            }
            case 6: {
                n = this.makeEnumValuesForTimeZoneEnumType(stringArray, arrayList);
                break;
            }
            case 22: {
                nonCachedValue = this.getNeDefaultsModel().getNonCachedValue(stringArray[3]);
                string2 = stringArray[4];
                n = this.makeEnumValuesForTreelessNamedEnumType(stringArray, arrayList);
                break;
            }
            case 9: {
                n = this.makeEnumValuesForNamedEnumType(stringArray, arrayList);
                break;
            }
            case 8: {
                n = this.makeEnumValuesForVariableRangeType(stringArray, arrayList);
                break;
            }
            case 10: {
                n = this.makeEnumValuesForVariableNamedEnumMasterType(objectArray, arrayList);
                break;
            }
            case 11: {
                n = this.makeEnumValuesForVariableNamedEnumSlaveType(stringArray, arrayList);
                break;
            }
            case 12: {
                n = this.makeEnumValuesForVariableRangeEnumSlaveType(stringArray, arrayList);
                break;
            }
            case 13: {
                nonCachedValue = this.getNeDefaultsModel().getNonCachedValue(stringArray[3]);
                string2 = stringArray[4];
                if (objectArray[5] == "") break;
                arrayList.add(objectArray[5]);
                arrayList.add(objectArray[6]);
                break;
            }
            case 1: 
            case 5: 
            case 25: {
                n = n2;
                break;
            }
            default: {
                if (objectArray[2].equals(IDefaultsElement.S_STRING)) {
                    this.phase1db.info("String (Default Handling) " + string + " type " + objectArray[2]);
                }
                if (objectArray.length > 4 && objectArray[4] != "") {
                    arrayList.add(objectArray[4]);
                    arrayList.add(objectArray[5]);
                    break;
                }
                this.phase1db.info("No variable portion on " + string);
            }
        }
        if (this.phase1db.isFineEnabled() && arrayList != null) {
            String string4 = string + " has " + arrayList.size() + " enum values";
            if (arrayList.size() > 1000) {
                this.phase1db.info(string4);
            } else {
                this.phase1db.fine(string4);
            }
        }
        int n3 = 0;
        if (!objectArray[1].equals("FALSE")) {
            if (objectArray[1].equals("TRUE")) {
                n3 = 1;
            } else {
                String[] stringArray2 = ((String)objectArray[1]).split("\\.");
                if (stringArray2 == null || stringArray2.length == 0) {
                    stringArray2 = new String[]{(String)objectArray[1]};
                }
                n3 = Integer.parseInt(stringArray2[0]);
                if (stringArray2.length > 1) {
                    string3 = stringArray2[1];
                    for (int i = 2; i < stringArray2.length; ++i) {
                        string3 = string3 + "." + stringArray2[i];
                    }
                }
            }
        }
        return new DefaultsElement(string, null, string3, string2, DefaultsEdit.getInstance(string, n, arrayList), nonCachedValue, n3);
    }

    private void makeTreeWithInfo(DefaultsNode defaultsNode, Object[] objectArray) {
        String[] stringArray = this.getLastLevel((String)objectArray[0]);
        this.makeElementPath(defaultsNode, stringArray[1], this.makeDefaultElement(defaultsNode, objectArray));
    }

    private void helpGetDefaultsTree(DefaultsNode defaultsNode, Object[][] objectArray) {
        this.lastParent = null;
        for (int i = 0; i < objectArray.length; ++i) {
            this.phase1db.fine("=======================================loop " + i);
            this.makeTreeWithInfo(defaultsNode, objectArray[i]);
        }
    }

    private DefaultsNode getDefaultsTreePhase1(DefaultsNode defaultsNode) throws Exception {
        Object[] objectArray = this.node.getPlatform().getListOfDefaultsLists();
        this.phase1db.info("getDefaultsTreePhase1()" + this.node.getName() + " " + this.node.getPlatform().getPlatformName() + " listOfDefaultsLists.length = " + objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) {
                Object[][] objectArray2 = (Object[][])objectArray[i];
                this.phase1db.info("defaultsList.length = " + objectArray2.length + " first item:" + objectArray2[0][0].toString());
                this.helpGetDefaultsTree(defaultsNode, objectArray2);
                continue;
            }
            this.phase1db.severe("Null pointer at " + i);
        }
        return defaultsNode;
    }

    private DefaultsNode getDefaultsTreePhase2(DefaultsNode defaultsNode) throws Exception {
        this.phase2db.info("getDefaultsTreePhase2():" + this.node.getName() + " " + this.node.getPlatform().getPlatformName() + " " + this.getNeDefaultsModel().getNodeModel().getName() + " " + defaultsNode.getName());
        this.defaultsTree.resetFromNode(defaultsNode);
        return defaultsNode;
    }

    public IDefaultsNode getDefaultsTree(IDefaultsNode iDefaultsNode) throws Exception {
        if (iDefaultsNode == null || iDefaultsNode.getFullName() != this.node.getName()) {
            if (iDefaultsNode == null) {
                this.phase1db.severe("getDefaultsTree(): null");
            } else {
                this.phase1db.info("getDefaultsTree() >" + iDefaultsNode.getFullName() + "/" + this.node.getName() + "<");
            }
            iDefaultsNode = this.getDefaultsTreePhase1(new DefaultsNode(this.node.getName()));
        }
        this.getDefaultsTreePhase2((DefaultsNode)iDefaultsNode);
        return iDefaultsNode;
    }

    private IDefaultsNode getDefaultsTree() throws Exception {
        return this.getDefaultsTree(null);
    }

    private IDefaultsNode getChild(IDefaultsNode iDefaultsNode, String string) {
        IDefaultsNode iDefaultsNode2 = null;
        if (iDefaultsNode == null) {
            iDefaultsNode2 = this.getValidationRoot(string);
        } else {
            IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                if (!iDefaultsNodeArray[i].getName().equals(string)) continue;
                iDefaultsNode2 = iDefaultsNodeArray[i];
                break;
            }
        }
        return iDefaultsNode2;
    }

    private IDefaultsNode getNode(IDefaultsNode iDefaultsNode, String string) {
        int n;
        while ((n = string.indexOf(46)) > 0) {
            String string2 = string.substring(0, n);
            iDefaultsNode = this.getChild(iDefaultsNode, string2);
            string = string.substring(n + 1);
            if (iDefaultsNode != null) continue;
            return null;
        }
        return this.getChild(iDefaultsNode, string);
    }

    private IDefaultsElement getElement(IDefaultsNode iDefaultsNode, String string) {
        this.phase2db.fine("getElement(): " + (iDefaultsNode != null ? iDefaultsNode.getName() + " " + string : string));
        IDefaultsNode iDefaultsNode2 = this.getNode(iDefaultsNode, string);
        if (iDefaultsNode2 instanceof IDefaultsElement) {
            return (IDefaultsElement)iDefaultsNode2;
        }
        return null;
    }

    private DefaultsNode makeValidationTree(String string) {
        DefaultsNode defaultsNode = null;
        if (string != null && string != "") {
            defaultsNode = new DefaultsNode(string);
            Object[][] objectArray = this.node.getPlatform().getDefaultsList(string);
            if (objectArray != null) {
                this.helpGetDefaultsTree(defaultsNode, objectArray);
            } else {
                this.db.severe("No tree for " + string);
            }
        }
        return defaultsNode;
    }

    private DefaultsNode getValidationRoot(String string) {
        DefaultsNode defaultsNode;
        if (this.validationMap == null) {
            this.validationMap = new TreeMap();
        }
        if ((defaultsNode = (DefaultsNode)this.validationMap.get(string)) == null && (defaultsNode = this.makeValidationTree(string)) != null) {
            this.validationMap.put(string, defaultsNode);
        }
        return defaultsNode;
    }

    private String toString(eEqType eEqType2) {
        return eEqType2 == null ? "null" : this.defaultsTree.getNameFromEqType(eEqType2);
    }

    private DefaultsNode getValidationRoot(eEqType eEqType2) {
        return this.getValidationRoot(this.toString(eEqType2));
    }

    public void validate(eEqType eEqType2, String string, String string2) throws ProvisionError {
        this.validate(eEqType2, null, string, string2);
    }

    private IDefaultsElement getElement(eEqType eEqType2, eEqType eEqType3, String string) {
        DefaultsNode defaultsNode;
        IDefaultsElement iDefaultsElement = null;
        if (eEqType.XTC_CARD.equals(eEqType2)) {
            defaultsNode = this.getValidationRoot(this.toString(eEqType3));
        } else if (eEqType.CTX_CARD.equals(eEqType2) || eEqType.CTX_2500_CARD.equals(eEqType2) || eEqType.DS1_28_DS3_EC1_3_LINE_CARD.equals(eEqType2) || eEqType.DS1_84_DS3_EC1_3_LINE_CARD.equals(eEqType2)) {
            defaultsNode = this.getValidationRoot(this.toString(eEqType2) + "." + this.toString(eEqType3));
        } else if (eEqType.MRC_12_LINE_CARD.equals(eEqType2) || eEqType.ASAP_4_LINE_CARD.equals(eEqType2)) {
            defaultsNode = this.getValidationRoot(this.toString(eEqType2));
            switch (eEqType3.value()) {
                case 28: {
                    if (this.node.getPlatform().is455()) {
                        string = string.replaceFirst("thresholds", "thresholds.stm1");
                        break;
                    }
                    string = string.replaceFirst("thresholds", "thresholds.oc3");
                    break;
                }
                case 29: {
                    if (this.node.getPlatform().is455()) {
                        string = string.replaceFirst("thresholds", "thresholds.stm4");
                        break;
                    }
                    string = string.replaceFirst("thresholds", "thresholds.oc12");
                    break;
                }
                case 30: {
                    string = this.node.getPlatform().is455() ? string.replaceFirst("thresholds", "thresholds.stm16") : string.replaceFirst("thresholds", "thresholds.oc48");
                }
            }
        } else {
            defaultsNode = this.getValidationRoot(this.toString(eEqType2));
        }
        if (defaultsNode == null) {
            this.db.severe("getElement(): No validation exists");
        } else {
            String string2 = defaultsNode.getName() + "." + string;
            iDefaultsElement = this.getElement(defaultsNode, string2);
            if (iDefaultsElement == null) {
                this.db.severe("getElement(): Invalid validation attempt: fullPath=" + string2);
            }
        }
        return iDefaultsElement;
    }

    protected DefaultsElement getElement(String string, String string2) {
        return (DefaultsElement)this.getElement(this.getValidationRoot(string), string2);
    }

    public void validate(eEqType eEqType2, eEqType eEqType3, String string, String string2) throws ProvisionError {
        this.db.info("validate(): module=" + this.toString(eEqType2) + " port=" + this.toString(eEqType3) + " path=" + string + " value=" + string2);
        IDefaultsElement iDefaultsElement = this.getElement(eEqType2, eEqType3, string);
        if (iDefaultsElement != null) {
            iDefaultsElement.checkValue(string2);
        }
    }

    public void validate(eEqType eEqType2, eEqType eEqType3, String string, String string2, ValueAccessor valueAccessor) throws ProvisionError {
        this.db.info("validate(): module=" + this.toString(eEqType2) + " port=" + this.toString(eEqType3) + " path=" + string + " value=" + string2 + " accessor=" + valueAccessor);
        IDefaultsElement iDefaultsElement = this.getElement(eEqType2, eEqType3, string);
        if (iDefaultsElement != null) {
            iDefaultsElement.checkValue(string2, valueAccessor);
        }
    }

    public void validate(String string, String string2, ValueAccessor valueAccessor) throws ProvisionError {
        this.db.info("validate(): path=" + string + " value=" + string2 + " accessor=" + valueAccessor);
        IDefaultsElement iDefaultsElement = this.getElement((IDefaultsNode)null, string);
        if (iDefaultsElement != null) {
            iDefaultsElement.checkValue(string2, valueAccessor);
        }
    }

    public boolean doChangesCauseReboot(IDefaultsNode iDefaultsNode) {
        IDefaultsElement iDefaultsElement = this.getElement(iDefaultsNode, "NODE.general.IIOPListenerPort");
        return iDefaultsElement != null && iDefaultsElement.isDirty();
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    public void updateLocal() {
        super.updateLocal();
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 0: {
                    this.db.info(this.getClass().getName() + "::update():    this DELETED");
                    this.delete();
                    break;
                }
                case 1: {
                    this.db.info(this.getClass().getName() + " update():    thisCHANGED");
                    this.setChanged();
                    this.updateLocal();
                    break;
                }
                case 2: {
                    this.db.info(this.getClass().getName() + " update():    STRUCTURE CHANGED");
                    break;
                }
                default: {
                    this.db.info(this.getClass().getName() + "update():    " + "UNKNOWN NE UPDATE TYPE" + n);
                }
            }
        }
    }

    public void init() {
        this.db.info("Initing DefaultsManager " + this.toString());
        super.init0();
        this.phase1db = this.db.getChildDebug("BuildTree");
        this.phase2db = this.db.getChildDebug("RefreshTree");
        this.phase3db = this.db.getChildDebug("PortTree");
        HashMap[] hashMapArray = (HashMap[])this.node.getPlatform().getEqTypeNameMapsForDefaults();
        HashMap hashMap = hashMapArray[0];
        HashMap hashMap2 = hashMapArray[1];
        this.defaultsTree = new DefaultsTree(this.node, hashMap, hashMap2);
        this.defaultsTree.init();
    }

    public void delete() {
        this.dispose();
    }

    public void destroy() {
        super.destroy();
        if (this.db != null) {
            this.db.info("Destroying DefaultsManager " + this.toString());
            this.db.dispose();
            this.db = null;
        }
        if (this.node != null) {
            this.node = null;
        }
    }

    public void dispose() {
        this.db.info("Disposing DefaultsManager " + this.toString());
        if (this.defaultsTree != null) {
            this.defaultsTree.dispose();
            this.defaultsTree = null;
        }
        if (this.validationMap != null) {
            this.validationMap.clear();
            this.validationMap = null;
        }
        if (this.phase1db != null) {
            this.phase1db.dispose();
            this.phase1db = null;
        }
        if (this.phase2db != null) {
            this.phase2db.dispose();
            this.phase2db = null;
        }
        if (this.phase3db != null) {
            this.phase3db.dispose();
            this.phase3db = null;
        }
        super.dispose();
    }

    private boolean helpImportDefaults(InputStream inputStream, IDefaultsNode iDefaultsNode, IValidity iValidity) throws CTCUserException {
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            HashMap hashMap = new HashMap();
            DetailedLog detailedLog = this.parseProperties(properties, iDefaultsNode, hashMap);
            if (detailedLog != null) {
                if (iValidity == null) {
                    Iterator iterator = hashMap.values().iterator();
                    while (iterator.hasNext()) {
                        DefaultsElement defaultsElement = (DefaultsElement)iterator.next();
                        defaultsElement.presetValue(null);
                    }
                    throw new CTCUserException(DefaultsManager.getWarningsText(detailedLog));
                }
                if (iValidity.doCancel(hashMap.size(), detailedLog)) {
                    this.phase3db.info("User canceled import...clearing presets");
                    Iterator iterator = hashMap.values().iterator();
                    while (iterator.hasNext()) {
                        IDefaultsElement iDefaultsElement = (IDefaultsElement)iterator.next();
                        iDefaultsElement.presetValue(null);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            this.phase3db.info(hashMap.size() + " valid elements to set ...");
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = properties.getProperty(string);
                IDefaultsElement iDefaultsElement = (IDefaultsElement)hashMap.get(string);
                try {
                    iDefaultsElement.setValue(string2);
                }
                catch (ProvisionError provisionError) {
                    this.phase3db.severe("Pre-edited value failed subsequent edit: " + (Object)((Object)provisionError));
                }
            }
        }
        catch (IOException iOException) {
            throw new CTCUserException("Cannot load defaults file :" + iOException.getMessage(), (Throwable)iOException);
        }
        catch (Exception exception) {
            throw new CTCUserException("Cannot load defaults file:" + exception.getMessage(), (Throwable)exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    this.phase3db.severe("cannot close " + inputStream);
                }
            }
        }
        return true;
    }

    private boolean importDefaults(String string, InputStream inputStream) throws CTCUserException {
        IDefaultsNode iDefaultsNode = null;
        try {
            iDefaultsNode = this.getDefaultsTree();
        }
        catch (Exception exception) {
            throw new CTCUserException("Cannot load defaults from NE " + string + ":" + exception.getMessage(), (Throwable)exception);
        }
        if (this.helpImportDefaults(inputStream, iDefaultsNode, null)) {
            this.phase3db.info("Committing...");
            try {
                this.defaultsTree.applyToNode(iDefaultsNode);
            }
            catch (Exception exception) {
                throw new CTCUserException("Cannot apply defaults file " + string + ":" + exception.getMessage(), (Throwable)exception);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean importDefaults(String string) throws CTCUserException {
        File file = new File(string);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            return this.importDefaults(file.getAbsolutePath(), fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CTCUserException("Cannot load defaults file " + file.getAbsolutePath() + ": this file was not found;" + fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CTCUserException("Cannot load defaults file " + file.getAbsolutePath() + ": this file might not be a valid defaults file;" + illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
        }
    }

    public boolean importDefaults(File file, IDefaultsNode iDefaultsNode, IValidity iValidity) throws CTCUserException {
        this.phase3db.info("Importing defaults...");
        if (file == null) {
            this.phase3db.severe("No file argument passed in");
            return false;
        }
        if (iDefaultsNode == null) {
            this.phase3db.severe("No droot argument passed in");
            return false;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            return this.helpImportDefaults(fileInputStream, iDefaultsNode, iValidity);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CTCUserException("Cannot load defaults file " + file.getAbsolutePath() + ": this file was not found;" + fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CTCUserException("Cannot load defaults file " + file.getAbsolutePath() + ": this file might not be a valid defaults file;" + illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
        }
    }

    protected static String getWarningsText(DetailedLog detailedLog) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = detailedLog.getChildren().iterator();
        while (iterator.hasNext()) {
            DetailedLog detailedLog2 = (DetailedLog)iterator.next();
            String string = detailedLog2.getDesc();
            if (string.startsWith(INV_VALUE)) {
                string = "";
            } else {
                int n = string.indexOf("s (");
                if (n > 0) {
                    string = string.substring(0, n) + ":";
                }
            }
            Iterator iterator2 = detailedLog2.getChildren().iterator();
            while (iterator2.hasNext()) {
                DetailedLog detailedLog3 = (DetailedLog)iterator2.next();
                if (!bl) {
                    stringBuffer.append("; ");
                }
                stringBuffer.append(string);
                stringBuffer.append(detailedLog3.getDesc());
                bl = false;
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DetailedLog parseProperties(Properties properties, IDefaultsNode iDefaultsNode, HashMap hashMap) {
        DetailedLog detailedLog = null;
        DetailedLog detailedLog2 = new DetailedLog(3);
        DetailedLog detailedLog3 = new DetailedLog(2);
        DetailedLog detailedLog4 = new DetailedLog(2);
        DetailedLog detailedLog5 = new DetailedLog(3);
        try {
            Object object;
            Object object2;
            Iterator iterator;
            Object object3;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                object3 = (String)enumeration.nextElement();
                iterator = properties.getProperty((String)object3);
                object2 = this.getElement(iDefaultsNode, (String)object3);
                if (object2 == null) {
                    detailedLog3.addChild(new DetailedLog((String)object3));
                    continue;
                }
                if (object2.hasIndependentValidity()) {
                    try {
                        object2.checkValue((String)((Object)iterator));
                        object2.presetValue((String)((Object)iterator));
                        hashMap.put(object3, object2);
                    }
                    catch (ProvisionError provisionError) {
                        this.phase3db.severe("Bypassing invalid element " + (String)object3 + " with value " + (String)((Object)iterator) + ": " + (Object)((Object)provisionError));
                        detailedLog2.addChild(new DetailedLog(provisionError.getMessage()));
                    }
                    continue;
                }
                this.phase3db.info((String)object3 + " is of uncertain validity");
                object2.presetValue((String)((Object)iterator));
                arrayList.add(object3);
                hashMap.put(object3, object2);
            }
            this.phase3db.info("Uncertain validity list has " + arrayList.size() + " elements");
            int n = 1;
            this.phase3db.info("Processing elements of uncertain validity...");
            object3 = new ArrayList();
            while (n > 0) {
                n = 0;
                this.phase3db.info("loop...");
                iterator = arrayList.iterator();
                while (n == 0 && iterator.hasNext()) {
                    object2 = (String)iterator.next();
                    object = (IDefaultsElement)hashMap.get(object2);
                    try {
                        object.checkValue();
                    }
                    catch (ProvisionError provisionError) {
                        this.phase3db.info("Removing invalid element " + object2 + " from uncertain validity list: " + (Object)((Object)provisionError));
                        ++n;
                        iterator.remove();
                        hashMap.remove(object2);
                        object3.add(object);
                        detailedLog2.addChild(new DetailedLog(provisionError.getMessage()));
                    }
                }
            }
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                object2 = (IDefaultsElement)iterator.next();
                object2.presetValue(null);
            }
            object3.clear();
            object3 = null;
            this.phase3db.info("Processing missing elements");
            object2 = new TreeMap();
            this.fillMap((Map)object2, iDefaultsNode);
            object = ((TreeMap)object2).values().iterator();
            while (object.hasNext()) {
                DefaultsElement defaultsElement = (DefaultsElement)object.next();
                String string = defaultsElement.getFullName();
                if (properties.containsKey(string)) continue;
                if (defaultsElement.neverEditable()) {
                    this.phase3db.info("Not reporting never editable field as missing");
                    continue;
                }
                detailedLog4.addChild(new DetailedLog(string));
            }
        }
        catch (Exception exception) {
            detailedLog5.addChild(new DetailedLog(exception.getMessage()));
            if (this.phase3db.isSevereEnabled()) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        finally {
            int n = detailedLog4.getChildCount() + detailedLog2.getChildCount() + detailedLog3.getChildCount() + detailedLog5.getChildCount();
            if (n > 0) {
                detailedLog = new DetailedLog("Found " + n + " error(s)/warning(s)");
                this.addChildDl(detailedLog, detailedLog2, INV_VALUE);
                this.addChildDl(detailedLog, detailedLog4, MISSING_DEFAULTS);
                this.addChildDl(detailedLog, detailedLog3, UNKNOWN_DEFAULTS);
                this.addChildDl(detailedLog, detailedLog5, UNEXPECTED_ERROR);
            }
        }
        return detailedLog;
    }

    private void addChildDl(DetailedLog detailedLog, DetailedLog detailedLog2, String string) {
        int n = detailedLog2.getChildCount();
        if (n > 0) {
            detailedLog2.setDesc(string + n + PluralisationUtil.s(" item", n) + ")");
            detailedLog.addChild(detailedLog2);
        }
    }

    private String getExportHeader() {
        String string = "unknown";
        String string2 = "unknown";
        try {
            string = BuildInfo.sanitize(this.node.getSwVersion());
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader instanceof CmsClassLoader) {
            string2 = BuildInfo.sanitize(((CmsClassLoader)classLoader).getSwVersion());
        }
        return "\n#NE Defaults from build=" + string + "\n#ELE build=" + string2 + "\n#";
    }

    public boolean exportDefaults(String string) throws CTCUserException {
        File file = new File(string);
        return this.exportDefaults(file);
    }

    public boolean exportDefaults(File file) throws CTCUserException {
        FileOutputStream fileOutputStream = null;
        try {
            Properties properties = this.helpExportDefaults();
            String string = this.getExportHeader();
            try {
                fileOutputStream = new FileOutputStream(file);
                properties.store(fileOutputStream, string);
                boolean bl = true;
                return bl;
            }
            catch (Exception exception) {
                try {
                    throw new CTCUserException("Cannot save defaults to file " + file.getAbsolutePath() + ":" + exception.getMessage(), (Throwable)exception);
                }
                catch (Exception exception2) {
                    throw new CTCUserException("Cannot load default properties from the node:" + exception2.getMessage(), (Throwable)exception2);
                }
            }
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    this.phase3db.severe("Exception on file close: " + exception);
                }
            }
        }
    }

    public boolean exportAnnotatedDefaults(String string) throws CTCUserException {
        File file = new File(string);
        FileOutputStream fileOutputStream = null;
        try {
            String string2 = this.getExportHeader();
            try {
                fileOutputStream = new FileOutputStream(file);
                this.helpExportAnnotatedDefaults(fileOutputStream, string2);
            }
            catch (Exception exception) {
                throw new CTCUserException("Cannot save defaults to file " + file.getAbsolutePath() + ":" + exception.getMessage(), (Throwable)exception);
            }
        }
        catch (Exception exception) {
            throw new CTCUserException("Cannot load default properties from the node:" + exception.getMessage(), (Throwable)exception);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public boolean importAnnotatedDefaults(String string) throws CTCUserException {
        block19: {
            this.phase3db.info("Importing annotated defaults...");
            File file = new File(string);
            if (file == null) {
                this.phase3db.severe("No file argument passed in");
                return false;
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                AnnotatedDefaultsInputStream annotatedDefaultsInputStream = new AnnotatedDefaultsInputStream(fileInputStream);
                IDefaultsNode iDefaultsNode = null;
                try {
                    iDefaultsNode = this.getDefaultsTree();
                }
                catch (Exception exception) {
                    throw new CTCUserException("Cannot load defaults from NE " + string + ":" + exception.getMessage(), (Throwable)exception);
                }
                if (this.helpImportDefaults(annotatedDefaultsInputStream, iDefaultsNode, null)) {
                    this.phase3db.info("Committing annotated defaults...");
                    try {
                        this.defaultsTree.applyToNode(iDefaultsNode);
                        break block19;
                    }
                    catch (Exception exception) {
                        throw new CTCUserException("Cannot apply defaults file " + string + ":" + exception.getMessage(), (Throwable)exception);
                    }
                }
                boolean bl = false;
                return bl;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CTCUserException("Cannot load defaults file " + file.getAbsolutePath() + ": this file was not found;" + fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CTCUserException("Cannot load defaults file " + file.getAbsolutePath() + ": this file might not be a valid defaults file;" + illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return true;
    }

    private Properties helpExportDefaults() throws Exception {
        SortableProperties sortableProperties = new SortableProperties(new Properties());
        HashMap hashMap = new HashMap();
        this.fillMap(hashMap, this.getDefaultsTree());
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            IDefaultsElement iDefaultsElement = (IDefaultsElement)hashMap.get(string);
            if (!iDefaultsElement.neverEditable()) {
                sortableProperties.setProperty(string, iDefaultsElement.getValue());
                continue;
            }
            this.phase3db.fine("Skipping export of never editable " + iDefaultsElement.getFullName());
        }
        sortableProperties.setSortedKeys(true);
        return sortableProperties;
    }

    private void helpExportAnnotatedDefaults(FileOutputStream fileOutputStream, String string) throws Exception {
        fileOutputStream.write(string.getBytes());
        fileOutputStream.write(10);
        TreeMap treeMap = new TreeMap();
        this.fillMap(treeMap, this.getDefaultsTree());
        StringBuffer stringBuffer = new StringBuffer(1024);
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            IDefaultsElement iDefaultsElement = (IDefaultsElement)treeMap.get(string2);
            String string3 = iDefaultsElement.getUnits();
            String string4 = iDefaultsElement.getSideEffects();
            stringBuffer.append(iDefaultsElement.getFullName()).append("|").append(iDefaultsElement.getValue()).append("|").append(string3 == null || string3.equals("") ? "undefined" : string3).append("|").append(iDefaultsElement.getEdit()).append("|").append(string4 == null || string4.equals("") ? "No side effects" : string4).append("|");
            fileOutputStream.write(stringBuffer.toString().getBytes());
            fileOutputStream.write(10);
            stringBuffer.delete(0, stringBuffer.length());
        }
    }

    private void fillMap(Map map, IDefaultsNode iDefaultsNode) {
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsNode iDefaultsNode2 = iDefaultsNodeArray[i];
            if (iDefaultsNode2 instanceof IDefaultsElement) {
                map.put(((IDefaultsElement)iDefaultsNode2).getFullName(), iDefaultsNode2);
                continue;
            }
            this.fillMap(map, iDefaultsNode2);
        }
    }

    private void validateDirty(IDefaultsNode iDefaultsNode) throws Exception {
        if (iDefaultsNode.isDirty()) {
            if (iDefaultsNode instanceof IDefaultsElement) {
                ++this.elementsVisited;
                ((IDefaultsElement)iDefaultsNode).checkValue();
            } else {
                ++this.nodesVisited;
                IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
                for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                    this.validateDirty(iDefaultsNodeArray[i]);
                }
            }
        }
    }

    public void applyToNode(IDefaultsNode iDefaultsNode) throws Exception {
        this.nodesVisited = 0;
        this.elementsVisited = 0;
        this.validateDirty(iDefaultsNode);
        this.db.info("NodesVisited " + this.nodesVisited + " Elements visited " + this.elementsVisited);
        this.defaultsTree.applyToNode(iDefaultsNode);
    }

    public void setPassword(String string) {
        this.defaultsTree.setPassword(string);
    }

    public class DefaultsManagerDebug
    extends SDebug {
        DefaultsManagerDebug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        public final void getTree() {
            try {
                DefaultsManager.this.getDefaultsTree();
            }
            catch (Exception exception) {
                DefaultsManagerDebug.printStackTrace((Throwable)exception);
            }
        }

        public final void setTree() {
            try {
                DefaultsManager.this.defaultsTree.applyToNode(DefaultsManager.this.getDefaultsTree());
            }
            catch (Exception exception) {
                DefaultsManagerDebug.printStackTrace((Throwable)exception);
            }
        }

        public final void setEntireTree() {
            try {
                IDefaultsNode iDefaultsNode = DefaultsManager.this.getDefaultsTree();
                iDefaultsNode.resetDirty(true);
                DefaultsManager.this.defaultsTree.applyToNode(iDefaultsNode);
            }
            catch (Exception exception) {
                DefaultsManagerDebug.printStackTrace((Throwable)exception);
            }
        }

        public final void printEqTypeNames() {
            if (DefaultsManager.this.node != null) {
                TDMTerminology tDMTerminology = DefaultsManager.this.node.getTDMTerminology();
                EqTypeHelper.printEqTypeNames((KDebug)this, (TDMTerminology)tDMTerminology);
            }
        }
    }

    private class AnnotatedDefaultsInputStream
    extends FilterInputStream {
        boolean foundFirst;
        boolean foundSecond;

        AnnotatedDefaultsInputStream(InputStream inputStream) {
            super(inputStream);
            this.foundFirst = false;
            this.foundSecond = false;
            this.foundFirst = false;
            this.foundSecond = false;
        }

        private int convertByte(int n) {
            if (n == 10 || n == 13) {
                this.foundSecond = false;
                this.foundFirst = false;
            } else if (this.foundFirst) {
                if (!this.foundSecond && n == 124) {
                    this.foundSecond = true;
                }
                if (this.foundSecond) {
                    n = 10;
                }
            } else if (n == 124) {
                this.foundFirst = true;
                n = 61;
            }
            return n;
        }

        public int read() throws IOException {
            return this.convertByte(this.in.read());
        }

        public int read(byte[] byArray) throws IOException {
            int n = this.in.read(byArray);
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)this.convertByte(byArray[i]);
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.in.read(byArray, n, n2);
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)this.convertByte(byArray[i]);
            }
            return n3;
        }
    }

    public static interface IValidity {
        public boolean doCancel(int var1, DetailedLog var2);
    }
}

