/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.nedefaults;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.eQualityLevel;
import cerent.cms.idl.Common.eReversionMode;
import cerent.cms.idl.Common.sRevertiveBehavior;
import cerent.cms.idl.Ds123Media.eDs1Mapping;
import cerent.cms.idl.Ds123Media.eLineCoding;
import cerent.cms.idl.Ds123Media.eLineType;
import cerent.cms.idl.Ds123Media.eSaBit;
import cerent.cms.idl.Ds123Media.eThresholdType;
import cerent.cms.idl.Ds123Media.sConfig;
import cerent.cms.idl.Ds123Media.sNetworkPmPathThresholds;
import cerent.cms.idl.Ds123Media.sThresholds;
import cerent.cms.idl.Dwdm.eAisSquelchMode;
import cerent.cms.idl.Dwdm.eDataRate;
import cerent.cms.idl.Dwdm.eDwdmFecMode;
import cerent.cms.idl.Dwdm.eDwdmLineType;
import cerent.cms.idl.Dwdm.eMappingType;
import cerent.cms.idl.Dwdm.eMonitorType;
import cerent.cms.idl.Dwdm.eTermMode;
import cerent.cms.idl.Dwdm.s8B10BPmThresholds;
import cerent.cms.idl.Dwdm.sFECPmThresholds;
import cerent.cms.idl.Dwdm.sLaserThresholds;
import cerent.cms.idl.Dwdm.sOTNThresholds;
import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.ePortToVtMappingMode;
import cerent.cms.idl.EtherMedia.eEtherDuplex;
import cerent.cms.idl.EtherMedia.eEtherSpeed;
import cerent.cms.idl.EtherMedia.eFlowControlNegotiated;
import cerent.cms.idl.EtherMedia.ePosFramingType;
import cerent.cms.idl.EtherMedia.sCE1000EtherLineAdminInfo;
import cerent.cms.idl.EtherMedia.sML2MapperEtherLineAdminInfo;
import cerent.cms.idl.EtherMedia.sML2PosPortAdminInfo;
import cerent.cms.idl.FCMedia.eFCMediaType;
import cerent.cms.idl.FCMedia.sFCLineAdminInfo;
import cerent.cms.idl.If.eALSMode;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.idl.If.sLineSyncConfig;
import cerent.cms.idl.Lmp.eWdmRoleType;
import cerent.cms.idl.Lmp.sProductConfigAttrs;
import cerent.cms.idl.Node.eChassisVoltageType;
import cerent.cms.idl.Node.sPwrMonVoltage;
import cerent.cms.idl.Security.eAccessMechanism;
import cerent.cms.idl.Security.eSerialPortId;
import cerent.cms.idl.SonetMedia.sLineThresholds;
import cerent.cms.idl.SonetMedia.sPathThresholds;
import cerent.cms.idl.SonetMedia.sPhysicalThresholds;
import cerent.cms.idl.SonetMedia.sSectionThresholds;
import cerent.cms.idl.SonetMedia.sVtThresholds;
import cerent.cms.idl.SonetTopology.eDetectionGuardTimer;
import cerent.cms.idl.SonetTopology.eRecoveryGuardTimer;
import cerent.cms.idl.SonetTopology.eVerifyGuardTimer;
import cerent.cms.idl.Synchronization.eBits;
import cerent.cms.idl.Synchronization.eBitsFacility;
import cerent.cms.idl.Synchronization.eBitsLBO;
import cerent.cms.idl.Synchronization.eResQualityLevel;
import cerent.cms.idl.Synchronization.eSsmGen;
import cerent.cms.idl.Synchronization.eTimingMode;
import cerent.cms.idl.Synchronization.eTimingSystem;
import cerent.cms.idl.Synchronization.sBitsConfig;
import cerent.cms.idl.Synchronization.sSyncConfig;
import cerent.cms.model.AccessMechanism;
import cerent.cms.model.AccessState;
import cerent.cms.model.CtcTimeZone;
import cerent.cms.model.CtcTimeZoneFactory;
import cerent.cms.model.Feature;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ISecureIpConfig;
import cerent.cms.model.LANAccessMode;
import cerent.cms.model.LcdIpSetting;
import cerent.cms.model.LmpModel;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.Operation;
import cerent.cms.model.ProxyXlator;
import cerent.cms.model.RadiusServer;
import cerent.cms.model.RadiusServerModel;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SecurityModel;
import cerent.cms.model.SecurityPolicy;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.model.nedefaults.DefaultsElement;
import cerent.cms.model.nedefaults.IDefaultsElement;
import cerent.cms.model.nedefaults.IDefaultsNode;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.util.AbstractHoNum;
import cerent.util.InetUtil;
import cerent.util.NetworkMapUtil;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class DefaultsTree {
    private NodeModelDelegate nmd;
    private SDebug db;
    private String password = null;
    private NeDefaultsModel neDefaultsModel;
    private HashMap pendingApplications;
    private final HashMap eqTypeNameTypeMap;
    private final HashMap eqTypeTypeNameMap;
    private static final String[] SECURITY_LEVELS = new String[]{"Retrieve", "Maintenance", "Provisioning", "Superuser"};
    private static final String[] RECOVERY_GUARD_TIMERS = new String[]{"0", "0.05", "0.1", "0.5", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private static final String[] VERIFY_GUARD_TIMERS = new String[]{"0.5", "1"};
    private static final String[] DETECTION_GUARD_TIMERS = new String[]{"0", "0.05", "0.1", "0.5", "1", "2", "3", "4", "5"};
    private static final short DSN_STS_SIZE = 1;
    private static final double SCALE_FACTOR = -1000.0;
    public static final String NOT_SUPPORTED = "(NOT SUPPORTED)";

    public DefaultsTree(NodeModelDelegate nodeModelDelegate, HashMap hashMap, HashMap hashMap2) {
        this.nmd = nodeModelDelegate;
        this.eqTypeNameTypeMap = hashMap;
        this.eqTypeTypeNameMap = hashMap2;
    }

    public void init() {
        this.db = this.nmd.getDefaultsManager().getDebug().getChildDebug("WalkTree");
        this.neDefaultsModel = this.nmd.getNeDefaultsModel();
        if (this.db.isInfoEnabled()) {
            this.db.info("Effective NeDefaultsModel class is " + this.neDefaultsModel.getClass().getName() + " from " + this.nmd.getClass().getName());
        }
        this.pendingApplications = new HashMap();
    }

    public void dispose() {
        if (this.pendingApplications != null) {
            this.pendingApplications.clear();
            this.pendingApplications = null;
        }
        this.neDefaultsModel = null;
        if (this.db != null) {
            this.db.dispose();
            this.db = null;
        }
    }

    public NeDefaultsModel getNeDefaultsModel() {
        return this.neDefaultsModel;
    }

    private int findIndex(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    private String[] getHoursMins(String string) {
        String[] stringArray = new String[2];
        if (string == null || string == "") {
            this.db.severe("firstlevel:anystring was null or empty");
            stringArray[0] = null;
            stringArray[1] = null;
        } else {
            int n = string.indexOf(":");
            if (n < 0) {
                this.db.fine("firstlevel:Hit End of Line....str = " + string);
                stringArray[0] = string;
                stringArray[1] = null;
            } else {
                stringArray[0] = string.substring(0, n);
                stringArray[1] = string.substring(n + 1);
                this.db.fine("firstlevel:outstr0 = " + stringArray[0] + " outstr1 = " + stringArray[1]);
            }
        }
        return stringArray;
    }

    private String[] getMinsSecs(String string) {
        return this.getHoursMins(string);
    }

    private boolean stringToBool(String string) {
        return string.equals("TRUE");
    }

    private String boolToString(boolean bl) {
        String string = "FALSE";
        if (bl) {
            string = "TRUE";
        }
        return string;
    }

    private short stringToSoakTime(String string) {
        String[] stringArray = this.getHoursMins(string);
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        short s = (short)(n * 4 + n2 / 15);
        return s;
    }

    private String soakTimeToString(short s) {
        int n = s / 4;
        int n2 = s % 4 * 15;
        String string = "";
        String string2 = "";
        string = n < 10 ? "0" + String.valueOf(n) : String.valueOf(n);
        string2 = n2 < 10 ? "0" + String.valueOf(n2) : String.valueOf(n2);
        String string3 = string + ":" + string2;
        return string3;
    }

    private String lockoutDurationToString(int n) {
        int n2 = n / 60;
        int n3 = n % 60;
        String string = "";
        String string2 = "";
        String string3 = "";
        if (n2 < 10) {
            string3 = "0";
        }
        string = string3 + String.valueOf(n2);
        string3 = "";
        if (n3 < 10) {
            string3 = "0";
        }
        string2 = string3 + String.valueOf(n3);
        return string + ":" + string2;
    }

    private int stringToLockoutDuration(String string) {
        String[] stringArray = this.getMinsSecs(string);
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        return n * 60 + n2;
    }

    private int stringToIdleUserTimeout(String string) {
        String[] stringArray = this.getHoursMins(string);
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = n * 60 + n2;
        return n3;
    }

    private String idleUserTimeoutToString(int n) {
        int n2 = n / 60;
        int n3 = n % 60;
        String string = "";
        String string2 = "";
        string = n2 < 10 ? "0" + String.valueOf(n2) : String.valueOf(n2);
        string2 = n3 < 10 ? "0" + String.valueOf(n3) : String.valueOf(n3);
        String string3 = string + ":" + string2;
        return string3;
    }

    private void makeClean(IDefaultsNode[] iDefaultsNodeArray) {
        if (iDefaultsNodeArray != null) {
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                if (!(iDefaultsNodeArray[i] instanceof IDefaultsElement)) continue;
                ((IDefaultsElement)iDefaultsNodeArray[i]).makeClean();
            }
        }
    }

    private void handleLineSyncConfig(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        eTimingSystem eTimingSystem2 = eTimingSystem.SONET_TIMING;
        if (this.nmd.getPlatform().is455()) {
            eTimingSystem2 = eTimingSystem.SDH_TIMING;
        }
        if (iDefaultsNodeArray != null && iDefaultsNodeArray.length > 0) {
            this.db.fine("handleLineSyncConfig(): with " + iDefaultsNodeArray.length);
            sLineSyncConfig sLineSyncConfig2 = this.neDefaultsModel.getDefLineSyncConfig(eEqType2, eEqType3, eTimingSystem2);
            boolean bl2 = false;
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
                String string = iDefaultsElement.getName();
                String string2 = iDefaultsElement.getValue();
                this.db.fine("handleLineSyncConfig: processing " + string);
                bl2 |= iDefaultsElement.isDirty();
                if (string.equals("SyncMsgIn")) {
                    if (bl) {
                        sLineSyncConfig2.syncMessageIn = iDefaultsElement.getEnumValue() == 1;
                        continue;
                    }
                    iDefaultsElement.initEnumValue(sLineSyncConfig2.syncMessageIn ? 1 : 0);
                    continue;
                }
                if (string.equals("SendDoNotUse")) {
                    if (bl) {
                        sLineSyncConfig2.sendDoNotUse = this.stringToBool(string2);
                        continue;
                    }
                    iDefaultsElement.initValue(this.boolToString(sLineSyncConfig2.sendDoNotUse));
                    continue;
                }
                if (string.equals("AdminSSMIn")) {
                    if (bl) {
                        sLineSyncConfig2.adminSSM = this.getQualityLevel(string2);
                        continue;
                    }
                    iDefaultsElement.initValue(this.getStringFromQualityLevel(sLineSyncConfig2.adminSSM));
                    continue;
                }
                if (string.equals("Send<FF>DoNotUse")) {
                    if (bl) {
                        sLineSyncConfig2.sendDoNotUseFF = this.stringToBool(string2);
                        continue;
                    }
                    iDefaultsElement.initValue(this.boolToString(sLineSyncConfig2.sendDoNotUseFF));
                    continue;
                }
                this.db.severe("handleLineSyncConfig: unknown name: " + string);
            }
            if (bl && bl2) {
                this.neDefaultsModel.setDefLineSyncConfig(eEqType2, eEqType3, eTimingSystem2, sLineSyncConfig2);
                this.makeClean(iDefaultsNodeArray);
            }
        } else {
            this.db.info("No line sync config on " + this.getNameFromEqType(eEqType2) + " " + this.getNameFromEqType(eEqType3));
        }
    }

    private void setDsnConfigToNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        sConfig sConfig2 = this.neDefaultsModel.getDefConfig(eEqType2, eEqType3);
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            String string2 = iDefaultsElement.getValue();
            if (string.equals("LineType")) {
                bl |= iDefaultsElement.isDirty();
                sConfig2.lineType = eLineType.from_int(iDefaultsElement.getEnumValue());
                continue;
            }
            if (string.equals("LineCoding")) {
                bl |= iDefaultsElement.isDirty();
                if (string2.equals("B8ZS")) {
                    sConfig2.lineCoding = eLineCoding.B8ZS;
                    continue;
                }
                if (string2.equals("AMI")) {
                    sConfig2.lineCoding = eLineCoding.AMI;
                    continue;
                }
                if (string2.equals("HDB3")) {
                    sConfig2.lineCoding = eLineCoding.HDB3;
                    continue;
                }
                sConfig2.lineCoding = eLineCoding.B3ZS;
                continue;
            }
            if (string.equals("LineLength")) {
                bl |= iDefaultsElement.isDirty();
                sConfig2.lineLength = iDefaultsElement.getEnumValue();
                continue;
            }
            if (string.equals("FdlMode")) {
                bl |= iDefaultsElement.isDirty();
                sConfig2.fdlModeMask = iDefaultsElement.getEnumValue();
                continue;
            }
            this.db.severe("setDsnConfigToNodeValues: Unknown config value " + string);
        }
        if (bl) {
            this.neDefaultsModel.setDefConfig(eEqType2, eEqType3, sConfig2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setDsnPmToNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, String string, boolean bl, eThresholdType eThresholdType2) throws Exception {
        sThresholds sThresholds2 = new sThresholds(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        sNetworkPmPathThresholds sNetworkPmPathThresholds2 = new sNetworkPmPathThresholds(0, 0, 0, 0, 0, 0);
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = iDefaultsElement.getName();
            int n = Integer.parseInt(iDefaultsElement.getValue());
            bl2 |= iDefaultsElement.isDirty();
            if (string2.equals("CV") || string2.equals("CVCP") || string2.equals("CVP") || string2.equals("EB")) {
                sThresholds2.cv = n;
                continue;
            }
            if (string2.equals("ES") || string2.equals("ESCP") || string2.equals("ESP")) {
                sThresholds2.es = n;
                continue;
            }
            if (string2.equals("SES") || string2.equals("SESCP") || string2.equals("SESP")) {
                sThresholds2.ses = n;
                continue;
            }
            if (string2.equals("UAS") || string2.equals("UASCP") || string2.equals("UASP")) {
                sThresholds2.uas = n;
                continue;
            }
            if (string2.equals("AISS") || string2.equals("AISSP")) {
                sThresholds2.ais = n;
                continue;
            }
            if (string2.equals("SAS") || string2.equals("SASCP") || string2.equals("SASP")) {
                sThresholds2.sas = n;
                continue;
            }
            if (string2.equals("LOSS")) {
                sThresholds2.loss = n;
                continue;
            }
            if (string2.equals("BBE")) {
                sThresholds2.bbe = n;
                continue;
            }
            if (string2.equals("CSS")) {
                sThresholds2.css = n;
                continue;
            }
            if (string2.equals("ESA")) {
                sThresholds2.esa = n;
                continue;
            }
            if (string2.equals("ESB")) {
                sThresholds2.esb = n;
                continue;
            }
            if (string2.equals("SEFS")) {
                sThresholds2.sefs = n;
                continue;
            }
            if (string2.equals("FC")) {
                sThresholds2.fc = n;
                continue;
            }
            if (string2.equals("ESNE")) {
                sNetworkPmPathThresholds2.esne = n;
                continue;
            }
            if (string2.equals("SESNE")) {
                sNetworkPmPathThresholds2.sesne = n;
                continue;
            }
            if (string2.equals("UASNE")) {
                sNetworkPmPathThresholds2.uasne = n;
                continue;
            }
            if (string2.equals("ESFE")) {
                sNetworkPmPathThresholds2.esfe = n;
                continue;
            }
            if (string2.equals("SESFE")) {
                sNetworkPmPathThresholds2.sesfe = n;
                continue;
            }
            if (string2.equals("UASFE")) {
                sNetworkPmPathThresholds2.uasfe = n;
                continue;
            }
            this.db.severe("setDsnPmToNodeVals: Unknown " + string2 + " pm parm.");
        }
        this.db.info("setDsnPmToNodeVals(): dirty? " + bl2);
        if (bl2) {
            if (string.equals("line") || string.equals("ms")) {
                this.neDefaultsModel.setDefPmThr(eEqType2, eEqType3, bl, eThresholdType2, sThresholds2);
            } else if (string.equals("path")) {
                this.neDefaultsModel.setDefPmPathThr(eEqType2, eEqType3, bl, eThresholdType2, sThresholds2);
            } else if (string.equals("pbitpath")) {
                if (eEqType2 == eEqType.DS3E_LINE_CARD || eEqType2 == eEqType.DS3I_LINE_CARD || eEqType2 == eEqType.DS3_EC1_48_LINE_CARD || eEqType2 == eEqType.CTX_CARD && eEqType3 == eEqType.DS3 || eEqType2 == eEqType.DS1_28_DS3_EC1_3_LINE_CARD && eEqType3 == eEqType.DS3 || eEqType2 == eEqType.DS1_84_DS3_EC1_3_LINE_CARD && eEqType3 == eEqType.DS3 || eEqType2 == eEqType.DS3_EC1_6_LINE_CARD && eEqType3 == eEqType.DS3) {
                    this.neDefaultsModel.setDefPmPathThr(eEqType2, eEqType3, bl, eThresholdType2, sThresholds2);
                } else if (eEqType2 == eEqType.DS3XM_LINE_CARD || eEqType2 == eEqType.DS3XM12_LINE_CARD) {
                    sThresholds[] sThresholdsArray = this.neDefaultsModel.getDefDs3xmPmPathThr(eEqType2, eEqType3, bl, eThresholdType2);
                    sThresholdsArray[1] = sThresholds2;
                    this.neDefaultsModel.setDefDs3xmPmPathThr(eEqType2, eEqType3, bl, eThresholdType2, sThresholdsArray[0], sThresholdsArray[1]);
                } else {
                    this.db.severe("setDsnPmToNodeVals(): unhandled card " + eEqType2.value());
                }
            } else if (string.equals("cpbitpath")) {
                this.neDefaultsModel.setDefPmCPBitThr(eEqType2, eEqType3, bl, eThresholdType2, sThresholds2);
            } else if (string.equals("ds1path")) {
                sThresholds[] sThresholdsArray = this.neDefaultsModel.getDefDs3xmPmPathThr(eEqType2, eEqType3, bl, eThresholdType2);
                sThresholdsArray[0] = sThresholds2;
                this.neDefaultsModel.setDefDs3xmPmPathThr(eEqType2, eEqType3, bl, eThresholdType2, sThresholdsArray[0], sThresholdsArray[1]);
            } else if (string.equals("ds1network")) {
                this.neDefaultsModel.setDefNetworkPmPathThr(eEqType2, eThresholdType2, sNetworkPmPathThresholds2);
            } else {
                this.db.severe("setDsnPmToNodeVals(): unknown name " + string);
            }
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private sLineThresholds helpSetLinePmToNodeVals(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        sLineThresholds sLineThresholds2 = new sLineThresholds(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            int n = Integer.parseInt(iDefaultsElement.getValue());
            bl |= iDefaultsElement.isDirty();
            if (iDefaultsElement.getName().equals("CV") || iDefaultsElement.getName().equals("EB")) {
                sLineThresholds2.cv = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("ES")) {
                sLineThresholds2.es = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("SES")) {
                sLineThresholds2.ses = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("UAS")) {
                sLineThresholds2.uas = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("FC")) {
                sLineThresholds2.fc = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PSC")) {
                sLineThresholds2.psc = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PSD")) {
                sLineThresholds2.psd = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PSC-W")) {
                sLineThresholds2.pscw = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PSD-W")) {
                sLineThresholds2.psdw = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PSC-S")) {
                sLineThresholds2.pscs = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PSD-S")) {
                sLineThresholds2.psds = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PSC-R")) {
                sLineThresholds2.pscr = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PSD-R")) {
                sLineThresholds2.psdr = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("BBE")) {
                sLineThresholds2.bbe = n;
                continue;
            }
            this.db.severe("helpSetLinePmToNodeVals: Unknown line pm parm " + iDefaultsElement.getName());
        }
        if (!bl) {
            sLineThresholds2 = null;
        }
        return sLineThresholds2;
    }

    private void setLinePmToNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sLineThresholds sLineThresholds2 = this.helpSetLinePmToNodeVals(iDefaultsNodeArray);
        if (sLineThresholds2 != null) {
            this.neDefaultsModel.setDefLineThr(eEqType2, eEqType3, bl, eIntervalType2, sLineThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setLinePmToNodeVals(eEqType eEqType2, eEqType eEqType3, eDataRate eDataRate2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sLineThresholds sLineThresholds2 = this.helpSetLinePmToNodeVals(iDefaultsNodeArray);
        if (sLineThresholds2 != null) {
            this.neDefaultsModel.setDefLineThr(eEqType2, eEqType3, eDataRate2, bl, eIntervalType2, sLineThresholds2);
        }
    }

    private void setLinePmToNodeVals(eEqType eEqType2, eEqType eEqType3, eDwdmLineType eDwdmLineType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sLineThresholds sLineThresholds2 = this.helpSetLinePmToNodeVals(iDefaultsNodeArray);
        if (sLineThresholds2 != null) {
            this.neDefaultsModel.setDefLineThr(eEqType2, eEqType3, eDwdmLineType2, bl, eIntervalType2, sLineThresholds2);
        }
    }

    private sSectionThresholds helpSetSectionPmToNodeVals(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        sSectionThresholds sSectionThresholds2 = new sSectionThresholds(0, 0, 0, 0, 0, 0);
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getValue();
            bl |= iDefaultsElement.isDirty();
            if (iDefaultsElement.getName().equals("CV") || iDefaultsElement.getName().equals("EB")) {
                sSectionThresholds2.cv = Integer.parseInt(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("ES")) {
                sSectionThresholds2.es = Integer.parseInt(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("SES")) {
                sSectionThresholds2.ses = Integer.parseInt(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("SEFS")) {
                sSectionThresholds2.sefs = Integer.parseInt(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("UAS")) {
                sSectionThresholds2.uas = Integer.parseInt(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("BBE")) {
                sSectionThresholds2.bbe = Integer.parseInt(string);
                continue;
            }
            this.db.severe("setSectionPmToNodeVals: Unknown line pm parm " + iDefaultsElement.getName());
        }
        if (!bl) {
            sSectionThresholds2 = null;
        }
        return sSectionThresholds2;
    }

    private void setSectionPmToNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sSectionThresholds sSectionThresholds2 = this.helpSetSectionPmToNodeVals(iDefaultsNodeArray);
        if (sSectionThresholds2 != null) {
            this.neDefaultsModel.setDefSectionThr(eEqType2, eEqType3, bl, eIntervalType2, sSectionThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setSectionPmToNodeVals(eEqType eEqType2, eEqType eEqType3, eDataRate eDataRate2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sSectionThresholds sSectionThresholds2 = this.helpSetSectionPmToNodeVals(iDefaultsNodeArray);
        if (sSectionThresholds2 != null) {
            this.neDefaultsModel.setDefSectionThr(eEqType2, eEqType3, eDataRate2, bl, eIntervalType2, sSectionThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setSectionPmToNodeVals(eEqType eEqType2, eEqType eEqType3, eDwdmLineType eDwdmLineType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sSectionThresholds sSectionThresholds2 = this.helpSetSectionPmToNodeVals(iDefaultsNodeArray);
        if (sSectionThresholds2 != null) {
            this.neDefaultsModel.setDefSectionThr(eEqType2, eEqType3, eDwdmLineType2, bl, eIntervalType2, sSectionThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void set8B10BPmToNodeVals(eEqType eEqType2, eEqType eEqType3, eDataRate eDataRate2, IDefaultsNode[] iDefaultsNodeArray, eIntervalType eIntervalType2) throws Exception {
        s8B10BPmThresholds s8B10BPmThresholds2 = new s8B10BPmThresholds(0L, 0L, 0L, 0L, 0L, 0L);
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getValue();
            bl |= iDefaultsElement.isDirty();
            if (iDefaultsElement.getName().equals("validPackets")) {
                s8B10BPmThresholds2.validPkts = Long.parseLong(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("invalidPackets")) {
                s8B10BPmThresholds2.invalidPkts = Long.parseLong(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("codeGroupViolations")) {
                s8B10BPmThresholds2.codeViol = Long.parseLong(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("idleOrderedSets")) {
                s8B10BPmThresholds2.idleSets = Long.parseLong(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("nonIdleOrderedSets")) {
                s8B10BPmThresholds2.nonIdleSets = Long.parseLong(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("dataCodeGroups")) {
                s8B10BPmThresholds2.dataSets = Long.parseLong(string);
                continue;
            }
            this.db.severe("set8B10BPmToNodeVals: Unknown line pm parm " + iDefaultsElement.getName());
        }
        if (bl) {
            this.neDefaultsModel.setDef8B10BPmThr(eEqType2, eEqType3, eDataRate2, eIntervalType2, s8B10BPmThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setVtPathPmToNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sVtThresholds sVtThresholds2 = new sVtThresholds(0, 0, 0, 0, 0, 0);
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            int n = Integer.parseInt(iDefaultsElement.getValue());
            bl2 |= iDefaultsElement.isDirty();
            if (iDefaultsElement.getName().equals("CV") || iDefaultsElement.getName().equals("EB")) {
                sVtThresholds2.cv = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("ES")) {
                sVtThresholds2.es = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("SES")) {
                sVtThresholds2.ses = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("UAS")) {
                sVtThresholds2.uas = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("FC")) {
                sVtThresholds2.fc = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("BBE")) {
                sVtThresholds2.bbe = n;
                continue;
            }
            this.db.severe("setVtPathPmToNodeVals: Unknown vt pm parm " + iDefaultsElement.getName());
        }
        if (bl2) {
            this.neDefaultsModel.setDefVtThr(eEqType2, eEqType3, bl, eIntervalType2, sVtThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setStsPathPmToNodeVals(eEqType eEqType2, eEqType eEqType3, short s, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sPathThresholds sPathThresholds2 = new sPathThresholds(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            this.db.fine("setStsPathPmToNodeVals() " + iDefaultsNodeArray[i].getFullName());
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            int n = Integer.parseInt(iDefaultsElement.getValue());
            bl2 |= iDefaultsElement.isDirty();
            if (iDefaultsElement.getName().equals("CV") || iDefaultsElement.getName().equals("EB")) {
                sPathThresholds2.cv = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("ES")) {
                sPathThresholds2.es = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("SES")) {
                sPathThresholds2.ses = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("UAS")) {
                sPathThresholds2.uas = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("FC")) {
                sPathThresholds2.fc = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("BBE")) {
                sPathThresholds2.bbe = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PPJC-PDET")) {
                sPathThresholds2.pjpIn = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PPJC-PGEN")) {
                sPathThresholds2.pjpOut = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("NPJC-PDET")) {
                sPathThresholds2.pjnIn = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("NPJC-PGEN")) {
                sPathThresholds2.pjnOut = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PJCDIFF")) {
                sPathThresholds2.pjDiff = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PJCS-PGEN")) {
                sPathThresholds2.pjOutSec = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PJCS-PDET")) {
                sPathThresholds2.pjInSec = n;
                continue;
            }
            this.db.severe("setStsPathPmToNodeVals: Unknown sts pm parm " + iDefaultsElement.getName());
        }
        if (bl2) {
            this.neDefaultsModel.setDefPathThrCmn(eEqType2, eEqType3, s, bl, eIntervalType2, sPathThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setOtnPmToNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2, eMonitorType eMonitorType2) throws Exception {
        sOTNThresholds sOTNThresholds2 = new sOTNThresholds(0, 0, 0, 0, 0);
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            int n = Integer.parseInt(iDefaultsElement.getValue());
            bl2 |= iDefaultsElement.isDirty();
            if (iDefaultsElement.getName().equals("ES")) {
                sOTNThresholds2.es = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("SES")) {
                sOTNThresholds2.ses = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("UAS")) {
                sOTNThresholds2.uas = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("FC")) {
                sOTNThresholds2.fc = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("BBE")) {
                sOTNThresholds2.bbe = n;
                continue;
            }
            this.db.severe("setOtnPmToNodeVals: Unknown otn pm parm " + iDefaultsElement.getName() + " " + iDefaultsElement.getValue());
        }
        if (bl2) {
            this.neDefaultsModel.setDefOtnThr(eEqType2, eEqType3, bl, eIntervalType2, eMonitorType2, sOTNThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setFecPmToNodeVals(eEqType eEqType2, eEqType eEqType3, eIntervalType eIntervalType2, eDwdmFecMode eDwdmFecMode2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        sFECPmThresholds sFECPmThresholds2 = new sFECPmThresholds(0L, 0L, 0L, 0L, 0L);
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getValue();
            bl |= iDefaultsElement.isDirty();
            if (iDefaultsElement.getName().equals("BitErrorsCorrected")) {
                sFECPmThresholds2.bitErrCor = Long.parseLong(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("UncorrectableWords")) {
                sFECPmThresholds2.uncorWords = Long.parseLong(string);
                continue;
            }
            this.db.severe("setFecPmToNodeVals: Unknown fec pm parm " + iDefaultsElement.getName());
        }
        if (bl) {
            this.neDefaultsModel.setDefFecThr(eEqType2, eEqType3, eIntervalType2, eDwdmFecMode2, sFECPmThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private sLaserThresholds helpSetOpticalThresholdsToNodeVals(IDefaultsNode[] iDefaultsNodeArray, sLaserThresholds sLaserThresholds2) throws Exception {
        sLaserThresholds sLaserThresholds3 = sLaserThresholds2;
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            String string2 = iDefaultsElement.getValue();
            float f = Float.parseFloat(string2);
            this.db.fine("Setting " + string + " from " + string2 + " i.e. " + f);
            bl |= iDefaultsElement.isDirty();
            if (string.equals("LowTxPower")) {
                sLaserThresholds3.txPower.low = Math.round((float)((double)f * 10.0 + 400.0));
                continue;
            }
            if (string.equals("LowRxPower")) {
                sLaserThresholds3.rxPower.low = Math.round((float)((double)f * 10.0 + 400.0));
                continue;
            }
            if (string.equals("HighTxPower")) {
                sLaserThresholds3.txPower.high = Math.round((float)((double)f * 10.0 + 400.0));
                continue;
            }
            if (string.equals("HighRxPower")) {
                sLaserThresholds3.rxPower.high = Math.round((float)((double)f * 10.0 + 400.0));
                continue;
            }
            if (string.equals("HighLaserBias")) {
                sLaserThresholds3.laserBias.high = Math.round((float)((double)f * 10.0));
                continue;
            }
            this.db.severe("helpSetOpticalThresholdsToNodeVals: Unknown laser thresholds parm " + iDefaultsElement.getName());
        }
        if (bl) {
            this.db.fine("Setting optical thresholds:");
            this.db.fine("txPower:     low=" + sLaserThresholds3.txPower.low + " high=" + sLaserThresholds3.txPower.high);
            this.db.fine("rxPower:     low=" + sLaserThresholds3.rxPower.low + " high=" + sLaserThresholds3.rxPower.high);
            this.db.fine("laserBias:   high=" + sLaserThresholds3.laserBias.high);
            return sLaserThresholds3;
        }
        return null;
    }

    private void setOpticalThresholdsToNodeVals(eEqType eEqType2, eEqType eEqType3, eDwdmLineType eDwdmLineType2, eIntervalType eIntervalType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        sLaserThresholds sLaserThresholds2 = this.neDefaultsModel.getDefOpticsThr(eEqType2, eEqType3, eDwdmLineType2, eIntervalType2);
        sLaserThresholds sLaserThresholds3 = this.helpSetOpticalThresholdsToNodeVals(iDefaultsNodeArray, sLaserThresholds2);
        if (sLaserThresholds3 != null) {
            this.neDefaultsModel.setDefOpticsThr(eEqType2, eEqType3, eDwdmLineType2, eIntervalType2, sLaserThresholds3);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setOpticalAlarmThresholdsToNodeVals(eEqType eEqType2, eEqType eEqType3, eDwdmLineType eDwdmLineType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        sLaserThresholds sLaserThresholds2 = this.neDefaultsModel.getDefOpticsAlmThr(eEqType2, eEqType3, eDwdmLineType2);
        sLaserThresholds sLaserThresholds3 = this.helpSetOpticalThresholdsToNodeVals(iDefaultsNodeArray, sLaserThresholds2);
        if (sLaserThresholds3 != null) {
            this.neDefaultsModel.setDefOpticsAlmThr(eEqType2, eEqType3, eDwdmLineType2, sLaserThresholds3);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private boolean setDistExtensionConfigToNodeVals(sFCLineAdminInfo sFCLineAdminInfo2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            short s;
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            bl |= iDefaultsElement.isDirty();
            String string = iDefaultsElement.getName();
            String string2 = iDefaultsElement.getValue();
            if (string.equals("Enabled")) {
                sFCLineAdminInfo2.portDistanceExtension = s = this.stringToBool(string2);
                continue;
            }
            if (string.equals("AutoDetect")) {
                sFCLineAdminInfo2.creditAutoDetect = s = this.stringToBool(string2);
                continue;
            }
            if (string.equals("NumCredits")) {
                sFCLineAdminInfo2.numCredits = s = Short.parseShort(string2);
                continue;
            }
            if (string.equals("AutoadjustGFPBufferThreshold")) {
                s = (short)(this.stringToBool(string2) ? 1 : 0);
                sFCLineAdminInfo2.gfpBufferAutoThreshold = s;
                continue;
            }
            if (string.equals("NumGFPBuffers")) {
                sFCLineAdminInfo2.gfpNumBuffers = s = Short.parseShort(string2);
                continue;
            }
            this.db.severe("setDistExtConfigToNodeValues: Unknown config value " + string);
        }
        return bl;
    }

    private boolean setEnhancedFcFiconConfigToNodeVals(sFCLineAdminInfo sFCLineAdminInfo2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            short s;
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            bl |= iDefaultsElement.isDirty();
            String string = iDefaultsElement.getName();
            String string2 = iDefaultsElement.getValue();
            if (string.equals("IngressIdleFiltering")) {
                sFCLineAdminInfo2.ingressFiltering = s = this.stringToBool(string2);
                continue;
            }
            if (string.equals("MaxFrameSize")) {
                sFCLineAdminInfo2.maxFrameSize = s = Short.parseShort(string2);
                continue;
            }
            this.db.severe("setEnhancedFcFiconConfigToNodeValues: Unknown config value " + string);
        }
        return bl;
    }

    private void setFcmrConfigToNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, IDefaultsNode[] iDefaultsNodeArray2) throws Exception {
        eCardOperMode eCardOperMode2 = null;
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            if (string.equals("Mode")) {
                eCardOperMode2 = eCardOperMode.from_int(iDefaultsElement.getEnumValue());
                bl = iDefaultsElement.isDirty();
                continue;
            }
            this.db.severe("setFcmrConfigToNodeVals(): unknown " + string);
        }
        this.setFcmrConfigToNodeVals(eEqType2, eEqType3, eCardOperMode2, iDefaultsNodeArray2, bl);
    }

    private void setFcmrConfigToNodeVals(eEqType eEqType2, eEqType eEqType3, eCardOperMode eCardOperMode2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        sFCLineAdminInfo sFCLineAdminInfo2 = this.neDefaultsModel.getDefFcmrConfig(eEqType2, eEqType3);
        if (sFCLineAdminInfo2.portLoopback != eLoopback.NO_LOOPBACK) {
            bl = true;
            sFCLineAdminInfo2.portLoopback = eLoopback.NO_LOOPBACK;
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            int n;
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("distanceExtension")) {
                bl |= this.setDistExtensionConfigToNodeVals(sFCLineAdminInfo2, iDefaultsNodeArray[i].getChildren());
                continue;
            }
            if (string.equals("enhancedFibreChannelFicon")) {
                bl |= this.setEnhancedFcFiconConfigToNodeVals(sFCLineAdminInfo2, iDefaultsNodeArray[i].getChildren());
                continue;
            }
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            bl |= iDefaultsElement.isDirty();
            if (string.equals("State") || string.equals("AdminState")) {
                n = iDefaultsElement.getEnumValue();
                sFCLineAdminInfo2.portState = eAdminState.from_int(n);
                continue;
            }
            if (string.equals("AINSSoakTime")) {
                this.helpHandleSoakTime(eEqType2, eEqType3, iDefaultsElement, true);
                continue;
            }
            if (string.equals("MediaType")) {
                n = iDefaultsElement.getEnumValue();
                sFCLineAdminInfo2.portMediaType = eFCMediaType.from_int(n);
                continue;
            }
            if (string.equals("DistanceExtensionVsLinkRecovery")) {
                n = iDefaultsElement.getEnumValue();
                sFCLineAdminInfo2.portDistanceExtension = n == 1;
                sFCLineAdminInfo2.portLinkRecovery = n == 2;
                continue;
            }
            this.db.severe("setFcmrConfigToNodeValues: Unknown config value " + string);
        }
        if (bl) {
            this.neDefaultsModel.setDefFcmrConfig(eEqType2, eEqType3, eCardOperMode2, sFCLineAdminInfo2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void handleCardMode(eEqType eEqType2, IDefaultsNode iDefaultsNode, boolean bl) throws Exception {
        if (bl) {
            this.setCardMode(eEqType2, iDefaultsNode.getChildren());
        } else {
            this.getCardMode(eEqType2, iDefaultsNode.getChildren());
        }
    }

    private void getCardMode(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        eCardOperMode eCardOperMode2 = this.neDefaultsModel.getDefCardOperMode(eEqType2);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            if (!string.equals("Mode")) continue;
            iDefaultsElement.initEnumValue(eCardOperMode2.value());
        }
    }

    private void setCardMode(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            eCardOperMode eCardOperMode2 = null;
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            String string2 = iDefaultsElement.getValue();
            if (!string.equals("Mode")) continue;
            eCardOperMode2 = eCardOperMode.from_int(iDefaultsElement.getEnumValue());
            if (!iDefaultsElement.isDirty()) continue;
            this.neDefaultsModel.setDefCardOperMode(eEqType2, eCardOperMode2);
            iDefaultsElement.makeClean();
        }
    }

    private void helpApplyDwdmPmByDataRate(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        this.db.info("helpApplyToDwdmPm: dwdmNodes size = " + iDefaultsNodeArray.length);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            eDataRate eDataRate2 = null;
            eEqType eEqType3 = eEqType.DWDM_CLIENT_PORT;
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("oc3") || string.equals("stm1")) {
                eDataRate2 = eDataRate.OC3;
            } else if (string.equals("oc12") || string.equals("stm4")) {
                eDataRate2 = eDataRate.OC12;
            } else if (string.equals("oc48") || string.equals("stm16")) {
                eDataRate2 = eDataRate.OC48;
            } else if (string.equals("oc192") || string.equals("stm64")) {
                eDataRate2 = eDataRate.OC192;
            } else if (string.equals("1gethernet")) {
                eDataRate2 = eDataRate.ONE_GE;
            } else if (string.equals("1gfiberchannel")) {
                eDataRate2 = eDataRate.ONE_GFC;
            } else if (string.equals("1gficon")) {
                eDataRate2 = eDataRate.ONE_GFICON;
            } else if (string.equals("2gfiberchannel")) {
                eDataRate2 = eDataRate.TWO_GFC;
            } else if (string.equals("2gficon")) {
                eDataRate2 = eDataRate.TWO_GFICON;
            } else {
                this.db.severe("Unexpected data rate " + string);
            }
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                String string2 = iDefaultsNodeArray2[j].getName();
                IDefaultsNode[] iDefaultsNodeArray3 = iDefaultsNodeArray2[j].getChildren();
                for (int k = 0; k < iDefaultsNodeArray3.length; ++k) {
                    IDefaultsNode[] iDefaultsNodeArray4;
                    boolean bl = true;
                    eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                    if (iDefaultsNodeArray3[k].getName().equals("farend")) {
                        bl = false;
                    } else if (iDefaultsNodeArray3[k].getName().equals("15min")) {
                        eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                    } else if (iDefaultsNodeArray3[k].getName().equals("1day")) {
                        eIntervalType2 = eIntervalType.INTERVAL_DAY;
                    }
                    if (string2.equals("8b10b")) {
                        iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                        this.set8B10BPmToNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray4, eIntervalType2);
                        continue;
                    }
                    iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                    for (int i2 = 0; i2 < iDefaultsNodeArray4.length; ++i2) {
                        if (iDefaultsNodeArray4[i2].getName().equals("1day")) {
                            eIntervalType2 = eIntervalType.INTERVAL_DAY;
                        }
                        IDefaultsNode[] iDefaultsNodeArray5 = iDefaultsNodeArray4[i2].getChildren();
                        if (string2.equals("line") || string2.equals("ms")) {
                            this.setLinePmToNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray5, bl, eIntervalType2);
                            continue;
                        }
                        if (string2.equals("section") || string2.equals("rs")) {
                            this.setSectionPmToNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray5, bl, eIntervalType2);
                            continue;
                        }
                        this.db.info("helpApplyToDwdmPm: couldn't set to node vals for " + eEqType2 + " " + eDataRate2 + " " + iDefaultsNodeArray5.length + " " + bl + " " + eIntervalType2);
                    }
                }
            }
        }
    }

    private void helpApplyDwdmPmByLineType(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        this.db.info("helpApplyToDwdmPm: dwdmNodes size = " + iDefaultsNodeArray.length);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            eDwdmLineType eDwdmLineType2 = eDwdmLineType.DWDM_CLIENT;
            eEqType eEqType3 = eEqType.DWDM_CLIENT_PORT;
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("trunk")) {
                eDwdmLineType2 = eDwdmLineType.DWDM_TRUNK;
            }
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                String string2 = iDefaultsNodeArray2[j].getName();
                IDefaultsNode[] iDefaultsNodeArray3 = iDefaultsNodeArray2[j].getChildren();
                for (int k = 0; k < iDefaultsNodeArray3.length; ++k) {
                    boolean bl = true;
                    if (iDefaultsNodeArray3[k].getName().equals("farend")) {
                        bl = false;
                    }
                    IDefaultsNode[] iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                    for (int i2 = 0; i2 < iDefaultsNodeArray4.length; ++i2) {
                        eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                        if (iDefaultsNodeArray4[i2].getName().equals("1day")) {
                            eIntervalType2 = eIntervalType.INTERVAL_DAY;
                        }
                        IDefaultsNode[] iDefaultsNodeArray5 = iDefaultsNodeArray4[i2].getChildren();
                        if (string2.equals("line") || string2.equals("ms")) {
                            this.setLinePmToNodeVals(eEqType2, eEqType3, eDwdmLineType2, iDefaultsNodeArray5, bl, eIntervalType2);
                            continue;
                        }
                        if (string2.equals("section") || string2.equals("rs")) {
                            this.setSectionPmToNodeVals(eEqType2, eEqType3, eDwdmLineType2, iDefaultsNodeArray5, bl, eIntervalType2);
                            continue;
                        }
                        this.db.info("helpApplyToDwdmPm: couldn't set to node vals for " + eEqType2 + " " + eDwdmLineType2 + " " + iDefaultsNodeArray5.length + " " + bl + " " + eIntervalType2);
                    }
                }
            }
        }
    }

    private void applyToNodeCircuits(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            Object object;
            String string = "";
            String string2 = iDefaultsNodeArray[i].getName();
            if (string2.equals("upsr") || string2.equals("sncp")) {
                object = iDefaultsNodeArray[i].getChildren();
                sRevertiveBehavior sRevertiveBehavior2 = new sRevertiveBehavior();
                for (int j = 0; j < ((IDefaultsNode[])object).length; ++j) {
                    boolean bl2;
                    IDefaultsElement iDefaultsElement = (IDefaultsElement)object[j];
                    String string3 = iDefaultsElement.getName();
                    if (string3.equals("Revertive")) {
                        bl |= iDefaultsElement.isDirty();
                        string = iDefaultsElement.getValue();
                        sRevertiveBehavior2.reversionMode = eReversionMode.NON_REVERTIVE_BEHAVIOR;
                        if (!string.equals("TRUE")) continue;
                        sRevertiveBehavior2.reversionMode = eReversionMode.REVERTIVE_BEHAVIOR;
                        continue;
                    }
                    if (string3.equals("ReversionTime")) {
                        bl |= iDefaultsElement.isDirty();
                        string = iDefaultsElement.getValue();
                        sRevertiveBehavior2.reversionTime = (int)(Float.parseFloat(string) * 60.0f);
                        continue;
                    }
                    if (!iDefaultsElement.isDirty()) continue;
                    if (string3.equals("STS_SFBER") || string3.equals("HO_SFBER")) {
                        bl2 = (short)iDefaultsElement.getEnumValue();
                        this.nmd.setUpsrSfBerLevel(2, (short)(bl2 ? 1 : 0));
                    } else if (string3.equals("STS_SDBER") || string3.equals("HO_SDBER")) {
                        bl2 = (short)iDefaultsElement.getEnumValue();
                        this.nmd.setUpsrSdBerLevel(2, (short)(bl2 ? 1 : 0));
                    } else if (string3.equals("VT_SFBER") || string3.equals("LO_SFBER")) {
                        bl2 = (short)iDefaultsElement.getEnumValue();
                        this.nmd.setUpsrSfBerLevel(1, (short)(bl2 ? 1 : 0));
                    } else if (string3.equals("VT_SDBER") || string3.equals("LO_SDBER")) {
                        bl2 = (short)iDefaultsElement.getEnumValue();
                        this.nmd.setUpsrSdBerLevel(1, (short)(bl2 ? 1 : 0));
                    } else if (string3.equals("SwitchOnPDIP")) {
                        string = iDefaultsElement.getValue();
                        bl2 = this.stringToBool(string);
                        this.nmd.setUpsrSwitchOnPdip(bl2);
                    } else if (string3.equals("AllowUpsrOverOnePlusOne") || string3.equals("AllowSncpOverOnePlusOne")) {
                        this.neDefaultsModel.allowUpsrOverOnePlusOne(this.stringToBool(iDefaultsElement.getValue()));
                    } else {
                        this.db.severe("applyNodeCircuits: unknown " + string3);
                    }
                    iDefaultsElement.makeClean();
                }
                if (!bl) continue;
                this.nmd.setUpsrReversion(RevertiveBehaviorFactory.getIRevertiveBehavior(sRevertiveBehavior2));
                this.makeClean((IDefaultsNode[])object);
                continue;
            }
            if (string2.equals("State") || string2.equals("AdminState")) {
                object = (IDefaultsElement)iDefaultsNodeArray[i];
                if (!object.isDirty()) continue;
                eAdminState eAdminState2 = eAdminState.from_int(object.getEnumValue());
                this.neDefaultsModel.setDefaultCircuitAdminState(eAdminState2);
                object.makeClean();
                continue;
            }
            if (string2.equals("SendPDIP")) {
                object = (IDefaultsElement)iDefaultsNodeArray[i];
                if (!object.isDirty()) continue;
                boolean bl3 = this.stringToBool(object.getValue());
                this.nmd.setSendPDIP(bl3);
                object.makeClean();
                continue;
            }
            this.db.severe("Unknown node circuit " + string2);
        }
    }

    private void applyToNodeProtection(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            boolean bl;
            Object object;
            IDefaultsNode[] iDefaultsNodeArray2;
            boolean bl2;
            String string = "";
            String string2 = iDefaultsNodeArray[i].getName();
            if (string2.equals("1+1") || string2.equals("lmsp")) {
                bl2 = false;
                sRevertiveBehavior sRevertiveBehavior2 = this.neDefaultsModel.getDefOnePlusOneRev();
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                    object = (IDefaultsNode[])iDefaultsNodeArray2[j];
                    String string3 = object.getName();
                    string = object.getValue();
                    if (string3.equals("BidirectionalSwitching")) {
                        if (!object.isDirty()) continue;
                        bl = this.stringToBool(string);
                        this.neDefaultsModel.setDefOnePlusOneBidir(bl);
                        object.makeClean();
                        continue;
                    }
                    if (string3.equals("Revertive")) {
                        bl2 |= object.isDirty();
                        sRevertiveBehavior2.reversionMode = eReversionMode.NON_REVERTIVE_BEHAVIOR;
                        if (!string.equals("TRUE")) continue;
                        sRevertiveBehavior2.reversionMode = eReversionMode.REVERTIVE_BEHAVIOR;
                        continue;
                    }
                    if (string3.equals("ReversionTime")) {
                        bl2 |= object.isDirty();
                        sRevertiveBehavior2.reversionTime = (int)(Float.parseFloat(string) * 60.0f);
                        continue;
                    }
                    if (string3.equals("RecoveryGuardTimer")) {
                        if (!object.isDirty()) continue;
                        eRecoveryGuardTimer eRecoveryGuardTimer2 = eRecoveryGuardTimer.from_int(this.findIndex(RECOVERY_GUARD_TIMERS, string));
                        this.neDefaultsModel.setDefRecoveryGuardTimer(eRecoveryGuardTimer2);
                        object.makeClean();
                        continue;
                    }
                    if (string3.equals("VerifyGuardTimer")) {
                        if (!object.isDirty()) continue;
                        eVerifyGuardTimer eVerifyGuardTimer2 = eVerifyGuardTimer.from_int(this.findIndex(VERIFY_GUARD_TIMERS, string));
                        this.neDefaultsModel.setDefVerifyGuardTimer(eVerifyGuardTimer2);
                        object.makeClean();
                        continue;
                    }
                    if (string3.equals("DetectionGuardTimer")) {
                        if (!object.isDirty()) continue;
                        eDetectionGuardTimer eDetectionGuardTimer2 = eDetectionGuardTimer.from_int(this.findIndex(DETECTION_GUARD_TIMERS, string));
                        this.neDefaultsModel.setDefDetectionGuardTimer(eDetectionGuardTimer2);
                        object.makeClean();
                        continue;
                    }
                    this.db.severe("applyToNodeProtection:unknown 1+1 item " + string3);
                }
                if (!bl2) continue;
                this.neDefaultsModel.setDefOnePlusOneRev(sRevertiveBehavior2);
                this.makeClean(iDefaultsNodeArray2);
                continue;
            }
            if (string2.startsWith("ycable")) {
                bl2 = false;
                sRevertiveBehavior sRevertiveBehavior3 = this.neDefaultsModel.getDefYCableRev();
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                    object = (IDefaultsElement)iDefaultsNodeArray2[j];
                    String string4 = object.getName();
                    string = object.getValue();
                    if (string4.equals("BidirectionalSwitching")) {
                        if (!object.isDirty()) continue;
                        bl = this.stringToBool(string);
                        this.neDefaultsModel.setDefYCableBidir(bl);
                        object.makeClean();
                        continue;
                    }
                    if (string4.equals("Revertive")) {
                        bl2 |= object.isDirty();
                        sRevertiveBehavior3.reversionMode = eReversionMode.NON_REVERTIVE_BEHAVIOR;
                        if (!string.equals("TRUE")) continue;
                        sRevertiveBehavior3.reversionMode = eReversionMode.REVERTIVE_BEHAVIOR;
                        continue;
                    }
                    if (string4.equals("ReversionTime")) {
                        bl2 |= object.isDirty();
                        sRevertiveBehavior3.reversionTime = (int)(Float.parseFloat(string) * 60.0f);
                        continue;
                    }
                    this.db.severe("applyToNodeProtection:unknown ycable item " + string4);
                }
                if (!bl2) continue;
                this.neDefaultsModel.setDefYCableRev(sRevertiveBehavior3);
                this.makeClean(iDefaultsNodeArray2);
                continue;
            }
            if (string2.startsWith("splitter")) {
                bl2 = false;
                sRevertiveBehavior sRevertiveBehavior4 = this.neDefaultsModel.getDefSplittRev();
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                    object = (IDefaultsElement)iDefaultsNodeArray2[j];
                    String string5 = object.getName();
                    string = object.getValue();
                    if (string5.equals("Revertive")) {
                        bl2 |= object.isDirty();
                        sRevertiveBehavior4.reversionMode = eReversionMode.NON_REVERTIVE_BEHAVIOR;
                        if (!string.equals("TRUE")) continue;
                        sRevertiveBehavior4.reversionMode = eReversionMode.REVERTIVE_BEHAVIOR;
                        continue;
                    }
                    if (string5.equals("ReversionTime")) {
                        bl2 |= object.isDirty();
                        sRevertiveBehavior4.reversionTime = (int)(Float.parseFloat(string) * 60.0f);
                        continue;
                    }
                    this.db.severe("applyToNodeProtection:unknown ycable item " + string5);
                }
                if (!bl2) continue;
                this.neDefaultsModel.setDefSplittRev(sRevertiveBehavior4);
                this.makeClean(iDefaultsNodeArray2);
                continue;
            }
            if (string2.equals("blsr") || string2.equals("msspr")) {
                bl2 = false;
                boolean bl3 = false;
                iDefaultsNodeArray2 = this.neDefaultsModel.getDefBlsrRingRev();
                sRevertiveBehavior sRevertiveBehavior5 = this.neDefaultsModel.getDefBlsrSpanRev();
                object = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < ((Object)object).length; ++j) {
                    IDefaultsElement iDefaultsElement = (IDefaultsElement)object[j];
                    String string6 = iDefaultsElement.getName();
                    string = iDefaultsElement.getValue();
                    if (string6.equals("RingRevertive")) {
                        bl2 |= iDefaultsElement.isDirty();
                        iDefaultsNodeArray2.reversionMode = eReversionMode.NON_REVERTIVE_BEHAVIOR;
                        if (string.equals("TRUE")) {
                            iDefaultsNodeArray2.reversionMode = eReversionMode.REVERTIVE_BEHAVIOR;
                        }
                        this.neDefaultsModel.setDefBlsrRingRev((sRevertiveBehavior)iDefaultsNodeArray2);
                        iDefaultsElement.makeClean();
                        continue;
                    }
                    if (string6.equals("RingReversionTime")) {
                        bl2 |= iDefaultsElement.isDirty();
                        iDefaultsNodeArray2.reversionTime = (int)(Float.parseFloat(string) * 60.0f);
                        continue;
                    }
                    if (string6.equals("SpanRevertive")) {
                        bl3 |= iDefaultsElement.isDirty();
                        sRevertiveBehavior5.reversionMode = eReversionMode.NON_REVERTIVE_BEHAVIOR;
                        if (!string.equals("TRUE")) continue;
                        sRevertiveBehavior5.reversionMode = eReversionMode.REVERTIVE_BEHAVIOR;
                        continue;
                    }
                    if (string6.equals("SpanReversionTime")) {
                        bl3 |= iDefaultsElement.isDirty();
                        sRevertiveBehavior5.reversionTime = (int)(Float.parseFloat(string) * 60.0f);
                        continue;
                    }
                    this.db.severe("applyToNodeProtection:unknown 1+1 item " + string6);
                }
                if (bl2) {
                    this.neDefaultsModel.setDefBlsrRingRev((sRevertiveBehavior)iDefaultsNodeArray2);
                }
                if (bl3) {
                    this.neDefaultsModel.setDefBlsrSpanRev(sRevertiveBehavior5);
                }
                this.makeClean((IDefaultsNode[])object);
                continue;
            }
            this.db.severe("applyToNodeProtection:unknown prot type " + string2);
        }
    }

    private eQualityLevel getQualityLevel(String string) {
        eQualityLevel eQualityLevel2 = eQualityLevel.PRS;
        if (string.equals("PRS")) {
            eQualityLevel2 = eQualityLevel.PRS;
        } else if (string.equals("STU")) {
            eQualityLevel2 = this.nmd.provides(Feature.SDH) ? eQualityLevel.STU_SDH : eQualityLevel.STU;
        } else if (string.equals("ST2")) {
            eQualityLevel2 = eQualityLevel.ST2;
        } else if (string.equals("TNC")) {
            eQualityLevel2 = eQualityLevel.TNC;
        } else if (string.equals("ST3E")) {
            eQualityLevel2 = eQualityLevel.ST3E;
        } else if (string.equals("ST3")) {
            eQualityLevel2 = eQualityLevel.ST3;
        } else if (string.equals("SMC")) {
            eQualityLevel2 = eQualityLevel.SMC;
        } else if (string.equals("ST4")) {
            eQualityLevel2 = eQualityLevel.ST4;
        } else if (string.equals("DUS")) {
            eQualityLevel2 = this.nmd.provides(Feature.SDH) ? eQualityLevel.DUS_SDH : eQualityLevel.DUS;
        } else if (string.equals("RES")) {
            eQualityLevel2 = eQualityLevel.RES;
        } else if (string.equals("G811")) {
            eQualityLevel2 = eQualityLevel.G811;
        } else if (string.equals("G812T")) {
            eQualityLevel2 = eQualityLevel.G812T;
        } else if (string.equals("G812L")) {
            eQualityLevel2 = eQualityLevel.G812L;
        } else if (string.equals("SETS")) {
            eQualityLevel2 = eQualityLevel.SETS;
        } else if (string.equals("RES")) {
            eQualityLevel2 = this.nmd.provides(Feature.SDH) ? eQualityLevel.RES_SDH : eQualityLevel.RES;
        }
        return eQualityLevel2;
    }

    private eSaBit getSabit(String string) {
        eSaBit eSaBit2 = eSaBit.SA4;
        if (string.equals("4")) {
            eSaBit2 = eSaBit.SA4;
        } else if (string.equals("5")) {
            eSaBit2 = eSaBit.SA5;
        } else if (string.equals("6")) {
            eSaBit2 = eSaBit.SA6;
        } else if (string.equals("7")) {
            eSaBit2 = eSaBit.SA7;
        } else if (string.equals("8")) {
            eSaBit2 = eSaBit.SA8;
        }
        return eSaBit2;
    }

    private void helpHandleTimingGeneral(IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        IChassisModel iChassisModel = this.nmd.getNcChassis();
        SynchronizationModel synchronizationModel = iChassisModel.getSyncModel();
        sSyncConfig sSyncConfig2 = synchronizationModel.getConfig();
        sRevertiveBehavior sRevertiveBehavior2 = sSyncConfig2.reversion;
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string;
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = iDefaultsNodeArray[i].getName();
            bl2 |= iDefaultsElement.isDirty();
            if (string2.equals("Revertive")) {
                if (bl) {
                    string = iDefaultsElement.getValue();
                    if (string.equals("FALSE")) {
                        sRevertiveBehavior2.reversionMode = eReversionMode.NON_REVERTIVE_BEHAVIOR;
                        continue;
                    }
                    sRevertiveBehavior2.reversionMode = eReversionMode.REVERTIVE_BEHAVIOR;
                    continue;
                }
                string = this.boolToString(sRevertiveBehavior2.reversionMode == eReversionMode.REVERTIVE_BEHAVIOR);
                iDefaultsElement.initValue(string);
                continue;
            }
            if (string2.equals("ReversionTime")) {
                if (bl) {
                    string = iDefaultsElement.getValue();
                    sRevertiveBehavior2.reversionTime = (int)(Float.parseFloat(string) * 60.0f);
                    continue;
                }
                string = String.valueOf((double)sRevertiveBehavior2.reversionTime / 60.0);
                iDefaultsElement.initValue(string);
                continue;
            }
            if (string2.equals("QualityOfRES")) {
                if (bl) {
                    sSyncConfig2.interpretResAs = eResQualityLevel.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.getSiblingElement("SSMMessageSet").initEnumValue(sSyncConfig2.ssmGeneration.value());
                iDefaultsElement.initEnumValue(sSyncConfig2.interpretResAs.value());
                continue;
            }
            if (string2.equals("SSMMessageSet")) {
                if (bl) {
                    sSyncConfig2.ssmGeneration = eSsmGen.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sSyncConfig2.ssmGeneration.value());
                continue;
            }
            if (string2.equals("Mode")) {
                string = "UNKNOWN";
                if (bl) {
                    string = iDefaultsElement.getValue();
                    if (string.equals("External")) {
                        sSyncConfig2.timingMode = eTimingMode.EXT_TIME;
                        continue;
                    }
                    if (string.equals("Mixed")) {
                        sSyncConfig2.timingMode = eTimingMode.MIXED_TIME;
                        continue;
                    }
                    if (string.equals("Line")) {
                        sSyncConfig2.timingMode = eTimingMode.LINE_TIME;
                        continue;
                    }
                    this.db.severe("unknown mode " + sSyncConfig2.timingMode.value());
                    continue;
                }
                if (sSyncConfig2.timingMode == eTimingMode.EXT_TIME) {
                    string = "External";
                } else if (sSyncConfig2.timingMode == eTimingMode.MIXED_TIME) {
                    string = "Mixed";
                } else if (sSyncConfig2.timingMode == eTimingMode.LINE_TIME) {
                    string = "Line";
                } else {
                    this.db.severe("unknown mode " + sSyncConfig2.timingMode.value());
                }
                iDefaultsElement.initValue(string);
                continue;
            }
            this.db.severe("handleNodeTiming: unknown general element= " + string2);
        }
        if (bl && bl2) {
            synchronizationModel.setConfig(sSyncConfig2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void helpHandleBits(IDefaultsNode[] iDefaultsNodeArray, eBits eBits2, boolean bl) throws Exception {
        boolean bl2 = false;
        IChassisModel iChassisModel = this.nmd.getNcChassis();
        SynchronizationModel synchronizationModel = iChassisModel.getSyncModel();
        sBitsConfig sBitsConfig2 = synchronizationModel.getBitsConfig(eBits2);
        sBitsConfig sBitsConfig3 = synchronizationModel.getBitsConfig(eBits2);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string;
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = iDefaultsElement.getName();
            bl2 |= iDefaultsElement.isDirty();
            if (string2.equals("FacilityType")) {
                if (bl) {
                    sBitsConfig2.facilityType = eBitsFacility.from_int(iDefaultsElement.getEnumValue());
                    this.setBitsSyncMessageIn(sBitsConfig3, sBitsConfig2);
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.facilityType.value());
                continue;
            }
            if (string2.equals("FacilityTypeOut")) {
                if (bl) {
                    sBitsConfig2.facilityTypeBitsOut = eBitsFacility.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.facilityTypeBitsOut.value());
                continue;
            }
            if (string2.equals("State") || string2.equals("AdminState")) {
                if (bl) {
                    sBitsConfig2.adminState = eAdminState.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.adminState.value());
                continue;
            }
            if (string2.equals("StateOut")) {
                if (bl) {
                    sBitsConfig2.adminStateBitsOut = eAdminState.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.adminStateBitsOut.value());
                continue;
            }
            if (string2.equals("Framing")) {
                if (bl) {
                    sBitsConfig2.framing = eLineType.from_int(iDefaultsElement.getEnumValue());
                    this.setBitsSyncMessageIn(sBitsConfig3, sBitsConfig2);
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.framing.value());
                continue;
            }
            if (string2.equals("FramingOut")) {
                if (bl) {
                    sBitsConfig2.framingBitsOut = eLineType.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.framingBitsOut.value());
                continue;
            }
            if (string2.equals("Coding")) {
                if (bl) {
                    sBitsConfig2.coding = eLineCoding.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.coding.value());
                continue;
            }
            if (string2.equals("CodingOut")) {
                if (bl) {
                    sBitsConfig2.codingBitsOut = eLineCoding.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.codingBitsOut.value());
                continue;
            }
            if (string2.equals("AdminSSMIn")) {
                if (bl) {
                    sBitsConfig2.assumedQuality = this.getQualityLevel(iDefaultsElement.getValue());
                    continue;
                }
                string = this.getStringFromQualityLevel(sBitsConfig2.assumedQuality);
                iDefaultsElement.initValue(string);
                continue;
            }
            if (string2.equals("AISThreshold")) {
                if (bl) {
                    sBitsConfig2.aisThreshold = this.getQualityLevel(iDefaultsElement.getValue());
                    continue;
                }
                string = this.getStringFromQualityLevel(sBitsConfig2.aisThreshold);
                iDefaultsElement.initValue(string);
                continue;
            }
            if (string2.equals("LBO")) {
                if (bl) {
                    sBitsConfig2.bitsLBO = eBitsLBO.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.bitsLBO.value());
                continue;
            }
            if (string2.equals("Sa bit")) {
                if (bl) {
                    sBitsConfig2.saBit = this.getSabit(iDefaultsElement.getValue());
                    continue;
                }
                string = this.getStringFromSaBit(sBitsConfig2.saBit);
                iDefaultsElement.initValue(string);
                continue;
            }
            this.db.severe("helpHandleBits(): unknown bits " + string2);
        }
        if (bl && bl2) {
            synchronizationModel.setBitsConfig(eBits2, sBitsConfig2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setBitsSyncMessageIn(sBitsConfig sBitsConfig2, sBitsConfig sBitsConfig3) {
        if (sBitsConfig3.facilityType == eBitsFacility.BITS_64K) {
            sBitsConfig3.syncMessageIn = false;
        } else if (sBitsConfig2.framing != sBitsConfig3.framing) {
            switch (sBitsConfig3.framing.value()) {
                case 0: 
                case 2: 
                case 4: {
                    sBitsConfig3.syncMessageIn = true;
                    break;
                }
                case 1: 
                case 3: 
                case 16: 
                case 17: {
                    sBitsConfig3.syncMessageIn = false;
                    break;
                }
                default: {
                    this.db.severe("Unknown framing value " + sBitsConfig3.framing.value());
                }
            }
        }
    }

    private void applyNodeIPSettings(IDefaultsElement iDefaultsElement) throws Exception {
        String string = iDefaultsElement.getName();
        String string2 = iDefaultsElement.getValue();
        if (string.equals("CtcIpDisplaySuppression")) {
            if (iDefaultsElement.isDirty()) {
                this.nmd.setCtcIpDisplaySuppression(true, this.stringToBool(string2));
                iDefaultsElement.makeClean();
            }
        } else if (string.equals("LcdSetting")) {
            if (iDefaultsElement.isDirty()) {
                String string3 = string2;
                for (int i = 0; i < LcdIpSetting.LCD_IP_SETTING.length; ++i) {
                    if (!LcdIpSetting.LCD_IP_SETTING[i].equals(string3)) continue;
                    this.nmd.setLcdIpSetting(i, true);
                    break;
                }
                iDefaultsElement.makeClean();
            }
        } else {
            this.db.severe("applyNodeIpSettings: unknown general element= " + string);
        }
    }

    private void helpApplyTimeZoneAndUseDST(IDefaultsElement iDefaultsElement, IDefaultsElement iDefaultsElement2) {
        Object object;
        boolean bl;
        boolean bl2 = false;
        CtcTimeZone ctcTimeZone = this.nmd.getCtcTimeZone();
        boolean bl3 = bl = !ctcTimeZone.isDSTDisabled();
        if (iDefaultsElement != null && iDefaultsElement.isDirty()) {
            bl2 = true;
            object = this.nmd.getCtcTimeZoneFactory();
            String string = iDefaultsElement.getValue();
            for (int i = 0; i < ((CtcTimeZoneFactory)object).getNumberofTimeZones(); ++i) {
                CtcTimeZone ctcTimeZone2 = ((CtcTimeZoneFactory)object).getCtcTimeZone(i);
                if (!string.equals(ctcTimeZone2.toString())) continue;
                ctcTimeZone = ctcTimeZone2;
            }
        }
        if (iDefaultsElement2 != null && iDefaultsElement2.isDirty()) {
            bl2 = true;
            object = iDefaultsElement2.getValue();
            bl = this.stringToBool((String)object);
        }
        if (bl2) {
            this.nmd.setTimeZone(ctcTimeZone, bl);
            this.nmd.setCtcTimeZone(ctcTimeZone);
            if (iDefaultsElement != null) {
                iDefaultsElement.makeClean();
            }
            if (iDefaultsElement2 != null) {
                iDefaultsElement2.makeClean();
            }
        }
    }

    private void applyToNodeGeneral(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        IDefaultsElement iDefaultsElement = null;
        IDefaultsElement iDefaultsElement2 = null;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement3 = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement3.getName();
            if (string.equals("RaiseConditionOnEmptySlot")) {
                if (!iDefaultsElement3.isDirty()) continue;
                this.neDefaultsModel.setRaiseConditionOnEmptySlot(this.stringToBool(iDefaultsElement3.getValue()));
                iDefaultsElement3.makeClean();
                continue;
            }
            if (string.equals("ReportLoopbackConditionsOnOOS-MTPorts") || string.equals("ReportLoopbackConditionsOnUnlocked,MaintenancePorts")) {
                if (!iDefaultsElement3.isDirty()) continue;
                this.neDefaultsModel.setShowLoopbackAlarmsOnPortsUndergoingMaintenance(iDefaultsElement3.getEnumValue() == 1);
                iDefaultsElement3.makeClean();
                continue;
            }
            if (string.equals("SDPBER")) {
                if (!iDefaultsElement3.isDirty()) continue;
                short s = (short)iDefaultsElement3.getEnumValue();
                this.neDefaultsModel.setAisvOnSdpBerLevel(s);
                iDefaultsElement3.makeClean();
                continue;
            }
            String string2 = iDefaultsElement3.getValue();
            if (string.equals("DefaultsDescription")) {
                if (!iDefaultsElement3.isDirty()) continue;
                this.neDefaultsModel.setDefDescription(string2);
                iDefaultsElement3.makeClean();
                continue;
            }
            if (string.equals("TimeZone")) {
                iDefaultsElement = iDefaultsElement3;
                continue;
            }
            if (string.equals("UseDST")) {
                iDefaultsElement2 = iDefaultsElement3;
                continue;
            }
            if (string.equals("NtpSntpServer")) {
                if (!iDefaultsElement3.isDirty()) continue;
                IIpAddr iIpAddr = InetUtil.makeIpAddr(string2);
                this.nmd.setSntpHost(iIpAddr);
                iDefaultsElement3.makeClean();
                continue;
            }
            if (string.equals("InsertAISVOnSDP")) {
                if (!iDefaultsElement3.isDirty()) continue;
                this.neDefaultsModel.setAisvOnSdp(this.stringToBool(string2));
                iDefaultsElement3.makeClean();
                continue;
            }
            this.db.severe("applyToNodeGeneral: unknown general element= " + string);
        }
        this.helpApplyTimeZoneAndUseDST(iDefaultsElement, iDefaultsElement2);
    }

    private void applyToNodePowerMonitor(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        sPwrMonVoltage sPwrMonVoltage2 = this.neDefaultsModel.getDefPowerMonitor(eChassisVoltageType.V48);
        sPwrMonVoltage sPwrMonVoltage3 = this.neDefaultsModel.getDefPowerMonitor(eChassisVoltageType.V60);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            String string2 = iDefaultsElement.getValue();
            if (string.equals("ELWBATVG") || string.equals("ELWBATVG_48V")) {
                if (!iDefaultsElement.isDirty()) continue;
                sPwrMonVoltage2.ex_low_voltage = this.convertVoltage(string2);
                bl = true;
                continue;
            }
            if (string.equals("LWBATVG")) {
                if (!iDefaultsElement.isDirty()) continue;
                sPwrMonVoltage2.low_voltage = this.convertVoltage(string2);
                bl = true;
                continue;
            }
            if (string.equals("HIBATVG")) {
                if (!iDefaultsElement.isDirty()) continue;
                sPwrMonVoltage2.high_voltage = this.convertVoltage(string2);
                bl = true;
                continue;
            }
            if (string.equals("EHIBATVG") || string.equals("EHIBATVG_48V")) {
                if (!iDefaultsElement.isDirty()) continue;
                sPwrMonVoltage2.ex_high_voltage = this.convertVoltage(string2);
                bl = true;
                continue;
            }
            if (string.equals("ELWBATVG_60V")) {
                if (!iDefaultsElement.isDirty()) continue;
                sPwrMonVoltage3.ex_low_voltage = this.convertVoltage(string2);
                bl2 = true;
                continue;
            }
            if (string.equals("EHIBATVG_60V")) {
                if (!iDefaultsElement.isDirty()) continue;
                sPwrMonVoltage3.ex_high_voltage = this.convertVoltage(string2);
                bl2 = true;
                continue;
            }
            this.db.severe("unknown power monitor element: " + string);
        }
        if (bl) {
            this.neDefaultsModel.setDefPowerMonitor(sPwrMonVoltage2);
        }
        if (bl2) {
            this.neDefaultsModel.setDefPowerMonitor(sPwrMonVoltage3);
        }
        this.makeClean(iDefaultsNodeArray);
    }

    private int convertVoltage(String string) {
        int n = (int)(Double.parseDouble(string) * -1000.0);
        return n;
    }

    private String convertVoltage(int n) {
        String string = Double.toString((double)n / -1000.0);
        return string;
    }

    private void applyPendingApplications() throws Exception {
        this.db.fine("applyPendingApplications: size = " + this.pendingApplications.size());
        if (this.pendingApplications.size() > 0) {
            int n;
            Object object;
            Object object2;
            Object object3;
            IDefaultsElement iDefaultsElement = (IDefaultsElement)this.pendingApplications.get("LANAccess");
            if (iDefaultsElement != null && iDefaultsElement.getName().equals("LANAccess") && iDefaultsElement.isDirty()) {
                object3 = iDefaultsElement.getValue();
                object2 = (SecurityModel)this.nmd.getSecurityModel();
                ((SecurityModel)object2).setLANAccess(LANAccessMode.from_string((String)object3));
            }
            object3 = this.nmd.getIpConfig();
            object2 = this.nmd.getSecureIpConfig();
            boolean bl = object2.isSecureMode();
            boolean bl2 = object2.isPermanentSecureMode();
            boolean bl3 = false;
            iDefaultsElement = (IDefaultsElement)this.pendingApplications.get("IIOPListenerPort");
            if (iDefaultsElement != null && iDefaultsElement.getName().equals("IIOPListenerPort")) {
                if (iDefaultsElement.isDirty()) {
                    object = iDefaultsElement.getValue();
                    n = Integer.parseInt((String)object);
                    if (n > Short.MAX_VALUE) {
                        n -= 65536;
                    }
                    object3.setIiopPort((short)n);
                    bl3 = true;
                }
            } else if (iDefaultsElement != null) {
                this.db.severe("Pending mismatch: " + iDefaultsElement.getName());
            }
            if ((iDefaultsElement = (IDefaultsElement)this.pendingApplications.get("SecureModeOn")) != null && iDefaultsElement.getName().equals("SecureModeOn") && iDefaultsElement.isDirty()) {
                boolean bl4;
                if (bl2) {
                    throw new Exception(" The secure mode is locked and cannot be changed");
                }
                boolean bl5 = this.stringToBool(iDefaultsElement.getValue());
                IDefaultsElement iDefaultsElement2 = (IDefaultsElement)this.pendingApplications.get("SecureModeLocked");
                boolean bl6 = bl4 = iDefaultsElement2 == null ? bl2 : this.stringToBool(iDefaultsElement2.getValue());
                if (bl5 != bl) {
                    object2.setMode(bl5);
                }
                if (bl5) {
                    short s;
                    IIpAddr iIpAddr;
                    String string;
                    String string2 = "10.0.0.1";
                    String string3 = "24";
                    if (bl4) {
                        object2.setSecureMode(bl4);
                    }
                    object = object3.getIpAddress();
                    n = object3.getNetMaskPrefixLength();
                    try {
                        string = "NODE.security.dataComm.DefaultTCCEthernetIP";
                        string2 = this.neDefaultsModel.getClientDefault(string);
                    }
                    catch (NoSuchDefault noSuchDefault) {
                        this.db.severe("No Such Default" + (Object)((Object)noSuchDefault));
                    }
                    try {
                        iIpAddr = InetUtil.makeIpAddr(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.db.fine("Invalid IP Address" + numberFormatException);
                        throw new Exception("Invalid IP Address");
                    }
                    try {
                        string = "NODE.security.dataComm.DefaultTCCEthernetIPNetmask";
                        string3 = this.neDefaultsModel.getClientDefault(string);
                    }
                    catch (NoSuchDefault noSuchDefault) {
                        this.db.fine("No Such Default" + (Object)((Object)noSuchDefault));
                    }
                    try {
                        s = Short.parseShort(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.db.fine("Invalid IP Netmask" + numberFormatException);
                        throw new Exception("Invalid IP Netmask");
                    }
                    String string4 = ProxyXlator.getProxyStringOrStatus(this.nmd);
                    if (!string4.equals("GNE") && !string4.equals("ENE")) {
                        ProxyXlator.setProxy(this.nmd, 2);
                    }
                    object2.setIpAddress((IIpAddr)object);
                    object2.setNetMaskPrefixLength((short)n);
                    object3.setIpAddress(iIpAddr);
                    object3.setNetMaskPrefixLength(s);
                } else {
                    object = object2.getIpAddress();
                    n = object2.getNetMaskPrefixLength();
                    object3.setIpAddress((IIpAddr)object);
                    object3.setNetMaskPrefixLength((short)n);
                }
                bl3 = false;
                this.nmd.setSecureIpConfig((IIpConfig)object3, (ISecureIpConfig)object2);
            } else if (iDefaultsElement != null) {
                this.db.severe("Pending mismatch: " + iDefaultsElement.getName() + " dirty: " + iDefaultsElement.isDirty());
            }
            if (bl3) {
                if (bl) {
                    this.nmd.setSecureIpConfig((IIpConfig)object3, (ISecureIpConfig)object2);
                } else {
                    this.nmd.setIpConfig((IIpConfig)object3);
                }
            }
            object = this.pendingApplications.values().iterator();
            while (object.hasNext()) {
                iDefaultsElement = (IDefaultsElement)object.next();
                iDefaultsElement.makeClean();
            }
            this.pendingApplications.clear();
        }
    }

    private void applyToNodeTop(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        this.db.fine("applyToNodeTop: children size = " + iDefaultsNodeArray.length);
        boolean bl = true;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsNode iDefaultsNode = iDefaultsNodeArray[i];
            String string = iDefaultsNode.getName();
            if (!iDefaultsNode.isDirty()) {
                this.db.info(string + " is clean... continuing...");
                continue;
            }
            if (string.equals("general")) {
                this.applyToNodeGeneral(iDefaultsNode.getChildren());
                continue;
            }
            if (string.equals("lmp")) {
                this.handleNodeLmp(iDefaultsNode.getChildren(), bl);
                continue;
            }
            if (string.equals("osi")) {
                this.handleTreelessDefaults(iDefaultsNodeArray[i], bl);
                continue;
            }
            if (string.equals("powerMonitor")) {
                this.applyToNodePowerMonitor(iDefaultsNode.getChildren());
                continue;
            }
            if (string.equals("network")) {
                this.handleNodeNetwork(iDefaultsNode.getChildren(), bl);
                continue;
            }
            if (string.equals("security")) {
                this.handleNodeSecurity(iDefaultsNode.getChildren(), bl);
                continue;
            }
            if (string.equals("timing")) {
                this.handleNodeTiming(iDefaultsNode.getChildren(), bl);
                continue;
            }
            if (string.equals("protection")) {
                this.applyToNodeProtection(iDefaultsNode.getChildren());
                continue;
            }
            if (string.equals("circuits")) {
                this.applyToNodeCircuits(iDefaultsNode.getChildren());
                continue;
            }
            this.db.severe("Unknown general level " + string);
        }
        this.applyPendingApplications();
    }

    public void setPassword(String string) {
        this.password = string;
    }

    protected eEqType getEqTypeFromName(String string) throws Exception {
        if (string.equals("UNASSIGNED")) {
            return eEqType.UNPROVISIONED;
        }
        if (string.equals("PPM (1 Port)")) {
            return eEqType.PPM_1_PORT;
        }
        return (eEqType)this.eqTypeNameTypeMap.get(string);
    }

    protected String getNameFromEqType(eEqType eEqType2) {
        if (eEqType2.equals(eEqType.UNPROVISIONED)) {
            return "UNASSIGNED";
        }
        if (eEqType2.equals(eEqType.PPM_1_PORT)) {
            return "PPM (1 Port)";
        }
        return (String)this.eqTypeTypeNameMap.get(eEqType2);
    }

    private void getDsnConfigFromNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        this.db.fine("getDsnConfigFromNodeVals " + iDefaultsNodeArray.length);
        sConfig sConfig2 = this.neDefaultsModel.getDefConfig(eEqType2, eEqType3);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsNodeArray[i].getName();
            String string2 = "";
            if (string.equals("LineType")) {
                iDefaultsElement.initEnumValue(sConfig2.lineType.value());
                continue;
            }
            if (string.equals("LineCoding")) {
                string2 = sConfig2.lineCoding == eLineCoding.B8ZS ? "B8ZS" : (sConfig2.lineCoding == eLineCoding.AMI ? "AMI" : (sConfig2.lineCoding == eLineCoding.HDB3 ? "HDB3" : "B3ZS"));
                iDefaultsElement.initValue(string2);
                continue;
            }
            if (string.equals("LineLength")) {
                int n = 0;
                if (eEqType3 == eEqType.DS1_VT_MAPPED) {
                    n = 655;
                    if (sConfig2.lineLength >= 0 && sConfig2.lineLength < 132) {
                        n = 131;
                    } else if (sConfig2.lineLength >= 132 && sConfig2.lineLength < 263) {
                        n = 262;
                    } else if (sConfig2.lineLength >= 263 && sConfig2.lineLength < 394) {
                        n = 393;
                    } else if (sConfig2.lineLength >= 394 && sConfig2.lineLength < 525) {
                        n = 524;
                    }
                } else {
                    n = 450;
                    if (sConfig2.lineLength >= 0 && sConfig2.lineLength < 226) {
                        n = 225;
                    }
                }
                iDefaultsElement.initEnumValue(n);
                continue;
            }
            if (string.equals("FdlMode")) {
                iDefaultsElement.initEnumValue(sConfig2.fdlModeMask);
                continue;
            }
            this.db.severe("Unknown config value " + string);
            string2 = "UNKNOWN";
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getDsnPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, String string, boolean bl, eThresholdType eThresholdType2) throws Exception {
        sNetworkPmPathThresholds sNetworkPmPathThresholds2;
        sThresholds sThresholds2;
        block50: {
            sThresholds[] sThresholdsArray;
            block53: {
                block52: {
                    block51: {
                        sThresholds2 = null;
                        sNetworkPmPathThresholds2 = null;
                        if (!string.equals("line") && !string.equals("ms")) break block51;
                        sThresholds2 = this.neDefaultsModel.getDefPmThr(eEqType2, eEqType3, bl, eThresholdType2);
                        break block50;
                    }
                    if (!string.equals("path")) break block52;
                    sThresholds2 = this.neDefaultsModel.getDefPmPathThr(eEqType2, eEqType3, bl, eThresholdType2);
                    break block50;
                }
                if (!string.equals("pbitpath")) break block53;
                if (eEqType2 == eEqType.DS3E_LINE_CARD || eEqType2 == eEqType.DS3I_LINE_CARD || eEqType2 == eEqType.DS3_EC1_48_LINE_CARD || eEqType2 == eEqType.CTX_CARD && eEqType3 == eEqType.DS3 || eEqType2 == eEqType.DS1_28_DS3_EC1_3_LINE_CARD && eEqType3 == eEqType.DS3 || eEqType2 == eEqType.DS1_84_DS3_EC1_3_LINE_CARD && eEqType3 == eEqType.DS3 || eEqType2 == eEqType.DS3_EC1_6_LINE_CARD && eEqType3 == eEqType.DS3) {
                    sThresholds2 = this.neDefaultsModel.getDefPmPathThr(eEqType2, eEqType3, bl, eThresholdType2);
                    break block50;
                } else if (eEqType2 == eEqType.DS3XM_LINE_CARD || eEqType2 == eEqType.DS3XM12_LINE_CARD) {
                    sThresholdsArray = this.neDefaultsModel.getDefDs3xmPmPathThr(eEqType2, eEqType3, bl, eThresholdType2);
                    sThresholds2 = sThresholdsArray[1];
                    break block50;
                } else {
                    this.db.severe("getDsnPmToNodeVals(): " + string + " not correct for  " + this.getNameFromEqType(eEqType2) + " " + this.getNameFromEqType(eEqType3) + " !!");
                }
                break block50;
            }
            if (string.equals("ds1path")) {
                if (eEqType2 != eEqType.DS3XM_LINE_CARD && eEqType2 != eEqType.DS3XM12_LINE_CARD) {
                    this.db.severe("Error in getDsnPmToNodeVals....ds1path not correct for this card!!");
                    return;
                }
                sThresholdsArray = this.neDefaultsModel.getDefDs3xmPmPathThr(eEqType2, eEqType3, bl, eThresholdType2);
                sThresholds2 = sThresholdsArray[0];
            } else if (string.equals("ds1network")) {
                sNetworkPmPathThresholds2 = this.neDefaultsModel.getDefNetworkPmPathThr(eEqType2, eThresholdType2);
            } else {
                if (!string.equals("cpbitpath")) {
                    this.db.severe("Error in getDsnPmToNodeVals....could not get Thresholds!!!" + string);
                    return;
                }
                sThresholds2 = this.neDefaultsModel.getDefPmCPBitThr(eEqType2, eEqType3, bl, eThresholdType2);
            }
        }
        int n = 0;
        while (n < iDefaultsNodeArray.length) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[n];
            String string2 = iDefaultsElement.getName();
            String string3 = "";
            if (string2.equals("CV") || string2.equals("CVCP") || string2.equals("CVP") || string2.equals("EB")) {
                string3 = String.valueOf(sThresholds2.cv);
            } else if (string2.equals("ES") || string2.equals("ESCP") || string2.equals("ESP")) {
                string3 = String.valueOf(sThresholds2.es);
            } else if (string2.equals("SES") || string2.equals("SESCP") || string2.equals("SESP")) {
                string3 = String.valueOf(sThresholds2.ses);
            } else if (string2.equals("UAS") || string2.equals("UASCP") || string2.equals("UASP")) {
                string3 = String.valueOf(sThresholds2.uas);
            } else if (string2.equals("AISS") || string2.equals("AISSP")) {
                string3 = String.valueOf(sThresholds2.ais);
            } else if (string2.equals("SAS") || string2.equals("SASCP") || string2.equals("SASP")) {
                string3 = String.valueOf(sThresholds2.sas);
            } else if (string2.equals("LOSS")) {
                string3 = String.valueOf(sThresholds2.loss);
            } else if (string2.equals("BBE")) {
                string3 = String.valueOf(sThresholds2.bbe);
            } else if (string2.equals("CSS")) {
                string3 = String.valueOf(sThresholds2.css);
            } else if (string2.equals("ESA")) {
                string3 = String.valueOf(sThresholds2.esa);
            } else if (string2.equals("ESB")) {
                string3 = String.valueOf(sThresholds2.esb);
            } else if (string2.equals("SEFS")) {
                string3 = String.valueOf(sThresholds2.sefs);
            } else if (string2.equals("FC")) {
                string3 = String.valueOf(sThresholds2.fc);
            } else if (string2.equals("ESNE")) {
                string3 = String.valueOf(sNetworkPmPathThresholds2.esne);
            } else if (string2.equals("SESNE")) {
                string3 = String.valueOf(sNetworkPmPathThresholds2.sesne);
            } else if (string2.equals("UASNE")) {
                string3 = String.valueOf(sNetworkPmPathThresholds2.uasne);
            } else if (string2.equals("ESFE")) {
                string3 = String.valueOf(sNetworkPmPathThresholds2.esfe);
            } else if (string2.equals("SESFE")) {
                string3 = String.valueOf(sNetworkPmPathThresholds2.sesfe);
            } else if (string2.equals("UASFE")) {
                string3 = String.valueOf(sNetworkPmPathThresholds2.uasfe);
            } else {
                string3 = String.valueOf("88");
                this.db.severe("getDsnPmToNodeVals: Unknown " + string2 + " pm parm.");
            }
            iDefaultsElement.initValue(string3);
            ++n;
        }
        return;
    }

    void helpGetLinePmVals(sLineThresholds sLineThresholds2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = "";
            if (iDefaultsElement.getName().equals("CV") || iDefaultsElement.getName().equals("EB")) {
                string = String.valueOf(sLineThresholds2.cv);
            } else if (iDefaultsElement.getName().equals("ES")) {
                string = String.valueOf(sLineThresholds2.es);
            } else if (iDefaultsElement.getName().equals("SES")) {
                string = String.valueOf(sLineThresholds2.ses);
            } else if (iDefaultsElement.getName().equals("UAS")) {
                string = String.valueOf(sLineThresholds2.uas);
            } else if (iDefaultsElement.getName().equals("FC")) {
                string = String.valueOf(sLineThresholds2.fc);
            } else if (iDefaultsElement.getName().equals("PSC")) {
                string = String.valueOf(sLineThresholds2.psc);
            } else if (iDefaultsElement.getName().equals("PSD")) {
                string = String.valueOf(sLineThresholds2.psd);
            } else if (iDefaultsElement.getName().equals("PSC-W")) {
                string = String.valueOf(sLineThresholds2.pscw);
            } else if (iDefaultsElement.getName().equals("PSD-W")) {
                string = String.valueOf(sLineThresholds2.psdw);
            } else if (iDefaultsElement.getName().equals("PSC-S")) {
                string = String.valueOf(sLineThresholds2.pscs);
            } else if (iDefaultsElement.getName().equals("PSD-S")) {
                string = String.valueOf(sLineThresholds2.psds);
            } else if (iDefaultsElement.getName().equals("PSC-R")) {
                string = String.valueOf(sLineThresholds2.pscr);
            } else if (iDefaultsElement.getName().equals("PSD-R")) {
                string = String.valueOf(sLineThresholds2.psdr);
            } else if (iDefaultsElement.getName().equals("BBE")) {
                string = String.valueOf(sLineThresholds2.bbe);
            } else {
                string = String.valueOf("88");
                this.db.severe("helpGetLinePmVals: Unknown line pm parm " + iDefaultsElement.getName());
            }
            iDefaultsElement.initValue(string);
        }
    }

    private void getLinePmFromNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sLineThresholds sLineThresholds2 = this.neDefaultsModel.getDefLineThr(eEqType2, eEqType3, bl, eIntervalType2);
        this.helpGetLinePmVals(sLineThresholds2, iDefaultsNodeArray);
    }

    private void getLinePmFromNodeVals(eEqType eEqType2, eEqType eEqType3, eDataRate eDataRate2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sLineThresholds sLineThresholds2 = this.neDefaultsModel.getDefLineThr(eEqType2, eEqType3, eDataRate2, bl, eIntervalType2);
        this.helpGetLinePmVals(sLineThresholds2, iDefaultsNodeArray);
    }

    private void getLinePmFromNodeVals(eEqType eEqType2, eEqType eEqType3, eDwdmLineType eDwdmLineType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sLineThresholds sLineThresholds2 = this.neDefaultsModel.getDefLineThr(eEqType2, eEqType3, eDwdmLineType2, bl, eIntervalType2);
        this.helpGetLinePmVals(sLineThresholds2, iDefaultsNodeArray);
    }

    void helpGetSectionPmVals(sSectionThresholds sSectionThresholds2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = "";
            if (iDefaultsElement.getName().equals("CV") || iDefaultsElement.getName().equals("EB")) {
                string = String.valueOf(sSectionThresholds2.cv);
            } else if (iDefaultsElement.getName().equals("ES")) {
                string = String.valueOf(sSectionThresholds2.es);
            } else if (iDefaultsElement.getName().equals("SES")) {
                string = String.valueOf(sSectionThresholds2.ses);
            } else if (iDefaultsElement.getName().equals("SEFS")) {
                string = String.valueOf(sSectionThresholds2.sefs);
            } else if (iDefaultsElement.getName().equals("UAS")) {
                string = String.valueOf(sSectionThresholds2.uas);
            } else if (iDefaultsElement.getName().equals("BBE")) {
                string = String.valueOf(sSectionThresholds2.bbe);
            } else {
                string = String.valueOf("88");
                this.db.severe("getSectionPmToNodeVals: Unknown section pm parm " + iDefaultsElement.getName());
            }
            iDefaultsElement.initValue(string);
        }
    }

    private void getSectionPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sSectionThresholds sSectionThresholds2 = this.neDefaultsModel.getDefSectionThr(eEqType2, eEqType3, bl, eIntervalType2);
        this.helpGetSectionPmVals(sSectionThresholds2, iDefaultsNodeArray);
    }

    private void getSectionPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, eDataRate eDataRate2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sSectionThresholds sSectionThresholds2 = this.neDefaultsModel.getDefSectionThr(eEqType2, eEqType3, eDataRate2, bl, eIntervalType2);
        this.helpGetSectionPmVals(sSectionThresholds2, iDefaultsNodeArray);
    }

    private void getSectionPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, eDwdmLineType eDwdmLineType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sSectionThresholds sSectionThresholds2 = this.neDefaultsModel.getDefSectionThr(eEqType2, eEqType3, eDwdmLineType2, bl, eIntervalType2);
        this.helpGetSectionPmVals(sSectionThresholds2, iDefaultsNodeArray);
    }

    private void get8B10BPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, eDataRate eDataRate2, IDefaultsNode[] iDefaultsNodeArray, eIntervalType eIntervalType2) throws Exception {
        s8B10BPmThresholds s8B10BPmThresholds2 = this.neDefaultsModel.getDef8B10BPmThr(eEqType2, eEqType3, eDataRate2, eIntervalType2);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = "";
            if (iDefaultsElement.getName().equals("validPackets")) {
                string = String.valueOf(s8B10BPmThresholds2.validPkts);
            } else if (iDefaultsElement.getName().equals("invalidPackets")) {
                string = String.valueOf(s8B10BPmThresholds2.invalidPkts);
            } else if (iDefaultsElement.getName().equals("codeGroupViolations")) {
                string = String.valueOf(s8B10BPmThresholds2.codeViol);
            } else if (iDefaultsElement.getName().equals("idleOrderedSets")) {
                string = String.valueOf(s8B10BPmThresholds2.idleSets);
            } else if (iDefaultsElement.getName().equals("nonIdleOrderedSets")) {
                string = String.valueOf(s8B10BPmThresholds2.nonIdleSets);
            } else if (iDefaultsElement.getName().equals("dataCodeGroups")) {
                string = String.valueOf(s8B10BPmThresholds2.dataSets);
            } else {
                string = String.valueOf("88");
                this.db.severe("get8B10BPmToNodeVals: Unknown pm parm " + iDefaultsElement.getName());
            }
            iDefaultsElement.initValue(string);
        }
    }

    private void getVtPathPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sVtThresholds sVtThresholds2 = this.neDefaultsModel.getDefVtThr(eEqType2, eEqType3, bl, eIntervalType2);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = "";
            if (iDefaultsElement.getName().equals("CV") || iDefaultsElement.getName().equals("EB")) {
                string = String.valueOf(sVtThresholds2.cv);
            } else if (iDefaultsElement.getName().equals("ES")) {
                string = String.valueOf(sVtThresholds2.es);
            } else if (iDefaultsElement.getName().equals("SES")) {
                string = String.valueOf(sVtThresholds2.ses);
            } else if (iDefaultsElement.getName().equals("UAS")) {
                string = String.valueOf(sVtThresholds2.uas);
            } else if (iDefaultsElement.getName().equals("FC")) {
                string = String.valueOf(sVtThresholds2.fc);
            } else if (iDefaultsElement.getName().equals("BBE")) {
                string = String.valueOf(sVtThresholds2.bbe);
            } else {
                string = String.valueOf("88");
                this.db.severe("getVtPathPmToNodeVals: Unknown vt pm parm " + iDefaultsElement.getName());
            }
            iDefaultsElement.initValue(string);
        }
    }

    private void getStsPathPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, short s, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sPathThresholds sPathThresholds2 = this.neDefaultsModel.getDefPathThrCmn(eEqType2, eEqType3, s, bl, eIntervalType2);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            this.db.fine("getStsPathPmFromNodeVals() " + iDefaultsNodeArray[i].getFullName());
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = "";
            if (iDefaultsElement.getName().equals("CV") || iDefaultsElement.getName().equals("EB")) {
                string = String.valueOf(sPathThresholds2.cv);
            } else if (iDefaultsElement.getName().equals("ES")) {
                string = String.valueOf(sPathThresholds2.es);
            } else if (iDefaultsElement.getName().equals("SES")) {
                string = String.valueOf(sPathThresholds2.ses);
            } else if (iDefaultsElement.getName().equals("UAS")) {
                string = String.valueOf(sPathThresholds2.uas);
            } else if (iDefaultsElement.getName().equals("FC")) {
                string = String.valueOf(sPathThresholds2.fc);
            } else if (iDefaultsElement.getName().equals("BBE")) {
                string = String.valueOf(sPathThresholds2.bbe);
            } else if (iDefaultsElement.getName().equals("PPJC-PDET")) {
                string = String.valueOf(sPathThresholds2.pjpIn);
            } else if (iDefaultsElement.getName().equals("PPJC-PGEN")) {
                string = String.valueOf(sPathThresholds2.pjpOut);
            } else if (iDefaultsElement.getName().equals("NPJC-PDET")) {
                string = String.valueOf(sPathThresholds2.pjnIn);
            } else if (iDefaultsElement.getName().equals("NPJC-PGEN")) {
                string = String.valueOf(sPathThresholds2.pjnOut);
            } else if (iDefaultsElement.getName().equals("PJCDIFF")) {
                string = String.valueOf(sPathThresholds2.pjDiff);
            } else if (iDefaultsElement.getName().equals("PJCS-PDET")) {
                string = String.valueOf(sPathThresholds2.pjInSec);
            } else if (iDefaultsElement.getName().equals("PJCS-PGEN")) {
                string = String.valueOf(sPathThresholds2.pjOutSec);
            } else {
                string = String.valueOf("88");
                this.db.severe("getStsPathPmFromNodeVals: Unknown sts pm parm " + iDefaultsElement.getName());
            }
            iDefaultsElement.initValue(string);
        }
    }

    private void getOtnPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2, eMonitorType eMonitorType2) throws Exception {
        sOTNThresholds sOTNThresholds2 = this.neDefaultsModel.getDefOtnThr(eEqType2, eEqType3, bl, eIntervalType2, eMonitorType2);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = "";
            if (iDefaultsElement.getName().equals("ES")) {
                string = String.valueOf(sOTNThresholds2.es);
            } else if (iDefaultsElement.getName().equals("SES")) {
                string = String.valueOf(sOTNThresholds2.ses);
            } else if (iDefaultsElement.getName().equals("UAS")) {
                string = String.valueOf(sOTNThresholds2.uas);
            } else if (iDefaultsElement.getName().equals("FC")) {
                string = String.valueOf(sOTNThresholds2.fc);
            } else if (iDefaultsElement.getName().equals("BBE")) {
                string = String.valueOf(sOTNThresholds2.bbe);
            } else {
                string = String.valueOf("88");
                this.db.severe("getOtnPmFromNodeVals: Unknown otn pm parm " + iDefaultsElement.getName());
            }
            iDefaultsElement.initValue(string);
        }
    }

    private void getFecPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, eIntervalType eIntervalType2, eDwdmFecMode eDwdmFecMode2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        sFECPmThresholds sFECPmThresholds2 = this.neDefaultsModel.getDefFecThr(eEqType2, eEqType3, eIntervalType2, eDwdmFecMode2);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = "";
            if (iDefaultsElement.getName().equals("BitErrorsCorrected")) {
                string = String.valueOf(sFECPmThresholds2.bitErrCor);
            } else if (iDefaultsElement.getName().equals("UncorrectableWords")) {
                string = String.valueOf(sFECPmThresholds2.uncorWords);
            } else {
                string = String.valueOf("88");
                this.db.severe("getFecPmFromNodeVals: Unknown fec pm parm " + iDefaultsElement.getName());
            }
            iDefaultsElement.initValue(string);
        }
    }

    private void helpGetOpticalThresholdsFromNodeVals(sLaserThresholds sLaserThresholds2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = "";
            float f = 0.0f;
            int n = 0;
            int n2 = 10;
            if (iDefaultsElement.getName().equals("LowTxPower")) {
                f = sLaserThresholds2.txPower.low;
                n = 400;
            } else if (iDefaultsElement.getName().equals("LowRxPower")) {
                f = sLaserThresholds2.rxPower.low;
                n = 400;
            } else if (iDefaultsElement.getName().equals("HighTxPower")) {
                f = sLaserThresholds2.txPower.high;
                n = 400;
            } else if (iDefaultsElement.getName().equals("HighRxPower")) {
                f = sLaserThresholds2.rxPower.high;
                n = 400;
            } else if (iDefaultsElement.getName().equals("HighLaserBias")) {
                f = sLaserThresholds2.laserBias.high;
            } else {
                f = 88.0f;
                n2 = 1;
                this.db.severe("helpGetOpticalThresholdFromNodeVals: Unknown sLaserThresholds parm " + iDefaultsElement.getName());
            }
            string = String.valueOf((f - (float)n) / (float)n2);
            iDefaultsElement.initValue(string);
        }
    }

    private void getOpticalAlarmThresholdsFromNodeVals(eEqType eEqType2, eEqType eEqType3, eDwdmLineType eDwdmLineType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        this.db.fine("getOpticalAlarmThresholdsFromNodeVals " + iDefaultsNodeArray.length);
        sLaserThresholds sLaserThresholds2 = this.neDefaultsModel.getDefOpticsAlmThr(eEqType2, eEqType3, eDwdmLineType2);
        this.helpGetOpticalThresholdsFromNodeVals(sLaserThresholds2, iDefaultsNodeArray);
    }

    private void getOpticalThresholdsFromNodeVals(eEqType eEqType2, eEqType eEqType3, eDwdmLineType eDwdmLineType2, eIntervalType eIntervalType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        this.db.fine("getOpticalThresholdsFromNodeVals" + iDefaultsNodeArray.length);
        sLaserThresholds sLaserThresholds2 = this.neDefaultsModel.getDefOpticsThr(eEqType2, eEqType3, eDwdmLineType2, eIntervalType2);
        this.helpGetOpticalThresholdsFromNodeVals(sLaserThresholds2, iDefaultsNodeArray);
    }

    private void helpHandleInhibitLoopback(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                this.neDefaultsModel.setDefInhibitLpbk(eEqType2, eEqType3, this.stringToBool(iDefaultsElement.getValue()));
                iDefaultsElement.makeClean();
            }
        } else {
            iDefaultsElement.initValue(this.boolToString(this.neDefaultsModel.getDefInhibitLpbk(eEqType2, eEqType3)));
        }
    }

    private void helpHandleAdminState(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = iDefaultsElement.getEnumValue();
                eAdminState eAdminState2 = eAdminState.from_int(n);
                this.neDefaultsModel.setDefAdminState(eEqType2, eEqType3, eAdminState2);
                iDefaultsElement.makeClean();
            }
        } else {
            eAdminState eAdminState3 = this.neDefaultsModel.getDefAdminState(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(eAdminState3.value());
        }
    }

    private void helpHandleSoakTime(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string = iDefaultsElement.getValue();
                short s = this.stringToSoakTime(string);
                this.neDefaultsModel.setDefAinsSoakTime(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefAinsSoakTime(eEqType2, eEqType3);
            String string = this.soakTimeToString(s);
            iDefaultsElement.initValue(string);
        }
    }

    private void helpHandleOperatingMode(eEqType eEqType2, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                eCardOperMode eCardOperMode2 = eCardOperMode.from_int(iDefaultsElement.getEnumValue());
                this.neDefaultsModel.setDefCardOperMode(eEqType2, eCardOperMode2);
                iDefaultsElement.makeClean();
            }
        } else {
            iDefaultsElement.initEnumValue(this.neDefaultsModel.getDefCardOperMode(eEqType2).value());
        }
    }

    private void helpHandlePortToVtMappingMode(eEqType eEqType2, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                ePortToVtMappingMode ePortToVtMappingMode2 = ePortToVtMappingMode.from_int(iDefaultsElement.getEnumValue());
                this.neDefaultsModel.setDefPortToVtMappingMode(eEqType2, ePortToVtMappingMode2);
                iDefaultsElement.makeClean();
            }
        } else {
            iDefaultsElement.initEnumValue(this.neDefaultsModel.getDefPortToVtMappingMode(eEqType2).value());
        }
    }

    private void helpHandleAlsMode(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = iDefaultsElement.getEnumValue();
                eALSMode eALSMode2 = eALSMode.from_int(n);
                this.neDefaultsModel.setDefAlsMode(eEqType2, eEqType3, eALSMode2);
                iDefaultsElement.makeClean();
            }
        } else {
            eALSMode eALSMode3 = this.neDefaultsModel.getDefAlsMode(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(eALSMode3.value());
        }
    }

    private void helpHandleAlsRecoveryPulseInterval(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string = iDefaultsElement.getValue();
                short s = Short.parseShort(string);
                this.neDefaultsModel.setDefAlsRecoveryInterval(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefAlsRecoveryInterval(eEqType2, eEqType3);
            String string = String.valueOf(new Short(s));
            iDefaultsElement.initValue(string);
        }
    }

    private void helpHandleAlsRecoveryPulseDuration(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string = iDefaultsElement.getValue();
                Float f = new Float(Float.parseFloat(string) * 10.0f);
                short s = f.shortValue();
                this.neDefaultsModel.setDefAlsRecoveryPulseWidth(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefAlsRecoveryPulseWidth(eEqType2, eEqType3);
            String string = String.valueOf(new Float((double)s / 10.0));
            iDefaultsElement.initValue(string);
        }
    }

    private void helpHandleLoopbackAis(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl, eLoopback eLoopback2) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                boolean bl2 = this.stringToBool(iDefaultsElement.getValue());
                this.neDefaultsModel.setDefLoopbackAis(eEqType2, eEqType3, eLoopback2, bl2);
                iDefaultsElement.makeClean();
            }
        } else {
            boolean bl3 = this.neDefaultsModel.getDefLoopbackAis(eEqType2, eEqType3, eLoopback2);
            iDefaultsElement.initValue(this.boolToString(bl3));
        }
    }

    private void helpHandleAisOnFacilityLoopback(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        this.helpHandleLoopbackAis(eEqType2, eEqType3, iDefaultsElement, bl, eLoopback.LINE_LOOPBACK);
    }

    private void helpHandleAisOnTerminalLoopback(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        this.helpHandleLoopbackAis(eEqType2, eEqType3, iDefaultsElement, bl, eLoopback.INWARD_LOOPBACK);
    }

    private void helpHandleMappingType(eEqType eEqType2, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = iDefaultsElement.getEnumValue();
                eMappingType eMappingType2 = eMappingType.from_int(n);
                this.neDefaultsModel.setDefMappingType(eEqType2, eMappingType2);
                iDefaultsElement.makeClean();
            }
        } else {
            eMappingType eMappingType3 = this.neDefaultsModel.getDefMappingType(eEqType2);
            iDefaultsElement.initEnumValue(eMappingType3.value());
        }
    }

    private void helpHandleSfBerLevel(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                short s = (short)iDefaultsElement.getEnumValue();
                this.neDefaultsModel.setDefDeclareSfBerLevel(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefDeclareSfBerLevel(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(s);
        }
    }

    private void helpHandleDsnSfBerLevel(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                short s = (short)iDefaultsElement.getEnumValue();
                this.neDefaultsModel.setDefDeclareDSnSfBerLevel(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefDeclareDSnSfBerLevel(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(s);
        }
    }

    private void helpHandleSdBerLevel(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                short s = (short)iDefaultsElement.getEnumValue();
                this.neDefaultsModel.setDefDeclareSdBerLevel(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefDeclareSdBerLevel(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(s);
        }
    }

    private void helpHandleDsnSdBerLevel(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                short s = (short)iDefaultsElement.getEnumValue();
                this.neDefaultsModel.setDefDeclareDSnSdBerLevel(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefDeclareDSnSdBerLevel(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(s);
        }
    }

    private void helpHandleDs1RetimingEnabled(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string = iDefaultsElement.getValue();
                boolean bl2 = this.stringToBool(string);
                this.neDefaultsModel.setDefDs1RetimingEnabled(eEqType2, eEqType3, bl2);
                iDefaultsElement.makeClean();
            }
        } else {
            boolean bl3 = this.neDefaultsModel.getDefDs1RetimingEnabled(eEqType2, eEqType3);
            String string = this.boolToString(bl3);
            iDefaultsElement.initValue(string);
        }
    }

    private void helpHandleDs1AisvEnabled(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                boolean bl2 = iDefaultsElement.getEnumValue() == 1;
                this.neDefaultsModel.setDefDs1AisvEnabled(eEqType2, eEqType3, bl2);
                iDefaultsElement.makeClean();
            }
        } else {
            boolean bl3 = this.neDefaultsModel.getDefDs1AisvEnabled(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(bl3 ? 1 : 0);
        }
    }

    private void helpHandleDs1AisOnLofEnabled(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                boolean bl2 = iDefaultsElement.getEnumValue() == 1;
                this.neDefaultsModel.setDefDs1AisOnLofEnabled(eEqType2, eEqType3, bl2);
                iDefaultsElement.makeClean();
            }
        } else {
            boolean bl3 = this.neDefaultsModel.getDefDs1AisOnLofEnabled(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(bl3 ? 1 : 0);
        }
    }

    private void helpHandleLineSdBerLevel(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                short s = (short)iDefaultsElement.getEnumValue();
                this.neDefaultsModel.setDefLineSdBerLevel(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefLineSdBerLevel(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(s);
        }
    }

    private void helpHandleDs1Mapping(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = iDefaultsElement.getEnumValue();
                eDs1Mapping eDs1Mapping2 = eDs1Mapping.from_int(n);
                this.neDefaultsModel.setDefDs1Mapping(eEqType2, eEqType3, eDs1Mapping2);
                iDefaultsElement.makeClean();
            }
        } else {
            eDs1Mapping eDs1Mapping3 = this.neDefaultsModel.getDefDs1Mapping(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(eDs1Mapping3.value());
        }
    }

    private void helpHandleE1SaBit(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = iDefaultsElement.getEnumValue();
                eSaBit eSaBit2 = eSaBit.from_int(n);
                this.neDefaultsModel.setDefE1SaBit(eEqType2, eEqType3, eSaBit2);
                iDefaultsElement.makeClean();
            }
        } else {
            eSaBit eSaBit3 = this.neDefaultsModel.getDefE1SaBit(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(eSaBit3.value());
        }
    }

    private void helpHandleLineLength(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = iDefaultsElement.getEnumValue();
                int n2 = 1;
                if (this.neDefaultsModel.getDefLineBuildout(eEqType2, eEqType3) < 0) {
                    n2 = -1;
                }
                this.neDefaultsModel.setDefLineBuildout(eEqType2, eEqType3, n * n2);
                iDefaultsElement.makeClean();
            }
        } else {
            int n = this.neDefaultsModel.getDefLineBuildout(eEqType2, eEqType3);
            int n3 = 450;
            if (n > -226 && n < 226) {
                n3 = 225;
            }
            iDefaultsElement.initEnumValue(n3);
        }
    }

    private void helpHandlePJStsMon(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string = iDefaultsElement.getValue();
                short s = Short.parseShort(string);
                if (this.nmd.getFramingType() == 1) {
                    s = (short)AbstractHoNum.Vc4Num2Sts((int)s);
                }
                this.neDefaultsModel.setDefPointerSts(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefPointerSts(eEqType2, eEqType3);
            if (this.nmd.getFramingType() == 1) {
                s = (short)AbstractHoNum.StsNum2Vc4((int)s);
            }
            String string = String.valueOf(s);
            iDefaultsElement.initValue(string);
        }
    }

    private void helpHandleRxEqualization(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = 1;
                int n2 = this.neDefaultsModel.getDefLineBuildout(eEqType2, eEqType3);
                String string = iDefaultsElement.getValue();
                if (string.equals("TRUE") && n2 < 0 || string.equals("FALSE") && n2 > 0) {
                    n = -1;
                }
                this.neDefaultsModel.setDefLineBuildout(eEqType2, eEqType3, n2 * n);
                iDefaultsElement.makeClean();
            }
        } else {
            int n = this.neDefaultsModel.getDefLineBuildout(eEqType2, eEqType3);
            String string = this.boolToString(n >= 0);
            iDefaultsElement.initValue(string);
        }
    }

    private void helpHandleIppmEnabled(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string = iDefaultsElement.getValue();
                boolean bl2 = this.stringToBool(string);
                this.neDefaultsModel.setDefIPPMEnabled(eEqType2, eEqType3, bl2);
                iDefaultsElement.makeClean();
            }
        } else {
            boolean bl3 = this.neDefaultsModel.getDefIPPMEnabled(eEqType2, eEqType3);
            String string = this.boolToString(bl3);
            iDefaultsElement.initValue(string);
        }
    }

    private void helpHandleDsnPm(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, String string, boolean bl, eThresholdType eThresholdType2, eIntervalType eIntervalType2, boolean bl2) throws Exception {
        if (string.equals("line") || string.equals("path") || string.equals("pbitpath") || string.equals("cpbitpath") || string.equals("ds1path") || string.equals("ds1network")) {
            if (bl2) {
                this.setDsnPmToNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, string, bl, eThresholdType2);
            } else {
                this.getDsnPmFromNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, string, bl, eThresholdType2);
            }
        } else if (string.equals("vt") || string.equals("vclo")) {
            if (bl2) {
                this.setVtPathPmToNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, bl, eIntervalType2);
            } else {
                this.getVtPathPmFromNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, bl, eIntervalType2);
            }
        } else if (string.equals("sts") || string.equals("vc4")) {
            if (bl2) {
                this.setStsPathPmToNodeVals(eEqType2, eEqType3, (short)1, iDefaultsNodeArray, bl, eIntervalType2);
            } else {
                this.getStsPathPmFromNodeVals(eEqType2, eEqType3, (short)1, iDefaultsNodeArray, bl, eIntervalType2);
            }
        } else {
            this.db.severe("helpHandleDSnPm: couldnt set/get node vals for " + string);
        }
    }

    private void handleDSnPm(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleDSnPm: dsnPmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                boolean bl2 = true;
                if (iDefaultsNodeArray2[j].getName().equals("farend")) {
                    bl2 = false;
                }
                IDefaultsNode[] iDefaultsNodeArray3 = iDefaultsNodeArray2[j].getChildren();
                for (int k = 0; k < iDefaultsNodeArray3.length; ++k) {
                    eThresholdType eThresholdType2 = eThresholdType.THRESHOLD_15_MIN;
                    eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                    if (iDefaultsNodeArray3[k].getName().equals("1day")) {
                        eThresholdType2 = eThresholdType.THRESHOLD_1_DAY;
                        eIntervalType2 = eIntervalType.INTERVAL_DAY;
                    }
                    IDefaultsNode[] iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                    this.helpHandleDsnPm(eEqType2, eEqType3, iDefaultsNodeArray4, string, bl2, eThresholdType2, eIntervalType2, bl);
                }
            }
        }
    }

    private void handleDSnConfig(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        Object object;
        Object object2;
        int n;
        this.db.fine("handleDSnConfig: dsnNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        for (n = 0; n < iDefaultsNodeArray.length; ++n) {
            object2 = iDefaultsNodeArray[n].getName();
            object = (IDefaultsElement)iDefaultsNodeArray[n];
            if (((String)object2).equals("State") || ((String)object2).equals("AdminState")) {
                arrayList2.add(object);
                continue;
            }
            if (((String)object2).equals("AINSSoakTime")) {
                this.helpHandleSoakTime(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("FeInhibitLpbk")) {
                this.helpHandleInhibitLoopback(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("SFBER")) {
                this.helpHandleDsnSfBerLevel(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("SDBER")) {
                this.helpHandleDsnSdBerLevel(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("SyncMsgIn")) {
                arrayList3.add(object);
                continue;
            }
            if (((String)object2).equals("SendDoNotUse")) {
                arrayList3.add(object);
                continue;
            }
            if (((String)object2).equals("RetimingEnabled")) {
                this.helpHandleDs1RetimingEnabled(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("SendAISVOnDefects")) {
                this.helpHandleDs1AisvEnabled(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("TreatLOFAsDefect")) {
                this.helpHandleDs1AisOnLofEnabled(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("SendAISOnFacilityLoopback")) {
                this.helpHandleAisOnFacilityLoopback(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("SendAISOnTerminalLoopback")) {
                this.helpHandleAisOnTerminalLoopback(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("AdminSSMIn")) {
                arrayList3.add(object);
                continue;
            }
            if (((String)object2).equals("ProvidesSyncFromCard")) {
                arrayList3.add(object);
                continue;
            }
            if (((String)object2).equals("Ds1Mapping")) {
                arrayList2.add(object);
                continue;
            }
            if (((String)object2).equals("SaBit")) {
                this.helpHandleE1SaBit(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("OperatingMode")) {
                this.helpHandleOperatingMode(eEqType2, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("PortToVtMappingMode")) {
                arrayList2.add(object);
                continue;
            }
            arrayList.add(object);
        }
        this.db.fine("DsnConfig timing " + arrayList3.size());
        this.db.fine("DsnConfig remaining " + arrayList.size());
        if (bl) {
            this.setDsnConfigToNodeVals(eEqType2, eEqType3, arrayList.toArray(new IDefaultsNode[0]));
        } else {
            this.getDsnConfigFromNodeVals(eEqType2, eEqType3, arrayList.toArray(new IDefaultsNode[0]));
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            object2 = (IDefaultsElement)arrayList2.get(n);
            object = object2.getName();
            if (((String)object).equals("State") || ((String)object).equals("AdminState")) {
                this.helpHandleAdminState(eEqType2, eEqType3, (IDefaultsElement)object2, bl);
                continue;
            }
            if (((String)object).equals("Ds1Mapping")) {
                this.helpHandleDs1Mapping(eEqType2, eEqType3, (IDefaultsElement)object2, bl);
                continue;
            }
            if (((String)object).equals("PortToVtMappingMode")) {
                this.helpHandlePortToVtMappingMode(eEqType2, (IDefaultsElement)object2, bl);
                continue;
            }
            this.db.severe("handleDSnConfig: Shouldnt be here...." + (String)object);
        }
        this.handleLineSyncConfig(eEqType2, eEqType3, arrayList3.toArray(new IDefaultsNode[0]), bl);
    }

    private void handleDSn(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.info("handleDSn: dsnNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("pmthresholds")) {
                this.handleDSnPm(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("config")) {
                this.handleDSnConfig(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("ds1config")) {
                this.handleDSnConfig(eEqType2, eEqType.DS1_VT_MAPPED, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.db.severe("handleDSn: Shouldnt be here...." + string);
        }
    }

    private void helpHandleOCnAlarmPhysicalThresholds(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, eIntervalType eIntervalType2, boolean bl) throws Exception {
        this.db.fine("helpHandleOCnAlarmPhysicalThresholds: ocnElems size = " + iDefaultsNodeArray.length + ", applying " + bl);
        sPhysicalThresholds sPhysicalThresholds2 = new sPhysicalThresholds(0, 0, 0, 0, 0, 0);
        if (bl) {
            boolean bl2 = false;
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                String string = iDefaultsNodeArray[i].getName();
                String string2 = ((IDefaultsElement)iDefaultsNodeArray[i]).getValue();
                int n = Integer.parseInt(string2);
                if (iDefaultsNodeArray[i].isDirty()) {
                    bl2 = true;
                }
                if (string.equals("OPT-HIGH")) {
                    sPhysicalThresholds2.optHigh = n;
                    continue;
                }
                if (string.equals("OPR-HIGH")) {
                    sPhysicalThresholds2.oprHigh = n;
                    continue;
                }
                if (string.equals("LBC-HIGH")) {
                    sPhysicalThresholds2.lbcHigh = n;
                    continue;
                }
                if (string.equals("OPT-LOW")) {
                    sPhysicalThresholds2.optLow = n;
                    continue;
                }
                if (string.equals("OPR-LOW")) {
                    sPhysicalThresholds2.oprLow = n;
                    continue;
                }
                if (string.equals("LBC-LOW")) {
                    sPhysicalThresholds2.lbcLow = n;
                    continue;
                }
                this.db.severe("helpHandleOCnAlarmPhysicalThresholds: Unknown name " + string);
            }
            if (bl2) {
                if (eIntervalType2 == null) {
                    this.neDefaultsModel.setDefPhysicalAlmThresholds(eEqType2, eEqType3, sPhysicalThresholds2);
                } else {
                    this.neDefaultsModel.setDefPhysicalPmThresholds(eEqType2, eEqType3, eIntervalType2, sPhysicalThresholds2);
                }
                this.makeClean(iDefaultsNodeArray);
            }
        } else {
            sPhysicalThresholds2 = eIntervalType2 == null ? this.neDefaultsModel.getDefPhysicalAlmThresholds(eEqType2, eEqType3) : this.neDefaultsModel.getDefPhysicalPmThresholds(eEqType2, eEqType3, eIntervalType2);
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                String string = iDefaultsNodeArray[i].getName();
                int n = 0;
                if (string.equals("OPT-HIGH")) {
                    n = sPhysicalThresholds2.optHigh;
                } else if (string.equals("OPR-HIGH")) {
                    n = sPhysicalThresholds2.oprHigh;
                } else if (string.equals("LBC-HIGH")) {
                    n = sPhysicalThresholds2.lbcHigh;
                } else if (string.equals("OPT-LOW")) {
                    n = sPhysicalThresholds2.optLow;
                } else if (string.equals("OPR-LOW")) {
                    n = sPhysicalThresholds2.oprLow;
                } else if (string.equals("LBC-LOW")) {
                    n = sPhysicalThresholds2.lbcLow;
                } else {
                    this.db.severe("helpHandleOCnAlarmPhysicalThresholds: Unknown name " + string);
                }
                ((IDefaultsElement)iDefaultsNodeArray[i]).initValue(String.valueOf(n));
            }
        }
    }

    private void helpHandleOCnPm(String string, eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2, boolean bl2) throws Exception {
        this.db.fine("helpHandleOCnPm: ocnPmElems size = " + iDefaultsNodeArray.length + ", applying " + bl2);
        if (string.equals("line") || string.equals("ms")) {
            if (bl2) {
                this.setLinePmToNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, bl, eIntervalType2);
            } else {
                this.getLinePmFromNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, bl, eIntervalType2);
            }
        } else if (string.equals("section") || string.equals("rs")) {
            if (bl2) {
                this.setSectionPmToNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, bl, eIntervalType2);
            } else {
                this.getSectionPmFromNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, bl, eIntervalType2);
            }
        } else if (string.equals("sts") || string.equals("sts1") || string.equals("path") || string.startsWith("sts3c") || string.startsWith("sts12c")) {
            int n = 1;
            n = string.equals("sts1") || string.equals("sts") || string.equals("path") ? 1 : (string.startsWith("sts3c") ? 3 : 12);
            if (bl2) {
                this.setStsPathPmToNodeVals(eEqType2, eEqType3, (short)n, iDefaultsNodeArray, bl, eIntervalType2);
            } else {
                this.getStsPathPmFromNodeVals(eEqType2, eEqType3, (short)n, iDefaultsNodeArray, bl, eIntervalType2);
            }
        } else if (string.equals("vt") || string.equals("vclo")) {
            if (bl2) {
                this.setVtPathPmToNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, bl, eIntervalType2);
            } else {
                this.getVtPathPmFromNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, bl, eIntervalType2);
            }
        } else {
            this.db.severe("helpHandleOCnPm: unexpected name " + string);
        }
    }

    private void getDistExtensionConfigFromNodeVals(sFCLineAdminInfo sFCLineAdminInfo2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = "";
            if (string.equals("Enabled")) {
                string2 = this.boolToString(sFCLineAdminInfo2.portDistanceExtension);
                iDefaultsElement.initValue(string2);
            } else if (string.equals("AutoDetect")) {
                string2 = this.boolToString(sFCLineAdminInfo2.creditAutoDetect);
                iDefaultsElement.initValue(string2);
            } else if (string.equals("NumCredits")) {
                string2 = Short.toString(sFCLineAdminInfo2.numCredits);
                iDefaultsElement.initValue(string2);
            } else if (string.equals("AutoadjustGFPBufferThreshold")) {
                string2 = this.boolToString(sFCLineAdminInfo2.gfpBufferAutoThreshold);
                iDefaultsElement.initValue(string2);
            } else if (string.equals("NumGFPBuffers")) {
                string2 = Short.toString(sFCLineAdminInfo2.gfpNumBuffers);
                iDefaultsElement.initValue(string2);
            } else {
                this.db.severe("Unknown config value " + string);
                string2 = "UNKNOWN";
                iDefaultsElement.initValue(string2);
            }
            this.db.fine("name=" + string + " val is now: " + string2);
        }
    }

    private void getEnhancedFcFiconConfigFromNodeVals(sFCLineAdminInfo sFCLineAdminInfo2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = "";
            if (string.equals("IngressIdleFiltering")) {
                string2 = this.boolToString(sFCLineAdminInfo2.ingressFiltering);
                iDefaultsElement.initValue(string2);
            } else if (string.equals("MaxFrameSize")) {
                string2 = Short.toString(sFCLineAdminInfo2.maxFrameSize);
                iDefaultsElement.initValue(string2);
            } else {
                this.db.severe("Unknown config value " + string);
                string2 = "UNKNOWN";
                iDefaultsElement.initValue(string2);
            }
            this.db.fine("name=" + string + " val is now: " + string2);
        }
    }

    private void getFcmrConfigFromNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        sFCLineAdminInfo sFCLineAdminInfo2 = null;
        sFCLineAdminInfo2 = this.neDefaultsModel.getDefFcmrConfig(eEqType2, eEqType3);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("distanceExtension")) {
                this.getDistExtensionConfigFromNodeVals(sFCLineAdminInfo2, iDefaultsNodeArray[i].getChildren());
                continue;
            }
            if (string.equals("enhancedFibreChannelFicon")) {
                this.getEnhancedFcFiconConfigFromNodeVals(sFCLineAdminInfo2, iDefaultsNodeArray[i].getChildren());
                continue;
            }
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = "";
            if (string.equals("State") || string.equals("AdminState")) {
                iDefaultsElement.initEnumValue(sFCLineAdminInfo2.portState.value());
                continue;
            }
            if (string.equals("AINSSoakTime")) {
                this.helpHandleSoakTime(eEqType2, eEqType3, iDefaultsElement, false);
                continue;
            }
            if (string.equals("MediaType")) {
                iDefaultsElement.initEnumValue(sFCLineAdminInfo2.portMediaType.value());
                continue;
            }
            if (string.equals("DistanceExtensionVsLinkRecovery")) {
                int n = 0;
                if (sFCLineAdminInfo2.portDistanceExtension) {
                    n = 1;
                } else if (sFCLineAdminInfo2.portLinkRecovery) {
                    n = 2;
                }
                iDefaultsElement.initEnumValue(n);
                continue;
            }
            this.db.severe("getFcmrConfigFromNodeVals(): unknown  " + string);
        }
    }

    private void handleFcmr(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleFcmr: fcmrNodes size = " + iDefaultsNodeArray.length);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (!string.equals("config")) continue;
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            IDefaultsNode iDefaultsNode = null;
            IDefaultsNode iDefaultsNode2 = null;
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                String string2 = iDefaultsNodeArray2[j].getName();
                if (string2.equals("card")) {
                    if (bl) {
                        iDefaultsNode = iDefaultsNodeArray2[j];
                        continue;
                    }
                    this.getCardMode(eEqType2, iDefaultsNodeArray2[j].getChildren());
                    continue;
                }
                if (string2.equals("port")) {
                    if (bl) {
                        iDefaultsNode2 = iDefaultsNodeArray2[j];
                        continue;
                    }
                    this.getFcmrConfigFromNodeVals(eEqType2, this.getPortTypeForCard(eEqType2), iDefaultsNodeArray2[j].getChildren());
                    continue;
                }
                this.db.severe("handleFcmr(): Unknown name " + string2);
            }
            if (!bl) continue;
            this.setFcmrConfigToNodeVals(eEqType2, this.getPortTypeForCard(eEqType2), iDefaultsNode.getChildren(), iDefaultsNode2.getChildren());
        }
    }

    private void helpHandleMlIos(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string;
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = iDefaultsElement.getName();
            if (string2.equals("consolePortAccess")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    this.neDefaultsModel.setDefIosConsolePortAccess(eEqType2, this.stringToBool(iDefaultsElement.getValue()));
                    iDefaultsElement.makeClean();
                    continue;
                }
                string = this.boolToString(this.neDefaultsModel.getDefIosConsolePortAccess(eEqType2));
                iDefaultsElement.initValue(string);
                continue;
            }
            if (string2.equals("radiusServerAccess")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    this.neDefaultsModel.setDefIosRadiusRelayAccess(eEqType2, this.stringToBool(iDefaultsElement.getValue()));
                    iDefaultsElement.makeClean();
                    continue;
                }
                string = this.boolToString(this.neDefaultsModel.getDefIosRadiusRelayAccess(eEqType2));
                iDefaultsElement.initValue(string);
                continue;
            }
            this.db.severe("helpHandleMlIos(): unknown name " + string2);
        }
    }

    private void handleRanSvc(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleRanSvc: ranSvcNodes size = " + iDefaultsNodeArray.length);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("ios")) {
                this.helpHandleMlIos(eEqType2, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.db.severe("handleRanSvc: unknown elem" + string);
        }
    }

    private void handleMl(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleMl: mlNodes size = " + iDefaultsNodeArray.length);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("config")) {
                IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                    String string2 = iDefaultsNodeArray2[j].getName();
                    if (string2.equals("card")) {
                        this.handleCardMode(eEqType2, iDefaultsNodeArray2[j], bl);
                        continue;
                    }
                    this.db.severe("handleMl: unknown config" + string2);
                }
                continue;
            }
            if (string.equals("ios")) {
                this.helpHandleMlIos(eEqType2, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.db.severe("handleMl: unknown elem" + string);
        }
    }

    private void handleML2Mapper(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleML2Mapper: nodes size = " + iDefaultsNodeArray.length);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsNode[] iDefaultsNodeArray2;
            int n;
            Object object;
            String string = iDefaultsNodeArray[i].getName();
            eEqType eEqType3 = eEqType.L1P_ETHER_PORT;
            if (string.equals("config")) {
                eEqType3 = eEqType.L1P_ETHER_PORT;
                object = iDefaultsNodeArray[i].getChildren();
                for (n = 0; n < ((IDefaultsNode[])object).length; ++n) {
                    iDefaultsNodeArray2 = (IDefaultsNode[])object[n];
                    String string2 = iDefaultsNodeArray2.getName();
                    if (string2.equals("State") || string2.equals("AdminState")) {
                        this.helpHandleAdminState(eEqType2, eEqType3, (IDefaultsElement)iDefaultsNodeArray2, bl);
                        continue;
                    }
                    if (string2.equals("AINSSoakTime")) {
                        this.helpHandleSoakTime(eEqType2, eEqType3, (IDefaultsElement)iDefaultsNodeArray2, bl);
                        continue;
                    }
                    this.db.severe("unknown ml2 mapper elem " + string2);
                }
                continue;
            }
            if (string.equals("posPortConfig")) {
                eEqType3 = eEqType.L1P_POS_PORT;
                continue;
            }
            if (string.equals("etherPortConfig")) {
                eEqType3 = eEqType.L1P_ETHER_PORT;
                object = this.neDefaultsModel.getDefML2MapperEtherLineAdminInfo(eEqType2, eEqType3);
                n = 0;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                    IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[j];
                    String string3 = iDefaultsElement.getName();
                    if (string3.equals("802-1Q-VlanCoS")) {
                        if (bl) {
                            n |= iDefaultsElement.isDirty();
                            object.vlanCosThreshold = Short.parseShort(iDefaultsElement.getValue());
                            continue;
                        }
                        iDefaultsElement.initValue(Short.toString(object.vlanCosThreshold));
                        continue;
                    }
                    if (string3.equals("IP-ToS")) {
                        if (bl) {
                            n |= iDefaultsElement.isDirty();
                            object.ipTosThreshold = Short.parseShort(iDefaultsElement.getValue());
                            continue;
                        }
                        iDefaultsElement.initValue(Short.toString(object.ipTosThreshold));
                        continue;
                    }
                    if (string3.equals("EnableFlowControl")) {
                        if (bl) {
                            n |= iDefaultsElement.isDirty();
                            object.flowControlEnabled = this.stringToBool(iDefaultsElement.getValue());
                            continue;
                        }
                        iDefaultsElement.initValue(this.boolToString(object.flowControlEnabled));
                        continue;
                    }
                    if (string3.equals("LinkDuplex")) {
                        if (bl) {
                            n |= iDefaultsElement.isDirty();
                            object.linkDuplex = eEtherDuplex.from_int(iDefaultsElement.getEnumValue());
                            continue;
                        }
                        iDefaultsElement.initEnumValue(object.linkDuplex.value());
                        continue;
                    }
                    if (string3.equals("LinkSpeed")) {
                        if (bl) {
                            n |= iDefaultsElement.isDirty();
                            object.linkSpeed = eEtherSpeed.from_int(iDefaultsElement.getEnumValue());
                            continue;
                        }
                        iDefaultsElement.initEnumValue(object.linkSpeed.value());
                        continue;
                    }
                    this.db.severe("unknown ml2 config mapper name " + string3);
                }
                if (!bl || n == 0) continue;
                this.neDefaultsModel.setDefML2MapperEtherLineAdminInfo(eEqType2, eEqType3, (sML2MapperEtherLineAdminInfo)object);
                n = 0;
                this.makeClean(iDefaultsNodeArray2);
                continue;
            }
            this.db.severe("unknown ml2 mapper port type " + string);
        }
    }

    private void handleCE1000(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleCE1000: nodes size = " + iDefaultsNodeArray.length);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string;
            Object object;
            int n;
            Object object2;
            String string2 = iDefaultsNodeArray[i].getName();
            eEqType eEqType3 = eEqType.CE_1000_ETHER_PORT;
            if (string2.equals("config")) {
                object2 = iDefaultsNodeArray[i].getChildren();
                for (n = 0; n < ((IDefaultsNode[])object2).length; ++n) {
                    IDefaultsElement iDefaultsElement = (IDefaultsElement)object2[n];
                    String string3 = iDefaultsElement.getName();
                    if (string3.equals("State")) {
                        this.helpHandleAdminState(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string3.equals("AINSSoakTime")) {
                        this.helpHandleSoakTime(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    this.db.severe("unknown ml2 mapper elem " + string3);
                }
                continue;
            }
            if (string2.equals("posPortConfig")) {
                eEqType3 = eEqType.CE_1000_POS_PORT;
                object2 = this.neDefaultsModel.getDefCE1000PosPortAdminInfo(eEqType2, eEqType3);
                IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                    IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[j];
                    object = iDefaultsElement.getName();
                    string = iDefaultsElement.getValue();
                    if (!((String)object).equals("FramingType")) continue;
                    if (bl) {
                        if (string.equals("HDLC")) {
                            object2.framingType = ePosFramingType.HDLC;
                        } else if (string.equals("GFP-F")) {
                            object2.framingType = ePosFramingType.GFP_F;
                        } else {
                            this.db.severe("Unknown CE1000 POS framing type " + string);
                            object2.framingType = ePosFramingType.HDLC;
                        }
                        this.neDefaultsModel.setDefCE1000PosPortAdminInfo(eEqType2, eEqType3, (sML2PosPortAdminInfo)object2);
                        this.makeClean(iDefaultsNodeArray2);
                        continue;
                    }
                    if (object2.framingType == ePosFramingType.HDLC) {
                        iDefaultsElement.initValue("HDLC");
                        continue;
                    }
                    if (object2.framingType == ePosFramingType.GFP_F) {
                        iDefaultsElement.initValue("GFP-F");
                        continue;
                    }
                    this.db.severe("Unknown CE1000 POS framing type " + string);
                    iDefaultsElement.initValue("HDLC");
                }
                continue;
            }
            if (string2.equals("etherPortConfig")) {
                eEqType3 = eEqType.CE_1000_ETHER_PORT;
                object2 = this.neDefaultsModel.getDefCE1000EtherLineAdminInfo(eEqType2, eEqType3);
                n = 0;
                IDefaultsNode[] iDefaultsNodeArray3 = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < iDefaultsNodeArray3.length; ++j) {
                    object = (IDefaultsElement)iDefaultsNodeArray3[j];
                    string = object.getName();
                    String string4 = object.getValue();
                    if (string.equals("FlowControl")) {
                        if (bl) {
                            object2.flowControl = string4.equals("Pass Through") ? eFlowControlNegotiated.PASS_THROUGH_FLOW_CONTROL : (string4.equals("Symmetric") ? eFlowControlNegotiated.SYMMETRIC_FLOW_CONTROL : eFlowControlNegotiated.NO_FLOW_CONTROL);
                            n = 1;
                            continue;
                        }
                        if (object2.flowControl == eFlowControlNegotiated.PASS_THROUGH_FLOW_CONTROL) {
                            object.initValue("Pass Through");
                            continue;
                        }
                        if (object2.flowControl == eFlowControlNegotiated.SYMMETRIC_FLOW_CONTROL) {
                            object.initValue("Symmetric");
                            continue;
                        }
                        object.initValue("None");
                        continue;
                    }
                    if (string.equals("AutoNegotiation")) {
                        if (bl) {
                            object2.negotiation = this.stringToBool(string4);
                            n = 1;
                            continue;
                        }
                        object.initValue(this.boolToString(object2.negotiation));
                        continue;
                    }
                    if (!string.equals("MTU")) continue;
                    if (bl) {
                        object2.maxFrameSize = Integer.parseInt(string4);
                        n = 1;
                        continue;
                    }
                    String string5 = String.valueOf(object2.maxFrameSize);
                    object.initValue(string5);
                }
                if (!bl || n == 0) continue;
                this.neDefaultsModel.setDefCE1000EtherLineAdminInfo(eEqType2, eEqType3, (sCE1000EtherLineAdminInfo)object2);
                n = 0;
                this.makeClean(iDefaultsNodeArray3);
                continue;
            }
            this.db.severe("unknown CE1000 port type " + string2);
        }
    }

    private void handleEtherConfig(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            this.db.fine("handleEtherConfig(): " + string);
            if (string.equals("State") || string.equals("AdminState")) {
                this.helpHandleAdminState(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            if (string.equals("AINSSoakTime")) {
                this.helpHandleSoakTime(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            this.db.severe("unknown MRC ETHER name " + string);
        }
    }

    private void handleG1000(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsNode iDefaultsNode = iDefaultsNodeArray[i];
            String string = iDefaultsNode.getName();
            this.db.fine("handleG1000(): " + string);
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNode.getChildren();
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[j];
                String string2 = iDefaultsElement.getName();
                this.db.fine("handleG1000(): " + string + "." + string2);
                if (string2.equals("State") || string2.equals("AdminState")) {
                    this.helpHandleAdminState(eEqType2, eEqType3, iDefaultsElement, bl);
                    continue;
                }
                if (string2.equals("AINSSoakTime")) {
                    this.helpHandleSoakTime(eEqType2, eEqType3, iDefaultsElement, bl);
                    continue;
                }
                this.db.severe("unknown g1000 name " + string2);
            }
        }
    }

    private void handleCtx(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            this.db.fine("handleCtx() " + string + " " + (this.getEqTypeFromName(string) == null ? -1 : this.getEqTypeFromName(string).value()));
            if (string.startsWith("DS") || string.startsWith("E1") || string.startsWith("E3")) {
                this.handleDSn(eEqType2, this.getEqTypeFromName(string), iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.startsWith("OC") || string.startsWith("EC") || string.startsWith("ST")) {
                this.handleOCn(eEqType2, this.getEqTypeFromName(string), iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("Wideband") || string.equals("Broadband") || string.equals("PPM")) {
                this.handleMutablePorts(eEqType2, iDefaultsNodeArray[i], bl);
                continue;
            }
            if (string.equals("config")) {
                this.handleDSnConfig(eEqType2, eEqType.DS1_VT_MAPPED, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.db.severe("handleCtx(): Unknown name " + string);
        }
    }

    private void handleOCnPhysicalThresholds(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleOCnPhysicalThresholds: ocnNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("warning")) {
                this.handleOCnWarningPhysicalThresholds(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("alarm")) {
                IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                this.helpHandleOCnAlarmPhysicalThresholds(eEqType2, eEqType3, iDefaultsNodeArray2, null, bl);
                continue;
            }
            this.db.severe("Unexpected data: " + string);
        }
    }

    private void handleOCnWarningPhysicalThresholds(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleOCnWaringPhysicalThresholds: ocnNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            eIntervalType eIntervalType2 = null;
            if (string.equals("15min")) {
                eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
            } else if (string.equals("1day")) {
                eIntervalType2 = eIntervalType.INTERVAL_DAY;
            } else if (!string.equals("alarm")) {
                this.db.severe("Unexpected data: " + string);
            }
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            this.helpHandleOCnAlarmPhysicalThresholds(eEqType2, eEqType3, iDefaultsNodeArray2, eIntervalType2, bl);
        }
    }

    private void handleOCnPm(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleOCnPm: ocnPmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                boolean bl2 = true;
                if (iDefaultsNodeArray2[j].getName().equals("farend")) {
                    bl2 = false;
                }
                IDefaultsNode[] iDefaultsNodeArray3 = iDefaultsNodeArray2[j].getChildren();
                for (int k = 0; k < iDefaultsNodeArray3.length; ++k) {
                    eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                    if (iDefaultsNodeArray3[k].getName().equals("1day")) {
                        eIntervalType2 = eIntervalType.INTERVAL_DAY;
                    }
                    IDefaultsNode[] iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                    this.helpHandleOCnPm(string, eEqType2, eEqType3, iDefaultsNodeArray4, bl2, eIntervalType2, bl);
                }
            }
        }
    }

    private void handleOCnConfig(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleOCnConfig: ocnNodes size = " + iDefaultsNodeArray.length + " " + (eEqType2 == null ? -1 : eEqType2.value()) + " " + (eEqType3 == null ? -1 : eEqType3.value()) + ", applying " + bl);
        ArrayList<IDefaultsElement> arrayList = new ArrayList<IDefaultsElement>();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement;
            String string;
            int n;
            IDefaultsNode[] iDefaultsNodeArray2;
            String string2 = iDefaultsNodeArray[i].getName();
            if (string2.equals("line")) {
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    string = iDefaultsNodeArray2[n].getName();
                    iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[n];
                    if (string.equals("SFBER")) {
                        this.helpHandleSfBerLevel(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string.equals("SDBER")) {
                        this.helpHandleSdBerLevel(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string.equals("State") || string.equals("AdminState")) {
                        this.helpHandleAdminState(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string.equals("AINSSoakTime")) {
                        this.helpHandleSoakTime(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string.equals("SyncMsgIn")) {
                        arrayList.add(iDefaultsElement);
                        continue;
                    }
                    if (string.equals("AdminSSMIn")) {
                        arrayList.add(iDefaultsElement);
                        continue;
                    }
                    if (string.equals("Send<FF>DoNotUse")) {
                        arrayList.add(iDefaultsElement);
                        continue;
                    }
                    if (string.equals("SendDoNotUse")) {
                        arrayList.add(iDefaultsElement);
                        continue;
                    }
                    if (string.equals("LineLength")) {
                        this.helpHandleLineLength(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string.equals("PJStsMon#") || string.equals("PJVC4Mon#")) {
                        this.helpHandlePJStsMon(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string.equals("RxEqualization")) {
                        this.helpHandleRxEqualization(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string.equals("AlsMode")) {
                        this.helpHandleAlsMode(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string.equals("AlsRecoveryPulseInterval")) {
                        this.helpHandleAlsRecoveryPulseInterval(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string.equals("AlsRecoveryPulseDuration")) {
                        this.helpHandleAlsRecoveryPulseDuration(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string.equals("SendAISOnFacilityLoopback")) {
                        this.helpHandleAisOnFacilityLoopback(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string.equals("SendAISOnTerminalLoopback")) {
                        this.helpHandleAisOnTerminalLoopback(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    this.db.severe("handleOCnConfig(): Unknown line config value " + string2);
                }
                continue;
            }
            if (string2.equals("sts") || string2.equals("vc4")) {
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    string = iDefaultsNodeArray2[n].getName();
                    iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[n];
                    if (string.equals("IPPMEnabled")) {
                        this.helpHandleIppmEnabled(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    this.db.severe("Unknown sts/vc4 config value " + string2);
                }
                continue;
            }
            if (string2.equals("card")) {
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                eEqType3 = eEqType.OSCM_PORT;
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    string = iDefaultsNodeArray2[n].getName();
                    iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[n];
                    if (string.equals("AlsMode")) {
                        this.helpHandleAlsMode(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    this.db.severe("handleOCnConfig(): Unknown line config value >>" + string + "<< on " + iDefaultsElement.getFullName());
                }
                continue;
            }
            this.db.severe("Unknown config value " + string2);
        }
        this.handleLineSyncConfig(eEqType2, eEqType3, arrayList.toArray(new IDefaultsNode[0]), bl);
    }

    private void handleOCn(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleOCn: ocnNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("physicalthresholds")) {
                this.handleOCnPhysicalThresholds(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("pmthresholds")) {
                this.handleOCnPm(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("config")) {
                this.handleOCnConfig(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.db.severe("handleOCn: Shouldnt be here...." + string);
        }
    }

    private void helpHandleDwdmPmByDataRate(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.info("helpHandleDwdmPm: dwdmNodes size = " + iDefaultsNodeArray.length + ". appplying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            eDataRate eDataRate2 = null;
            eEqType eEqType3 = eEqType.DWDM_CLIENT_PORT;
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("oc3") || string.equals("stm1")) {
                eDataRate2 = eDataRate.OC3;
            } else if (string.equals("oc12") || string.equals("stm4")) {
                eDataRate2 = eDataRate.OC12;
            } else if (string.equals("oc48") || string.equals("stm16")) {
                eDataRate2 = eDataRate.OC48;
            } else if (string.equals("oc192") || string.equals("stm64")) {
                eDataRate2 = eDataRate.OC192;
            } else if (string.equals("1gethernet")) {
                eDataRate2 = eDataRate.ONE_GE;
            } else if (string.equals("1gfiberchannel")) {
                eDataRate2 = eDataRate.ONE_GFC;
            } else if (string.equals("1gficon")) {
                eDataRate2 = eDataRate.ONE_GFICON;
            } else if (string.equals("2gfiberchannel")) {
                eDataRate2 = eDataRate.TWO_GFC;
            } else if (string.equals("2gficon")) {
                eDataRate2 = eDataRate.TWO_GFICON;
            } else {
                this.db.severe("Unexpected data rate " + string);
            }
            this.db.fine("helpHandleDwdmPm: " + string);
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                String string2 = iDefaultsNodeArray2[j].getName();
                this.db.fine("helpHandleDwdmPm: child1 " + string2 + " size = " + iDefaultsNodeArray2.length);
                IDefaultsNode[] iDefaultsNodeArray3 = iDefaultsNodeArray2[j].getChildren();
                for (int k = 0; k < iDefaultsNodeArray3.length; ++k) {
                    IDefaultsNode[] iDefaultsNodeArray4;
                    boolean bl2 = true;
                    eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                    if (iDefaultsNodeArray3[k].getName().equals("farend")) {
                        bl2 = false;
                    } else if (iDefaultsNodeArray3[k].getName().equals("15min")) {
                        eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                    } else if (iDefaultsNodeArray3[k].getName().equals("1day")) {
                        eIntervalType2 = eIntervalType.INTERVAL_DAY;
                    }
                    this.db.fine("helpHandleDwdmPm: child2 " + iDefaultsNodeArray3[k].getName() + " size = " + iDefaultsNodeArray3.length);
                    if (string2.equals("8b10b")) {
                        iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                        if (bl) {
                            this.set8B10BPmToNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray4, eIntervalType2);
                            continue;
                        }
                        this.get8B10BPmFromNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray4, eIntervalType2);
                        continue;
                    }
                    iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                    for (int i2 = 0; i2 < iDefaultsNodeArray4.length; ++i2) {
                        eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                        if (iDefaultsNodeArray4[i2].getName().equals("1day")) {
                            eIntervalType2 = eIntervalType.INTERVAL_DAY;
                        }
                        this.db.fine("helpHandleDwdmPm: child3 " + iDefaultsNodeArray4[i2].getName() + " size = " + iDefaultsNodeArray4.length);
                        IDefaultsNode[] iDefaultsNodeArray5 = iDefaultsNodeArray4[i2].getChildren();
                        if (string2.equals("line") || string2.equals("ms")) {
                            this.db.fine("helpHandleDwdmPm: provisioning line");
                            if (bl) {
                                this.setLinePmToNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray5, bl2, eIntervalType2);
                                continue;
                            }
                            this.getLinePmFromNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray5, bl2, eIntervalType2);
                            continue;
                        }
                        if (string2.equals("section") || string2.equals("rs")) {
                            this.db.fine("helpHandleDwdmPm: provisioning section");
                            if (bl) {
                                this.setSectionPmToNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray5, bl2, eIntervalType2);
                                continue;
                            }
                            this.getSectionPmFromNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray5, bl2, eIntervalType2);
                            continue;
                        }
                        this.db.severe("helpHandleDwdmPm: couldn't set from node vals for " + eDataRate2 + " " + string2 + ": eq " + eEqType2.value() + " port type " + eEqType3.value() + " buckets " + iDefaultsNodeArray5.length + " end " + bl2 + " int " + eIntervalType2.value());
                    }
                }
            }
        }
    }

    private void helpHandleDwdmPmByLineType(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.info("helpHandleDwdmPm: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            eDwdmLineType eDwdmLineType2 = eDwdmLineType.DWDM_CLIENT;
            eEqType eEqType3 = eEqType.DWDM_CLIENT_PORT;
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("trunk") || string.equals("sonet") || string.equals("sdh")) {
                eDwdmLineType2 = eDwdmLineType.DWDM_TRUNK;
                eEqType3 = eEqType.DWDM_TRUNK_PORT;
            }
            this.db.fine("helpHandleDwdmPm: " + string + " port type= " + eEqType3.value());
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                String string2 = iDefaultsNodeArray2[j].getName();
                this.db.fine("helpHandleDwdmPm: child1 " + string2 + " size = " + iDefaultsNodeArray2.length);
                IDefaultsNode[] iDefaultsNodeArray3 = iDefaultsNodeArray2[j].getChildren();
                for (int k = 0; k < iDefaultsNodeArray3.length; ++k) {
                    boolean bl2 = true;
                    if (iDefaultsNodeArray3[k].getName().equals("farend")) {
                        bl2 = false;
                    }
                    this.db.fine("helpHandleDwdmPm: child2 " + iDefaultsNodeArray3[k].getName() + " size = " + iDefaultsNodeArray3.length);
                    IDefaultsNode[] iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                    for (int i2 = 0; i2 < iDefaultsNodeArray4.length; ++i2) {
                        eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                        if (iDefaultsNodeArray4[i2].getName().equals("1day")) {
                            eIntervalType2 = eIntervalType.INTERVAL_DAY;
                        }
                        this.db.fine("helpHandleDwdmPm: child3 " + iDefaultsNodeArray4[i2].getName() + " size = " + iDefaultsNodeArray4.length);
                        IDefaultsNode[] iDefaultsNodeArray5 = iDefaultsNodeArray4[i2].getChildren();
                        if (string2.equals("line") || string2.equals("ms")) {
                            this.db.fine("helpHandleDwdmPm: provisioning line");
                            if (bl) {
                                this.setLinePmToNodeVals(eEqType2, eEqType3, eDwdmLineType2, iDefaultsNodeArray5, bl2, eIntervalType2);
                                continue;
                            }
                            this.getLinePmFromNodeVals(eEqType2, eEqType3, eDwdmLineType2, iDefaultsNodeArray5, bl2, eIntervalType2);
                            continue;
                        }
                        if (string2.equals("section") || string2.equals("rs")) {
                            this.db.fine("helpHandleDwdmPm: provisioning section");
                            if (bl) {
                                this.setSectionPmToNodeVals(eEqType2, eEqType3, eDwdmLineType2, iDefaultsNodeArray5, bl2, eIntervalType2);
                                continue;
                            }
                            this.getSectionPmFromNodeVals(eEqType2, eEqType3, eDwdmLineType2, iDefaultsNodeArray5, bl2, eIntervalType2);
                            continue;
                        }
                        this.db.severe("helpHandleDwdmPm: couldn't set from node vals for " + string + " " + string2 + ": eq " + eEqType2.value() + " port type " + eEqType3.value() + " buckets " + iDefaultsNodeArray5.length + " end " + bl2 + " int " + eIntervalType2.value());
                    }
                }
            }
        }
    }

    private void handleDwdmPm(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        if (eEqType2 == eEqType.TXP_MR_2_5G_LINE_CARD || eEqType2 == eEqType.TXPP_MR_2_5G_LINE_CARD) {
            this.helpHandleDwdmPmByDataRate(eEqType2, iDefaultsNodeArray, bl);
        } else if (eEqType2 == eEqType.TXP_MR_10G_LINE_CARD || eEqType2 == eEqType.MXP_2_5G_10G_LINE_CARD || eEqType2 == eEqType.TXP_MR_10E_LINE_CARD || eEqType2 == eEqType.MXP_2_5G_10E_LINE_CARD || eEqType2 == eEqType.MXP_MR_10DME_LINE_CARD || eEqType2 == eEqType.MXP_MR_2_5G_LINE_CARD || eEqType2 == eEqType.MXPP_MR_2_5G_LINE_CARD) {
            this.helpHandleDwdmPmByLineType(eEqType2, iDefaultsNodeArray, bl);
        } else {
            this.db.severe("Unexpected nXp card type " + this.getNameFromEqType(eEqType2));
        }
    }

    private void handleDwdmOtnThresholds(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.info("handleDwdmOtnThresholds: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        eEqType eEqType3 = eEqType.DWDM_TRUNK_PORT;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            eMonitorType eMonitorType2 = eMonitorType.MON_SECTION;
            if (iDefaultsNodeArray[i].getName().equals("pm")) {
                eMonitorType2 = eMonitorType.MON_PATH;
            }
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                boolean bl2 = true;
                if (iDefaultsNodeArray2[j].getName().equals("farend")) {
                    bl2 = false;
                }
                IDefaultsNode[] iDefaultsNodeArray3 = iDefaultsNodeArray2[j].getChildren();
                for (int k = 0; k < iDefaultsNodeArray3.length; ++k) {
                    eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                    if (iDefaultsNodeArray3[k].getName().equals("1day")) {
                        eIntervalType2 = eIntervalType.INTERVAL_DAY;
                    }
                    IDefaultsNode[] iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                    if (bl) {
                        this.setOtnPmToNodeVals(eEqType2, eEqType3, iDefaultsNodeArray4, bl2, eIntervalType2, eMonitorType2);
                        continue;
                    }
                    this.getOtnPmFromNodeVals(eEqType2, eEqType3, iDefaultsNodeArray4, bl2, eIntervalType2, eMonitorType2);
                }
            }
        }
    }

    private void helpHandleDwdmFecThresholds(eEqType eEqType2, eEqType eEqType3, eDwdmFecMode eDwdmFecMode2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            this.db.fine("Getting FEC interval of " + string);
            eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
            if (string.equals("1day")) {
                eIntervalType2 = eIntervalType.INTERVAL_DAY;
            }
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            if (bl) {
                this.setFecPmToNodeVals(eEqType2, eEqType3, eIntervalType2, eDwdmFecMode2, iDefaultsNodeArray2);
                continue;
            }
            this.getFecPmFromNodeVals(eEqType2, eEqType3, eIntervalType2, eDwdmFecMode2, iDefaultsNodeArray2);
        }
    }

    private void handleDwdmFecThresholds(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.info("handleDwdmFecThresholds: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        eEqType eEqType3 = eEqType.OC192_PORT;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            eDwdmFecMode eDwdmFecMode2 = eDwdmFecMode.STANDARD_FEC;
            String string = iDefaultsNodeArray[i].getName();
            IDefaultsNode[] iDefaultsNodeArray2 = new IDefaultsNode[]{iDefaultsNodeArray[i]};
            this.db.fine("handleDwdmFecThresholds: " + string);
            if (string.equals("oc3") || string.equals("stm1")) {
                eEqType3 = eEqType.OC3_PORT;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string.equals("oc12") || string.equals("stm4")) {
                eEqType3 = eEqType.OC12_PORT;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string.equals("oc48") || string.equals("stm16")) {
                eEqType3 = eEqType.OC48_PORT;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string.equals("1gethernet")) {
                eEqType3 = eEqType.ONE_GE_PORT;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string.equals("1gfiberchannel")) {
                eEqType3 = eEqType.FC1G_PORT;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string.equals("1gficon")) {
                eEqType3 = eEqType.FICON1G_PORT;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string.equals("2gfiberchannel")) {
                eEqType3 = eEqType.FC2G_PORT;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string.equals("2gficon")) {
                eEqType3 = eEqType.FICON2G_PORT;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string.equals("standard")) {
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string.equals("enhanced")) {
                eDwdmFecMode2 = eDwdmFecMode.ENHANCED_FEC;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            }
            this.helpHandleDwdmFecThresholds(eEqType2, eEqType3, eDwdmFecMode2, iDefaultsNodeArray2, bl);
        }
    }

    private void handleDwdmOtn(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.info("handleDwdmOtn: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("otnLines")) {
                this.helpHandleDwdmOtnLineConfig(eEqType2, string, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("g709thresholds")) {
                this.handleDwdmOtnThresholds(eEqType2, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("fecthresholds")) {
                this.handleDwdmFecThresholds(eEqType2, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.db.severe("handleDwdmOtn: unknown level " + string);
        }
    }

    private void handleDwdmOpticalThresholds(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.info("handleDwdmOpticalThresholds: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            eDwdmLineType eDwdmLineType2 = eDwdmLineType.DWDM_CLIENT;
            eEqType eEqType3 = eEqType.DWDM_CLIENT_PORT;
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("trunk")) {
                eDwdmLineType2 = eDwdmLineType.DWDM_TRUNK;
                eEqType3 = eEqType.DWDM_TRUNK_PORT;
            }
            this.db.fine("handleDwdmOpticalThresholds: " + string);
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                IDefaultsNode[] iDefaultsNodeArray3;
                if (iDefaultsNodeArray2[j].getName().equals("warning")) {
                    iDefaultsNodeArray3 = iDefaultsNodeArray2[j].getChildren();
                    for (int k = 0; k < iDefaultsNodeArray3.length; ++k) {
                        eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                        if (iDefaultsNodeArray3[k].getName().equals("1day")) {
                            eIntervalType2 = eIntervalType.INTERVAL_DAY;
                        }
                        IDefaultsNode[] iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                        if (bl) {
                            this.setOpticalThresholdsToNodeVals(eEqType2, eEqType3, eDwdmLineType2, eIntervalType2, iDefaultsNodeArray4);
                            continue;
                        }
                        this.getOpticalThresholdsFromNodeVals(eEqType2, eEqType3, eDwdmLineType2, eIntervalType2, iDefaultsNodeArray4);
                    }
                    continue;
                }
                iDefaultsNodeArray3 = iDefaultsNodeArray2[j].getChildren();
                if (bl) {
                    this.setOpticalAlarmThresholdsToNodeVals(eEqType2, eEqType3, eDwdmLineType2, iDefaultsNodeArray3);
                    continue;
                }
                this.getOpticalAlarmThresholdsFromNodeVals(eEqType2, eEqType3, eDwdmLineType2, iDefaultsNodeArray3);
            }
        }
    }

    private void helpGetTermMode(eEqType eEqType2, IDefaultsElement iDefaultsElement) throws Exception {
        eTermMode eTermMode2 = this.neDefaultsModel.getDefTermMode(eEqType2);
        iDefaultsElement.initEnumValue(eTermMode2.value());
    }

    private void helpGetAisSquelchMode(eEqType eEqType2, IDefaultsElement iDefaultsElement) throws Exception {
        eAisSquelchMode eAisSquelchMode2 = this.neDefaultsModel.getDefAisSquelchMode(eEqType2);
        iDefaultsElement.initEnumValue(eAisSquelchMode2.value());
    }

    private void helpSetTermModeAndAisSquelchMode(eEqType eEqType2, IDefaultsElement iDefaultsElement, IDefaultsElement iDefaultsElement2) throws Exception {
        boolean bl = false;
        eTermMode eTermMode2 = null;
        eAisSquelchMode eAisSquelchMode2 = null;
        if (iDefaultsElement == null) {
            eTermMode2 = eTermMode.TERM_TRANSPARENT;
        } else {
            if (iDefaultsElement.isDirty()) {
                bl = true;
            }
            eTermMode2 = eTermMode.from_int(iDefaultsElement.getEnumValue());
        }
        if (iDefaultsElement2 == null) {
            eAisSquelchMode2 = eAisSquelchMode.MODE_DISABLE;
        } else {
            if (iDefaultsElement2.isDirty()) {
                bl = true;
            }
            eAisSquelchMode2 = eAisSquelchMode.from_int(iDefaultsElement2.getEnumValue());
        }
        if (bl) {
            this.db.fine("Setting  termMode " + eTermMode2.value() + " aisSquelchMode " + eAisSquelchMode2.value());
            this.neDefaultsModel.setDefDwdmCardConfig(eEqType2, eTermMode2, eAisSquelchMode2);
            if (iDefaultsElement != null) {
                iDefaultsElement.makeClean();
            }
            if (iDefaultsElement2 != null) {
                iDefaultsElement2.makeClean();
            }
        }
    }

    private void helpHandleDwdmLineConfig(eEqType eEqType2, String string, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        eEqType eEqType3 = eEqType.DWDM_CLIENT_PORT;
        if (string.equals("trunk")) {
            eEqType3 = eEqType.DWDM_TRUNK_PORT;
        }
        ArrayList<IDefaultsElement> arrayList = new ArrayList<IDefaultsElement>();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = iDefaultsElement.getName();
            this.db.info("helpHandleDwdmLineConfig: " + string + " " + string2);
            if (string2.equals("ppmPortAssignment") || string2.equals("ppmSlotAssignment") || string2.equals("mrPortAssignment")) {
                this.handleConfigurableDwdmPorts(eEqType2, iDefaultsElement, bl);
                continue;
            }
            if (string2.equals("State") || string2.equals("AdminState")) {
                this.helpHandleAdminState(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            if (string2.equals("AINSSoakTime")) {
                this.helpHandleSoakTime(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            if (string2.equals("TerminationMode")) {
                if (!bl) {
                    this.helpGetTermMode(eEqType2, iDefaultsElement);
                    continue;
                }
                this.helpSetTermModeAndAisSquelchMode(eEqType2, iDefaultsElement.getSiblingElement("TerminationMode"), null);
                continue;
            }
            if (string2.equals("AisSquelchMode")) {
                if (bl) {
                    this.helpSetTermModeAndAisSquelchMode(eEqType2, iDefaultsElement.getSiblingElement("TerminationMode"), iDefaultsElement);
                    continue;
                }
                this.helpGetAisSquelchMode(eEqType2, iDefaultsElement);
                continue;
            }
            if (string2.equals("SFBER")) {
                this.helpHandleSfBerLevel(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            if (string2.equals("SDBER")) {
                this.helpHandleSdBerLevel(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            if (string2.equals("AlsMode")) {
                this.helpHandleAlsMode(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            if (string2.equals("AlsRecoveryPulseInterval")) {
                this.helpHandleAlsRecoveryPulseInterval(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            if (string2.equals("AlsRecoveryPulseDuration")) {
                this.helpHandleAlsRecoveryPulseDuration(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            if (string2.equals("SyncMsgIn")) {
                arrayList.add(iDefaultsElement);
                continue;
            }
            if (string2.equals("SendDoNotUse")) {
                arrayList.add(iDefaultsElement);
                continue;
            }
            this.db.severe("helpHandleDwdmLineConfig(): Unknown line config value >>" + string2 + "<< on " + iDefaultsElement.getFullName());
        }
        this.handleLineSyncConfig(eEqType2, eEqType3, arrayList.toArray(new IDefaultsNode[0]), bl);
    }

    private void helpHandleOptConfig(eEqType eEqType2, String string, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        eEqType eEqType3 = eEqType.AMP_PORT;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = iDefaultsElement.getName();
            this.db.info("helpHandleOptConfig: " + string + " " + string2);
            if (string2.equals("AlsMode")) {
                this.helpHandleAlsMode(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            this.db.severe("helpHandleDwdmLineConfig(): Unknown line config value >>" + string2 + "<< on " + iDefaultsElement.getFullName());
        }
    }

    private void helpHandleDwdmOtnLineConfig(eEqType eEqType2, String string, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        eEqType eEqType3 = eEqType.DWDM_TRUNK_PORT;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = iDefaultsElement.getName();
            this.db.info("helpHandleDwdmOtnLineConfig: " + string2);
            if (string2.equals("G709OTN")) {
                if (bl) continue;
                boolean bl2 = this.neDefaultsModel.getDefG709OTN(eEqType2);
                iDefaultsElement.initEnumValue(bl2 ? 1 : 0);
                continue;
            }
            if (string2.equals("FEC")) {
                if (bl) continue;
                eDwdmFecMode eDwdmFecMode2 = this.neDefaultsModel.getDefFecMode(eEqType2);
                iDefaultsElement.initEnumValue(eDwdmFecMode2.value());
                continue;
            }
            if (string2.equals("SDBER")) {
                this.helpHandleLineSdBerLevel(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            if (string2.equals("AsynchSynchMapping")) {
                this.helpHandleMappingType(eEqType2, iDefaultsElement, bl);
                continue;
            }
            this.db.severe("Unknown " + string + " otnLines config value " + string2);
        }
    }

    private void handleDwdmConfig(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.info("handleDwdmConfig: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        ArrayList<IDefaultsElement> arrayList = new ArrayList<IDefaultsElement>();
        eEqType eEqType3 = eEqType.DWDM_CLIENT_PORT;
        IDefaultsNode iDefaultsNode = null;
        IDefaultsNode iDefaultsNode2 = null;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("fc")) {
                if (bl) {
                    iDefaultsNode2 = iDefaultsNodeArray[i];
                    continue;
                }
                this.getFcmrConfigFromNodeVals(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren());
                continue;
            }
            if (string.equals("card")) {
                if (bl) {
                    iDefaultsNode = iDefaultsNodeArray[i];
                    continue;
                }
                this.getCardMode(eEqType2, iDefaultsNodeArray[i].getChildren());
                continue;
            }
            if (string.equals("client") || string.equals("trunk")) {
                this.helpHandleDwdmLineConfig(eEqType2, string, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("payload") || string.equals("sonet") || string.equals("sdh")) {
                IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                    String string2 = iDefaultsNodeArray2[j].getName();
                    IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[j];
                    if (string2.equals("SFBER")) {
                        this.helpHandleSfBerLevel(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string2.equals("SDBER")) {
                        this.helpHandleSdBerLevel(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string2.equals("SyncMsgIn")) {
                        arrayList.add(iDefaultsElement);
                        continue;
                    }
                    if (string2.equals("SendDoNotUse")) {
                        arrayList.add(iDefaultsElement);
                        continue;
                    }
                    this.db.severe("handleDwdmConfig(): Unknown payload/sonet/trunk config value " + string + " " + string2);
                }
                continue;
            }
            this.db.severe("Unknown dwdm config value " + string);
        }
        if (bl && iDefaultsNode != null && iDefaultsNode2 != null) {
            this.setFcmrConfigToNodeVals(eEqType2, eEqType3, iDefaultsNode.getChildren(), iDefaultsNode2.getChildren());
        }
        this.handleLineSyncConfig(eEqType2, eEqType3, arrayList.toArray(new IDefaultsNode[0]), bl);
    }

    private void handleDwdm(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.info("handleDwdm: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            this.db.info("handleDwdm: name = " + string);
            if (string.equals("pmthresholds")) {
                this.handleDwdmPm(eEqType2, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("otn")) {
                this.handleDwdmOtn(eEqType2, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("opticalthresholds")) {
                this.handleDwdmOpticalThresholds(eEqType2, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("config")) {
                this.handleDwdmConfig(eEqType2, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.db.severe("handleDwdm: Shouldnt be here....");
        }
    }

    private void handleOptConfig(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.info("handleOptConfig: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("card")) {
                this.helpHandleOptConfig(eEqType2, string, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.db.severe("Unknown dwdm config value " + string);
        }
    }

    private void handleOpt(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.info("handleOpt: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            this.db.info("handleOpt: name = " + string);
            if (string.equals("config")) {
                this.handleOptConfig(eEqType2, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.db.severe("handleOpt: Shouldnt be here....");
        }
    }

    private void handleMrcPhysicalThresholds(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleMrcPhysicalThresholds: mrcNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        block3: for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            eEqType eEqType3 = this.getMrcPortTypeFromName(string);
            this.db.fine("handleMrcPhysicalThresholds: port eEqType= " + eEqType3.value());
            switch (eEqType3.value()) {
                case 28: 
                case 29: 
                case 30: 
                case 61: {
                    this.handleOCnPhysicalThresholds(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl);
                    continue block3;
                }
                default: {
                    this.db.severe("handleMrcPhysicalThresholds: unknown port eEqType= " + eEqType3.value());
                }
            }
        }
    }

    private void handleMrcPm(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleMrcPm: mrcNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        block3: for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            eEqType eEqType3 = this.getMrcPortTypeFromName(string);
            this.db.fine("handleMrcPm: port eEqType= " + eEqType3.value());
            switch (eEqType3.value()) {
                case 28: 
                case 29: 
                case 30: 
                case 61: {
                    this.handleOCnPm(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl);
                    continue block3;
                }
                default: {
                    this.db.severe("handleMrcPm: unknown port eEqType= " + eEqType3.value());
                }
            }
        }
    }

    private void handleMrcConfig(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleMrcConfig: mrcNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        block4: for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            eEqType eEqType3 = this.getMrcPortTypeFromName(string);
            this.db.fine("handleMrcConfig: port eEqType= " + eEqType3.value());
            switch (eEqType3.value()) {
                case 28: 
                case 29: 
                case 30: 
                case 61: {
                    this.handleOCnConfig(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl);
                    continue block4;
                }
                case 166: {
                    this.handleEtherConfig(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl);
                    continue block4;
                }
                default: {
                    this.db.severe("handleMrcConfig: unknown port eEqType= " + eEqType3.value());
                }
            }
        }
    }

    private void handleMrc(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleMrc: mrcNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("physicalthresholds")) {
                this.handleMrcPhysicalThresholds(eEqType2, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("pmthresholds")) {
                this.handleMrcPm(eEqType2, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("config")) {
                this.handleMrcConfig(eEqType2, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.db.severe("handleMrc: Shouldnt be here....");
        }
    }

    private void handleMutablePorts(eEqType eEqType2, IDefaultsNode iDefaultsNode, boolean bl) throws Exception {
        String string = iDefaultsNode.getName();
        this.db.fine("handleMutablePorts " + string);
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = iDefaultsElement.getName();
            String string3 = iDefaultsElement.getValue();
            eEqType eEqType3 = eEqType.INVALID;
            if (string.equals("PPM")) {
                if (string2.equals("slotAssignment")) {
                    eEqType3 = eEqType.PPM_SLOT;
                } else if (string2.equals("portAssignment")) {
                    eEqType3 = eEqType.PPM_1_PORT;
                } else {
                    this.db.severe("Unknown pluggable container name " + string + " " + string2);
                }
            } else if (string.equals("Wideband")) {
                eEqType3 = eEqType.WBE_SLOT;
            } else if (string.equals("Broadband")) {
                eEqType3 = eEqType.BBE_SLOT;
            } else if (string.equals("MR")) {
                eEqType3 = eEqType.MR_SLOT;
            } else {
                this.db.severe("Unknown pluggable container name " + string + " " + string2);
            }
            eEqType eEqType4 = eEqType.INVALID;
            if (bl) {
                if (iDefaultsElement.isDirty()) {
                    eEqType4 = this.getEqTypeFromName(string3);
                    this.neDefaultsModel.setDefPluggableEqType(eEqType2, eEqType3, eEqType4);
                    iDefaultsElement.makeClean();
                }
            } else {
                eEqType4 = this.neDefaultsModel.getDefPluggableEqType(eEqType2, eEqType3);
                string3 = this.getNameFromEqType(eEqType4);
                iDefaultsElement.initValue(string3);
            }
            this.db.info("Mutable equipment type on " + this.getNameFromEqType(eEqType2) + " " + eEqType2.value() + " " + string + " " + eEqType4.value() + " " + string2 + " is " + string3);
        }
    }

    private boolean isPPMPortContainer(eEqType eEqType2) {
        return eEqType2 == eEqType.PPM_1_PORT || eEqType2 == eEqType.MR_SLOT;
    }

    private void handleConfigurableDwdmPorts(eEqType eEqType2, IDefaultsNode iDefaultsNode, boolean bl) throws Exception {
        DefaultsElement defaultsElement = (DefaultsElement)iDefaultsNode;
        String string = defaultsElement.getName();
        this.db.fine("handleConfigurableDwdmPorts " + string);
        eEqType eEqType3 = eEqType.INVALID;
        if (string.equals("ppmPortAssignment")) {
            eEqType3 = eEqType.PPM_1_PORT;
        } else if (string.equals("ppmSlotAssignment")) {
            eEqType3 = eEqType.PPM_SLOT;
        } else if (string.equals("mrPortAssignment")) {
            eEqType3 = eEqType.MR_SLOT;
        } else {
            this.db.severe("Unknown pluggable container name " + string + " " + string);
        }
        eEqType eEqType4 = eEqType.INVALID;
        if (bl) {
            int n = defaultsElement.getEnumValue();
            eEqType4 = eEqType.from_int(n);
            IDefaultsElement iDefaultsElement = defaultsElement.getCousinElement("//.//.otn.otnLines.G709OTN");
            IDefaultsElement iDefaultsElement2 = defaultsElement.getCousinElement("//.//.otn.otnLines.FEC");
            if (!this.isPPMPortContainer(eEqType3) || iDefaultsElement == null || iDefaultsElement2 == null) {
                if (defaultsElement.isDirty()) {
                    this.neDefaultsModel.setDefPluggableEqType(eEqType2, eEqType3, eEqType4);
                    defaultsElement.makeClean();
                }
            } else if (defaultsElement.isDirty() || iDefaultsElement.isDirty() || iDefaultsElement2.isDirty()) {
                n = iDefaultsElement.getEnumValue();
                boolean bl2 = n == 1;
                n = iDefaultsElement2.getEnumValue();
                eDwdmFecMode eDwdmFecMode2 = eDwdmFecMode.from_int(n);
                this.neDefaultsModel.setDefG709OTN(eEqType2, eEqType3, eEqType4, bl2, eDwdmFecMode2);
                defaultsElement.makeClean();
                iDefaultsElement.makeClean();
                iDefaultsElement2.makeClean();
            }
        } else {
            eEqType4 = this.neDefaultsModel.getDefPluggableEqType(eEqType2, eEqType3);
            defaultsElement.initEnumValue(eEqType4.value());
        }
        this.db.info("Configurable equipment type on " + this.getNameFromEqType(eEqType2) + " " + eEqType2.value() + eEqType4.value() + " " + string + " is " + defaultsElement.getEnumValue());
    }

    private void handleNodeCircuits(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            Object object;
            String string = "";
            String string2 = iDefaultsNodeArray[i].getName();
            if (string2.equals("upsr") || string2.equals("sncp")) {
                object = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < ((IDefaultsNode[])object).length; ++j) {
                    String string3 = object[j].getName();
                    IDefaultsElement iDefaultsElement = (IDefaultsElement)object[j];
                    if (string3.equals("Revertive") || string3.equals("ReversionTime")) {
                        IRevertiveBehavior iRevertiveBehavior = this.nmd.getUpsrReversion();
                        sRevertiveBehavior sRevertiveBehavior2 = RevertiveBehaviorFactory.getRevertiveBehavior(iRevertiveBehavior);
                        string = string3.equals("Revertive") ? this.boolToString(sRevertiveBehavior2.reversionMode == eReversionMode.REVERTIVE_BEHAVIOR) : (string3.equals("ReversionTime") ? String.valueOf((double)sRevertiveBehavior2.reversionTime / 60.0) : "UNKNOWN");
                        iDefaultsElement.initValue(string);
                        continue;
                    }
                    if (string3.equals("STS_SFBER") || string3.equals("HO_SFBER")) {
                        short s = this.nmd.getUpsrSfBerLevel(2);
                        iDefaultsElement.initEnumValue(s);
                        continue;
                    }
                    if (string3.equals("STS_SDBER") || string3.equals("HO_SDBER")) {
                        short s = this.nmd.getUpsrSdBerLevel(2);
                        iDefaultsElement.initEnumValue(s);
                        continue;
                    }
                    if (string3.equals("VT_SFBER") || string3.equals("LO_SFBER")) {
                        short s = this.nmd.getUpsrSfBerLevel(1);
                        iDefaultsElement.initEnumValue(s);
                        continue;
                    }
                    if (string3.equals("VT_SDBER") || string3.equals("LO_SDBER")) {
                        short s = this.nmd.getUpsrSdBerLevel(1);
                        iDefaultsElement.initEnumValue(s);
                        continue;
                    }
                    if (string3.equals("SwitchOnPDIP")) {
                        boolean bl = this.nmd.getUpsrSwitchOnPdip();
                        string = this.boolToString(bl);
                        iDefaultsElement.initValue(string);
                        continue;
                    }
                    if (string3.equals("AllowUpsrOverOnePlusOne") || string3.equals("AllowSncpOverOnePlusOne")) {
                        iDefaultsElement.initValue(this.boolToString(this.neDefaultsModel.allowUpsrOverOnePlusOne()));
                        continue;
                    }
                    this.db.severe("Unknown node circuit upsr/sncp " + string2);
                }
                continue;
            }
            if (string2.equals("State") || string2.equals("AdminState")) {
                object = (IDefaultsElement)iDefaultsNodeArray[i];
                object.initEnumValue(this.neDefaultsModel.getDefaultCircuitAdminState().value());
                continue;
            }
            if (string2.equals("SendPDIP")) {
                ((IDefaultsElement)iDefaultsNodeArray[i]).initValue(this.boolToString(this.nmd.getSendPDIP()));
                continue;
            }
            this.db.severe("Unknown node circuit " + string2);
        }
    }

    private void handleNodeProtection(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            Object object;
            Object object2;
            int n;
            String string = "";
            String string2 = iDefaultsNodeArray[i].getName();
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            if (string2.equals("1+1") || string2.equals("lmsp")) {
                boolean bl = this.neDefaultsModel.getDefOnePlusOneBidir();
                sRevertiveBehavior sRevertiveBehavior2 = this.neDefaultsModel.getDefOnePlusOneRev();
                if (sRevertiveBehavior2 == null) {
                    throw new Exception("OnePlusOne Revertive Behavior is null");
                }
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    object2 = iDefaultsNodeArray2[n].getName();
                    if (((String)object2).equals("BidirectionalSwitching")) {
                        string = this.boolToString(bl);
                    } else if (((String)object2).equals("Revertive")) {
                        string = this.boolToString(sRevertiveBehavior2.reversionMode == eReversionMode.REVERTIVE_BEHAVIOR);
                    } else if (((String)object2).equals("ReversionTime")) {
                        string = String.valueOf((double)sRevertiveBehavior2.reversionTime / 60.0);
                    } else if (((String)object2).equals("RecoveryGuardTimer")) {
                        object = this.neDefaultsModel.getDefRecoveryGuardTimer();
                        string = RECOVERY_GUARD_TIMERS[((eRecoveryGuardTimer)object).value()];
                    } else if (((String)object2).equals("VerifyGuardTimer")) {
                        object = this.neDefaultsModel.getDefVerifyGuardTimer();
                        string = VERIFY_GUARD_TIMERS[((eVerifyGuardTimer)object).value()];
                    } else if (((String)object2).equals("DetectionGuardTimer")) {
                        object = this.neDefaultsModel.getDefDetectionGuardTimer();
                        string = DETECTION_GUARD_TIMERS[((eDetectionGuardTimer)object).value()];
                    } else {
                        string = "UNKNOWN";
                    }
                    object = (IDefaultsElement)iDefaultsNodeArray2[n];
                    object.initValue(string);
                }
                continue;
            }
            if (string2.equals("blsr") || string2.equals("msspr")) {
                sRevertiveBehavior sRevertiveBehavior3 = this.neDefaultsModel.getDefBlsrRingRev();
                sRevertiveBehavior sRevertiveBehavior4 = this.neDefaultsModel.getDefBlsrSpanRev();
                if (sRevertiveBehavior4 == null) {
                    throw new Exception("BLSR Span Revertive Behavior is null");
                }
                if (sRevertiveBehavior3 == null) {
                    throw new Exception("BLSR Ring Revertive Behavior is null");
                }
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    object2 = iDefaultsNodeArray2[n].getName();
                    string = ((String)object2).equals("SpanRevertive") ? this.boolToString(sRevertiveBehavior4.reversionMode == eReversionMode.REVERTIVE_BEHAVIOR) : (((String)object2).equals("SpanReversionTime") ? String.valueOf((double)sRevertiveBehavior4.reversionTime / 60.0) : (((String)object2).equals("RingRevertive") ? this.boolToString(sRevertiveBehavior3.reversionMode == eReversionMode.REVERTIVE_BEHAVIOR) : (((String)object2).equals("RingReversionTime") ? String.valueOf((double)sRevertiveBehavior3.reversionTime / 60.0) : "UNKNOWN")));
                    object = (IDefaultsElement)iDefaultsNodeArray2[n];
                    object.initValue(string);
                }
                continue;
            }
            if (string2.startsWith("ycable")) {
                boolean bl = this.neDefaultsModel.getDefYCableBidir();
                sRevertiveBehavior sRevertiveBehavior5 = this.neDefaultsModel.getDefYCableRev();
                if (sRevertiveBehavior5 == null) {
                    throw new Exception("YCable RevertiveBehavior is null");
                }
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    object2 = iDefaultsNodeArray2[n].getName();
                    string = ((String)object2).equals("BidirectionalSwitching") ? this.boolToString(bl) : (((String)object2).equals("Revertive") ? this.boolToString(sRevertiveBehavior5.reversionMode == eReversionMode.REVERTIVE_BEHAVIOR) : (((String)object2).equals("ReversionTime") ? String.valueOf((double)sRevertiveBehavior5.reversionTime / 60.0) : "UNKNOWN"));
                    object = (IDefaultsElement)iDefaultsNodeArray2[n];
                    object.initValue(string);
                }
                continue;
            }
            if (string2.startsWith("splitter")) {
                sRevertiveBehavior sRevertiveBehavior6 = this.neDefaultsModel.getDefSplittRev();
                if (sRevertiveBehavior6 == null) {
                    throw new Exception("Splitter RevertiveBehavior is null");
                }
                for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                    String string3 = iDefaultsNodeArray2[j].getName();
                    string = string3.equals("Revertive") ? this.boolToString(sRevertiveBehavior6.reversionMode == eReversionMode.REVERTIVE_BEHAVIOR) : (string3.equals("ReversionTime") ? String.valueOf((double)sRevertiveBehavior6.reversionTime / 60.0) : "UNKNOWN");
                    object2 = (IDefaultsElement)iDefaultsNodeArray2[j];
                    object2.initValue(string);
                }
                continue;
            }
            string = "UNKNOWN";
        }
    }

    private String getStringFromQualityLevel(eQualityLevel eQualityLevel2) {
        String string = "UNKNOWN";
        switch (eQualityLevel2.value()) {
            case 0: {
                string = "PRS";
                break;
            }
            case 1: {
                string = "STU";
                break;
            }
            case 2: {
                string = "ST2";
                break;
            }
            case 3: {
                string = "TNC";
                break;
            }
            case 4: {
                string = "ST3E";
                break;
            }
            case 5: {
                string = "ST3";
                break;
            }
            case 6: {
                string = "SMC";
                break;
            }
            case 7: {
                string = "ST4";
                break;
            }
            case 8: {
                string = "DUS";
                break;
            }
            case 9: {
                string = "RES";
                break;
            }
            case 10: {
                string = "G811";
                break;
            }
            case 11: {
                string = "STU";
                break;
            }
            case 12: {
                string = "G812T";
                break;
            }
            case 13: {
                string = "G812L";
                break;
            }
            case 14: {
                string = "SETS";
                break;
            }
            case 15: {
                string = "DUS";
                break;
            }
            case 16: {
                string = "RES";
                break;
            }
        }
        return string;
    }

    private String getStringFromSaBit(eSaBit eSaBit2) {
        String string = "UNKNOWN";
        switch (eSaBit2.value()) {
            case 0: {
                string = "4";
                break;
            }
            case 1: {
                string = "5";
                break;
            }
            case 2: {
                string = "6";
                break;
            }
            case 3: {
                string = "7";
                break;
            }
            case 4: {
                string = "8";
                break;
            }
        }
        return string;
    }

    private void handleNodeTiming(IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        IDefaultsNode iDefaultsNode = null;
        IDefaultsNode iDefaultsNode2 = null;
        IDefaultsNode iDefaultsNode3 = null;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = "";
            String string2 = iDefaultsNodeArray[i].getName();
            if (string2.equals("bits-1")) {
                iDefaultsNode2 = iDefaultsNodeArray[i];
                continue;
            }
            if (string2.equals("bits-2")) {
                iDefaultsNode3 = iDefaultsNodeArray[i];
                continue;
            }
            if (string2.equals("general")) {
                iDefaultsNode = iDefaultsNodeArray[i];
                continue;
            }
            this.db.severe("handleNodeTiming: unknown element= " + string2);
        }
        if (iDefaultsNode != null) {
            this.helpHandleTimingGeneral(iDefaultsNode.getChildren(), bl);
        }
        if (iDefaultsNode2 != null) {
            this.helpHandleBits(iDefaultsNode2.getChildren(), eBits.BITS_1, bl);
        }
        if (iDefaultsNode3 != null) {
            this.helpHandleBits(iDefaultsNode3.getChildren(), eBits.BITS_2, bl);
        }
    }

    private void helpHandleAccessState(eAccessMechanism eAccessMechanism2, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        SecurityModel securityModel = (SecurityModel)this.nmd.getSecurityModel();
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                securityModel.setAccessState(AccessMechanism.from_int(eAccessMechanism2.value()), AccessState.from_int(iDefaultsElement.getEnumValue()));
                iDefaultsElement.makeClean();
            }
        } else {
            iDefaultsElement.initEnumValue(securityModel.getAccessState(AccessMechanism.from_int(eAccessMechanism2.value())).intValue());
        }
    }

    private void helpHandleNodeSecurity(IDefaultsNode iDefaultsNode, boolean bl) throws Exception {
        SecurityModel securityModel = (SecurityModel)this.nmd.getSecurityModel();
        String string = iDefaultsNode.getName();
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        if (string.equals("lanAccess")) {
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
                String string2 = iDefaultsElement.getName();
                String string3 = iDefaultsElement.getValue();
                this.db.fine("helpHandleNodeSecurity: " + string + " " + string2);
                if (string2.equals("LANAccess")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        this.pendingApplications.put(string2, iDefaultsElement);
                        continue;
                    }
                    iDefaultsElement.initValue(securityModel.getLANAccess().toString());
                    continue;
                }
                if (string2.equals("RestoreTimeout")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        securityModel.setLANAccessTimeout(Integer.parseInt(string3));
                        iDefaultsElement.makeClean();
                        continue;
                    }
                    iDefaultsElement.initValue(String.valueOf(securityModel.getLANAccessTimeout()));
                    continue;
                }
                this.db.severe("Unknown security access " + string2);
            }
        } else if (string.equals("serialCraftAccess")) {
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
                String string4 = iDefaultsElement.getName();
                String string5 = iDefaultsElement.getValue();
                this.db.fine("helpHandleNodeSecurity: " + string + " " + string4);
                if (string4.equals("EnableCraftPort") || string4.equals("EnableCraftPortA")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        securityModel.setSerialPortAccess(eSerialPortId.CRAFT_PORT_A, string5.equals("TRUE"));
                        iDefaultsElement.makeClean();
                        continue;
                    }
                    iDefaultsElement.initValue(this.boolToString(securityModel.getSerialPortAccess(eSerialPortId.CRAFT_PORT_A)));
                    continue;
                }
                if (string4.equals("EnableCraftPortB")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        securityModel.setSerialPortAccess(eSerialPortId.CRAFT_PORT_B, string5.equals("TRUE"));
                        iDefaultsElement.makeClean();
                        continue;
                    }
                    iDefaultsElement.initValue(this.boolToString(securityModel.getSerialPortAccess(eSerialPortId.CRAFT_PORT_B)));
                    continue;
                }
                this.db.severe("helpHandleNodeSecurity(): unknown security access " + string4);
            }
        } else if (string.equals("shellAccess")) {
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
                String string6 = iDefaultsElement.getName();
                String string7 = iDefaultsElement.getValue();
                this.db.fine("helpHandleNodeSecurity(): " + string + " " + string6);
                if (string6.equals("EnableShellPassword")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        if (string7.equals("TRUE")) {
                            securityModel.setEnforceShellPasswordOn();
                        } else {
                            securityModel.setEnforceShellPasswordOff(this.password);
                        }
                        iDefaultsElement.makeClean();
                        continue;
                    }
                    iDefaultsElement.initValue(this.boolToString(securityModel.isEnforceShellPassword()));
                    continue;
                }
                if (string6.equals("TelnetPort")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        securityModel.setTelnetPort(Integer.parseInt(iDefaultsElement.getValue()));
                        iDefaultsElement.makeClean();
                        continue;
                    }
                    iDefaultsElement.initValue(String.valueOf(securityModel.getTelnetPort()));
                    continue;
                }
                if (string6.equals("AccessState")) {
                    this.helpHandleAccessState(eAccessMechanism.SHELL_ACCESS, iDefaultsElement, bl);
                    continue;
                }
                this.db.severe("helpHandleNodeSecurity(): unknown security shell access " + string6);
            }
        } else if (string.equals("tl1Access")) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[0];
            String string8 = iDefaultsElement.getName();
            if (string8.equals("AccessState")) {
                this.helpHandleAccessState(eAccessMechanism.TL1_ACCESS, iDefaultsElement, bl);
            } else {
                this.db.severe("helpHandleNodeSecurity(): Unknown security tl1 access " + string8);
            }
        } else if (string.equals("emsAccess")) {
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
                String string9 = iDefaultsElement.getName();
                if (string9.equals("AccessState")) {
                    this.helpHandleAccessState(eAccessMechanism.EMS_ACCESS, iDefaultsElement, bl);
                    continue;
                }
                if (string9.equals("IIOPListenerPort")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        this.pendingApplications.put(string9, iDefaultsElement);
                        continue;
                    }
                    int n = this.nmd.getIpConfig().getIiopPort();
                    if (n < 0) {
                        n += 65536;
                    }
                    iDefaultsElement.initValue(String.valueOf(n));
                    continue;
                }
                this.db.severe("helpHandleNodeSecurity(): unknown security ems access " + string9);
            }
        } else if (string.equals("snmpAccess")) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[0];
            String string10 = iDefaultsElement.getName();
            if (string10.equals("AccessState")) {
                this.helpHandleAccessState(eAccessMechanism.SNMP_ACCESS, iDefaultsElement, bl);
            } else {
                this.db.severe("helpHandleNodeSecurity(): unknown security snmp access " + string10);
            }
        } else if (string.equals("radiusServer")) {
            this.handleNodeNetworkSecurity(iDefaultsNode.getChildren(), bl);
        } else if (string.equals("radiusServerList")) {
            this.handleNodeRadiusServerList(iDefaultsNode.getChildren(), bl);
        } else if (string.equals("legalDisclaimer")) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[0];
            String string11 = iDefaultsElement.getName();
            String string12 = iDefaultsElement.getValue();
            if (bl) {
                if (iDefaultsElement.isDirty()) {
                    ((SecurityModel)this.nmd.getSecurityModel()).setLegalDisclaimer(string12);
                    iDefaultsElement.makeClean();
                }
            } else {
                iDefaultsElement.initValue(((SecurityModel)this.nmd.getSecurityModel()).getLegalDisclaimer());
            }
        } else if (string.equals("grantPermission")) {
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
                String string13 = iDefaultsElement.getName();
                this.db.fine("helpHandleNodeSecurity(): " + string + " " + string13);
                Operation operation = null;
                if (string13.equals("PMClearingPrivilege")) {
                    operation = Operation.CLEAR_PM;
                } else if (string13.equals("ActivateRevertSoftware")) {
                    operation = Operation.ACTIVATE_REVERT_SW;
                } else if (string13.equals("RetrieveAuditLog")) {
                    operation = Operation.RETRIEVE_AUDIT;
                } else if (string13.equals("RestoreDB")) {
                    operation = Operation.RESTORE_DB;
                } else {
                    this.db.severe("helpHandleNodeSecurity: unknown operation = " + string13);
                    continue;
                }
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityModel.setOperationPrivilege(operation, SecurityLevel.from_int((int)iDefaultsElement.getEnumValue()));
                    iDefaultsElement.makeClean();
                    continue;
                }
                iDefaultsElement.initEnumValue(securityModel.getOperationPrivilege(operation).value());
            }
        } else {
            this.db.severe("helpHandleNodeSecurity(): unknown " + string);
        }
    }

    private void helpHandleNodeSecureModeConfig(IDefaultsElement iDefaultsElement) throws Exception {
        ISecureIpConfig iSecureIpConfig = this.nmd.getSecureIpConfig();
        String string = iDefaultsElement.getName();
        String string2 = "";
        this.db.fine("helpHandleNodeSecureModeConfig(): " + string);
        if (string.equals("SecureModeOn")) {
            boolean bl = iSecureIpConfig.isSecureMode();
            string2 = this.boolToString(bl);
        } else if (string.equals("SecureModeLocked")) {
            string2 = this.boolToString(iSecureIpConfig.isPermanentSecureMode());
        } else if (string.equals("CtcBackplaneIpDisplaySuppression")) {
            string2 = this.boolToString(this.nmd.getCtcIpDisplaySuppression(false));
        } else if (string.equals("LcdBackplaneIpSetting")) {
            int n = this.nmd.getLcdIpSetting(false);
            string2 = 0 <= n && n < LcdIpSetting.LCD_IP_SETTING.length ? LcdIpSetting.LCD_IP_SETTING[n] : LcdIpSetting.LCD_IP_SETTING[0];
        } else {
            string2 = "UNKNOWN";
            this.db.severe("helpHandleNodeSecureModeConfig: unknown element= " + string);
        }
        iDefaultsElement.initValue(string2);
    }

    private void handleNodeSecureModeConfig(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("ctc")) {
                this.handleTreelessDefaults(iDefaultsNodeArray[i], false);
                continue;
            }
            DefaultsElement defaultsElement = (DefaultsElement)iDefaultsNodeArray[i];
            if (defaultsElement.isDisplacedProperty()) {
                this.handleTreelessDefaults(defaultsElement, false);
                continue;
            }
            if (string.equals("isSecureModeSupportedOnControlCard")) {
                boolean bl = this.nmd.supportsSecureMode();
                defaultsElement.initEnumValue(bl ? 1 : 0);
                continue;
            }
            if (this.nmd.supportsSecureMode()) {
                this.helpHandleNodeSecureModeConfig(defaultsElement);
                continue;
            }
            this.db.severe(defaultsElement.getFullName() + " is " + NOT_SUPPORTED);
            defaultsElement.initValue(NOT_SUPPORTED);
        }
    }

    private void applyNodeSecureModeConfig(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        if (this.nmd.supportsSecureMode()) {
            boolean bl;
            IDefaultsElement iDefaultsElement = null;
            IDefaultsElement iDefaultsElement2 = null;
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                String string = iDefaultsNodeArray[i].getName();
                this.db.fine("applyNodeSecureModeConfig(): " + string);
                if (string.equals("ctc")) {
                    this.handleTreelessDefaults(iDefaultsNodeArray[i], true);
                    continue;
                }
                DefaultsElement defaultsElement = (DefaultsElement)iDefaultsNodeArray[i];
                String string2 = defaultsElement.getValue();
                if (defaultsElement.isDisplacedProperty()) {
                    this.handleTreelessDefaults(defaultsElement, true);
                    continue;
                }
                if (string.equals("SecureModeOn")) {
                    iDefaultsElement = defaultsElement;
                    continue;
                }
                if (string.equals("SecureModeLocked")) {
                    iDefaultsElement2 = defaultsElement;
                    continue;
                }
                if (string.equals("CtcBackplaneIpDisplaySuppression")) {
                    if (!defaultsElement.isDirty()) continue;
                    this.nmd.setCtcIpDisplaySuppression(false, this.stringToBool(string2));
                    defaultsElement.makeClean();
                    continue;
                }
                if (string.equals("LcdBackplaneIpSetting")) {
                    if (!defaultsElement.isDirty()) continue;
                    this.nmd.setLcdIpSetting(defaultsElement.getEnumValue(), false);
                    defaultsElement.makeClean();
                    continue;
                }
                this.db.info("applyNodeSecureModeConfig: unknown or uneditable " + defaultsElement.getName());
            }
            ISecureIpConfig iSecureIpConfig = this.nmd.getSecureIpConfig();
            boolean bl2 = iSecureIpConfig.isSecureMode();
            boolean bl3 = iSecureIpConfig.isPermanentSecureMode();
            if (iDefaultsElement != null && iDefaultsElement.isDirty() && this.stringToBool(iDefaultsElement.getValue()) != bl2) {
                if (bl3) {
                    throw new Exception(" The secure mode is locked and cannot be changed");
                }
                this.pendingApplications.put(iDefaultsElement.getName(), iDefaultsElement);
                if (iDefaultsElement2 != null) {
                    this.pendingApplications.put(iDefaultsElement2.getName(), iDefaultsElement2);
                }
            } else if (iDefaultsElement2 != null && iDefaultsElement2.isDirty() && this.stringToBool(iDefaultsElement2.getValue()) != bl3 && (bl = this.stringToBool(iDefaultsElement2.getValue())) != bl3) {
                if (bl3) {
                    throw new Exception("Locked secure mode cannot be unlocked");
                }
                if (!bl2) {
                    throw new Exception("Secure mode must be enabled before it can be locked");
                }
                this.nmd.makeSecurityPermanent();
                iDefaultsElement2.makeClean();
            }
        } else {
            this.db.info("applyNodeSecureModeConfig:  dataComm not supported on this TCC (" + this.nmd.supportsSecureMode() + ")");
        }
    }

    private boolean helpHandlePasswordAgingPolicy(SecurityPolicy securityPolicy, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsNode[] iDefaultsNodeArray2;
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("EnforcePasswordAging")) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
                iDefaultsNodeArray2 = iDefaultsElement.getValue();
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityPolicy.setPasswordExprPolicyEnabled(this.stringToBool((String)iDefaultsNodeArray2));
                    bl2 = true;
                    continue;
                }
                iDefaultsElement.initValue(this.boolToString(securityPolicy.isPasswordExprPolicyEnabled()));
                continue;
            }
            for (int j = 0; j < SECURITY_LEVELS.length; ++j) {
                if (!string.equalsIgnoreCase(SECURITY_LEVELS[j])) continue;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                int n = securityPolicy.getPasswordExprPeriod(j);
                int n2 = securityPolicy.getPasswordExprWarningPeriod(j);
                for (int k = 0; k < iDefaultsNodeArray2.length; ++k) {
                    IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[k];
                    String string2 = iDefaultsElement.getName();
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        if (string2.equals("AgingPeriod")) {
                            n = Integer.parseInt(iDefaultsElement.getValue());
                        } else if (string2.equals("WarningPeriod")) {
                            n2 = Integer.parseInt(iDefaultsElement.getValue());
                        }
                        bl2 = true;
                        continue;
                    }
                    if (string2.equals("AgingPeriod")) {
                        iDefaultsElement.initValue(String.valueOf(n));
                        continue;
                    }
                    if (!string2.equals("WarningPeriod")) continue;
                    iDefaultsElement.initValue(String.valueOf(n2));
                }
                if (!bl || !bl2) continue;
                securityPolicy.setPasswordExprPolicy(j, n, n2);
            }
        }
        return bl2;
    }

    private boolean helpHandlePasswordChangePolicy(SecurityPolicy securityPolicy, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            String string2 = iDefaultsElement.getValue();
            if (string.equals("CannotChangeNewPassword")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityPolicy.setPasswordFlippingPolicyEnabled(this.stringToBool(string2));
                    bl2 = true;
                    continue;
                }
                iDefaultsElement.initValue(this.boolToString(securityPolicy.getPasswordFlippingPolicyEnabled()));
                continue;
            }
            if (string.equals("CannotChangeNewPasswordForNDays")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityPolicy.setPasswordFlippingPolicyThreshold(Integer.parseInt(string2));
                    bl2 = true;
                    continue;
                }
                iDefaultsElement.initValue(String.valueOf(securityPolicy.getPasswordFlippingPolicyThreshold()));
                continue;
            }
            if (string.equals("PreventReusingLastNPasswords")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityPolicy.setPasswordReuseThreshold(Integer.parseInt(string2));
                    bl2 = true;
                    continue;
                }
                iDefaultsElement.initValue(String.valueOf(securityPolicy.getPasswordReuseThreshold()));
                continue;
            }
            if (string.equals("RequirePasswordChangeOnFirstLoginToNewAccount")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityPolicy.setForcePasswordChange(this.stringToBool(string2));
                    bl2 = true;
                    continue;
                }
                iDefaultsElement.initValue(this.boolToString(securityPolicy.getForcePasswordChange()));
                continue;
            }
            if (!string.equals("NewPasswordMustDifferFromOldByNCharacters")) continue;
            if (bl) {
                if (!iDefaultsElement.isDirty()) continue;
                securityPolicy.setMinChangedCharsInPwd(Short.parseShort(string2));
                bl2 = true;
                continue;
            }
            iDefaultsElement.initValue(String.valueOf(securityPolicy.getMinChangedCharsInPwd()));
        }
        return bl2;
    }

    private boolean helpHandleUserLockoutPolicy(SecurityPolicy securityPolicy, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            String string2 = iDefaultsElement.getValue();
            if (string.equals("FailedLoginsAllowedBeforeLockout")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityPolicy.setLockoutThreshold(Integer.parseInt(string2));
                    bl2 = true;
                    continue;
                }
                iDefaultsElement.initValue(String.valueOf(securityPolicy.getLockoutThreshold()));
                continue;
            }
            if (string.equals("LockoutDuration")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityPolicy.setLockoutDuration(this.stringToLockoutDuration(string2));
                    bl2 = true;
                    continue;
                }
                iDefaultsElement.initValue(this.lockoutDurationToString(securityPolicy.getLockoutDuration()));
                continue;
            }
            if (!string.equals("ManualUnlockBySuperuser")) continue;
            if (bl) {
                if (!iDefaultsElement.isDirty()) continue;
                securityPolicy.setManualUnlock(this.stringToBool(string2));
                bl2 = true;
                continue;
            }
            iDefaultsElement.initValue(this.boolToString(securityPolicy.isManualUnlock()));
        }
        return bl2;
    }

    private void helpHandleNodeSecurityPolicy(IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        SecurityModel securityModel = (SecurityModel)this.nmd.getSecurityModel();
        SecurityPolicy securityPolicy = (SecurityPolicy)securityModel.getSecurityPolicy();
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string;
            String string2;
            IDefaultsElement iDefaultsElement;
            int n;
            IDefaultsNode[] iDefaultsNodeArray2;
            String string3 = iDefaultsNodeArray[i].getName();
            this.db.fine("helpHandleNodeSecurityPolicy():" + string3);
            if (string3.equals("idleUserTimeout")) {
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[n];
                    string2 = iDefaultsNodeArray2[n].getName();
                    string = iDefaultsElement.getValue();
                    for (int j = 0; j < SECURITY_LEVELS.length; ++j) {
                        if (!string2.equalsIgnoreCase(SECURITY_LEVELS[j])) continue;
                        if (bl) {
                            if (!iDefaultsElement.isDirty()) continue;
                            securityPolicy.setIdleTimeout(j, this.stringToIdleUserTimeout(string));
                            bl2 = true;
                            continue;
                        }
                        iDefaultsElement.initValue(this.idleUserTimeoutToString(securityPolicy.getIdleTimeout(j)));
                    }
                }
                continue;
            }
            if (string3.equals("passwordAging")) {
                bl2 |= this.helpHandlePasswordAgingPolicy(securityPolicy, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string3.equals("passwordChange")) {
                bl2 |= this.helpHandlePasswordChangePolicy(securityPolicy, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string3.equals("userLockout")) {
                bl2 |= this.helpHandleUserLockoutPolicy(securityPolicy, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (!string3.equals("other")) continue;
            iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[n];
                string2 = iDefaultsElement.getName();
                string = iDefaultsElement.getValue();
                if (string2.equals("DisableInactiveUser")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        securityPolicy.setDisableInactiveUserPolicyEnabled(iDefaultsElement.getEnumValue() == 1);
                        bl2 = true;
                        continue;
                    }
                    iDefaultsElement.initEnumValue(securityPolicy.getDisableInactiveUserPolicyEnabled() ? 1 : 0);
                    continue;
                }
                if (string2.equals("InactiveDuration")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        securityPolicy.setMaxInactiveDaysBeforeDisable(Integer.parseInt(iDefaultsElement.getValue()));
                        bl2 = true;
                        continue;
                    }
                    iDefaultsElement.initValue(String.valueOf(securityPolicy.getMaxInactiveDaysBeforeDisable()));
                    continue;
                }
                if (string2.equals("SingleSessionPerUser")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        securityPolicy.setSingleSessionPerUser(this.stringToBool(string));
                        bl2 = true;
                        continue;
                    }
                    iDefaultsElement.initValue(this.boolToString(securityPolicy.isSingleSessionPerUser()));
                    continue;
                }
                this.db.fine("Not a policy: passing off to node security");
                this.helpHandleNodeSecurity(iDefaultsElement, bl);
            }
        }
        if (bl && bl2) {
            securityModel.setSecurityPolicy(securityPolicy);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void handleNodeSecurity(IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        ArrayList<IDefaultsNode> arrayList = new ArrayList<IDefaultsNode>();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            this.db.fine("handleNodeSecurity(): " + string);
            if (string.equals("dataComm")) {
                if (bl) {
                    this.applyNodeSecureModeConfig(iDefaultsNodeArray[i].getChildren());
                    continue;
                }
                this.handleNodeSecureModeConfig(iDefaultsNodeArray[i].getChildren());
                continue;
            }
            if (string.equals("idleUserTimeout") || string.equals("passwordAging") || string.equals("passwordChange") || string.equals("userLockout") || string.equals("other")) {
                arrayList.add(iDefaultsNodeArray[i]);
                continue;
            }
            this.helpHandleNodeSecurity(iDefaultsNodeArray[i], bl);
        }
        if (arrayList.size() > 0) {
            this.helpHandleNodeSecurityPolicy(arrayList.toArray(new IDefaultsNode[arrayList.size()]), bl);
        }
    }

    private void handleNodeGeneral(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            if (string.equals("RaiseConditionOnEmptySlot")) {
                iDefaultsElement.initValue(this.boolToString(this.neDefaultsModel.getRaiseConditionOnEmptySlot()));
                continue;
            }
            if (string.equals("ReportLoopbackConditionsOnOOS-MTPorts") || string.equals("ReportLoopbackConditionsOnUnlocked,MaintenancePorts")) {
                iDefaultsElement.initEnumValue(this.neDefaultsModel.getShowLoopbackAlarmsOnPortsUndergoingMaintenance() ? 1 : 0);
                continue;
            }
            if (string.equals("SDPBER")) {
                short s = this.neDefaultsModel.getAisvOnSdpBerLevel();
                iDefaultsElement.initEnumValue(s);
                continue;
            }
            String string2 = "";
            if (string.equals("DefaultsDescription")) {
                string2 = this.neDefaultsModel.getDefDescription();
            } else if (string.equals("TimeZone")) {
                string2 = this.nmd.getCtcTimeZone().toString();
            } else if (string.equals("UseDST")) {
                string2 = this.boolToString(!this.nmd.getCtcTimeZone().isDSTDisabled());
            } else if (string.equals("NtpSntpServer")) {
                string2 = InetUtil.makeDottedString(this.nmd.getSntpHost());
            } else if (string.equals("InsertAISVOnSDP")) {
                string2 = this.boolToString(this.neDefaultsModel.getAisvOnSdp());
            } else {
                string2 = "UNKNOWN";
                this.db.severe("handleNodeGeneral: unknown general element= " + string);
            }
            iDefaultsElement.initValue(string2);
        }
    }

    private void handleTreelessDefaults(IDefaultsNode iDefaultsNode, boolean bl) throws Exception {
        if (iDefaultsNode != null) {
            IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
            if (iDefaultsNodeArray == null || iDefaultsNodeArray.length == 0) {
                DefaultsElement defaultsElement = (DefaultsElement)iDefaultsNode;
                if (defaultsElement.isDisplacedProperty()) {
                    this.handleClientDefaults(defaultsElement, bl);
                } else {
                    defaultsElement.handleChange(bl);
                }
            } else {
                for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                    this.handleTreelessDefaults(iDefaultsNodeArray[i], bl);
                }
            }
        }
    }

    private void handleNodeIPSettings(IDefaultsElement iDefaultsElement) throws Exception {
        String string = "";
        String string2 = iDefaultsElement.getName();
        if (string2.equals("CtcIpDisplaySuppression")) {
            string = this.boolToString(this.nmd.getCtcIpDisplaySuppression(true));
        } else if (string2.equals("LcdSetting")) {
            int n = this.nmd.getLcdIpSetting(true);
            string = 0 <= n && n < LcdIpSetting.LCD_IP_SETTING.length ? LcdIpSetting.LCD_IP_SETTING[n] : LcdIpSetting.LCD_IP_SETTING[0];
        } else {
            string = "UNKNOWN";
            this.db.severe("handleNodeIPSettings: unknown general element= " + string2);
        }
        iDefaultsElement.initValue(string);
    }

    private void handleNodePowerMonitor(IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = "";
            String string2 = iDefaultsNodeArray[i].getName();
            sPwrMonVoltage sPwrMonVoltage2 = this.neDefaultsModel.getDefPowerMonitor(eChassisVoltageType.V48);
            sPwrMonVoltage sPwrMonVoltage3 = this.neDefaultsModel.getDefPowerMonitor(eChassisVoltageType.V60);
            if (string2.equals("ELWBATVG") || string2.equals("ELWBATVG_48V")) {
                string = this.convertVoltage(sPwrMonVoltage2.ex_low_voltage);
            } else if (string2.equals("LWBATVG")) {
                string = this.convertVoltage(sPwrMonVoltage2.low_voltage);
            } else if (string2.equals("HIBATVG")) {
                string = this.convertVoltage(sPwrMonVoltage2.high_voltage);
            } else if (string2.equals("EHIBATVG") || string2.equals("EHIBATVG_48V")) {
                string = this.convertVoltage(sPwrMonVoltage2.ex_high_voltage);
            } else if (string2.equals("ELWBATVG_60V")) {
                string = this.convertVoltage(sPwrMonVoltage3.ex_low_voltage);
            } else if (string2.equals("EHIBATVG_60V")) {
                string = this.convertVoltage(sPwrMonVoltage3.ex_high_voltage);
            } else {
                string = "UNKNOWN";
                this.db.severe("unknown power monitor element");
            }
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            iDefaultsElement.initValue(string);
        }
    }

    private void helpHandleGatewaySettings(IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string = iDefaultsElement.getValue();
                if (!string.equals("LeaveAsIs")) {
                    if (this.nmd.isSecureMode() && (string.equals("ProxyOnlyNode") || string.equals("None"))) {
                        iDefaultsElement.makeClean();
                        throw new Exception(" When in secure mode, the node must be configured as a GNE or an ENE.");
                    }
                    ProxyXlator.setProxy(this.nmd, string);
                    string = ProxyXlator.getProxyStringOrStatus(this.nmd);
                    iDefaultsElement.setComment("As is: " + string);
                }
                iDefaultsElement.makeClean();
            }
        } else {
            String string = ProxyXlator.getProxyStringOrStatus(this.nmd);
            iDefaultsElement.setComment("As is: " + string);
            if (!string.equals("None") && string.equals(ProxyXlator.getProxyStatus(this.nmd))) {
                string = "LeaveAsIs";
            }
            iDefaultsElement.initValue(string);
        }
    }

    private void helpHandleAlarmMissingBackplaneLAN(IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        SecurityModel securityModel = (SecurityModel)this.nmd.getSecurityModel();
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string = iDefaultsElement.getValue();
                securityModel.setAlarmOnLostBackLanLink(this.stringToBool(string));
                iDefaultsElement.makeClean();
            }
        } else {
            iDefaultsElement.initValue(this.boolToString(securityModel.getAlarmOnLostBackLanLink()));
        }
    }

    private void handleNodeNetworkGeneral(IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleNodeNetworkGeneral: children size = " + iDefaultsNodeArray.length);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("GatewaySettings")) {
                this.helpHandleGatewaySettings((IDefaultsElement)iDefaultsNodeArray[i], bl);
                continue;
            }
            if (string.equals("AlarmMissingBackplaneLAN")) {
                this.helpHandleAlarmMissingBackplaneLAN((IDefaultsElement)iDefaultsNodeArray[i], bl);
                continue;
            }
            this.helpHandleNodeNetworkGeneralIPSettings((IDefaultsElement)iDefaultsNodeArray[i], bl);
        }
    }

    private void helpHandleAAAServerUseLocalDatabase(IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        RadiusServerModel radiusServerModel = this.nmd.getRadiusServerModel();
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                radiusServerModel.setUseLocalDatabase(iDefaultsElement.getEnumValue() == 1);
                iDefaultsElement.makeClean();
            }
        } else {
            iDefaultsElement.initEnumValue(radiusServerModel.getUseLocalDatabase() ? 1 : 0);
        }
    }

    private void handleNodeNetworkSecurity(IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleNodeNetworkSecurity: children size = " + iDefaultsNodeArray.length);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("ctc")) {
                this.handleTreelessDefaults(iDefaultsNodeArray[i], bl);
                continue;
            }
            DefaultsElement defaultsElement = (DefaultsElement)iDefaultsNodeArray[i];
            if (defaultsElement.isDisplacedProperty()) {
                this.handleTreelessDefaults(defaultsElement, bl);
                continue;
            }
            if (string.equals("EnableNodeAsFinalAuthenticator")) {
                this.helpHandleAAAServerUseLocalDatabase(defaultsElement, bl);
                continue;
            }
            this.db.severe("Unknown network security " + string);
        }
    }

    private void handleNodeRadiusServerList(IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        Object object;
        RadiusServer[] radiusServerArray = null;
        int n = 0;
        radiusServerArray = bl ? new RadiusServer[iDefaultsNodeArray.length] : RadiusServerModel.getInstance(this.nmd).getRadiusServerList();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string;
            object = iDefaultsNodeArray[i].getChildren();
            this.db.info("handleNodeRadiusServerList(): " + i + " " + iDefaultsNodeArray[i].getName());
            String string2 = string = "UNPROVISIONED";
            String string3 = "1812";
            String string4 = "1813";
            String string5 = "";
            if (!bl && i < radiusServerArray.length) {
                string2 = InetUtil.makeDottedString(radiusServerArray[i].getIpAddr());
                string3 = String.valueOf(radiusServerArray[i].getAuthPort());
                string4 = String.valueOf(radiusServerArray[i].getAcctPort());
                string5 = new String(radiusServerArray[i].getSecret());
            }
            for (int j = 0; j < ((Object)object).length; ++j) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)object[j];
                String string6 = iDefaultsElement.getName();
                String string7 = iDefaultsElement.getValue();
                this.db.info("handleNodeRadiusServerList(): " + iDefaultsElement.getName());
                if (string6.equals("IPAddress")) {
                    if (bl) {
                        string2 = iDefaultsElement.getValue();
                        continue;
                    }
                    iDefaultsElement.initValue(string2);
                    continue;
                }
                if (string6.equals("SharedSecret")) {
                    if (bl) {
                        string5 = iDefaultsElement.getValue();
                        continue;
                    }
                    iDefaultsElement.initValue(string5);
                    continue;
                }
                if (string6.equals("AuthenticationPort")) {
                    if (bl) {
                        string3 = iDefaultsElement.getValue();
                        continue;
                    }
                    iDefaultsElement.initValue(string3);
                    continue;
                }
                if (!string6.equals("AccountingPort")) continue;
                if (bl) {
                    string4 = iDefaultsElement.getValue();
                    continue;
                }
                iDefaultsElement.initValue(string4);
            }
            if (bl && !string2.equals(string)) {
                radiusServerArray[n++] = new RadiusServer(InetUtil.makeIpAddr(string2), Short.parseShort(string3), Short.parseShort(string4), string5.getBytes());
                continue;
            }
            this.db.info("nothing to do with " + string2 + " " + string3 + " " + string4 + " " + string5);
        }
        if (bl) {
            this.db.info("applying");
            RadiusServer[] radiusServerArray2 = new RadiusServer[n];
            System.arraycopy(radiusServerArray, 0, radiusServerArray2, 0, n);
            object = RadiusServerModel.getInstance(this.nmd);
            ((RadiusServerModel)object).deleteRadiusServerList();
            ((RadiusServerModel)object).setRadiusServerList(radiusServerArray2);
        }
    }

    private void handleNodeNetwork(IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleNodeNetwork: children size = " + iDefaultsNodeArray.length);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            this.db.fine("handleNodeNetwork: " + string);
            if (string.equals("general")) {
                this.handleNodeNetworkGeneral(iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.db.severe("Unknown node network level " + string);
        }
    }

    private void helpHandleNodeNetworkGeneralIPSettings(IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        this.db.fine("handleNodeIPAddressSettings:");
        if (bl) {
            this.applyNodeIPSettings(iDefaultsElement);
        } else {
            this.handleNodeIPSettings(iDefaultsElement);
        }
    }

    private void handleNodeTop(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        boolean bl = false;
        this.db.info("handleNodeTop: children size = " + iDefaultsNodeArray.length);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            this.db.fine("handleNodeTop: " + string);
            if (string.equals("general")) {
                this.handleNodeGeneral(iDefaultsNodeArray[i].getChildren());
                continue;
            }
            if (string.equals("lmp")) {
                this.handleNodeLmp(iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("osi")) {
                this.handleTreelessDefaults(iDefaultsNodeArray[i], bl);
                continue;
            }
            if (string.equals("powerMonitor")) {
                this.handleNodePowerMonitor(iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("network")) {
                this.handleNodeNetwork(iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("security")) {
                this.handleNodeSecurity(iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("timing")) {
                this.handleNodeTiming(iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string.equals("protection")) {
                this.handleNodeProtection(iDefaultsNodeArray[i].getChildren());
                continue;
            }
            if (string.equals("circuits")) {
                this.handleNodeCircuits(iDefaultsNodeArray[i].getChildren());
                continue;
            }
            if (string.startsWith("XTCDS")) {
                this.handleDSn(eEqType.XTC_CARD, this.getEqTypeFromName(string), iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.db.severe("Unknown general level " + string);
        }
    }

    private void handleClientDefaults(IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        String string = iDefaultsElement.getFullName();
        this.db.info("handleClientDefaults(): " + string);
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string2 = iDefaultsElement.isNumericallyEnumerated() ? String.valueOf(iDefaultsElement.getEnumValue()) : iDefaultsElement.getValue();
                this.neDefaultsModel.setClientDefault(string, string2);
                if (iDefaultsElement.getFullName().startsWith("CTC.")) {
                    this.notifyCtcDefaultsObservers(iDefaultsElement);
                }
                iDefaultsElement.makeClean();
            }
        } else {
            try {
                String string3 = this.neDefaultsModel.getClientDefault(string);
                if (iDefaultsElement.isNumericallyEnumerated()) {
                    iDefaultsElement.initEnumValue(Integer.parseInt(string3));
                } else {
                    iDefaultsElement.initValue(string3);
                }
            }
            catch (NoSuchDefault noSuchDefault) {
                iDefaultsElement.resetValue();
                this.db.fine("No such default " + string + " " + (Object)((Object)noSuchDefault));
            }
            catch (Exception exception) {
                this.db.severe("Can't retrieve the default for " + string + " " + exception);
            }
        }
    }

    private void notifyCtcDefaultsObservers(IDefaultsNode iDefaultsNode) {
        try {
            String string = iDefaultsNode.getFullName();
            if (string.equals("CTC.network.Map")) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNode;
                NetworkMapUtil.changeNetworkMap(iDefaultsElement.getValue());
            }
        }
        catch (Exception exception) {
            this.db.severe("notifyCtcDefaultsObservers(): " + exception.toString());
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private void handleNode(IDefaultsNode iDefaultsNode, boolean bl, ArrayList arrayList) throws Exception {
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        this.db.fine("Starting handleNode on " + this.nmd.getName() + ", " + iDefaultsNodeArray.length + " children, applying? " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsNode iDefaultsNode2 = iDefaultsNodeArray[i];
            String string = iDefaultsNode2.getName();
            if (bl && !iDefaultsNode2.isDirty()) {
                this.db.info(string + " is clean... continuing...");
                continue;
            }
            this.db.fine("Current name : " + string);
            try {
                if (string.startsWith("NODE")) {
                    if (bl) {
                        this.applyToNodeTop(iDefaultsNode2.getChildren());
                        continue;
                    }
                    this.handleNodeTop(iDefaultsNode2.getChildren());
                    continue;
                }
                if (string.startsWith("CTC")) {
                    this.handleTreelessDefaults(iDefaultsNode2, bl);
                    continue;
                }
                eEqType eEqType2 = this.getEqTypeFromName(string);
                if (string.startsWith("CTX") || string.equals("DS3-EC1-48") || string.equals("DS1-E1-56") || string.equals("DS3-EC1-6") || string.equals("DS1-28-DS3-EC1-3") || string.equals("DS1-84-DS3-EC1-3")) {
                    this.handleCtx(eEqType2, iDefaultsNode2.getChildren(), bl);
                    continue;
                }
                if (string.startsWith("DS") || string.startsWith("E1") || string.startsWith("E3")) {
                    this.handleDSn(eEqType2, this.getPortTypeForCard(eEqType2), iDefaultsNode2.getChildren(), bl);
                    continue;
                }
                if (string.startsWith("XTCDS")) {
                    this.handleDSn(eEqType.XTC_CARD, this.getEqTypeFromName(string), iDefaultsNode2.getChildren(), bl);
                    continue;
                }
                if (string.startsWith("EC") || string.startsWith("OC") || string.startsWith("ST") || string.startsWith("OSC")) {
                    this.handleOCn(eEqType2, this.getPortTypeForCard(eEqType2), iDefaultsNode2.getChildren(), bl);
                    continue;
                }
                if (string.startsWith("MXP") || string.startsWith("TXP")) {
                    this.handleDwdm(eEqType2, iDefaultsNode2.getChildren(), bl);
                    continue;
                }
                if (string.startsWith("OPT")) {
                    this.handleOpt(eEqType2, iDefaultsNode2.getChildren(), bl);
                    continue;
                }
                if (string.startsWith("ASAP") || string.startsWith("MRC")) {
                    this.handleMrc(eEqType2, iDefaultsNode2.getChildren(), bl);
                    continue;
                }
                if (string.startsWith("FC-MR")) {
                    this.handleFcmr(eEqType2, iDefaultsNode2.getChildren(), bl);
                    continue;
                }
                if (string.equals("RAN-SVC")) {
                    this.handleRanSvc(eEqType2, iDefaultsNode2.getChildren(), bl);
                    continue;
                }
                if (string.startsWith("ML100") || string.startsWith("ML-100")) {
                    this.handleMl(eEqType2, iDefaultsNode2.getChildren(), bl);
                    continue;
                }
                if (string.equals("CE-100T-8")) {
                    this.handleML2Mapper(eEqType2, iDefaultsNode2.getChildren(), bl);
                    continue;
                }
                if (string.equals("CE-1000-4")) {
                    this.handleCE1000(eEqType2, iDefaultsNode2.getChildren(), bl);
                    continue;
                }
                if (string.equals("G1000")) {
                    this.handleG1000(eEqType2, this.getPortTypeForCard(eEqType2), iDefaultsNode2.getChildren(), bl);
                    continue;
                }
                this.db.severe("Unknown card = " + string);
                continue;
            }
            catch (Exception exception) {
                if (arrayList == null) {
                    throw exception;
                }
                arrayList.add(string + ": " + exception);
                if (!this.db.isSevereEnabled()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void resetFromNode(IDefaultsNode iDefaultsNode) throws Exception {
        iDefaultsNode.resetDirty();
        this.pendingApplications.clear();
        ArrayList arrayList = new ArrayList();
        this.handleNode(iDefaultsNode, false, arrayList);
        if (arrayList.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer("Failed to load the following:\n");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next() + "\n");
            }
            throw new Exception(stringBuffer.toString());
        }
    }

    public void applyToNode(IDefaultsNode iDefaultsNode) throws Exception {
        this.handleNode(iDefaultsNode, true, null);
    }

    private eEqType getPortTypeForCard(eEqType eEqType2) {
        eEqType eEqType3 = eEqType.INVALID;
        if (eEqType2 != null) {
            switch (eEqType2.value()) {
                case 4: {
                    eEqType3 = eEqType.DS1_VT_MAPPED;
                    break;
                }
                case 218: {
                    eEqType3 = eEqType.DS1_VT_MAPPED;
                    break;
                }
                case 6: {
                    eEqType3 = eEqType.DS3;
                    break;
                }
                case 185: {
                    eEqType3 = eEqType.DS3;
                    break;
                }
                case 57: {
                    eEqType3 = eEqType.DS3;
                    break;
                }
                case 66: {
                    eEqType3 = eEqType.DS3I_PORT;
                    break;
                }
                case 8: 
                case 145: {
                    eEqType3 = eEqType.DS3_TRANS_MUX;
                    break;
                }
                case 83: {
                    eEqType3 = eEqType.E1_PORT;
                    break;
                }
                case 108: {
                    eEqType3 = eEqType.E1_PORT;
                    break;
                }
                case 65: {
                    eEqType3 = eEqType.E3_PORT;
                    break;
                }
                case 12: {
                    eEqType3 = eEqType.EC1_PORT;
                    break;
                }
                case 9: {
                    eEqType3 = eEqType.OC3_PORT;
                    break;
                }
                case 124: {
                    eEqType3 = eEqType.OC3_PORT;
                    break;
                }
                case 106: {
                    eEqType3 = eEqType.OC3_PORT;
                    break;
                }
                case 10: {
                    eEqType3 = eEqType.OC12_PORT;
                    break;
                }
                case 85: {
                    eEqType3 = eEqType.OC12_PORT;
                    break;
                }
                case 11: {
                    eEqType3 = eEqType.OC48_PORT;
                    break;
                }
                case 126: {
                    eEqType3 = eEqType.OC48_PORT;
                    break;
                }
                case 87: {
                    eEqType3 = eEqType.OC48_PORT;
                    break;
                }
                case 127: {
                    eEqType3 = eEqType.OC3_PORT;
                    break;
                }
                case 128: {
                    eEqType3 = eEqType.OC3_PORT;
                    break;
                }
                case 60: 
                case 220: {
                    eEqType3 = eEqType.OC192_PORT;
                    break;
                }
                case 86: {
                    eEqType3 = eEqType.OC192_PORT;
                    break;
                }
                case 113: {
                    eEqType3 = eEqType.STM1E_PORT;
                    break;
                }
                case 14: {
                    eEqType3 = eEqType.ETHER_10_100_T;
                    break;
                }
                case 15: {
                    eEqType3 = eEqType.ETHER_1000_F;
                    break;
                }
                case 52: {
                    eEqType3 = eEqType.VIC_ENCODER_PORT;
                    break;
                }
                case 62: {
                    eEqType3 = eEqType.ETHER_1000_HDGE;
                    break;
                }
                case 143: {
                    eEqType3 = eEqType.FCMR_PORT;
                    break;
                }
                case 102: 
                case 103: 
                case 221: 
                case 238: {
                    eEqType3 = eEqType.L2SC_ETHER_PORT;
                    break;
                }
                case 47: {
                    eEqType3 = eEqType.INVALID;
                    break;
                }
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 146: 
                case 157: 
                case 219: {
                    eEqType3 = eEqType.INVALID;
                    if (!this.db.on()) break;
                    this.db.println("getPortTypeForCard: port type ambiguous for eEqType= " + eEqType2.value());
                    break;
                }
                case 37: 
                case 53: 
                case 160: {
                    eEqType3 = eEqType.UNKNOWN;
                    if (!this.db.on()) break;
                    this.db.println("getPortTypeForCard: port type unknown for eEqType= " + eEqType2.value());
                    break;
                }
                default: {
                    if (!this.db.on()) break;
                    this.db.severe("getPortTypeForCard: unknown/unsupported eEqType = " + eEqType2.value());
                }
            }
        }
        return eEqType3;
    }

    private eEqType getMrcPortTypeFromName(String string) {
        eEqType eEqType2 = eEqType.INVALID;
        if (string.equals("oc3") || string.equals("stm1")) {
            eEqType2 = eEqType.OC3_PORT;
        } else if (string.equals("oc12") || string.equals("stm4")) {
            eEqType2 = eEqType.OC12_PORT;
        } else if (string.equals("oc48") || string.equals("stm16")) {
            eEqType2 = eEqType.OC48_PORT;
        } else if (string.equals("oc192") || string.equals("stm64")) {
            eEqType2 = eEqType.OC192_PORT;
        } else if (string.equals("ether")) {
            eEqType2 = eEqType.L1P_ETHER_PORT;
        } else {
            this.db.severe("getMrcPortTypeFromName: unexpected port eEqType= " + eEqType2.value());
        }
        return eEqType2;
    }

    private void handleNodeLmpGeneral(IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleNodeLmpGeneral: children size = " + iDefaultsNodeArray.length);
        LmpModel lmpModel = LmpModel.getInstance(this.nmd);
        sProductConfigAttrs sProductConfigAttrs2 = new sProductConfigAttrs(lmpModel.isEnabled(), lmpModel.isWdm(), lmpModel.getWdmRole(), lmpModel.getLocalNodeId());
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            if (string.equals("Allowed")) {
                this.handleTreelessDefaults(iDefaultsElement, bl);
                continue;
            }
            if (string.equals("Enabled")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    bl2 = true;
                    sProductConfigAttrs2.enabled = iDefaultsElement.getEnumValue() == 1;
                    continue;
                }
                iDefaultsElement.initEnumValue(sProductConfigAttrs2.enabled ? 1 : 0);
                continue;
            }
            if (string.equals("LMP-WDM")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    bl2 = true;
                    sProductConfigAttrs2.wdm = iDefaultsElement.getEnumValue() == 1;
                    continue;
                }
                iDefaultsElement.initEnumValue(sProductConfigAttrs2.wdm ? 1 : 0);
                continue;
            }
            if (!string.equals("Role")) continue;
            if (bl) {
                if (!iDefaultsElement.isDirty()) continue;
                bl2 = true;
                sProductConfigAttrs2.wdm_role = eWdmRoleType.from_int(iDefaultsElement.getEnumValue());
                continue;
            }
            iDefaultsElement.initEnumValue(sProductConfigAttrs2.wdm_role.value());
        }
        if (bl && bl2) {
            lmpModel.set(sProductConfigAttrs2);
        }
    }

    private void handleNodeLmp(IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.fine("handleNodeLmp: children size = " + iDefaultsNodeArray.length);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            this.db.fine("handleNodeLmp: " + string);
            if (string.equals("general")) {
                this.handleNodeLmpGeneral(iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.handleTreelessDefaults(iDefaultsNodeArray[i], bl);
        }
    }
}

