/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ucp;

import cerent.cms.idl.Circuits.eCircuitSize;
import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Ucp.sTnaAddr;
import cerent.cms.idl.Ucp.xInvalidParams;
import cerent.cms.idl.UcpCircuits.eCircuitState;
import cerent.cms.idl.UcpCircuits.sCircuitOrigin;
import cerent.cms.idl.UcpCircuits.sEgressLabel;
import cerent.cms.idl.UcpCircuits.sLabel;
import cerent.cms.idl.UcpCircuits.xCircuitIdInUse;
import cerent.cms.idl.UcpCircuits.xLabelInUse;
import cerent.cms.idl.UcpCircuits.xNoMoreCircuitOrigins;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CircuitIdStillInUse;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.InvalidParams;
import cerent.cms.model.LabelInUse;
import cerent.cms.model.NoMoreCircuitOrigins;
import cerent.cms.model.NoSuchCircuitOrigin;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ucp.AbstractUcpCircuitModel;
import cerent.cms.model.ucp.AbstractUcpContainers;
import cerent.cms.model.ucp.EgressLabelFactory;
import cerent.cms.model.ucp.IEgressLabel;
import cerent.cms.model.ucp.ILabel;
import cerent.cms.model.ucp.ITnaAddr;
import cerent.cms.model.ucp.IUcpCircuitOriginModel;
import cerent.cms.model.ucp.LabelFactory;
import cerent.cms.model.ucp.TnaAddrFactory;
import cerent.cms.model.ucp.UcpCircuitOriginModel;
import cerent.cms.model.ucp.UcpCircuits;
import cerent.util.AnnotatedException;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class UcpCircuitOrigins
extends AbstractUcpContainers
implements Observer {
    private static final String MY_DEBUG_KEY = "UcpCircuitOrigins";
    private OriginsList originsList;
    private CreateOrigin createOrigin;

    public UcpCircuitOrigins(NodeModelDelegate nodeModelDelegate, UcpCircuits ucpCircuits) {
        super(nodeModelDelegate, nodeModelDelegate.getDebug());
        this.db = new UcpCircuitOriginsDebug(nodeModelDelegate.getDebug());
        this.originsList = new OriginsList(nodeModelDelegate, "UcpCircuitOrigins::originsList");
        this.createOrigin = new CreateOrigin(nodeModelDelegate, "UcpCircuitOrigins::createOrigin");
    }

    public UcpCircuitOriginModel add(ICircuitId iCircuitId, int n, ITnaAddr iTnaAddr, int n2, boolean bl, short s, short s2, ILabel iLabel, IEgressLabel iEgressLabel, short s3, int n3) throws LabelInUse, CircuitIdStillInUse, NoMoreCircuitOrigins, InvalidParams {
        Object object;
        sCircuitId sCircuitId2 = null;
        sTnaAddr sTnaAddr2 = null;
        sLabel sLabel2 = null;
        sEgressLabel sEgressLabel2 = null;
        if (iCircuitId != null) {
            sCircuitId2 = CircuitIdFactory.getCircuitId(iCircuitId);
        }
        if (iTnaAddr != null) {
            sTnaAddr2 = TnaAddrFactory.getTnaAddr(iTnaAddr);
        }
        if (iLabel != null) {
            sLabel2 = LabelFactory.getLabel(iLabel);
        }
        if (iEgressLabel != null) {
            sEgressLabel2 = EgressLabelFactory.getEgressLabel(iEgressLabel);
        }
        sCircuitOrigin sCircuitOrigin2 = new sCircuitOrigin(0, sCircuitId2, n, sTnaAddr2, eCircuitSize.from_int(n2), bl, s, s2, sLabel2, sEgressLabel2, s3, eCircuitState.from_int(n3));
        try {
            object = new Object[]{sCircuitOrigin2};
            sCircuitOrigin2.objIndex = (Integer)this.createOrigin.get(object);
        }
        catch (xLabelInUse xLabelInUse2) {
            throw new LabelInUse(AnnotatedException.getString((Exception)((Object)xLabelInUse2)));
        }
        catch (xCircuitIdInUse xCircuitIdInUse2) {
            throw new CircuitIdStillInUse(AnnotatedException.getString((Exception)((Object)xCircuitIdInUse2)));
        }
        catch (xNoMoreCircuitOrigins xNoMoreCircuitOrigins2) {
            throw new NoMoreCircuitOrigins(AnnotatedException.getString((Exception)((Object)xNoMoreCircuitOrigins2)));
        }
        catch (xInvalidParams xInvalidParams2) {
            throw new InvalidParams(AnnotatedException.getString((Exception)((Object)xInvalidParams2)));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        if (this.db.on()) {
            this.db.println("UcpCircuitOriginModel created with index = " + sCircuitOrigin2.objIndex);
        }
        object = new UcpCircuitOriginModel(this.node, this, sCircuitOrigin2, this.db);
        ((AbstractUcpCircuitModel)object).init();
        this.itemsByIndex.put(new Integer(sCircuitOrigin2.objIndex), object);
        this.createProcessed = true;
        return object;
    }

    public IUcpCircuitOriginModel getCircuitOriginByIndex(int n) throws NoSuchCircuitOrigin {
        UcpCircuitOriginModel ucpCircuitOriginModel = (UcpCircuitOriginModel)this.itemsByIndex.get(new Integer(n));
        if (ucpCircuitOriginModel == null) {
            throw new NoSuchCircuitOrigin("objIndex = " + n + " not found.");
        }
        return ucpCircuitOriginModel;
    }

    public IUcpCircuitOriginModel[] getCircuitOriginList() {
        IUcpCircuitOriginModel[] iUcpCircuitOriginModelArray = new UcpCircuitOriginModel[this.itemsByIndex.values().size()];
        iUcpCircuitOriginModelArray = this.itemsByIndex.values().toArray(iUcpCircuitOriginModelArray);
        return iUcpCircuitOriginModelArray;
    }

    public void init() {
        super.init();
        this.discover(this.itemsByIndex);
        Iterator iterator = this.itemsByIndex.values().iterator();
        while (iterator.hasNext()) {
            ((UcpCircuitOriginModel)iterator.next()).init();
        }
    }

    private void discover(Map map) {
        sCircuitOrigin[] sCircuitOriginArray = null;
        sCircuitOriginArray = this.getOrigins();
        if (sCircuitOriginArray == null) {
            this.db.println("Error in getting UcpNeighbors (null) UcpNeighbors::discover");
            return;
        }
        for (int i = 0; i < sCircuitOriginArray.length; ++i) {
            if (sCircuitOriginArray[i] == null) continue;
            Integer n = new Integer(sCircuitOriginArray[i].objIndex);
            UcpCircuitOriginModel ucpCircuitOriginModel = new UcpCircuitOriginModel(this.node, this, sCircuitOriginArray[i], this.db);
            map.put(n, ucpCircuitOriginModel);
        }
    }

    private sCircuitOrigin[] getOrigins() {
        sCircuitOrigin[] sCircuitOriginArray = new sCircuitOrigin[]{};
        try {
            sCircuitOriginArray = (sCircuitOrigin[])this.originsList.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
        return sCircuitOriginArray;
    }

    private void discoverOrigins(HashMap hashMap) {
        sCircuitOrigin[] sCircuitOriginArray = this.getOrigins();
        if (sCircuitOriginArray == null) {
            return;
        }
        for (int i = 0; i < sCircuitOriginArray.length; ++i) {
            hashMap.put(new Integer(sCircuitOriginArray[i].objIndex), sCircuitOriginArray[i]);
        }
    }

    protected ObjectType getObjectType() {
        return ObjectType.ObjectUcpOriginList;
    }

    protected boolean updateStructure() {
        UcpCircuitOriginModel ucpCircuitOriginModel;
        Object object;
        Object object2;
        if (this.db.on()) {
            this.db.println("Entry::UcpCircuitOrigins::updateUcpCircuitOriginsStructure()");
        }
        HashMap hashMap = new HashMap();
        boolean bl = false;
        this.discoverOrigins(hashMap);
        Collection collection = UcpCircuitOrigins.getAddedObjects(hashMap.keySet(), this.itemsByIndex.keySet());
        Iterator iterator = collection.iterator();
        if (collection.size() > 0) {
            while (iterator.hasNext()) {
                object2 = (Integer)iterator.next();
                if (this.db.on()) {
                    this.db.println("New origin found # " + collection.size());
                    this.db.println(" Origin # " + object2);
                }
                object = (sCircuitOrigin)hashMap.get(object2);
                ucpCircuitOriginModel = new UcpCircuitOriginModel(this.node, this, (sCircuitOrigin)object, this.db);
                this.itemsByIndex.put(object2, ucpCircuitOriginModel);
                ucpCircuitOriginModel.init();
            }
            bl = true;
        }
        if (this.createProcessed) {
            bl = true;
            this.createProcessed = false;
        }
        if ((object2 = UcpCircuitOrigins.getDeletedObjects(hashMap.keySet(), this.itemsByIndex.keySet())).size() > 0) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Integer)iterator.next();
                if (this.db.on()) {
                    this.db.println("Deleted origin found # " + object2.size());
                    this.db.println("Deleted origin index " + object);
                }
                if ((ucpCircuitOriginModel = (UcpCircuitOriginModel)this.itemsByIndex.get(object)) == null) continue;
                this.itemsByIndex.remove(object);
            }
        }
        if (this.db.on()) {
            this.db.println("Exit::UcpCircuitOrigins::updateUcpCircuitOriginsStructure()");
        }
        return bl;
    }

    public void remove(UcpCircuitOriginModel ucpCircuitOriginModel) {
        this.itemsByIndex.remove(new Integer(ucpCircuitOriginModel.getIndex()));
    }

    protected void disposeItems(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                ((UcpCircuitOriginModel)iterator.next()).dispose();
            }
            catch (Exception exception) {
                this.db.println("Exception caught while deleting circuit " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected void printUcpCircuitOriginString(SDebug sDebug) {
        if (this.itemsByIndex == null || this.itemsByIndex.size() == 0) {
            sDebug.println("No UcpCircuitOriginModel's contained in UcpCircuitOrigins");
            return;
        }
        sDebug.println("UCPCIRCUITORIGINS total size: " + this.itemsByIndex.values().size());
        Iterator iterator = this.itemsByIndex.values().iterator();
        while (iterator.hasNext()) {
            try {
                UcpCircuitOriginModel ucpCircuitOriginModel = (UcpCircuitOriginModel)iterator.next();
                sDebug.println("===============================================");
                ucpCircuitOriginModel.printString(sDebug);
            }
            catch (Exception exception) {
                sDebug.println("Got Exception " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public class UcpCircuitOriginsDebug
    extends SDebug {
        UcpCircuitOriginsDebug(KDebug kDebug) {
            super(kDebug, UcpCircuitOrigins.MY_DEBUG_KEY);
        }

        public final void dumpAllUcpCircuitOriginModels() {
            UcpCircuitOrigins.this.printUcpCircuitOriginString(this);
        }
    }

    private class CreateOrigin
    extends NonCachedValue {
        public CreateOrigin(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return new Integer(this.node.getIorRepository().getUcpCircuitOriginsRef().create((sCircuitOrigin)objectArray[0]));
        }

        public Object outer() {
            return UcpCircuitOrigins.this;
        }
    }

    private class OriginsList
    extends NonCachedValue {
        public OriginsList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getUcpCircuitOriginsRef().getCircuitOrigins();
        }

        public Object outer() {
            return UcpCircuitOrigins.this;
        }
    }
}

