/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ucp;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Ucp.sNeighbor;
import cerent.cms.idl.Ucp.xInvalidParams;
import cerent.cms.idl.Ucp.xNoMoreNeighbors;
import cerent.cms.idl.Ucp.xObjDuplicate;
import cerent.cms.model.InvalidParams;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NoMoreNeighbors;
import cerent.cms.model.NoSuchNeighbor;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.ucp.AbstractUcpContainers;
import cerent.cms.model.ucp.UcpNeighborModel;
import cerent.util.AnnotatedException;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.omg.CORBA.UserException;

public class UcpNeighbors
extends AbstractUcpContainers {
    private static final String MY_DEBUG_KEY = "UcpNeighbors";
    private NeighborsList neighborsList;
    private CreateNeighbor createNeighbor;
    private static ModelSingletonCollection ucpNeighborsSingletons;

    public static synchronized UcpNeighbors getInstance(NodeModelDelegate nodeModelDelegate) {
        UcpNeighbors ucpNeighbors;
        if (ucpNeighborsSingletons == null) {
            ucpNeighborsSingletons = ModelSingletonCollection.getMSCInstanceByName((String)MY_DEBUG_KEY);
        }
        if ((ucpNeighbors = (UcpNeighbors)ucpNeighborsSingletons.get((Object)nodeModelDelegate)) == null) {
            ucpNeighbors = new UcpNeighbors(nodeModelDelegate);
            ucpNeighborsSingletons.add((Object)nodeModelDelegate, (Object)ucpNeighbors);
        }
        return ucpNeighbors;
    }

    private UcpNeighbors(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate, nodeModelDelegate.getDebug());
        this.neighborsList = new NeighborsList(nodeModelDelegate, "Neighbors::neighborsList");
        this.createNeighbor = new CreateNeighbor(nodeModelDelegate, "Neighbors::createNeighbor");
        this.db = new UcpNeighborsDebug(nodeModelDelegate.getDebug());
    }

    public UcpNeighborModel create(sNeighbor sNeighbor2) throws ObjDuplicate, InvalidParams, NoMoreNeighbors {
        Object object;
        int n = -1;
        try {
            object = new Object[]{sNeighbor2};
            n = (short)((Integer)this.createNeighbor.get(object)).intValue();
        }
        catch (xObjDuplicate xObjDuplicate2) {
            throw new ObjDuplicate(AnnotatedException.getString((Exception)((Object)xObjDuplicate2)));
        }
        catch (xInvalidParams xInvalidParams2) {
            throw new InvalidParams(AnnotatedException.getString((Exception)((Object)xInvalidParams2)));
        }
        catch (xNoMoreNeighbors xNoMoreNeighbors2) {
            throw new NoMoreNeighbors(AnnotatedException.getString((Exception)((Object)xNoMoreNeighbors2)));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        if (n != -1) {
            if (this.db.on()) {
                this.db.println("UcpNeighborModel created with index = " + n);
            }
            sNeighbor2.index = (short)n;
            object = new UcpNeighborModel(this.node, this, sNeighbor2, null);
            ((UcpNeighborModel)object).init();
            this.itemsByIndex.put(new Integer(n), object);
            this.createProcessed = true;
            return object;
        }
        if (this.db.on()) {
            this.db.println("UcpNeighborModel unabled to be created (index == -1)");
        }
        return null;
    }

    public UcpNeighborModel getNeighborByIndex(short s) throws NoSuchNeighbor {
        UcpNeighborModel ucpNeighborModel = (UcpNeighborModel)this.itemsByIndex.get(new Integer(s));
        if (ucpNeighborModel == null) {
            throw new NoSuchNeighbor("neighbor index = " + s + " not found.");
        }
        return ucpNeighborModel;
    }

    public UcpNeighborModel[] getNeighborsList() {
        UcpNeighborModel[] ucpNeighborModelArray = new UcpNeighborModel[this.itemsByIndex.values().size()];
        ucpNeighborModelArray = this.itemsByIndex.values().toArray(ucpNeighborModelArray);
        return ucpNeighborModelArray;
    }

    public void init() {
        super.init();
        this.discover(this.itemsByIndex);
        Iterator iterator = this.itemsByIndex.values().iterator();
        while (iterator.hasNext()) {
            ((UcpNeighborModel)iterator.next()).init();
        }
    }

    private void discover(Map map) {
        sNeighbor[] sNeighborArray = null;
        sNeighborArray = this.getNeighbors();
        if (sNeighborArray == null) {
            this.db.println("Error in getting UcpNeighbors (null) UcpNeighbors::discover");
            return;
        }
        for (int i = 0; i < sNeighborArray.length; ++i) {
            if (sNeighborArray[i] == null) continue;
            Integer n = new Integer(sNeighborArray[i].index);
            map.put(n, new UcpNeighborModel(this.node, this, sNeighborArray[i], null));
        }
    }

    private sNeighbor[] getNeighbors() {
        sNeighbor[] sNeighborArray = new sNeighbor[]{};
        try {
            sNeighborArray = (sNeighbor[])this.neighborsList.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
        return sNeighborArray;
    }

    private void discoverNeighbors(HashMap hashMap) {
        sNeighbor[] sNeighborArray = this.getNeighbors();
        if (sNeighborArray == null) {
            return;
        }
        for (int i = 0; i < sNeighborArray.length; ++i) {
            hashMap.put(new Integer(sNeighborArray[i].index), sNeighborArray[i]);
        }
    }

    protected ObjectType getObjectType() {
        return ObjectType.ObjectUcpNeighborList;
    }

    protected boolean updateStructure() {
        UcpNeighborModel ucpNeighborModel;
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        boolean bl = false;
        this.discoverNeighbors(hashMap);
        Collection collection = UcpNeighbors.getAddedObjects(hashMap.keySet(), this.itemsByIndex.keySet());
        Iterator iterator = collection.iterator();
        if (collection.size() > 0) {
            while (iterator.hasNext()) {
                object2 = (Integer)iterator.next();
                object = (sNeighbor)hashMap.get(object2);
                ucpNeighborModel = new UcpNeighborModel(this.node, this, (sNeighbor)object, null);
                this.itemsByIndex.put(object2, ucpNeighborModel);
                ucpNeighborModel.init();
            }
            bl = true;
        }
        if (this.createProcessed) {
            bl = true;
            this.createProcessed = false;
        }
        if ((object2 = UcpNeighbors.getDeletedObjects(hashMap.keySet(), this.itemsByIndex.keySet())).size() > 0) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Integer)iterator.next();
                ucpNeighborModel = (UcpNeighborModel)this.itemsByIndex.get(object);
                if (ucpNeighborModel == null) continue;
                this.itemsByIndex.remove(object);
            }
        }
        return bl;
    }

    public void remove(UcpNeighborModel ucpNeighborModel) {
        this.itemsByIndex.remove(new Integer(ucpNeighborModel.getNbrIndex()));
    }

    protected void disposeItems(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                ((UcpNeighborModel)iterator.next()).dispose();
            }
            catch (Exception exception) {}
        }
    }

    protected void printUcpNeighborString(SDebug sDebug) {
        if (this.itemsByIndex == null || this.itemsByIndex.size() == 0) {
            sDebug.println("No UcpNeighborModel's contained in UcpNeighbors");
            return;
        }
        sDebug.println("UCPNEIGHBORS total size: " + this.itemsByIndex.values().size());
        Iterator iterator = this.itemsByIndex.values().iterator();
        while (iterator.hasNext()) {
            try {
                UcpNeighborModel ucpNeighborModel = (UcpNeighborModel)iterator.next();
                sDebug.println("===============================================");
                ucpNeighborModel.printString(sDebug);
            }
            catch (Exception exception) {
                sDebug.println("Got Exception " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public class UcpNeighborsDebug
    extends SDebug {
        UcpNeighborsDebug(KDebug kDebug) {
            super(kDebug, UcpNeighbors.MY_DEBUG_KEY);
        }

        public final void dumpAllUcpNeighborModels() {
            UcpNeighbors.this.printUcpNeighborString(this);
        }
    }

    private class CreateNeighbor
    extends NonCachedValue {
        public CreateNeighbor(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return new Integer(this.node.getIorRepository().getUcpNeighborsRef().create((sNeighbor)objectArray[0]));
        }

        public Object outer() {
            return UcpNeighbors.this;
        }
    }

    private class NeighborsList
    extends NonCachedValue {
        public NeighborsList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getUcpNeighborsRef().getNeighbors();
        }

        public Object outer() {
            return UcpNeighbors.this;
        }
    }
}

