/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Ds123Media.eThresholdType;
import cerent.cms.idl.Dwdm.eDataRate;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.FramingType;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.nedefaults.DefaultsManager;
import cerent.cms.model.nedefaults.ValueAccessor;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDHTDMTerminology;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractValidatingTableModel
extends AbstractTableModel {
    protected NodeModelDelegate node;
    protected DefaultsManager validationManager;
    private SDebug db;

    protected AbstractValidatingTableModel(NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        this.node = nodeModelDelegate;
        this.db = sDebug;
        this.validationManager = null;
    }

    private String lineTypeToStr(InterfaceModel interfaceModel) {
        String string = "unknown";
        IPortModel iPortModel = null;
        try {
            iPortModel = interfaceModel.getPortModel();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.severe(abstractCmsNoSuchEntityException.toString());
            return string;
        }
        IEntityModel iEntityModel = iPortModel.getParent();
        if ((iEntityModel.getEqType() == 150 || iEntityModel.getEqType() == 193) && (iEntityModel = iEntityModel.getParent()) != null && iEntityModel.getEqType() == 149) {
            iEntityModel = iEntityModel.getParent();
        }
        block2 : switch (iEntityModel.getEqType()) {
            case 118: 
            case 119: 
            case 181: 
            case 182: {
                if (iPortModel.getEqType() == 123) {
                    string = "pmthresholds.trunk";
                    break;
                }
                string = "pmthresholds.client";
                break;
            }
            case 120: 
            case 121: {
                InterfaceModel[] interfaceModelArray = null;
                interfaceModelArray = interfaceModel.getLowerLayerModels();
                eDataRate eDataRate2 = null;
                try {
                    eDataRate2 = eDataRate.from_int(((AbstractDwdmLineModel)interfaceModelArray[0]).getDataRate());
                }
                catch (NoSuchInterface noSuchInterface) {
                    this.db.severe(noSuchInterface.toString());
                    return string;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    this.db.severe(wrongInterfaceType.toString());
                    return string;
                }
                int n = interfaceModel.getNodeModel().getFramingType();
                boolean bl = FramingType.getFramingType((int)n).isSdh();
                switch (eDataRate2.value()) {
                    case 0: 
                    case 4: {
                        if (bl) {
                            string = "pmthresholds.stm1";
                            break block2;
                        }
                        string = "pmthresholds.oc3";
                        break block2;
                    }
                    case 1: 
                    case 5: {
                        if (bl) {
                            string = "pmthresholds.stm4";
                            break block2;
                        }
                        string = "pmthresholds.oc12";
                        break block2;
                    }
                    case 2: 
                    case 6: {
                        if (bl) {
                            string = "pmthresholds.stm16";
                            break block2;
                        }
                        string = "pmthresholds.oc48";
                        break block2;
                    }
                }
                this.db.severe("Unexpected data rate " + eDataRate2.value());
                break;
            }
            case 183: 
            case 184: {
                int n = interfaceModel.getNodeModel().getFramingType();
                boolean bl = FramingType.getFramingType((int)n).isSdh();
                if (bl) {
                    string = "pmthresholds.sdh";
                    break;
                }
                string = "pmthresholds.sonet";
                break;
            }
            default: {
                string = "pmthresholds";
            }
        }
        return string;
    }

    private String doSomethingHorrible(InterfaceModel interfaceModel) {
        String string = "sts";
        int n = 0;
        int n2 = 0;
        if (interfaceModel instanceof TdmHoModel) {
            HoPathDefModel hoPathDefModel = ((TdmHoModel)interfaceModel).getHoPathDefModel();
            n = hoPathDefModel == null ? 1 : (int)hoPathDefModel.getPathWidth();
            IPortModel iPortModel = null;
            try {
                iPortModel = interfaceModel.getPortModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.severe("doSomethingHorrible(): " + abstractCmsNoSuchEntityException.toString());
            }
            if (iPortModel != null) {
                switch (iPortModel.getEqType()) {
                    case 31: {
                        n2 = 1;
                        break;
                    }
                    case 28: {
                        n2 = 3;
                        break;
                    }
                    case 29: {
                        n2 = 12;
                        break;
                    }
                    case 30: {
                        n2 = 48;
                        break;
                    }
                    case 61: {
                        n2 = 192;
                        break;
                    }
                }
            }
        }
        block8 : switch (n) {
            case 1: {
                switch (n2) {
                    case 0: {
                        break block8;
                    }
                }
                string = "sts1";
                break;
            }
            case 3: {
                switch (n2) {
                    case 3: {
                        string = "sts3c";
                    }
                }
                string = "sts3c-9c";
                break;
            }
            case 6: 
            case 9: {
                string = "sts3c-9c";
                break;
            }
            case 12: 
            case 18: 
            case 24: 
            case 36: 
            case 48: 
            case 192: {
                switch (n2) {
                    case 12: {
                        string = "sts12c";
                        break block8;
                    }
                    case 48: {
                        string = "sts12c-48c";
                        break block8;
                    }
                    case 192: {
                        string = "sts12c-192c";
                        break block8;
                    }
                }
                break;
            }
        }
        return string;
    }

    private String pmTypeToStr(InterfaceModel interfaceModel, int n) {
        String string = "unknown";
        TDMTerminology tDMTerminology = interfaceModel.getNodeModel().getTDMTerminology();
        this.db.fine("pmTypeToStr: " + (n > -1 ? tDMTerminology.getPmStatType(n) : "-1"));
        if (tDMTerminology instanceof SDHTDMTerminology) {
            switch (n) {
                case 1: 
                case 7: {
                    string = "ms";
                    break;
                }
                case 0: {
                    string = "rs";
                    break;
                }
                case 9: 
                case 10: {
                    string = "path";
                    break;
                }
                case 12: {
                    string = "pbitpath";
                    break;
                }
                case 13: {
                    string = "cpbitpath";
                    break;
                }
                case 5: 
                case 6: {
                    string = "vclo";
                    break;
                }
                case 3: 
                case 4: {
                    string = "path";
                    break;
                }
            }
        } else {
            switch (n) {
                case 1: 
                case 7: {
                    string = "line";
                    break;
                }
                case 0: {
                    string = "section";
                    break;
                }
                case 9: 
                case 10: {
                    string = "path";
                    break;
                }
                case 12: {
                    string = "pbitpath";
                    break;
                }
                case 13: {
                    string = "cpbitpath";
                    break;
                }
                case 5: 
                case 6: {
                    string = "vt";
                    break;
                }
                case 3: 
                case 4: {
                    string = this.doSomethingHorrible(interfaceModel);
                    break;
                }
            }
        }
        return string;
    }

    private String intervalToStr(eIntervalType eIntervalType2) {
        return eIntervalType2 == eIntervalType.INTERVAL_15_MIN ? "15min" : "1day";
    }

    private String intervalToWarningAlarm(eIntervalType eIntervalType2) {
        return eIntervalType2 == null ? "alarm" : "warning";
    }

    private String endToStr(boolean bl) {
        return bl ? "nearend" : "farend";
    }

    private String getValidationPrefix(InterfaceModel interfaceModel, int n, eIntervalType eIntervalType2, boolean bl) {
        return this.lineTypeToStr(interfaceModel) + "." + this.pmTypeToStr(interfaceModel, n) + "." + this.endToStr(bl) + "." + this.intervalToStr(eIntervalType2) + ".";
    }

    private String getPhysicalValidationPrefix(eIntervalType eIntervalType2) {
        String string = this.intervalToWarningAlarm(eIntervalType2);
        String string2 = "";
        if (string.equals("warning")) {
            string2 = "." + this.intervalToStr(eIntervalType2);
        }
        return "physicalthresholds." + string + string2 + ".";
    }

    private void updateValidationManager() {
        if (this.validationManager == null) {
            this.validationManager = DefaultsManager.getInstance(this.node);
        }
    }

    private void validate(eEqType eEqType2, eEqType eEqType3, String string, String string2) throws ProvisionError {
        this.updateValidationManager();
        this.validationManager.validate(eEqType2, eEqType3, string, string2);
    }

    protected void validatePmThresholds(int n, InterfaceModel interfaceModel, eThresholdType eThresholdType2, boolean bl, String string, String string2) throws ProvisionError {
        this.validatePmThresholds(n, interfaceModel, eThresholdType2 == eThresholdType.THRESHOLD_15_MIN ? eIntervalType.INTERVAL_15_MIN : eIntervalType.INTERVAL_DAY, bl, string, string2);
    }

    protected void validatePmThresholds(int n, InterfaceModel interfaceModel, eIntervalType eIntervalType2, boolean bl, String string, String string2) throws ProvisionError {
        if (n > -1) {
            String string3 = this.getValidationPrefix(interfaceModel, n, eIntervalType2, bl) + string;
            try {
                if (this.db.isInfoEnabled()) {
                    this.db.info("Validating " + string2 + " on " + string3 + " for " + interfaceModel.getClass().getName() + " " + interfaceModel.getModuleModel().getEqTypeEnum().value() + " " + interfaceModel.getPortModel().getEqType());
                }
                this.validate(interfaceModel.getModuleModel().getEqTypeEnum(), eEqType.from_int(interfaceModel.getPortModel().getEqType()), string3, string2);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
    }

    protected void validatePmThresholds(int n, InterfaceModel interfaceModel, eIntervalType eIntervalType2, String string, String string2, ValueAccessor valueAccessor) throws ProvisionError {
        this.updateValidationManager();
        String string3 = null;
        switch (n) {
            case 11: {
                string3 = this.getPhysicalValidationPrefix(eIntervalType2) + string;
            }
        }
        try {
            this.db.info("Validating " + string2 + " on " + string3);
            this.validationManager.validate(interfaceModel.getModuleModel().getEqTypeEnum(), eEqType.from_int(interfaceModel.getPortModel().getEqType()), string3, string2, valueAccessor);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.severe("Edit cannot currently be performed " + (Object)((Object)abstractCmsNoSuchEntityException));
        }
    }

    protected Frame getFrame() {
        return this.node.getUiToolkit().getApplicationFrame();
    }

    protected void presentProvisionError(String string, ProvisionError provisionError) {
        ErrorMsg.displayDetailed((Component)this.getFrame(), EMC.EID_INVALID_COLUMN_NAME_PARAM_1, string, provisionError.getMessage());
    }
}

