/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Attribute;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.ui.AlsTableModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.AnnotatedException;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AlsPane
extends NodeProvPane
implements TableModelListener {
    private ObservableManager _obsMgr;
    protected AlsTableModel dataModel = null;
    protected InterfaceModel[] lineModels = null;
    protected ModuleModel eqpmtModel = (ModuleModel)this.getUiModel();
    private static final SDebug db = new SDebug("AlsPane");

    public AlsPane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray) {
        super(string, tabbedView);
        this.lineModels = interfaceModelArray;
        this.init();
    }

    private void init() {
        TableColumn tableColumn = null;
        this.createTableModel(this.lineModels);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        uScrollPane.setPreferredSize(new Dimension(200, 150));
        tableColumn = this.table.getColumn(AlsTableModel.columnNames[0]);
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        tableColumn = this.table.getColumn(AlsTableModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(this.getAttributeArray("AlsMode"))));
        tableColumn.setMinWidth(150);
        this.add((Component)uScrollPane);
        this.registerWithModel();
    }

    protected void createTableModel(InterfaceModel[] interfaceModelArray) {
        this.dataModel = new AlsTableModel(this.eqpmtModel, interfaceModelArray);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
    }

    protected JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected Attribute[] getAttributeArray(String string) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeArray(string);
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws Exception {
        try {
            this.dataModel.applyToModel();
            this.setDirty(false);
        }
        catch (Exception exception) {
            throw new AnnotatedException("Error applying changes", exception);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected void refreshMyLines(Object object) {
        InterfaceModel[] interfaceModelArray = null;
        if (object instanceof OcnLineUpdate) {
            interfaceModelArray = (InterfaceModel[])((OcnLineUpdate)object).getModels();
        } else if (object instanceof DwdmLineUpdate) {
            interfaceModelArray = ((DwdmLineUpdate)object).getDwdmLineModels();
        }
        if (interfaceModelArray != null) {
            this.unregisterWithModel();
            this.lineModels = interfaceModelArray;
            this.registerWithModel();
            this.dataModel.refreshMyLines(this.lineModels);
        }
    }

    public void enteringPage() throws Exception {
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        super.enteringPage();
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    protected void registerWithModel() {
        super.registerWithModel();
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    protected void unregisterWithModel() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    public void dispose() {
        this.unregisterWithModel();
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.dispose();
    }

    protected void changeMessage(Observable observable, Object object) {
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                AlsPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("changeMessage cannot find Model " + observable);
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.DwdmLineAlsPane;
    }
}

