/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.helper.PortHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class BaselineStatsDialog
extends JDialog
implements ActionListener {
    public static final int CANCEL = 0;
    public static final int SCOPE_PORT = 1;
    public static final int SCOPE_CARD = 2;
    public static final int SET = 4;
    public static final int UNSET = 8;
    private static final String TITLE = "Baseline Statistics";
    private static final String ALL_PORT = "All statistics for port ";
    private static final String ALL_CARD = "All statistics for card";
    private JRadioButton scopePortRB;
    private JRadioButton scopeCardRB;
    private ButtonGroup radioButtonGroup;
    private JPanel radioButtonPanel;
    private JButton setButton = new JButton("Set Baseline");
    private JButton unsetButton = new JButton("Unset Baseline");
    private JButton cancelButton = new JButton("Cancel");
    private int choice = 0;

    public BaselineStatsDialog(Frame frame, int[] nArray) {
        super(frame, TITLE, true);
        String string = PortHelper.getConcatenatedString((int[])nArray);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.scopePortRB = new JRadioButton(ALL_PORT + string, false);
        this.scopeCardRB = new JRadioButton(ALL_CARD, false);
        this.radioButtonGroup = new ButtonGroup();
        this.radioButtonGroup.add(this.scopePortRB);
        this.radioButtonGroup.add(this.scopeCardRB);
        int n = nArray[nArray.length - 1];
        if (n < 0) {
            this.scopePortRB.setEnabled(false);
            this.scopeCardRB.setSelected(true);
        } else {
            this.scopePortRB.setSelected(true);
        }
        this.setButton.addActionListener(this);
        this.unsetButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.radioButtonPanel = new JPanel(new GridLayout(0, 1));
        this.radioButtonPanel.add(this.scopePortRB);
        this.radioButtonPanel.add(this.scopeCardRB);
        this.radioButtonPanel.setBorder(BorderFactory.createTitledBorder("Scope"));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0, 10, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        jPanel2.add(this.setButton);
        jPanel2.add(this.unsetButton);
        jPanel2.add(this.cancelButton);
        jPanel.add((Component)this.radioButtonPanel, "Center");
        jPanel.add((Component)jPanel2, "South");
        container.add((Component)jPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BaselineStatsDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public void setAllPortRadioButtonTitle(String string) {
        if (string != null) {
            this.scopeCardRB.setText(string);
        }
    }

    public int getChoice() {
        return this.choice;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cancelButton) {
            this.choice = 0;
        } else {
            if (object == this.setButton) {
                this.choice = 4;
            } else if (object == this.unsetButton) {
                this.choice = 8;
            }
            this.choice = this.scopeCardRB.isSelected() ? (this.choice += 2) : ++this.choice;
        }
        this.setVisible(false);
    }
}

