/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.CSHelpID;
import cerent.launcher.CmsClassLoader;
import cerent.util.EID;
import cerent.util.HelpMgr;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.TreeSet;
import javax.help.HelpSet;
import javax.help.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class CSHelper {
    public static final ImageIcon helpIcon;
    public static final String HELP_ID = "HelpID";
    public static final String HELP_STRING = "Help";
    public static final String HELP_TOOLTIP = "Launch Context Sensitive Help";
    public static final String HELP_ICON = "/images/icons/help16.gif";
    private static final String PROP_GEN_PATH = "ctc";
    private static final String PROP_SANITY_CHECK_CSH = "cshelp.test";
    private static ImageIcon INFO_ICON;
    private static ImageIcon ERROR_ICON;
    private static HelpSet hs;
    private static int currentPlatform;
    private static boolean doSanityCheck;
    private static Preferences preferences;
    private static SDebug db;
    static /* synthetic */ Class class$cerent$cms$ui$CSHelpID;

    static void launchHelp(Component component, CSHelpID cSHelpID) {
        Window window = null;
        try {
            window = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), component);
        }
        catch (Exception exception) {
            window = null;
        }
        CSHelper.launchHelp(window, cSHelpID);
    }

    static void launchHelp(Window window, CSHelpID cSHelpID) {
        if (doSanityCheck) {
            CSHelper.sanityCheckCSH(CSHelper.class.getClassLoader());
        }
        HelpMgr.launchCSHelp((HelpSet)CSHelper.getHelpSet(), (Window)window, (String)cSHelpID.getHelpIDString());
    }

    public static HelpSet getHelpSet() {
        if (hs != null) {
            return hs;
        }
        try {
            URL uRL;
            String string = "";
            Preferences preferences = Preferences.instance();
            if (HelpMgr.getCSHPlatform() == 1) {
                if ((string = preferences.getProperty(PROP_GEN_PATH, "cshelp.sonet.url", string)).length() > 0) {
                    uRL = new URL(string);
                } else {
                    string = "cshelp/sonet/ctc.hs";
                    uRL = HelpSet.findHelpSet((ClassLoader)CSHelper.class.getClassLoader(), (String)string);
                }
            } else if ((string = preferences.getProperty(PROP_GEN_PATH, "cshelp.sdh.url", string)).length() > 0) {
                uRL = new URL(string);
            } else {
                string = "cshelp/sdh/ctc.hs";
                uRL = HelpSet.findHelpSet((ClassLoader)CSHelper.class.getClassLoader(), (String)string);
            }
            if (db.on()) {
                db.println("HelpSet path=" + string + " URL=" + uRL);
            }
            hs = new HelpSet(CSHelper.class.getClassLoader(), uRL);
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            hs = null;
        }
        return hs;
    }

    private static Class loadCshConst(ClassLoader classLoader) {
        Class<?> clazz;
        block4: {
            clazz = null;
            try {
                clazz = classLoader.loadClass("cerent.cms.ui.NetCSHelpConst");
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    clazz = classLoader.loadClass("cerent.cms.ui.CSHelpConst");
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    if (!db.on()) break block4;
                    SDebug.printStackTrace((Throwable)classNotFoundException2);
                }
            }
        }
        return clazz;
    }

    private static void sanityCheckCSH(ClassLoader classLoader) {
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        if (!(classLoader instanceof CmsClassLoader)) {
            return;
        }
        Map map = null;
        try {
            Class clazz = CSHelper.loadCshConst(classLoader);
            Field[] fieldArray = clazz.getFields();
            HelpSet helpSet = CSHelper.getHelpSet();
            map = helpSet.getLocalMap();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field;
                CSHelpID cSHelpID;
                if ((fieldArray[i].getModifiers() & 8) != 8 || fieldArray[i].getType() != (class$cerent$cms$ui$CSHelpID == null ? CSHelper.class$("cerent.cms.ui.CSHelpID") : class$cerent$cms$ui$CSHelpID) || !(cSHelpID = (CSHelpID)(field = fieldArray[i]).get(null)).supports(CSHelper.getCSHPlatform())) continue;
                String string = cSHelpID.getHelpIDString();
                if (!treeSet.contains(string)) {
                    treeSet.add(string);
                }
                if (map.isValidID(string, helpSet) || treeSet2.contains(string)) continue;
                treeSet2.add(string);
            }
            DetailedDialog detailedDialog = treeSet2.iterator();
            while (detailedDialog.hasNext()) {
                stringBuffer.append((String)detailedDialog.next() + "\n");
            }
            detailedDialog = DetailedDialog.instance((Frame)new JFrame(), (String)((CSHelper.getCSHPlatform() == 1 ? "SONET" : "SDH") + " - Context Sensitive Help Sanity Check Results"));
            if (stringBuffer.length() > 0) {
                detailedDialog.setText(classLoader + "\nThe following Help IDs are missing", ERROR_ICON);
            } else {
                detailedDialog.setText(classLoader + "\nThere is no missing Help IDs", INFO_ICON);
            }
            detailedDialog.append(stringBuffer.toString());
            detailedDialog.setSize(340, detailedDialog.getHeight());
            detailedDialog.show();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            String string = KErrorMsg.getString((EID)KEMC.EID_HELPSET_NOT_FOUND);
            CerentDialog.errorDialog(null, (String)string);
        }
    }

    protected static int getCSHPlatform() {
        if (currentPlatform == -1) {
            currentPlatform = HelpMgr.getCSHPlatform();
        }
        return currentPlatform;
    }

    static {
        INFO_ICON = new ImageIcon(CerentDialog.class.getResource("/images/icons/informational32.gif"));
        ERROR_ICON = new ImageIcon(CerentDialog.class.getResource("/images/icons/fatal_error32.gif"));
        hs = null;
        currentPlatform = -1;
        doSanityCheck = true;
        preferences = Preferences.instance();
        doSanityCheck = preferences.getBoolean(PROP_GEN_PATH, PROP_SANITY_CHECK_CSH, false);
        helpIcon = new ImageIcon(CSHelper.class.getResource(HELP_ICON));
        db = new SDebug("CSHelper");
    }
}

