/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.MfgPortModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.CardInventoryRowObject;
import cerent.cms.ui.RoDataSourceControl;
import cerent.util.BlockingModeController;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class CardInventoryDataSource
extends AbstractRowDataSource
implements Observer,
RoDataSourceControl,
BlockingModeController {
    private ModuleModel card;
    private List entities;
    private CardInventoryRowObject[] rowObjects;
    private ObservableManager observableManager;
    private static final int NEEDS_REFRESH = 1;
    private static final int NEEDS_RESET = 2;
    private static final SDebug db = new SDebug("CardInventoryDataSource");

    public CardInventoryDataSource(ModuleModel moduleModel) {
        this.card = moduleModel;
        this.observableManager = new ObservableManager(this, true);
        this.observableManager.setBlockingModeController(this);
    }

    public Object getObjectAtRow(int n) {
        try {
            return this.rowObjects != null ? this.rowObjects[n] : null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (db.on()) {
                db.println("getObjectAtRow " + n + " out of bounds");
            }
            return null;
        }
    }

    public int getRowCount() {
        return this.rowObjects != null ? this.rowObjects.length : 0;
    }

    public Collection getAllObjects() {
        return this.rowObjects != null ? Arrays.asList(this.rowObjects) : new ArrayList();
    }

    public void refreshFromModel(int n) throws Exception {
        if (n == -1 || n == 2) {
            this.resetFromNodeModel();
        }
        this.refreshFromModel();
    }

    private void resetFromNodeModel() {
        if (CardInventoryDataSource.db.on) {
            db.println("resetFromNodeModel");
        }
        this.observableManager.setObservable(null);
        if (this.card != null) {
            this.entities = this.card.getMfgPorts();
            this.observableManager.addObservable((Observable)((Object)this.card));
        }
        if (this.entities == null || this.entities.size() == 0) {
            if (CardInventoryDataSource.db.on) {
                db.println("Can't get mfgd Port entities!");
            }
        } else {
            if (CardInventoryDataSource.db.on) {
                db.println("resetFromNodeModel: " + this.entities.size() + " rows");
            }
            this.observableManager.addObservable((Observable[])this.entities.toArray(new Model[this.entities.size()]));
        }
    }

    public void refreshFromModel() {
        if (CardInventoryDataSource.db.on) {
            db.println("refreshFromModel()");
        }
        this.rowObjects = new CardInventoryRowObject[this.entities.size()];
        for (int i = 0; i < this.entities.size(); ++i) {
            if (CardInventoryDataSource.db.on) {
                db.println(this.entities.get(i).toString());
            }
            this.rowObjects[i] = new CardInventoryRowObject((MfgPortModel)this.entities.get(i));
        }
        if (CardInventoryDataSource.db.on) {
            db.println("refreshFromModel(): fireDataSourceChanged");
        }
        this.fireDataSourceChanged();
    }

    public IObservableManager getObservableManager() {
        if (CardInventoryDataSource.db.on) {
            db.println("getObservableManager: state = " + this.observableManager.getBlockingModeControllerState());
        }
        return this.observableManager;
    }

    public void disposeDataSource() {
        if (this.entities != null) {
            this.entities.clear();
        }
        this.rowObjects = null;
    }

    public void update(Observable observable, Object object) {
        int n;
        if (CardInventoryDataSource.db.on) {
            try {
                db.println("update: src = " + observable + ", evt = " + object);
            }
            catch (Exception exception) {
                db.warning("Attempted to access an EntityModel which no longer exists");
            }
        }
        if ((n = this.entities.indexOf(observable)) == -1 || object == ModelUpdateType.DELETED) {
            this.resetFromNodeModel();
        }
        this.refreshFromModel();
    }

    public int processBlockedEvent(Observable observable, Object object, int n) {
        int n2;
        if (CardInventoryDataSource.db.on) {
            db.println("processBlockedEvent: src " + observable + ", event = " + object + ", previousState = " + n);
        }
        if ((n2 = this.entities.indexOf(observable)) == -1 || object == ModelUpdateType.DELETED) {
            return 2;
        }
        if (n == 0) {
            return 1;
        }
        return n;
    }
}

