/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.ui.AinsCountDown;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ILineModelUpdater;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SoakMaintenancePane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;

public class CardMaintenancePane
extends NodeProvPane
implements ITabName {
    public CardMaintenancePane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray) {
        this(string, tabbedView, interfaceModelArray, new ILineModelUpdater(){

            public boolean updateIsForMe(ModuleModelUpdate moduleModelUpdate) {
                return false;
            }
        });
    }

    public CardMaintenancePane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray, ILineModelUpdater iLineModelUpdater) {
        super(string, tabbedView);
        this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
        this.subTabs.addTab("Protection", (Component)CardTabbedView.getProtectionPane(tabbedView));
        ModuleModel moduleModel = (ModuleModel)tabbedView.getUiModel();
        if (moduleModel.supportsJ1PathTrace(interfaceModelArray)) {
            this.subTabs.addTab("Path Trace", (Component)CardTabbedView.getPathTracePane(interfaceModelArray, tabbedView, iLineModelUpdater));
        }
        if (!(moduleModel instanceof DwdmModuleModel) && AinsCountDown.supportsAins(moduleModel)) {
            try {
                this.subTabs.addTab("AINS Soak", (Component)this.getSoakPane(tabbedView, interfaceModelArray, true));
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_SOAK_MAINT_PANE_CREATE);
            }
        }
        this.add((Component)this.subTabs);
    }

    public void addSubTab(String string, Pane pane, int n) {
        this.subTabs.insertTab(string, null, (Component)pane, null, n);
    }

    public void addSubTab(String string, Pane pane) {
        this.addSubTab(string, pane, 0);
    }

    public void disableSubTab(String string) {
        int n = this.subTabs.indexOfTab(string);
        if (n != -1) {
            this.subTabs.setEnabledAt(n, false);
        }
    }

    public boolean hasSubTabs() {
        return true;
    }

    protected Pane getSoakPane(TabbedView tabbedView, InterfaceModel[] interfaceModelArray, boolean bl) {
        return new SoakMaintenancePane("AINS Soak", tabbedView, interfaceModelArray, bl);
    }
}

