/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.AbstractInvalidViewException;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.CardVitalStatsPane;
import cerent.cms.ui.DefaultViewControllerLayout;
import cerent.cms.ui.EleViewController;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.IViewController;
import cerent.cms.ui.ShelfViewController;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.event.ShelfEventPanelController;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.UObservable;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CardViewController
extends EleViewController {
    protected IEntityModel entityModel = null;
    private static final SDebug db = new SDebug("CVC");

    public CardViewController(ShelfViewController shelfViewController, IChassisModel iChassisModel, IUiToolkit iUiToolkit, int n, int n2, int n3, boolean bl) {
        super((IViewController)shelfViewController, new ViewName(new int[]{n, n2, n3}), iUiToolkit, db, iChassisModel.getNodeModelDelegate(), bl, iChassisModel);
        db.fine("<init> " + this.getViewName());
    }

    public void update(Observable observable, Object object) {
        db.fine("update from " + observable + " tag is " + object);
        if (object instanceof Integer) {
            MfgEntityModel mfgEntityModel = null;
            if (object == ModelUpdateType.CHANGED) {
                this.setName();
                if (this.getCurrentView() != null && this.viewName.contains(this.getCurrentView())) {
                    db.fine("View is displayed. Setting title to " + this.name);
                    this.setTitleLabel(this.name);
                }
                if (this.entityModel instanceof ModuleModel) {
                    mfgEntityModel = (ModuleModel)this.entityModel;
                }
            }
            if (object == ModelUpdateType.DELETED || mfgEntityModel != null && mfgEntityModel.getState() == eEqState.DELETED) {
                if (this.nmd.isInited() && this.nmd.getLoginState()) {
                    try {
                        db.fine("update: jumping to shelf");
                        this.jumpView(this.viewName.getParentView(), false);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ErrorMsg.displayWarning(CardViewController.this.getFrame(), (EID)EMC.WID_NAV_CARD_DELETED);
                            }
                        });
                    }
                    catch (Exception exception) {
                        db.fine("update got exception when trying to jump to shelf view");
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)exception);
                        }
                        this.tryJumpView(ViewName.ROOT_VIEW);
                    }
                } else {
                    db.fine("update discarded (NMD !inited/LoggedOut)");
                }
            }
        }
    }

    protected void localDispose() {
        db.fine(this.getViewName() + " localDispose");
        if (this.sv != null) {
            ((AbstractCardViewPanel)this.sv).dispose();
        }
        if (this.entityModel != null) {
            this.entityModel.deleteObserver((Observer)this);
            this.entityModel = null;
        }
        super.localDispose();
    }

    protected void localDestroy() {
        db.fine(this.getViewName() + " localDestroy");
        this.chassis = null;
        super.localDestroy();
    }

    protected void localEnterView(ViewName viewName) {
        db.fine("localEnterView destView is " + viewName);
        super.localEnterView(viewName);
        if (this.entityModel != null) {
            this.entityModel.addObserver((Observer)this);
        }
    }

    protected void localExitView(ViewName viewName, ViewName viewName2) throws AbstractLeavePageException {
        db.fine("localExitView srcView is " + viewName + " destView is " + viewName2);
        super.localExitView(viewName, viewName2);
        this.localFlushViewPanel(viewName2);
    }

    protected JPanel createPanel(ViewName viewName) throws AbstractInvalidViewException {
        db.fine("createPanel destView is " + viewName);
        try {
            JPanel jPanel = new JPanel();
            this.svcl = new DefaultViewControllerLayout(jPanel, "card");
            if (this.getEntityModel().getChildren().size() < 1) {
                this.throwInvalidViewException("There is no card in slot " + viewName.getSlotId() + ".", 3);
            }
            this.entityModel = (IEntityModel)this.getEntityModel().getChildren().get(0);
            if (this.entityModel instanceof ModuleModel) {
                IPlatform iPlatform = this.chassis.getPlatform();
                ModuleModel moduleModel = (ModuleModel)this.entityModel;
                this.stv = iPlatform.getCardTabbedViewFactory().getCardView(moduleModel, new ShelfEventPanelController(this), this.uiToolkit);
                if (this.stv == null) {
                    this.throwInvalidViewException(viewName + " does not exist", 3);
                }
                this.stv.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
                this.sv = iPlatform.getCardViewPanel(moduleModel, this);
                this.nvsp = new CardVitalStatsPane(moduleModel, (UObservable)this.stv.getObservable());
                this.svcl.setComponents((JComponent)new UScrollPane((Component)this.sv), (JComponent)((Object)this.stv), this.nvsp);
            }
            return jPanel;
        }
        catch (AbstractInvalidViewException abstractInvalidViewException) {
            this.localFlushViewPanel(null);
            SDebug.printStackTrace((Throwable)abstractInvalidViewException);
            throw abstractInvalidViewException;
        }
        catch (Exception exception) {
            this.localFlushViewPanel(null);
            SDebug.printStackTrace((Throwable)exception);
            this.throwInvalidViewException(exception.getMessage(), 1);
            return null;
        }
    }

    private EntityModel getEntityModel() {
        List list;
        EntityModel entityModel = null;
        List list2 = this.chassis != null ? ((EntityModel)((Object)this.chassis)).getChildrenOfType(eClass.BACKPLANE) : null;
        EntityModel entityModel2 = list2 != null && list2.size() > 0 ? (EntityModel)list2.get(0) : null;
        List list3 = list = entityModel2 != null ? entityModel2.getChildren() : null;
        if (list != null) {
            entityModel = (EntityModel)list.get(this.getViewName().getSlotId() - 1);
        }
        return entityModel;
    }

    protected String getName() {
        String string;
        block2: {
            string = this.name;
            try {
                string = this.isMultishelf ? this.nmd.getName() + " Shelf " + this.chassis.getShelfId(this.isMultishelf) : this.nmd.getName();
            }
            catch (Exception exception) {
                db.println("Caught exception in getName");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }
}

