/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.Ec1LineUpdate;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds1.Ds1CardTabbedView;
import cerent.cms.ui.ds3e.Ds3eCardTabbedView;
import cerent.cms.ui.ec1.Ec1CardTabbedView;
import cerent.cms.ui.sonet.TdmCardTabbedView;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.awt.Component;

public class ComboCardMaintPane
extends AbstractSubTabbedPane
implements ITabName {
    protected Ds123LineModel[] ds3Lines;
    protected TdmLineModel[] ec1Lines;
    protected TdmLineModel[] ocnLines;
    protected Ds123LineModel[] ds1Lines;
    protected static final int HAS_DS1 = 1;
    protected static final int HAS_DS3 = 2;
    protected static final int HAS_EC1 = 3;
    protected static final int HAS_OCN = 4;
    protected int myIfs;
    private static final SDebug dbg = new SDebug("ComboCardMaintPane");

    public ComboCardMaintPane(String string, CardTabbedView cardTabbedView, TdmLineModel[] tdmLineModelArray) {
        this(string, cardTabbedView, null, null, null, tdmLineModelArray);
        this.myIfs = 16;
    }

    public ComboCardMaintPane(String string, CardTabbedView cardTabbedView, Ds123LineModel[] ds123LineModelArray, Ds123LineModel[] ds123LineModelArray2, TdmLineModel[] tdmLineModelArray) {
        this(string, cardTabbedView, ds123LineModelArray, ds123LineModelArray2, tdmLineModelArray, null);
        this.myIfs = 14;
    }

    public ComboCardMaintPane(String string, CardTabbedView cardTabbedView, Ds123LineModel[] ds123LineModelArray, TdmLineModel[] tdmLineModelArray) {
        this(string, cardTabbedView, null, ds123LineModelArray, tdmLineModelArray, null);
        this.myIfs = 12;
    }

    public ComboCardMaintPane(String string, CardTabbedView cardTabbedView, Ds123LineModel[] ds123LineModelArray, Ds123LineModel[] ds123LineModelArray2, TdmLineModel[] tdmLineModelArray, TdmLineModel[] tdmLineModelArray2) {
        super(string, cardTabbedView);
        this.ds1Lines = ds123LineModelArray;
        this.ds3Lines = ds123LineModelArray2;
        this.ec1Lines = tdmLineModelArray;
        this.ocnLines = tdmLineModelArray2;
        this.registerWithModel();
    }

    protected void createSubTabs() {
        if (dbg.on()) {
            dbg.info("Creating SubTabs");
        }
        ModuleModel moduleModel = (ModuleModel)this.getUiModel();
        if (this.hasDS1()) {
            this.subTabs.addTab("DS1", (Component)this.getDs1Tab(this.subTabs, moduleModel, this.ds1Lines));
        }
        if (this.hasDS3()) {
            String string;
            block7: {
                string = "DS3/E3";
                boolean bl = true;
                try {
                    bl = Model.getFramingType(moduleModel.getNodeModelDelegate()).isSonet();
                    string = bl ? "DS3" : "E3";
                }
                catch (AnnotatedException annotatedException) {
                    dbg.println("Could not determine terminology for ComboCardMaintPane!");
                    if (!dbg.on()) break block7;
                    SDebug.printStackTrace((Throwable)annotatedException);
                }
            }
            this.subTabs.addTab(string, (Component)this.getDs3Tab(this.subTabs, moduleModel, this.ds3Lines));
        }
        if (this.hasEC1()) {
            this.subTabs.addTab("EC1", (Component)this.getEc1Tab(this.subTabs, moduleModel, this.ec1Lines));
        }
        if (this.hasOCN()) {
            this.subTabs.addTab("Optical", (Component)this.getOpticalTab(this.subTabs, moduleModel, this.ocnLines));
        }
    }

    private Pane getDs1Tab(TabbedView tabbedView, ModuleModel moduleModel, Ds123LineModel[] ds123LineModelArray) {
        return Ds1CardTabbedView.getDs1MaintPane(tabbedView, moduleModel, ds123LineModelArray);
    }

    private Pane getDs3Tab(TabbedView tabbedView, ModuleModel moduleModel, Ds123LineModel[] ds123LineModelArray) {
        return Ds3eCardTabbedView.getDs3eMaintPane(tabbedView, moduleModel, ds123LineModelArray);
    }

    private Pane getEc1Tab(TabbedView tabbedView, ModuleModel moduleModel, TdmLineModel[] tdmLineModelArray) {
        return Ec1CardTabbedView.getEc1MaintPane("EC1", tabbedView, moduleModel, tdmLineModelArray);
    }

    private Pane getOpticalTab(TabbedView tabbedView, ModuleModel moduleModel, TdmLineModel[] tdmLineModelArray) {
        return TdmCardTabbedView.getTdmMaintPane("Optical", tabbedView, tdmLineModelArray);
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof Ds3LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received Ds3LineUpdate..");
            }
            this.ds3Lines = (Ds123LineModel[])((Ds3LineUpdate)object).getModels();
        } else if (object instanceof Ec1LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received Ec1LineUpdate...");
            }
            this.ec1Lines = (TdmLineModel[])((Ec1LineUpdate)object).getModels();
        } else if (object instanceof OcnLineUpdate) {
            if (dbg.on()) {
                dbg.info("Received OcnLineUpdate...");
            }
            this.ocnLines = (TdmLineModel[])((OcnLineUpdate)object).getModels();
        } else if (dbg.on()) {
            dbg.println("refreshMyLines received " + object);
        }
    }

    private boolean hasIf(int n) {
        return (this.myIfs & 1 << n) != 0;
    }

    protected boolean hasDS1() {
        return this.hasIf(1);
    }

    protected boolean hasDS3() {
        return this.hasIf(2);
    }

    protected boolean hasEC1() {
        return this.hasIf(3);
    }

    protected boolean hasOCN() {
        return this.hasIf(4);
    }
}

