/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IChassisModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityModel;
import cerent.cms.ui.AbstractInvalidViewException;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.DefaultViewControllerLayout;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.IViewController;
import cerent.cms.ui.InvalidViewException;
import cerent.cms.ui.MainTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.VitalStatsPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;

public abstract class EleViewController
extends AbstractViewController
implements Observer {
    protected String name;
    protected NodeModelDelegate nmd = null;
    protected INodeModel.AbstractConnectionNotifier cn = null;
    protected JPanel sv = null;
    protected MainTabbedView stv = null;
    protected VitalStatsPane nvsp = null;
    protected DefaultViewControllerLayout svcl = null;
    protected int curTabIndex;
    protected boolean isMultishelf;
    protected IChassisModel chassis;

    protected EleViewController(IViewController iViewController, ViewName viewName, IUiToolkit iUiToolkit, KDebug kDebug, NodeModelDelegate nodeModelDelegate, boolean bl) {
        this(iViewController, viewName, iUiToolkit, kDebug, nodeModelDelegate, bl, null);
    }

    protected EleViewController(IViewController iViewController, ViewName viewName, IUiToolkit iUiToolkit, KDebug kDebug, NodeModelDelegate nodeModelDelegate, boolean bl, IChassisModel iChassisModel) {
        super(iViewController, viewName, iUiToolkit, kDebug);
        this.isMultishelf = bl;
        this.chassis = iChassisModel;
        this.nmd = nodeModelDelegate;
        this.setName();
    }

    public VitalStatsPane getVitalStatsPane() {
        this.db.fine("getVitalStatsPane");
        return this.nvsp;
    }

    public TabbedView getTabbedView() {
        this.db.fine("getTabbedView");
        return this.stv;
    }

    public void update(Observable observable, Object object) {
        if (this.nmd == null) {
            return;
        }
        this.db.fine("update( " + object + " ) from " + observable);
        if (observable instanceof SecurityModel) {
            if (object == ModelUpdateType.LOGOUT && !this.nmd.isInited()) {
                this.db.fine("Have LOGOUT update");
                DisconnectThread disconnectThread = new DisconnectThread();
                disconnectThread.start();
            }
        } else if (observable instanceof NodeModelDelegate.ConnectionNotifier) {
            if (object == ModelUpdateType.CHANGED) {
                if (this.nmd.isInited() && this.nmd.getConnectionState()) {
                    this.setName();
                } else {
                    this.disconnect(this.viewName);
                }
            }
        } else if (observable instanceof NodeModelDelegate) {
            if (object == ModelUpdateType.DELETED) {
                this.db.fine("Got a DELETED event");
                if (this.parentVC != null) {
                    this.db.fine("Unmounting MSVC");
                    this.parentVC.removeChild((IViewController)this);
                }
                this.disconnect(this.viewName);
            } else if (object == ModelUpdateType.CHANGED) {
                this.setName();
                if (this.getCurrentView() != null && this.viewName.contains(this.getCurrentView())) {
                    this.db.fine("View is displayed. Setting title to " + this.name);
                    this.setTitleLabel(this.name);
                }
            }
        } else if (observable instanceof IChassisModel && object == ModelUpdateType.DELETED) {
            this.db.fine("Received a (fake) DELETED event from the NC Chassis");
            if (this.parentVC != null) {
                this.db.fine("Unmounting VC");
                this.parentVC.removeChild((IViewController)this);
            }
            this.disconnect(this.viewName);
        }
    }

    protected void localUpdateViewPanel(ViewName viewName) throws AbstractInvalidViewException, AbstractLeavePageException {
        this.db.fine("localUpdateViewPanel destView is " + viewName);
        if (!this.nmd.isInited() || !this.nmd.getConnectionState()) {
            ErrorMsg.displayWarning((Component)this.getFrame(), (EID)EMC.WID_NODE_NOT_INITIALIZED_PARAM_1, this.name);
            this.throwInvalidViewException(this.name + " not initialized.", 1);
        }
        if (viewName.getTabId() != 0 && !this.stv.changeTab(viewName.getTabId())) {
            this.throwInvalidViewException("View=" + viewName, 6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localDispose() {
        this.db.fine(this.getViewName() + " localDispose");
        if (this.sv != null) {
            this.sv = null;
        }
        if (this.stv != null) {
            this.curTabIndex = this.stv.getSelectedIndex();
            try {
                this.stv.destroy();
            }
            finally {
                this.stv = null;
            }
        }
        if (this.nvsp != null) {
            try {
                this.nvsp.dispose();
            }
            finally {
                this.nvsp = null;
            }
        }
        if (this.svcl != null) {
            try {
                this.svcl.destroy();
            }
            finally {
                this.svcl = null;
            }
        }
    }

    protected void localDestroy() {
        try {
            if (this.cn != null) {
                this.cn.deleteObserver((Observer)this);
            }
            if (this.nmd != null) {
                this.nmd.deleteObserver(this);
            }
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
        }
        this.localDispose();
        this.db.fine(this.getViewName() + " localDestroy");
    }

    protected void localEnterView(ViewName viewName) {
        this.db.fine("localEnterView destView is " + viewName);
        this.setTitleLabel(this.name);
        try {
            this.stv.setSelectedIndex(this.curTabIndex);
            this.stv.setShowing(true);
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
        }
        this.svcl.updateSplitPanes();
        AbstractViewController.setActiveObject(null);
    }

    protected void localExitView(ViewName viewName, ViewName viewName2) throws AbstractLeavePageException {
        this.db.fine("localExitView srcView is " + viewName + " destView is " + viewName2);
        if (this.svcl != null) {
            this.svcl.dispose();
        }
        try {
            if (this.stv != null) {
                this.curTabIndex = this.stv.getSelectedIndex();
                this.stv.setShowing(false);
            }
        }
        catch (AbstractLeavePageException abstractLeavePageException) {
            throw abstractLeavePageException;
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
        }
    }

    protected void throwInvalidViewException(String string, int n) throws AbstractInvalidViewException {
        throw new InvalidViewException(string, n);
    }

    protected void throwInvalidViewException(String string) throws AbstractInvalidViewException {
        throw new InvalidViewException(string, 1);
    }

    protected abstract String getName();

    protected synchronized void setName() {
        this.name = this.getName();
    }

    class DisconnectThread
    extends Thread {
        DisconnectThread() {
        }

        public void run() {
            EleViewController.this.disconnect(EleViewController.this.getViewName());
        }
    }
}

