/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IosConfigModel;
import cerent.cms.model.IosConfigTooBig;
import cerent.cms.model.IosModuleModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoIosConfig;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SoftwareError;
import cerent.cms.model.UpdateInProgress;
import cerent.cms.ui.AbstractPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.GridBagPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class IOSConfigDialog
extends JFrame
implements ActionListener,
Observer {
    private String nodeName = null;
    private IModuleModel moduleModel = null;
    private Component parent = null;
    private static HashMap allInstances = new HashMap();
    private static final SDebug db = new SDebug("IOSConfigDialog");
    private static final String CONFIG_FILE_TOO_BIG = "CONFIG FILE IS TOO BIG";
    private String host;
    private int port = 23;
    private IosConfigModel iosConfigModel = null;
    private JLabel sourceLabel = new JLabel("source route value");
    private JLabel timestampLabel = new JLabel("timestamp value");
    private JLabel hostLabel = new JLabel("host value");
    private JLabel directoryLabel = new JLabel("directory value");
    private JLabel fileLabel = new JLabel("file name value");
    private JButton uploadButton;
    private JButton downloadButton;
    private JButton mergeButton = new JButton("Merge");
    private String ctrlCard;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOSConfigDialog instance(Component component, IModuleModel iModuleModel) {
        IOSConfigDialog iOSConfigDialog = null;
        HashMap hashMap = allInstances;
        synchronized (hashMap) {
            iOSConfigDialog = (IOSConfigDialog)allInstances.get(iModuleModel);
            if (null == iOSConfigDialog) {
                if (IOSConfigDialog.db.on) {
                    db.println("Creating a new instance...");
                }
                iOSConfigDialog = new IOSConfigDialog(component, iModuleModel);
                allInstances.put(iModuleModel, iOSConfigDialog);
            } else if (IOSConfigDialog.db.on) {
                db.println("Using recycled instance...");
            }
        }
        return iOSConfigDialog;
    }

    private Image getApplicationIcon(Component component) {
        if (IOSConfigDialog.db.on) {
            db.finest("parent is: " + component + " Class:" + component.getClass());
        }
        Image image = null;
        if (null != component) {
            Component component2;
            for (component2 = component; null != component2 && !(component2 instanceof Frame); component2 = component2.getParent()) {
                if (!IOSConfigDialog.db.on) continue;
                db.finest("container is: " + component2 + " Class:" + component2.getClass());
            }
            if (null != component2 && component2 instanceof Frame) {
                if (IOSConfigDialog.db.on) {
                    db.finest("Frame is: " + (Frame)component2);
                }
                image = ((Frame)component2).getIconImage();
            }
        }
        if (IOSConfigDialog.db.on) {
            db.finest("returnValue is: " + image);
        }
        return image;
    }

    private IOSConfigDialog(Component component, IModuleModel iModuleModel) {
        this.host = iModuleModel.getNodeModel().getHostName();
        this.port = iModuleModel.getSlot() + 2000;
        this.moduleModel = iModuleModel;
        this.nodeName = iModuleModel.getNodeModel().getName();
        this.parent = component;
        if (IOSConfigDialog.db.on) {
            db.finest("Node model is: " + iModuleModel.getNodeModel());
            db.finest("Node name is: " + iModuleModel.getNodeModel().getName());
        }
        this.setIconImage(this.getApplicationIcon(component));
        this.iosConfigModel = ((IosModuleModel)iModuleModel).getIosConfig();
        this.ctrlCard = this.iosConfigModel.getControlCardName();
        this.uploadButton = new JButton("Local -> " + this.ctrlCard + "...");
        this.downloadButton = new JButton(this.ctrlCard + " -> Local...");
        if (null != this.iosConfigModel) {
            this.iosConfigModel.addObserver(this);
            if (IOSConfigDialog.db.on) {
                db.println("iosConfigModel observer added.");
            }
        } else {
            db.println("iosConfigModel is null -- no observer added!");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (db.on) {
                    db.finer("windowClosing");
                }
                IOSConfigDialog.this.setVisible(false);
                IOSConfigDialog.this.dispose();
            }
        });
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.anchor(17);
        gridBagPanel.inset(5, 5);
        gridBagPanel.add("Source:", 0, 0);
        gridBagPanel.add((Component)this.sourceLabel, 1, 0);
        gridBagPanel.add("Host:", 0, 1);
        gridBagPanel.add((Component)this.hostLabel, 1, 1);
        gridBagPanel.add("Directory:", 0, 2);
        gridBagPanel.add((Component)this.directoryLabel, 1, 2);
        gridBagPanel.add("Filename:", 0, 3);
        gridBagPanel.add((Component)this.fileLabel, 1, 3);
        gridBagPanel.add("Timestamp:", 0, 4);
        gridBagPanel.add((Component)this.timestampLabel, 1, 4);
        this.updateSourcePropertiesInfo();
        JPanel jPanel = new JPanel(new FlowLayout(1, 10, 10));
        this.uploadButton.setActionCommand("uploadButton");
        this.uploadButton.addActionListener(this);
        this.uploadButton.setEnabled(this.isUserLevelSufficient());
        jPanel.add(this.uploadButton);
        this.downloadButton.setActionCommand("downloadButton");
        this.downloadButton.addActionListener(this);
        this.updateDownloadButtonState();
        jPanel.add(this.downloadButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)gridBagPanel, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Exit");
        jMenuItem.setActionCommand("exitMenuItem");
        jMenuItem.addActionListener(this);
        jMenuItem.setMnemonic(88);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n, n2);
    }

    private void updateSourcePropertiesInfo() {
        if (null != this.iosConfigModel) {
            try {
                this.sourceLabel.setText(this.iosConfigModel.getSourceOriginConfigRoute());
                this.hostLabel.setText(this.iosConfigModel.getSourceOriginHostName());
                this.directoryLabel.setText(this.iosConfigModel.getSourceOriginDirectory());
                this.fileLabel.setText(this.iosConfigModel.getSourceOriginFileName());
                this.timestampLabel.setText(this.iosConfigModel.getSourceOriginTimestamp());
            }
            catch (Exception exception) {
                this.sourceLabel.setText("UNKNOWN");
                this.hostLabel.setText("UNKNOWN");
                this.directoryLabel.setText("UNKNOWN");
                this.fileLabel.setText("UNKNOWN");
                this.timestampLabel.setText("UNKNOWN");
                if (IOSConfigDialog.db.on) {
                    db.println("Exception caught in updateSourcePropertiesInfo(): " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
            this.updateDownloadButtonState();
            this.pack();
            this.invalidate();
            this.repaint();
        }
    }

    public void setVisible(boolean bl) {
        if (null != this.nodeName) {
            this.setTitle(this.nodeName + ", slot " + Integer.toString(this.port - 2000));
        } else {
            this.setTitle(this.host + ", port " + Integer.toString(this.port));
        }
        super.setVisible(bl);
    }

    private void updateDownloadButtonState() {
        this.downloadButton.setEnabled(this.isUserLevelSufficient() && this.isConfigPresent());
    }

    private boolean isConfigPresent() {
        boolean bl = !this.fileLabel.getText().equals("NONE") || !this.directoryLabel.getText().equals("NONE") || !this.hostLabel.getText().equals("NONE");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (IOSConfigDialog.db.on) {
            db.println("dispose called.");
        }
        this.setVisible(false);
        if (null != this.iosConfigModel) {
            this.iosConfigModel.deleteObserver(this);
            if (IOSConfigDialog.db.on) {
                db.println("iosConfigModel observer deleted.");
            }
        } else {
            db.println("iosConfigModel is null -- no observer deleted!");
        }
        HashMap hashMap = allInstances;
        synchronized (hashMap) {
            if (null != this.moduleModel) {
                allInstances.remove(this.moduleModel);
            }
        }
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("uploadButton")) {
            JFileChooser jFileChooser = new JFileChooser();
            if (jFileChooser.showOpenDialog(this) == 0) {
                File file = jFileChooser.getSelectedFile();
                if (IOSConfigDialog.db.on) {
                    try {
                        db.println("\n");
                        db.println("This file getPath() : " + file.getPath());
                        db.println("This file getAbsolutePath() : " + file.getAbsolutePath());
                        db.println("This file getAbsoluteFile() : " + file.getAbsoluteFile());
                        db.println("This file getCanonicalFile() : " + file.getCanonicalFile());
                        db.println("This file getCanonicalPath() : " + file.getCanonicalPath());
                        db.println("This file getParent() : " + file.getParent());
                        db.println("This file getParentFile().getPath() : " + file.getParentFile().getPath());
                    }
                    catch (Exception exception) {
                        db.println(exception.toString());
                    }
                }
                if (null != file && file.canRead()) {
                    String string2 = "Confirmation Dialog";
                    String string3 = "Uploading an IOS Startup Config file to the " + this.ctrlCard + "\n";
                    string3 = string3 + "will replace the existing file and cannot be undone.\n";
                    if (CerentDialog.yesNoDialog((Component)this, (String)(string3 = string3 + "OK to continue?"), (String)string2)) {
                        if (IOSConfigDialog.db.on) {
                            db.println("proceeding to call copyFileToTCC...");
                        }
                        if (this.copyFileToTCC(file)) {
                            CerentDialog.infoDialog((Component)this, (String)("The startup config file has been transferred successfully from the file server to the " + this.ctrlCard + ".\n" + "This file will become effective " + "when the card is inserted or rebooted, or\n" + "the \"copy start run\" command is executed."), (String)"Transfer successful");
                        }
                    }
                } else {
                    if (IOSConfigDialog.db.on) {
                        db.println("localFile was null or unreadable!");
                    }
                    ErrorMsg.displayError((Component)this, (EID)EMC.EID_FAIL_READ_FILE_PARAM_1, (Object)file.getAbsolutePath());
                }
            } else if (IOSConfigDialog.db.on) {
                db.println("APPROVE_OPTION not returned...");
            }
        } else if (string.equals("downloadButton")) {
            JFileChooser jFileChooser = new JFileChooser();
            if (jFileChooser.showSaveDialog(this) == 0) {
                File file = jFileChooser.getSelectedFile();
                if (null != file) {
                    boolean bl = true;
                    if (file.exists()) {
                        bl = CerentDialog.yesNoDialog((Component)this, (String)"OK to overwrite this file?", (String)"File Already Exists");
                    }
                    if (bl) {
                        try {
                            String string4 = this.iosConfigModel.retrieveIosConfig();
                            this.writeContentsToFile(string4, file);
                            CerentDialog.infoDialog((Component)this, (String)("The file has been transferred successfully from the " + this.ctrlCard + " to your local file system."), (String)"Transfer successful");
                        }
                        catch (NoIosConfig noIosConfig) {
                            ErrorMsg.displayError((Component)this, (EID)EMC.EID_NO_IOS_STARTUP_CONFIG);
                        }
                        catch (UpdateInProgress updateInProgress) {
                            ErrorMsg.displayError((Component)this, (EID)EMC.EID_UPDATE_IN_PROGRESS);
                        }
                        catch (SoftwareError softwareError) {
                            if (IOSConfigDialog.db.on) {
                                db.println("SofwareError caught in IOSConfigDialog in actionPerformed for 'downloadButton':" + (Object)((Object)softwareError));
                            }
                            SDebug.printStackTrace((Throwable)softwareError);
                            ErrorMsg.displayError((Component)this, (EID)EMC.EID_SOFTWWARE_ERROR);
                        }
                        catch (Exception exception) {
                            if (IOSConfigDialog.db.on) {
                                db.println("Exception caught: " + exception);
                            }
                            SDebug.printStackTrace((Throwable)exception);
                            ErrorMsg.displayError((Component)this, (EID)EMC.EID_FILE_SAVE_EXCEPTION);
                        }
                    } else if (IOSConfigDialog.db.on) {
                        db.println("user decided not to overwrite file...");
                    }
                } else if (IOSConfigDialog.db.on) {
                    db.println("localFile is null!");
                }
            } else if (IOSConfigDialog.db.on) {
                db.println("APPROVE_OPTION not returned...");
            }
        } else if (string.equals("mergeButton")) {
            this.iosConfigModel.mergeIosConfig();
        } else if (string.equals("exitMenuItem")) {
            this.setVisible(false);
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContentsToFile(String string, File file) {
        OutputStreamWriter outputStreamWriter = null;
        try {
            if (null != string && string.length() > 0) {
                outputStreamWriter = new FileWriter(file);
                outputStreamWriter.write(string);
                outputStreamWriter.flush();
            } else if (IOSConfigDialog.db.on) {
                db.println("ERROR - writeContentsToFile got null or zero length contents string!");
            }
        }
        catch (Exception exception) {
            if (IOSConfigDialog.db.on) {
                db.println("Exception caught : " + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContentsFromFile(File file) {
        if (IOSConfigDialog.db.on) {
            db.println("File length (in bytes) is: " + file.length());
        }
        String string = "<< empty file >>";
        if (file.length() > 98304L) {
            string = CONFIG_FILE_TOO_BIG;
        } else {
            InputStreamReader inputStreamReader = null;
            try {
                char[] cArray = new char[98304];
                if (file.exists() && file.isFile() && file.canRead()) {
                    int n;
                    int n2;
                    inputStreamReader = new FileReader(file);
                    for (n2 = 0; (n = inputStreamReader.read()) != -1 && n2 < 98304; ++n2) {
                        cArray[n2] = (char)n;
                    }
                    string = inputStreamReader.read() != -1 ? CONFIG_FILE_TOO_BIG : new String(cArray, 0, n2);
                }
            }
            catch (Exception exception) {
                if (IOSConfigDialog.db.on) {
                    db.println("Exception caught : " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
            finally {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return string;
    }

    private String truncateToMaxNameLength(String string) {
        int n = 61;
        return string.substring(0, n) + "...";
    }

    private boolean copyFileToTCC(File file) {
        boolean bl = false;
        String string = this.getContentsFromFile(file);
        if (string.equals(CONFIG_FILE_TOO_BIG)) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_IOS_CONFIG_TOO_BIG_PARAM_1, (Object)new Integer(98304).toString());
        } else {
            String string2;
            Object object;
            String string3 = "";
            try {
                object = InetAddress.getLocalHost();
                string3 = ((InetAddress)object).getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                string3 = "UNKNOWN_HOST";
            }
            object = file.getParentFile().getPath();
            String string4 = file.getName();
            int n = (int)(file.lastModified() / 1000L);
            if (string3.length() > 64) {
                string3 = this.truncateToMaxNameLength(string3);
                string2 = "The host name is longer than the maximum allowable size (64). \n";
                string2 = string2 + "If you continue, the IOS startup config file will still be copied to the " + this.ctrlCard + "\n";
                string2 = string2 + "but the properties dialog will display the host name in it's trucated form: \n\n";
                string2 = string2 + string3;
                if (!CerentDialog.yesNoDialog((Component)this, (String)(string2 = string2 + "\n\n Continue?"), (String)"Host Name Too Long")) {
                    return false;
                }
            }
            if (((String)object).length() > 64) {
                object = this.truncateToMaxNameLength((String)object);
                string2 = "The directory name is longer than the maximum allowable size (64). \n";
                string2 = string2 + "If you continue, the IOS startup config file will still be copied to the " + this.ctrlCard + "\n";
                string2 = string2 + "but the properties dialog will display the directory name in it's trucated form: \n\n";
                string2 = string2 + (String)object;
                if (!CerentDialog.yesNoDialog((Component)this, (String)(string2 = string2 + "\n\n Continue?"), (String)"Directory Name Too Long")) {
                    return false;
                }
            }
            if (string4.length() > 64) {
                string4 = this.truncateToMaxNameLength(string4);
                string2 = "The file name is longer than the maximum allowable size (64). \n";
                string2 = string2 + "If you continue, the IOS startup config file will still be copied to the " + this.ctrlCard + " \n";
                string2 = string2 + "but the properties dialog will display the file name in it's trucated form: \n\n";
                string2 = string2 + string4;
                if (!CerentDialog.yesNoDialog((Component)this, (String)(string2 = string2 + "\n\n Continue?"), (String)"File Name Too Long")) {
                    return false;
                }
            }
            if (null != this.iosConfigModel) {
                try {
                    if (IOSConfigDialog.db.on) {
                        db.println(" calling saveIosConfig(contents, hostName=" + string3 + ", directoryName=" + (String)object + ", localFileName=" + string4 + ", timeInSeconds=" + n);
                    }
                    this.iosConfigModel.saveIosConfig(string, string3, (String)object, string4, n);
                    bl = true;
                }
                catch (IosConfigTooBig iosConfigTooBig) {
                    if (IOSConfigDialog.db.on) {
                        db.println("Exception caught in copyFileToTCC: " + (Object)((Object)iosConfigTooBig));
                    }
                    SDebug.printStackTrace((Throwable)iosConfigTooBig);
                    ErrorMsg.displayDetailed((Component)this, EMC.EID_IOS_CONFIG_TCC_FAIL_PARAM_1, this.ctrlCard, "This file is too big.");
                }
                catch (SoftwareError softwareError) {
                    if (IOSConfigDialog.db.on) {
                        db.println("Exception caught in copyFileToTCC: " + (Object)((Object)softwareError));
                    }
                    SDebug.printStackTrace((Throwable)softwareError);
                    ErrorMsg.displayError((Component)this, (EID)EMC.EID_IOS_CONFIG_TCC_FAIL_PARAM_1, (Object)this.ctrlCard);
                }
                catch (UpdateInProgress updateInProgress) {
                    if (IOSConfigDialog.db.on) {
                        db.println("Exception caught in copyFileToTCC: " + (Object)((Object)updateInProgress));
                    }
                    SDebug.printStackTrace((Throwable)updateInProgress);
                    ErrorMsg.displayDetailed((Component)this, EMC.EID_IOS_CONFIG_TCC_FAIL_PARAM_1, this.ctrlCard, "There is an update in progress.\nPlease try again later.");
                }
            }
        }
        return bl;
    }

    public void update(Observable observable, Object object) {
        if (IOSConfigDialog.db.on) {
            db.println("update recieved in IOSConfigDialog: o=" + observable + ", arg=" + object);
        }
        if (IOSConfigDialog.db.on) {
            db.println("    class of arg is: " + object.getClass());
        }
        if (object instanceof Integer) {
            if (object == ModelUpdateType.DELETED) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        IOSConfigDialog.this.setVisible(false);
                        IOSConfigDialog.this.dispose();
                    }
                });
            } else if (object == ModelUpdateType.CHANGED && null != this.iosConfigModel) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        IOSConfigDialog.this.updateSourcePropertiesInfo();
                        IOSConfigDialog.this.mergeButton.setEnabled(!IOSConfigDialog.this.iosConfigModel.isIosConfigMerged() && IOSConfigDialog.this.isUserLevelSufficient());
                    }
                });
            }
        }
    }

    private boolean isUserLevelSufficient() {
        boolean bl = AbstractPane.isUserAuthorized((IModel)this.moduleModel, SecurityLevel.SUPERUSER);
        boolean bl2 = AbstractPane.isUserAuthorized((IModel)this.moduleModel, SecurityLevel.PROVISIONING);
        return bl || bl2;
    }
}

