/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.IPortModel;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmUpdate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.MutablePortCreationDialog;
import cerent.cms.ui.MutablePortsTableModel;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.ppm.ChangePpmPortRateDialog;
import cerent.util.ComparisonUtil;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.WindowHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class MutablePortsPane
extends NodeProvPane
implements ActionListener,
ListSelectionListener {
    private final SDebug _db;
    private HashMap _containers;
    private ObservableManager _obsMgr;
    private int _containerType;
    private CSHelpID _helpId;
    public static final String CREATE = "Create...";
    public static final String EDIT = "Edit...";
    public static final String DELETE = "Delete...";
    protected MutablePortsTableModel tableModel;
    protected JButton createPB;
    protected JButton editPB;
    protected JButton deletePB;
    protected CSHelpButton _helpPB;
    private PortModel[] _models;
    private int _numModels;
    private boolean needsEditButton;

    public MutablePortsPane(String string, TabbedView tabbedView, IPortContainer[] iPortContainerArray, int n, boolean bl, CSHelpID cSHelpID, SDebug sDebug) {
        super(string, tabbedView);
        this.needsEditButton = bl;
        int n2 = iPortContainerArray.length;
        this._containers = new HashMap(n2);
        this._containerType = n;
        this._helpId = cSHelpID;
        this._db = sDebug;
        for (int i = 0; i < n2; ++i) {
            this._containers.put(iPortContainerArray[i], iPortContainerArray[i].getContainedPorts());
        }
        this.init();
        this.registerWithModel();
    }

    protected ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    private void init() {
        this.createPortsPanel();
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.setComponentsEnabled();
    }

    private PortModel[] getPorts() {
        ArrayList arrayList;
        block5: {
            arrayList = new ArrayList();
            Iterator iterator = this._containers.values().iterator();
            while (iterator.hasNext()) {
                arrayList.addAll((List)iterator.next());
            }
            try {
                Collections.sort(arrayList, new PortComparator());
            }
            catch (Exception exception) {
                if (!this._db.on()) break block5;
                this._db.println("Caught exception while sorting port num.");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (this._db.on()) {
            this._db.println("There are " + arrayList.size() + " ports.");
            Iterator iterator = arrayList.iterator();
            int n = 1;
            while (iterator.hasNext()) {
                this._db.println("port " + n + " = " + iterator.next());
                ++n;
            }
        }
        return arrayList.toArray(new PortModel[arrayList.size()]);
    }

    protected void createPortsPanel() {
        this.setLayout(new BorderLayout());
        this._models = this.getPorts();
        this._numModels = this._models == null ? 0 : this._models.length;
        this.getObsMgr().addObservable(this._containers.keySet().toArray(new Observable[this._containers.size()]));
        this.tableModel = new MutablePortsTableModel(this._models, ((ModuleModel)this.getUiModel()).getEqType(), this.getUiModel().getNodeModel(), this._db);
        this.table = new UTable((TableModel)this.tableModel);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.table.getColumnModel().getColumn(i).setCellRenderer(new PortTableCellRenderer());
        }
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.add(this.getButtonBar(), "South");
    }

    protected JPanel getButtonBar() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        this.createPB = new JButton(CREATE);
        jPanel2.add(this.createPB);
        this.editPB = new JButton(EDIT);
        if (this.needsEditButton) {
            jPanel2.add(this.editPB);
        }
        this.deletePB = new JButton(DELETE);
        jPanel2.add(this.deletePB);
        this._helpPB = new CSHelpButton(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MutablePortsPane.this._helpPB.launchHelp(MutablePortsPane.this.getHelpID());
            }
        });
        jPanel3.add(this._helpPB);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        if (this.isUserAuthorized()) {
            this.createPB.addActionListener(this);
            this.deletePB.addActionListener(this);
            this.editPB.addActionListener(this);
        }
        return jPanel;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.setComponentsEnabled();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.createPB) {
            this.doCreate();
        } else if (object == this.editPB) {
            this.doEdit();
        } else if (object == this.deletePB) {
            this.doDelete();
        }
    }

    private void doDelete() {
        int n;
        if (this.table.getSelectedRowCount() == 1 && (n = this.table.getSelectedRow()) >= 0 && n < this._numModels && CerentDialog.yesNoDialog((Component)((Object)this), (String)("Really delete port " + PortHelper.getPortNumString((IPortModel)this._models[n]) + "?"), (String)"Delete Port")) {
            String string = "\nPort cannot be deleted if :\n\t- It is in service\n\t- It is in a protection group\n\t- It has a DCC/GCC in use\n\t- It is a timing source\n\t- It has circuits\n\t- It has overhead circuits\n\t- It has LMP data links";
            try {
                this._models[n].getNodeModelDelegate().getEntityTableModel().unprovisionPort(this._models[n]);
            }
            catch (ProvisionError provisionError) {
                EID eID = provisionError.getEID();
                if (eID != null) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)eID, (Object[])provisionError.getEIDParams());
                } else {
                    ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, provisionError.getPrettyMessage() + string);
                }
            }
            catch (ResourceInUse resourceInUse) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_PORT_IS_IN_USE, string);
            }
            catch (Exception exception) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, exception.toString());
            }
        }
    }

    protected void doCreate() {
        MutablePortCreationDialog.instance(this, this._containers.keySet().toArray(new IPortContainer[this._containers.size()])).show();
    }

    protected void doEdit() {
        int n;
        if (this.table.getSelectedRowCount() == 1 && (n = this.table.getSelectedRow()) >= 0 && n < this._numModels) {
            IEntityModel[] iEntityModelArray = new IEntityModel[]{(ModuleModel)this.getUiModel(), this._models[n]};
            ChangePpmPortRateDialog changePpmPortRateDialog = ChangePpmPortRateDialog.instance((Component)((Object)this), iEntityModelArray);
            changePpmPortRateDialog.pack();
            changePpmPortRateDialog.setVisible(true);
        }
    }

    public void refreshFromModel() {
        this.tableModel.refreshFromModel();
        this.setComponentsEnabled();
    }

    protected synchronized void setComponentsEnabled() {
        boolean bl = this.isUserAuthorized();
        this.setCreateEnabled(bl);
        this.setEditDeleteEnabled(this.table.getSelectedRow(), bl);
    }

    private void setCreateEnabled(boolean bl) {
        boolean bl2;
        block4: {
            bl2 = false;
            try {
                Iterator iterator = this._containers.keySet().iterator();
                while (bl && !bl2 && iterator.hasNext()) {
                    IPortContainer iPortContainer = (IPortContainer)iterator.next();
                    if (bl2) continue;
                    int n = iPortContainer.getContainedPorts().size();
                    if (this._db.on()) {
                        this._db.println("Contained ports size = " + n);
                    }
                    bl2 = iPortContainer.allowsPortCreation() && iPortContainer.getMaxPorts() > n;
                }
            }
            catch (Exception exception) {
                this._db.println("Caught exception in setCreateEnabled");
                if (!this._db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        WindowHelper.setEnabled((JComponent)this.createPB, (bl && bl2 ? 1 : 0) != 0);
    }

    private void setEditDeleteEnabled(int n, boolean bl) {
        boolean bl2;
        boolean bl3;
        block4: {
            bl3 = n != -1 && bl;
            bl2 = n != -1 && bl;
            try {
                if (bl3 || bl2) {
                    Iterator iterator = this._containers.keySet().iterator();
                    boolean bl4 = false;
                    while (!bl4 && iterator.hasNext()) {
                        IPortContainer iPortContainer = (IPortContainer)iterator.next();
                        if (!((List)this._containers.get(iPortContainer)).contains(this._models[n])) continue;
                        bl3 = bl3 && iPortContainer.allowsPortDeletion();
                        bl2 = bl2 && iPortContainer.allowsPortEditing();
                        bl4 = true;
                    }
                }
            }
            catch (Exception exception) {
                this._db.println("Caught exception in setEditDeleteEnabled");
                if (!this._db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        WindowHelper.setEnabled((JComponent)this.editPB, (boolean)bl2);
        WindowHelper.setEnabled((JComponent)this.deletePB, (boolean)bl3);
    }

    protected void refreshMyLines(Object object) {
        ModuleModelUpdate moduleModelUpdate;
        IPortContainer iPortContainer;
        if (this._db.on()) {
            this._db.println("Processing " + object);
        }
        if (object instanceof PpmUpdate && this._containerType == 150) {
            this.getObsMgr().removeObservable(this._containers.keySet().toArray(new Observable[this._containers.size()]));
            this._containers.clear();
            IPortContainer[] iPortContainerArray = (IPortContainer[])((PpmUpdate)object).getModels();
            for (int i = 0; i < iPortContainerArray.length; ++i) {
                this._containers.put(iPortContainerArray[i], iPortContainerArray[i].getContainedPorts());
            }
            this._models = this.getPorts();
            this._numModels = this._models == null ? 0 : this._models.length;
            this.getObsMgr().addObservable(this._containers.keySet().toArray(new Observable[this._containers.size()]));
            this.tableModel.refreshMyLines(this._models);
            this.setComponentsEnabled();
        } else if (object instanceof ModuleModelUpdate && ((ModuleModelUpdate)object).isLineModelUpdate() && (iPortContainer = (moduleModelUpdate = (ModuleModelUpdate)object).getContainer()) != null && this._containers.containsKey(iPortContainer)) {
            this._containers.put(iPortContainer, iPortContainer.getContainedPorts());
            this._models = this.getPorts();
            this._numModels = this._models == null ? 0 : this._models.length;
            this.tableModel.refreshMyLines(this._models);
            this.setComponentsEnabled();
        }
    }

    public CSHelpID getHelpID() {
        return this._helpId;
    }

    public void changeMessage(Observable observable, Object object) {
        if (this._db.on()) {
            this._db.println("Got an Update Message for " + observable);
        }
        this.requestRefresh(observable, this.getRefreshThread(observable));
        this.setComponentsEnabled();
    }

    private Runnable getRefreshThread(Observable observable) {
        return new Runnable(){

            public void run() {
                MutablePortsPane.this.tableModel.refreshFromModel();
            }
        };
    }

    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        super.dispose();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        this.getObsMgr().setPassing(true);
    }

    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        super.leavingPage();
    }

    private class PortComparator
    implements Comparator {
        private PortComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof PortModel && object2 instanceof PortModel) {
                PortModel portModel = (PortModel)object;
                PortModel portModel2 = (PortModel)object2;
                return ComparisonUtil.compare((int[])portModel.getPortNum(), (int[])portModel2.getPortNum());
            }
            return -1;
        }

        public boolean equals(Object object) {
            return object instanceof PortComparator;
        }
    }

    class PortTableCellRenderer
    extends DefaultTableCellRenderer {
        PortTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (MutablePortsPane.this._models[n] != null) {
                this.setRowColor(jTable, jLabel, bl, MutablePortsPane.this._models[n]);
            }
            return jLabel;
        }

        private void setRowColor(JTable jTable, JLabel jLabel, boolean bl, PortModel portModel) {
            if (bl) {
                jLabel.setForeground(ElementDefaults.SELECTION_FG);
                jLabel.setBackground(ElementDefaults.SELECTION_BG);
            } else {
                boolean bl2;
                block5: {
                    bl2 = false;
                    try {
                        IEntityModel iEntityModel = portModel.getParent();
                        if (iEntityModel instanceof MfgEntityModel) {
                            int n = ((MfgEntityModel)iEntityModel).getState().value();
                            bl2 = n == 0 || n == 1;
                        }
                    }
                    catch (CmsObjectNotExistException cmsObjectNotExistException) {
                        NodeProvPane.db.println("Caught ObjectNotExist in setRowColor");
                        if (!NodeProvPane.db.on()) break block5;
                        SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
                    }
                }
                jLabel.setForeground(bl2 ? ElementDefaults.PRE_PROVISION_FG : jTable.getForeground());
                jLabel.setBackground(bl2 ? ElementDefaults.PRE_PROVISION_BG : jTable.getBackground());
            }
        }
    }
}

