/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.INodeModel;
import cerent.util.SDebug;
import cerent.util.gui.CheckableItem;
import cerent.util.gui.CheckableList;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class NodeSelectPane
extends JPanel
implements ActionListener {
    private static final String DESC = "Select Applicable Nodes";
    private static final String SELECT_ALL = "Select All";
    private static final String UNSELECT_ALL = "Unselect All";
    private CheckableList nodeLB;
    private boolean showSelectButton = false;
    private JButton selectButton;
    private static final SDebug db = new SDebug("NodeSelectPane");

    public NodeSelectPane(Collection collection) {
        this.init(collection, true);
    }

    public NodeSelectPane(Collection collection, boolean bl) {
        this.init(collection, bl);
    }

    private void init(Collection collection, boolean bl) {
        this.showSelectButton = bl;
        this.setLayout(new BorderLayout());
        this.nodeLB = new CheckableList();
        this.nodeLB.setVisibleRowCount(6);
        if (bl) {
            this.add((Component)this.getButtonPane(), "North");
        } else {
            this.add((Component)new JLabel(DESC), "North");
        }
        this.add((Component)new UScrollPane((Component)this.nodeLB), "Center");
        this.updateNodesList(collection, true, true);
    }

    public void updateNodesList(Collection collection, boolean bl, boolean bl2) {
        ArrayList<CheckableItem> arrayList = new ArrayList<CheckableItem>(0);
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof INodeModel)) continue;
                INodeModel iNodeModel = (INodeModel)e;
                arrayList.add(new CheckableItem(new NodeInfo(iNodeModel), bl, bl2));
            }
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    CheckableItem checkableItem = (CheckableItem)object;
                    CheckableItem checkableItem2 = (CheckableItem)object2;
                    return checkableItem.toString().compareTo(checkableItem2.toString());
                }
            });
        }
        this.nodeLB.setListData(arrayList.toArray(new CheckableItem[0]));
        this.nodeLB.invalidate();
        this.nodeLB.repaint();
    }

    private JPanel getButtonPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(DESC), "West");
        this.selectButton = new JButton(UNSELECT_ALL);
        jPanel.add((Component)this.selectButton, "East");
        this.selectButton.addActionListener(this);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.selectButton) {
            if (this.selectButton.getText().equals(SELECT_ALL)) {
                this.toggleSelect(true);
                this.selectButton.setText(UNSELECT_ALL);
            } else {
                this.toggleSelect(false);
                this.selectButton.setText(SELECT_ALL);
            }
        }
    }

    public void toggleSelectedEnabled(boolean bl, boolean bl2) {
        ListModel listModel = this.nodeLB.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            checkableItem.setSelected(bl);
            checkableItem.setEnabled(bl2);
        }
        this.nodeLB.invalidate();
        this.nodeLB.repaint();
    }

    private void toggleSelect(boolean bl) {
        ListModel listModel = this.nodeLB.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            checkableItem.setSelected(bl);
        }
        this.nodeLB.invalidate();
        this.nodeLB.repaint();
    }

    public List getSelectedList() {
        ArrayList<INodeModel> arrayList = new ArrayList<INodeModel>(0);
        ListModel listModel = this.nodeLB.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            if (!checkableItem.isSelected()) continue;
            arrayList.add(((NodeInfo)checkableItem.getObject()).getNodeModel());
        }
        return arrayList;
    }

    class NodeInfo {
        private INodeModel nodeModel;

        NodeInfo(INodeModel iNodeModel) {
            this.nodeModel = iNodeModel;
        }

        public String toString() {
            String string = "?????";
            try {
                string = this.nodeModel.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }

        public INodeModel getNodeModel() {
            return this.nodeModel;
        }
    }
}

