/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IPluggableCarrierModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.model.PimModel;
import cerent.cms.model.PimUpdate;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.PpmUpdate;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.event.IEventPanelController;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.UObservable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public abstract class PluggableCardTabbedView
extends CardTabbedView
implements Observer {
    private LineObservable _myObs = null;
    private ObservableManager _obsMgr = null;
    private ArrayList _pimModelsList = new ArrayList();
    private ArrayList _ppmSlotsList = new ArrayList();
    private ArrayList _ppmModelsList = new ArrayList();
    protected Map _interfaceContainers = null;

    public PluggableCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
        this.init();
        this.showTabs();
    }

    public Observable getObservable() {
        if (this._myObs == null) {
            this._myObs = new LineObservable();
        }
        return this._myObs;
    }

    protected ObservableManager getOM() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager(this, false);
        }
        return this._obsMgr;
    }

    protected void init() {
        IPluggableCarrierModel iPluggableCarrierModel = (IPluggableCarrierModel)this.getUiModel();
        PluggableSlotModel[] pluggableSlotModelArray = iPluggableCarrierModel.getPimSlots();
        this.getOM().addObservable((Observable[])pluggableSlotModelArray);
        pluggableSlotModelArray = iPluggableCarrierModel.getPpmSlots();
        this._ppmSlotsList = new ArrayList<PluggableSlotModel>(Arrays.asList(pluggableSlotModelArray));
        this.getOM().addObservable((Observable[])pluggableSlotModelArray);
        PimModel[] pimModelArray = iPluggableCarrierModel.getPimModels();
        this._pimModelsList = new ArrayList<PimModel>(Arrays.asList(pimModelArray));
        this.getOM().addObservable((Observable[])pimModelArray);
        PpmModel[] ppmModelArray = iPluggableCarrierModel.getPpmModels();
        this._ppmModelsList = new ArrayList<PpmModel>(Arrays.asList(ppmModelArray));
        this.getOM().addObservable((Observable[])ppmModelArray);
        this.getOM().setActive(true);
        this.getOM().setPassing(true);
    }

    protected PimModel[] getPimModelsArray() {
        return this._pimModelsList.toArray(new PimModel[this._pimModelsList.size()]);
    }

    protected PluggableSlotModel[] getPpmSlotsArray() {
        return this._ppmSlotsList.toArray(new PluggableSlotModel[this._ppmSlotsList.size()]);
    }

    protected PpmModel[] getPpmModelsArray() {
        return this._ppmModelsList.toArray(new PpmModel[this._ppmModelsList.size()]);
    }

    protected List addModel(Observable observable) {
        IPluggableCarrierModel iPluggableCarrierModel = (IPluggableCarrierModel)this.getUiModel();
        ArrayList<ModuleModelUpdate> arrayList = new ArrayList<ModuleModelUpdate>();
        if (observable instanceof PluggableSlotModel) {
            Model[] modelArray = iPluggableCarrierModel.getPimModels();
            Model[] modelArray2 = iPluggableCarrierModel.getPpmModels();
            if (modelArray.length > this._pimModelsList.size()) {
                db.fine("PIM added.");
                this._pimModelsList = new ArrayList<PimModel>(Arrays.asList(modelArray));
                this.getOM().addObservable((Observable[])modelArray);
                db.fine("PPM slots added.");
                PluggableSlotModel[] pluggableSlotModelArray = iPluggableCarrierModel.getPpmSlots();
                this._ppmSlotsList = new ArrayList<PluggableSlotModel>(Arrays.asList(pluggableSlotModelArray));
                this.getOM().addObservable((Observable[])pluggableSlotModelArray);
                arrayList.add(new PimUpdate(modelArray));
            }
            if (modelArray2.length > this._ppmModelsList.size()) {
                db.fine("PPM added, PPM update queued.");
                this._ppmModelsList = new ArrayList<PpmModel>(Arrays.asList(modelArray2));
                this.getOM().addObservable((Observable[])modelArray2);
                arrayList.add(new PpmUpdate(modelArray2));
            }
        }
        return arrayList;
    }

    protected List removeModel(Observable observable) {
        this.getOM().removeObservable(observable);
        ArrayList<ModuleModelUpdate> arrayList = new ArrayList<ModuleModelUpdate>();
        if (observable instanceof PimModel && this._pimModelsList.remove(observable)) {
            db.fine("PIM removed.");
            PluggableSlotModel[] pluggableSlotModelArray = ((PimModel)((Object)observable)).getPpmSlots();
            this.getOM().removeObservable((Observable[])pluggableSlotModelArray);
            for (int i = 0; i < pluggableSlotModelArray.length; ++i) {
                this._ppmSlotsList.remove(pluggableSlotModelArray[i]);
            }
            arrayList.add(new PimUpdate(this.getPimModelsArray()));
        } else if (observable instanceof PluggableSlotModel && this._ppmSlotsList.remove(observable)) {
            db.fine("PPM slot removed");
        } else if (observable instanceof PpmModel && this._ppmModelsList.remove(observable)) {
            db.fine("PPM removed, PPM update queued.");
            arrayList.add(new PpmUpdate(this.getPpmModelsArray()));
        }
        return arrayList;
    }

    protected Object removeContainerMap(IInterfaceModel iInterfaceModel) {
        Object var2_2 = null;
        if (this._interfaceContainers != null && this._interfaceContainers.containsKey(iInterfaceModel)) {
            var2_2 = this._interfaceContainers.remove(iInterfaceModel);
            db.fine("Removed " + iInterfaceModel.toString() + " from container map");
        }
        return var2_2;
    }

    protected void addContainerMap(IInterfaceModel iInterfaceModel, IPortContainer iPortContainer) {
        if (this._interfaceContainers != null) {
            this._interfaceContainers.put(iInterfaceModel, iPortContainer);
            db.fine("Added " + iInterfaceModel.toString() + " to container map");
        }
    }

    protected void addContainerMap(IInterfaceModel iInterfaceModel) {
        block2: {
            try {
                this.addContainerMap(iInterfaceModel, (IPortContainer)iInterfaceModel.getPortModel().getParent());
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("Caught NoSuchEntity in init!");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
    }

    public void update(Observable observable, Object object) {
        int n = -1;
        List list = null;
        n = object instanceof IObjectMessageInfo ? ((IObjectMessageInfo)object).getUpdateType() : ((Integer)object).intValue();
        if (db.on()) {
            db.println("PluggableCardTabbedView received an update for " + observable + " type: " + object);
        }
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                if (db.on()) {
                    db.println("Adding a model...");
                }
                list = this.addModel(observable);
                break;
            }
            case 0: {
                if (db.on()) {
                    db.println("Removing a model...");
                }
                list = this.removeModel(observable);
                break;
            }
        }
        if (this._myObs != null && list != null && list.size() > 0) {
            if (db.on()) {
                db.println("Models changed.  Sending " + list.size() + " update(s) of type: " + list);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this._myObs.changed();
                this._myObs.notifyObservers((ModuleModelUpdate)iterator.next());
            }
        }
    }

    public void destroy() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        this._pimModelsList.clear();
        this._ppmSlotsList.clear();
        this._ppmModelsList.clear();
        if (this._interfaceContainers != null) {
            this._interfaceContainers.clear();
        }
        super.destroy();
    }

    private class LineObservable
    extends UObservable {
        private LineObservable() {
        }

        public void changed() {
            this.setChanged();
        }
    }
}

