/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.IPlatform;
import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.If.eIfType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmLineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmLoModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPmTableModel;
import cerent.cms.ui.LoInfo;
import cerent.cms.ui.MuxIndex;
import cerent.cms.ui.PmRendererStat;
import cerent.cms.ui.PmRendererStatRatio;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.pm.PmLayer;
import cerent.cms.ui.pm.PmLayerDs1Path;
import cerent.cms.ui.pm.PmLayerDs3Line;
import cerent.cms.ui.pm.PmLayerDs3i;
import cerent.cms.ui.pm.PmLayerDwdmOptics;
import cerent.cms.ui.pm.PmLayerE1;
import cerent.cms.ui.pm.PmLayerE3;
import cerent.cms.ui.pm.PmLayerE4Line;
import cerent.cms.ui.pm.PmLayerLoPath;
import cerent.cms.ui.pm.PmLayerOptics;
import cerent.cms.ui.pm.PmLayerSdhHoPath;
import cerent.cms.ui.pm.PmLayerSdhLine;
import cerent.cms.ui.pm.PmLayerSonetHoPath;
import cerent.cms.ui.pm.PmLayerSonetLine;
import cerent.cms.ui.pm.PmLayerSonetLinePhys;
import cerent.cms.ui.pm.PmLayerSonetStsPjc;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.IFixedColumnsTableModel;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Iterator;

public class PmTableModel
extends AbstractPmTableModel
implements IFixedColumnsTableModel {
    protected PmLayer currLayer;
    protected int currRowMin;
    protected int currRowMax;
    protected ArrayList choiceIFModel = new ArrayList(10);
    protected ArrayList choiceRanges = new ArrayList(10);
    protected ArrayList layers = new ArrayList(10);
    protected InterfaceModel[] lineModels;
    protected int numRows;
    protected int CurrentValues_numRows;
    private int curLayer;
    private int curChoice;
    private boolean fromPeerCard;
    private int currIntervalType;
    private int prevIntervalType;
    private boolean currNearEnd;
    private boolean prevNearEnd;
    private boolean IsCurrentValue;
    public static SDebug db = new SDebug("PmTableModel");
    public boolean flg_Barolo_Card = false;
    public double NA_VALUE = -1000000.0;
    protected IPlatform pci;

    public PmTableModel(InterfaceModel[] interfaceModelArray, NodeModelDelegate nodeModelDelegate) {
        this(interfaceModelArray, false, nodeModelDelegate);
    }

    public PmTableModel(InterfaceModel[] interfaceModelArray, boolean bl, NodeModelDelegate nodeModelDelegate) {
        this.lineModels = interfaceModelArray;
        this.numRows = 0;
        this.CurrentValues_numRows = 3;
        this.fromPeerCard = false;
        this.IsCurrentValue = bl;
        this.currIntervalType = 0;
        this.prevIntervalType = 0;
        this.currNearEnd = true;
        this.prevNearEnd = true;
        this.pci = nodeModelDelegate.getPlatform();
        this.setColNames(this.pci.getPmColumnNames());
    }

    private String getDs1PortName(NodeModelDelegate nodeModelDelegate, int n, int n2) {
        String string = "";
        EntityModel entityModel = null;
        Integer[] integerArray = nodeModelDelegate.getEntityTable().getElementIndices();
        for (int i = 0; i < integerArray.length; ++i) {
            try {
                entityModel = (EntityModel)nodeModelDelegate.getEntityTable().getEntityModelByIndex(integerArray[i].intValue());
                if (entityModel.getSlot() != n || entityModel.getPort() != n2) continue;
                PortModel portModel = (PortModel)entityModel;
                string = portModel.getInterfaceModel().getAlias();
                continue;
            }
            catch (Exception exception) {
                db.finest("Exception in getDs1PortName " + exception);
            }
        }
        if (string != null && !string.equals("")) {
            string = " \"" + string + "\"";
        }
        return string;
    }

    protected synchronized ArrayList getItemList(NodeModelDelegate nodeModelDelegate, int n, int n2) {
        ArrayList<Item> arrayList = new ArrayList<Item>(10);
        for (int i = n; i < this.layerCount(); ++i) {
            int n3;
            Item item = new Item();
            int n4 = this.choiceCount(i);
            String string = this.layerLabel(i) + ":";
            int n5 = nodeModelDelegate.getFramingType();
            item.label = string;
            item.layer = i;
            if (i == 0) {
                for (n3 = 0; n3 < n4; ++n3) {
                    item.contents.add(this.lineModels[n3]);
                }
            } else if (string.indexOf("VT") != -1) {
                for (n3 = 0; n3 < n4; ++n3) {
                    short s = (short)this.layerMuxIndex(i, n3);
                    item.contents.add(new LoInfo(n5, s));
                }
            } else if (string.indexOf("VC LO") != -1) {
                for (n3 = 0; n3 < n4; ++n3) {
                    short s = (short)this.layerMuxIndex(i, n3);
                    item.contents.add(new Integer(s));
                }
            } else {
                for (n3 = 0; n3 < n4; ++n3) {
                    MuxIndex muxIndex = this.layerMux(i, n3);
                    item.contents.add(muxIndex);
                }
            }
            arrayList.add(item);
        }
        return arrayList;
    }

    protected synchronized String getLabel(ArrayList arrayList) {
        String string = "";
        if (arrayList.isEmpty() || arrayList.size() < this.layerCount()) {
            return string;
        }
        for (int i = 0; i < this.layerCount(); ++i) {
            Object object;
            String string2 = this.layerLabel(i);
            Object e = arrayList.get(i);
            if (e == null) continue;
            if (e instanceof LoInfo) {
                object = (LoInfo)e;
                string = string + string2 + " " + ((LoInfo)object).loGroup + "-" + ((LoInfo)object).loNum + ", ";
                continue;
            }
            if (!(e instanceof MuxIndex)) continue;
            object = (MuxIndex)e;
            string = string + this.layerLabel(i) + " #" + ((MuxIndex)object).toShortString() + ((MuxIndex)object).getPortName() + ", ";
        }
        return string;
    }

    protected synchronized int choiceCount(int n) {
        return (Integer)this.choiceRanges.get(n);
    }

    public synchronized void clearStatsForParam(int[] nArray) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        Iterator iterator = this.layers.iterator();
        this.currRowMax = 0;
        int n = 0;
        while (iterator.hasNext()) {
            this.currRowMin = this.currRowMax;
            this.currLayer = (PmLayer)iterator.next();
            this.currRowMax += this.currLayer.parmCount();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (n < nArray.length && nArray[n] >= this.currRowMin && nArray[n] < this.currRowMax) {
                arrayList.add((String)this.getValueAt(nArray[n], 0));
                ++n;
            }
            if (arrayList.size() == 0) continue;
            Object[] objectArray = arrayList.toArray();
            String[] stringArray = new String[objectArray.length];
            System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
            this.currLayer.clearStats(stringArray);
        }
    }

    public void clearStatsForCard() throws NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, UnsupportedOperation {
        block4: {
            eIfType eIfType2;
            PmLayer pmLayer;
            InterfaceModel interfaceModel;
            block3: {
                interfaceModel = null;
                if (this.pci.is600()) break block3;
                for (int i = 0; i < this.lineModels.length; ++i) {
                    interfaceModel = this.lineModels[i];
                    db.println("clearing stats for interface: " + interfaceModel);
                    this.clearStatsForChildInterfaces(interfaceModel);
                }
                break block4;
            }
            if (null == this.lineModels[0] || null == (pmLayer = this.createPmLayer(eIfType2 = interfaceModel.getInfo().ifType, interfaceModel = this.lineModels[0]))) break block4;
            if (db.on()) {
                db.println("clearing stats for card: ");
            }
            pmLayer.clearAllStatsForCard();
            for (int i = 0; i < this.lineModels.length; ++i) {
                interfaceModel = this.lineModels[i];
                this.clearStatsForChildInterfaces(interfaceModel);
            }
        }
    }

    public void clearStatsForPort(InterfaceModel interfaceModel) throws NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, UnsupportedOperation {
        if (!this.pci.is600()) {
            if (db.on()) {
                db.println("clearing stats for interface: " + interfaceModel);
            }
            this.clearStatsForChildInterfaces(interfaceModel);
        } else {
            eIfType eIfType2 = interfaceModel.getInfo().ifType;
            PmLayer pmLayer = this.createPmLayer(eIfType2, interfaceModel);
            if (null != pmLayer) {
                if (db.on()) {
                    db.println("clearing stats for interface: " + interfaceModel);
                }
                pmLayer.clearAllStatsForLine();
                this.clearStatsForChildInterfaces(interfaceModel);
            }
        }
    }

    private void clearStatsForChildInterfaces(InterfaceModel interfaceModel) throws NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, UnsupportedOperation {
        eIfType eIfType2 = interfaceModel.getInfo().ifType;
        PmLayer pmLayer = this.createPmLayer(eIfType2, interfaceModel);
        if (null != pmLayer) {
            if (db.on()) {
                db.println("clearing stats for layer: " + pmLayer.layerLabel());
            }
            pmLayer.setIntervalType(eIntervalType.INTERVAL_15_MIN);
            if (!this.pci.is600()) {
                pmLayer.clearStats();
            }
            pmLayer.tossData();
            pmLayer.setIntervalType(eIntervalType.INTERVAL_DAY);
            if (!this.pci.is600()) {
                pmLayer.clearStats();
            }
            pmLayer.tossData();
            if (pmLayer.hasFarEnd()) {
                pmLayer.setNearEnd(false);
                pmLayer.setIntervalType(eIntervalType.INTERVAL_15_MIN);
                if (!this.pci.is600()) {
                    pmLayer.clearStats();
                }
                pmLayer.tossData();
                pmLayer.setIntervalType(eIntervalType.INTERVAL_DAY);
                if (!this.pci.is600()) {
                    pmLayer.clearStats();
                }
                pmLayer.tossData();
            } else {
                db.println("ignoring far end for: " + pmLayer.layerLabel());
            }
        }
        if (null != pmLayer && pmLayer.isHigherPmDisplayed()) {
            InterfaceModel[] interfaceModelArray = interfaceModel.getHigherLayerModels();
            for (int i = 0; i < interfaceModelArray.length; ++i) {
                this.clearStatsForChildInterfaces(interfaceModelArray[i]);
            }
        }
    }

    public synchronized void clearStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, UnsupportedOperation {
        Iterator iterator = this.layers.iterator();
        while (iterator.hasNext()) {
            PmLayer pmLayer = (PmLayer)iterator.next();
            if (!pmLayer.nearEnd && !pmLayer.hasFarEnd()) continue;
            if (db.on()) {
                db.println("clearing current stats for layer: " + pmLayer.layerLabel());
            }
            pmLayer.clearStats();
        }
    }

    protected PmLayer createPmLayerDs1Path(Ds123LineModel ds123LineModel) {
        return new PmLayerDs1Path(this, ds123LineModel, this.numRegisters);
    }

    protected PmLayer createPmLayerE1(Ds123LineModel ds123LineModel) {
        return new PmLayerE1(this, ds123LineModel, this.numRegisters);
    }

    protected PmLayer createPmLayerE3(Ds123LineModel ds123LineModel) {
        return new PmLayerE3(this, ds123LineModel, this.numRegisters);
    }

    protected PmLayer createPmLayerE4Line(TdmLineModel tdmLineModel) {
        return new PmLayerE4Line(this, tdmLineModel, this.numRegisters);
    }

    protected PmLayer createPmLayerDs3Line(Ds123LineModel ds123LineModel) {
        return new PmLayerDs3Line(this, ds123LineModel, this.numRegisters);
    }

    protected PmLayer createPmLayerDs3i(Ds123LineModel ds123LineModel) {
        return new PmLayerDs3i(this, ds123LineModel, this.numRegisters);
    }

    protected PmLayer createPmLayerDwdmCliLine(DwdmCliLineModel dwdmCliLineModel) {
        return new PmLayerDwdmOptics(this, dwdmCliLineModel, this.numRegisters);
    }

    protected PmLayer createPmLayerDwdmTrkLine(DwdmTrkLineModel dwdmTrkLineModel) {
        return new PmLayerDwdmOptics(this, dwdmTrkLineModel, this.numRegisters);
    }

    protected PmLayer createPmLayerSonetLine(TdmLineModel tdmLineModel) {
        if (this.pci.is600()) {
            return new PmLayerSonetLinePhys(this, tdmLineModel, this.numRegisters);
        }
        if (tdmLineModel.getNodeModel().getFramingType() == 0) {
            return new PmLayerSonetLine(this, tdmLineModel, this.numRegisters);
        }
        return new PmLayerSdhLine(this, tdmLineModel, this.numRegisters);
    }

    protected PmLayer createPmLayerTdmHo(TdmHoModel tdmHoModel) {
        boolean bl;
        block5: {
            bl = false;
            try {
                IPortModel iPortModel;
                int n;
                InterfaceModel interfaceModel = tdmHoModel.getHighestParent();
                if (interfaceModel != null && interfaceModel instanceof ITdmLineModel && ((n = (iPortModel = ((ITdmLineModel)interfaceModel).getPortModel()).getModuleModel().getEqType()) == 219 || n == 220)) {
                    bl = true;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block5;
                db.println("PmTableModel: Could not determine if HO Interface supports Far End PM. Defaulting to false");
            }
        }
        if (this.pci.is600()) {
            return new PmLayerSonetStsPjc(this, tdmHoModel, this.numRegisters);
        }
        if (tdmHoModel.getNodeModel().getFramingType() == 0) {
            return new PmLayerSonetHoPath(this, tdmHoModel, this.numRegisters, bl);
        }
        return new PmLayerSdhHoPath(this, tdmHoModel, this.numRegisters, bl);
    }

    protected PmLayer createPmLayerTdmLo(TdmLoModel tdmLoModel) {
        return new PmLayerLoPath(this, tdmLoModel, this.numRegisters);
    }

    protected PmLayer createPmLayerOptics(AbstractOpticsLineModel abstractOpticsLineModel) {
        return new PmLayerOptics(this, abstractOpticsLineModel, this.numRegisters);
    }

    public boolean isRMON() {
        return false;
    }

    public synchronized boolean hasFarEnd() {
        boolean bl = false;
        Iterator iterator = this.layers.iterator();
        while (iterator.hasNext()) {
            PmLayer pmLayer = (PmLayer)iterator.next();
            if (pmLayer.disableFarEnd()) {
                return false;
            }
            if (!pmLayer.hasFarEnd()) continue;
            bl = true;
        }
        return bl;
    }

    public int getRowCount() {
        if (this.IsCurrentValue) {
            return this.CurrentValues_numRows;
        }
        return this.numRows;
    }

    public Object getValueAt(int n, int n2) {
        block16: {
            try {
                Object object = this.getValueAtImpl(n, n2);
                if (1 == n2 && object != null) {
                    this.initBaseline();
                    if (object instanceof PmRendererStat) {
                        PmRendererStat pmRendererStat = (PmRendererStat)object;
                        long l = pmRendererStat.getLongCnt();
                        long l2 = this.baseline[n];
                        if (!this.flg_Barolo_Card) {
                            if (l >= 0L) {
                                long l3 = l - l2;
                                if (l3 < 0L) {
                                    this.resetBaseline();
                                } else if (l2 > 0L) {
                                    object = this.setLongValue(pmRendererStat, l3);
                                }
                            }
                        } else if ((double)l != this.NA_VALUE) {
                            long l4 = l - l2;
                            object = this.setLongValueB(pmRendererStat, l4);
                        }
                    } else if (object instanceof PmRendererStatRatio) {
                        PmRendererStatRatio pmRendererStatRatio = (PmRendererStatRatio)object;
                        float f = pmRendererStatRatio.getFloatCnt();
                        float f2 = (float)this.baseline[n] / 10.0f;
                        if (this.flg_Barolo_Card && (double)f != this.NA_VALUE) {
                            float f3 = f - f2;
                            object = this.setFloatValue(pmRendererStatRatio, f3);
                        }
                    }
                }
                return object;
            }
            catch (InternalCommError internalCommError) {
                if (db.on()) {
                    db.println("Caught exception in getValueAt(" + n + ", " + n2 + ": " + (Object)((Object)internalCommError));
                    SDebug.printStackTrace((Throwable)internalCommError);
                }
            }
            catch (Exception exception) {
                db.println("Caught exception in getValueAt(" + n + ", " + n2 + ": " + exception);
                if (!db.on()) break block16;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    protected Object getValueAtImpl(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        int n3 = n2 - 1;
        if (db.on()) {
            db.println("[PmTableModel] getValueAtImpl(" + n + "," + n2 + ")");
        }
        if (n >= this.numRows) {
            n = this.numRows - 1;
        }
        if (n < this.currRowMin || n >= this.currRowMax) {
            Iterator iterator = this.layers.iterator();
            this.currRowMax = 0;
            while (iterator.hasNext() && n >= this.currRowMax) {
                this.currRowMin = this.currRowMax;
                this.currLayer = (PmLayer)iterator.next();
                this.currRowMax += this.currLayer.parmCount();
            }
        }
        n -= this.currRowMin;
        if (n2 == 0) {
            return this.currLayer.parmName(n);
        }
        if (db.on()) {
            db.println("Calling refreshPmStats for " + this.currLayer);
        }
        this.currLayer.refreshPmStats(n3);
        this.fromPeerCard = this.currLayer.isFromPeerCard();
        return this.currLayer.getPmValue(n, n3);
    }

    public long getLongValue(Object object) {
        return ((PmRendererStat)object).getLongCnt();
    }

    public float getLongValueB(Object object) {
        return ((PmRendererStatRatio)object).getFloatCnt();
    }

    public Object setLongValue(Object object, long l) {
        ((PmRendererStat)object).setLongCnt(l);
        return object;
    }

    public Object setLongValueB(Object object, long l) {
        ((PmRendererStatRatio)object).setFloatCnt(l);
        return object;
    }

    public float getFloatValue(Object object) {
        return ((PmRendererStatRatio)object).cnt;
    }

    public Object setFloatValue(Object object, float f) {
        ((PmRendererStatRatio)object).cnt = f;
        return object;
    }

    public boolean isFromPeerCard() {
        return this.fromPeerCard;
    }

    protected synchronized int layerCount() {
        return this.choiceRanges.size();
    }

    protected synchronized String layerLabel(int n) {
        return ((PmLayer)this.layers.get(n)).layerLabel();
    }

    protected int getMuxIndex(int n) {
        return n;
    }

    protected String getMediumStr(InterfaceModel interfaceModel) {
        return "";
    }

    protected synchronized MuxIndex layerMux(int n, int n2) {
        MuxIndex muxIndex;
        try {
            Object[] objectArray;
            if (n < 1) {
                objectArray = this.lineModels;
            } else {
                InterfaceModel interfaceModel = (InterfaceModel)this.choiceIFModel.get(n - 1);
                objectArray = this.getNextLayer(interfaceModel);
            }
            muxIndex = this.createMuxIndex(objectArray[n2], n2);
        }
        catch (Exception exception) {
            muxIndex = new MuxIndex();
            db.println("error in PmTableModel.layerMuxIndex()" + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        return muxIndex;
    }

    protected MuxIndex createMuxIndex(Object object, int n) {
        MuxIndex muxIndex;
        block3: {
            muxIndex = null;
            if (object != null && object instanceof InterfaceModel) {
                InterfaceModel interfaceModel = (InterfaceModel)object;
                try {
                    muxIndex = new MuxIndex((InterfaceModel)object, interfaceModel.getPortModel().getPort());
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.println("Caught exception in createMuxIndex");
                    if (!db.on()) break block3;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return muxIndex;
    }

    private IPortModel getPortModel(InterfaceModel interfaceModel) {
        try {
            return interfaceModel.getPortModel();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return null;
        }
    }

    public String getPortName(InterfaceModel interfaceModel) {
        String string = "";
        IPortModel iPortModel = this.getPortModel(interfaceModel);
        if (iPortModel != null) {
            String string2;
            string = PortHelper.getPortNumString((IPortModel)iPortModel);
            try {
                string2 = interfaceModel.getAlias();
            }
            catch (NoSuchInterface noSuchInterface) {
                string2 = "";
            }
            if (string2 != null && !string2.equals("")) {
                string = string + " \"" + string2 + "\"";
            }
            if (interfaceModel instanceof TdmLineModel && ((TdmLineModel)interfaceModel).getMediumType() == 0) {
                string = string + " (" + ElementDefaults.getPortMediumString(0) + ")";
            }
        }
        return string;
    }

    protected String getMuxString(int n, int n2, String string, NodeModelDelegate nodeModelDelegate, int n3) {
        MuxIndex muxIndex = this.layerMux(n, n2);
        if (string.indexOf("DS1") >= 0 || string.indexOf("DS3") >= 0 || string.indexOf("Port") >= 0) {
            muxIndex.setPortName(this.getDs1PortName(nodeModelDelegate, n3, Integer.parseInt(muxIndex.toShortString())));
        }
        return muxIndex.toString();
    }

    protected synchronized int layerMuxIndex(int n, int n2) {
        int n3 = 0;
        try {
            Object[] objectArray;
            if (n < 1) {
                objectArray = this.lineModels;
            } else {
                InterfaceModel interfaceModel = (InterfaceModel)this.choiceIFModel.get(n - 1);
                objectArray = this.getNextLayer(interfaceModel);
            }
            n3 = this.getMuxIndex(objectArray[n2]);
            if (n3 < 1) {
                n3 = n2 + 1;
            }
        }
        catch (Exception exception) {
            db.println("error in PmTableModel.layerMuxIndex()" + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        return n3;
    }

    protected int getMuxIndex(Object object) throws NoSuchInterface {
        int n = 0;
        if (object != null && object instanceof InterfaceModel) {
            InterfaceModel interfaceModel = (InterfaceModel)object;
            n = this.getMuxIndex(interfaceModel.getInfo().muxIndex);
        }
        return n;
    }

    public synchronized void setChoice(int n, int n2) {
        Object object;
        Object object2;
        if (db.on()) {
            db.println("PmTableModel::setChoice(layer=" + n + ", choice=" + n2 + ") was called.");
        }
        this.currRowMin = 1;
        this.currRowMax = 0;
        if (this.lineModels == null) {
            if (db.on()) {
                db.println("Line Models are null");
            }
            return;
        }
        if (this.lineModels.length < 1) {
            if (db.on()) {
                db.println("Line Models has no lines");
            }
            this.choiceIFModel.clear();
            this.choiceRanges.clear();
            this.layers.clear();
            this.numRows = 0;
            return;
        }
        while (this.layers.size() > n) {
            object2 = (PmLayer)this.layers.get(n);
            ((PmLayer)object2).destroy();
            this.numRows -= ((PmLayer)object2).parmCount();
            this.layers.remove(n);
            this.choiceRanges.remove(n);
            this.choiceIFModel.remove(n);
        }
        if (n < 1) {
            object = this.lineModels;
        } else {
            try {
                object2 = (InterfaceModel)this.choiceIFModel.get(n - 1);
                object = this.getNextLayer((InterfaceModel)object2);
            }
            catch (Exception exception) {
                object = null;
                db.println("error in PmTableModel.setChoice()" + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.curLayer = n;
        this.curChoice = n2;
        while (object != null) {
            PmLayer pmLayer = null;
            try {
                object2 = this.getEIfType(object[n2]);
                pmLayer = this.createPmLayer((eIfType)object2, object[n2]);
                if (pmLayer != null) {
                    pmLayer.setNearEnd(this.currNearEnd);
                    pmLayer.setIntervalType(eIntervalType.from_int(this.currIntervalType));
                    this.layers.add(pmLayer);
                    this.choiceRanges.add(new Integer(((Object[])object).length));
                    this.choiceIFModel.add(object[n2]);
                    this.numRows += pmLayer.parmCount();
                }
                if ((object = object instanceof InterfaceModel[] ? this.getNextLayer((InterfaceModel)object[n2]) : null) != null) {
                    if (db.on()) {
                        db.println("going a level up: #" + ((Object[])object).length);
                    }
                    if (((Object[])object).length == 0) {
                        object = null;
                    }
                }
                n2 = 0;
                if (pmLayer == null || pmLayer.isHigherPmDisplayed()) continue;
                object = null;
            }
            catch (Exception exception) {
                object = null;
                db.println("error in PmTableModel.init()" + AnnotatedException.prettyString((Exception)exception));
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.resetBaseline();
        this.fireTableDataChanged();
    }

    protected PmLayer createPmLayer(eIfType eIfType2, Object object) {
        PmLayer pmLayer = null;
        if (object != null && object instanceof InterfaceModel) {
            InterfaceModel interfaceModel = (InterfaceModel)object;
            this.flg_Barolo_Card = false;
            switch (eIfType2.value()) {
                case 12: {
                    pmLayer = this.createPmLayerE1((Ds123LineModel)interfaceModel);
                    break;
                }
                case 1: {
                    pmLayer = this.createPmLayerDs1Path((Ds123LineModel)interfaceModel);
                    break;
                }
                case 2: {
                    pmLayer = this.createPmLayerDs3Line((Ds123LineModel)interfaceModel);
                    break;
                }
                case 14: {
                    pmLayer = this.createPmLayerDs3i((Ds123LineModel)interfaceModel);
                    break;
                }
                case 13: {
                    pmLayer = this.createPmLayerE3((Ds123LineModel)interfaceModel);
                    break;
                }
                case 15: {
                    pmLayer = this.createPmLayerE4Line((TdmLineModel)interfaceModel);
                    break;
                }
                case 5: {
                    pmLayer = this.createPmLayerSonetLine((TdmLineModel)interfaceModel);
                    break;
                }
                case 6: {
                    pmLayer = this.createPmLayerTdmHo((TdmHoModel)interfaceModel);
                    break;
                }
                case 7: {
                    pmLayer = this.createPmLayerTdmLo((TdmLoModel)interfaceModel);
                    break;
                }
                case 16: {
                    pmLayer = this.createPmLayerDwdmCliLine((DwdmCliLineModel)interfaceModel);
                    break;
                }
                case 17: {
                    pmLayer = this.createPmLayerDwdmTrkLine((DwdmTrkLineModel)interfaceModel);
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    this.flg_Barolo_Card = true;
                    pmLayer = this.createPmLayerOptics((AbstractOpticsLineModel)interfaceModel);
                    break;
                }
                default: {
                    db.println("PmTableModel::createPmLayer: unknown type:" + eIfType2);
                }
            }
        }
        return pmLayer;
    }

    protected eIfType getEIfType(Object object) throws NoSuchInterface {
        eIfType eIfType2 = null;
        if (object != null && object instanceof InterfaceModel) {
            InterfaceModel interfaceModel = (InterfaceModel)object;
            eIfType2 = interfaceModel.getInfo().ifType;
        }
        return eIfType2;
    }

    protected Object[] getNextLayer(InterfaceModel interfaceModel) {
        InterfaceModel[] interfaceModelArray = null;
        if (interfaceModel != null) {
            interfaceModelArray = interfaceModel.getHigherLayerModels();
        }
        return interfaceModelArray;
    }

    public synchronized void setIntervalType(int n) {
        Iterator iterator = this.layers.iterator();
        while (iterator.hasNext()) {
            ((PmLayer)iterator.next()).setIntervalType(eIntervalType.from_int(n));
        }
        this.prevIntervalType = this.currIntervalType;
        this.currIntervalType = n;
    }

    public synchronized void destroy() {
        if (this.layers == null) {
            return;
        }
        Iterator iterator = this.layers.iterator();
        while (iterator.hasNext()) {
            ((PmLayer)iterator.next()).destroy();
        }
    }

    public synchronized void setNearEnd(boolean bl) {
        Iterator iterator = this.layers.iterator();
        while (iterator.hasNext()) {
            ((PmLayer)iterator.next()).setNearEnd(bl);
        }
        this.prevNearEnd = this.currNearEnd;
        this.currNearEnd = bl;
    }

    public synchronized void tossData() {
        boolean bl = false;
        Iterator iterator = this.layers.iterator();
        while (iterator.hasNext()) {
            PmLayer pmLayer = (PmLayer)iterator.next();
            pmLayer.tossData();
            if (!pmLayer.needsRebuild()) continue;
            bl = true;
        }
        if (bl) {
            this.setChoice(this.curLayer, this.curChoice);
        }
        if (this.prevIntervalType != this.currIntervalType || this.prevNearEnd != this.currNearEnd) {
            this.resetBaseline();
            this.prevIntervalType = this.currIntervalType;
            this.prevNearEnd = this.currNearEnd;
        }
    }

    public void setBaseline() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        int n = this.getRowCount();
        this.initBaseline();
        if (!this.flg_Barolo_Card) {
            for (int i = 0; i < n; ++i) {
                Object object = this.getValueAtImpl(i, 1);
                if (!(object instanceof PmRendererStat)) continue;
                long l = this.getLongValue(object);
                this.baseline[i] = l < 0L ? 0L : l;
            }
            this.fireTableDataChanged();
        } else {
            try {
                for (int i = 0; i < n; ++i) {
                    Object object = this.getValueAtImpl(i, 1);
                    if (!(object instanceof PmRendererStatRatio)) continue;
                    long l = (long)this.getLongValueB(object) * 10L;
                    this.baseline[i] = (double)l == this.NA_VALUE ? 0L : l;
                }
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_REQUESTED_ACTION_NOT_ALLOWED);
            }
            this.fireTableDataChanged();
        }
    }

    public void refreshMyLines(InterfaceModel[] interfaceModelArray) {
        this.lineModels = interfaceModelArray;
    }

    private void initBaseline() {
        if (this.baseline == null) {
            this.baseline = new long[this.getRowCount()];
        }
    }

    protected void resetBaseline() {
        int n = this.getRowCount();
        this.baseline = new long[n];
    }

    private Frame getFrame() {
        if (this.lineModels != null && this.lineModels.length > 0) {
            return this.lineModels[0].getNodeModel().getUiToolkit().getApplicationFrame();
        }
        return null;
    }

    protected int getCurChoice() {
        return this.curChoice;
    }

    protected int getCurLayer() {
        return this.curLayer;
    }

    public static class Item {
        public ArrayList contents = new ArrayList();
        public String label;
        public int layer;
    }
}

