/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Ds3xmLineUpdate;
import cerent.cms.model.EtherLineUpdate;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.SoakTableModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SoakMaintenancePane
extends AbstractPane
implements ActionListener {
    protected static final String RETRIEVE_STRING = "Retrieve";
    protected InterfaceModel[] models;
    protected JButton refreshButton = new JButton("Retrieve");
    protected JLabel refreshLabel = new JLabel("");
    protected SoakTableModel dataModel;
    protected static final SDebug db = new SDebug("SoakMaintenancePane");

    public SoakMaintenancePane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray) {
        this(string, tabbedView, interfaceModelArray, false);
    }

    public SoakMaintenancePane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray, boolean bl) {
        super(string, tabbedView);
        this.models = interfaceModelArray;
        this.initPane();
        if (bl) {
            this.registerWithModel();
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SoakMaintenancePane;
    }

    protected SoakTableModel getDataModel() {
        return new SoakTableModel(this.models, (NodeModelDelegate)this.getUiModel().getNodeModel());
    }

    private void initPane() {
        this.dataModel = this.getDataModel();
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        CSHelpID cSHelpID = this.getHelpID();
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setCellRenderer(NodeProvPane.PORT_CELL_RENDERER);
        if (cSHelpID != null) {
            CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(cSHelpID);
            this.refreshButton.addActionListener(this);
            cSHelpButtonPane.addLeft(this.refreshButton);
            cSHelpButtonPane.addRight(this.refreshLabel);
            this.add(cSHelpButtonPane, "South");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshButton) {
            this.refresh();
        }
    }

    public void enteringPage() throws Exception {
        this.refresh();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof OcnLineUpdate) {
            this.models = (InterfaceModel[])((OcnLineUpdate)object).getModels();
            this.dataModel.refreshMyLines(this.models);
        } else if (object instanceof EtherLineUpdate) {
            this.models = (InterfaceModel[])((EtherLineUpdate)object).getModels();
            this.dataModel.refreshMyLines(this.models);
        } else if (object instanceof Ds3xmLineUpdate) {
            this.models = ((Ds3xmLineUpdate)object).getFilteredDs3s();
            this.dataModel.refreshMyLines(this.models);
        }
    }

    public void refresh() {
        this.refreshLabel();
        this.dataModel.refreshTable();
    }

    protected void refreshLabel() {
        this.refreshLabel.setText("Retrieved: " + SoakMaintenancePane.getFormattedDateTime());
    }
}

