/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.SquelchTblColumnGroup;
import cerent.cms.ui.SquelchTblColumnModel;
import cerent.cms.ui.SquelchTblHeader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SquelchTblHeaderUI
extends BasicTableHeaderUI {
    protected Vector paintedGroups = new Vector();

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = graphics.getClipBounds();
        SquelchTblColumnModel squelchTblColumnModel = (SquelchTblColumnModel)this.header.getColumnModel();
        if (squelchTblColumnModel == null) {
            return;
        }
        ((SquelchTblHeader)this.header).setColumnMargin();
        int n = 0;
        Dimension dimension = this.header.getSize();
        Rectangle rectangle2 = new Rectangle(0, 0, dimension.width, dimension.height);
        Hashtable<SquelchTblColumnGroup, Rectangle> hashtable = new Hashtable<SquelchTblColumnGroup, Rectangle>();
        Enumeration<TableColumn> enumeration = squelchTblColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            rectangle2.height = dimension.height;
            rectangle2.y = 0;
            TableColumn tableColumn = enumeration.nextElement();
            Iterator iterator = squelchTblColumnModel.getColumnGroups(tableColumn);
            if (iterator != null) {
                int n2 = 0;
                while (iterator.hasNext()) {
                    SquelchTblColumnGroup squelchTblColumnGroup = (SquelchTblColumnGroup)iterator.next();
                    Rectangle rectangle3 = (Rectangle)hashtable.get(squelchTblColumnGroup);
                    if (rectangle3 == null) {
                        rectangle3 = new Rectangle(rectangle2);
                        Dimension dimension2 = squelchTblColumnGroup.getSize(this.header.getTable());
                        rectangle3.width = dimension2.width;
                        rectangle3.height = dimension2.height;
                        hashtable.put(squelchTblColumnGroup, rectangle3);
                    }
                    if (!this.paintedGroups.contains(squelchTblColumnGroup)) {
                        this.paintCell(graphics, rectangle3, squelchTblColumnGroup);
                        this.paintedGroups.add(squelchTblColumnGroup);
                    }
                    rectangle2.height = dimension.height - (n2 += rectangle3.height);
                    rectangle2.y = n2;
                }
            }
            rectangle2.width = tableColumn.getWidth();
            if (rectangle2.intersects(rectangle)) {
                this.paintCell(graphics, rectangle2, n);
            }
            rectangle2.x += rectangle2.width;
            ++n;
        }
        this.paintedGroups.clear();
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, SquelchTblColumnGroup squelchTblColumnGroup) {
        TableCellRenderer tableCellRenderer = squelchTblColumnGroup.getHeaderRenderer();
        Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), squelchTblColumnGroup.getHeaderValue(), false, false, -1, -1);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private int getHeaderHeight() {
        int n = 0;
        SquelchTblColumnModel squelchTblColumnModel = (SquelchTblColumnModel)this.header.getColumnModel();
        for (int i = 0; i < squelchTblColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = squelchTblColumnModel.getColumn(i);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = this.header.getDefaultRenderer();
            }
            Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, i);
            int n2 = component.getPreferredSize().height;
            Iterator iterator = squelchTblColumnModel.getColumnGroups(tableColumn);
            if (iterator != null) {
                while (iterator.hasNext()) {
                    SquelchTblColumnGroup squelchTblColumnGroup = (SquelchTblColumnGroup)iterator.next();
                    n2 += squelchTblColumnGroup.getSize((JTable)this.header.getTable()).height;
                }
            }
            n = Math.max(n, n2);
        }
        return n;
    }

    private Dimension createHeaderSize(long l) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        if ((l += (long)(tableColumnModel.getColumnMargin() * tableColumnModel.getColumnCount())) > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        return new Dimension((int)l, this.getHeaderHeight());
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createHeaderSize(l);
    }
}

