/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.aic;

import cerent.cms.idl.Alarm.eSeverity;
import cerent.cms.idl.Equipment.eEnvAlrmType;
import cerent.cms.idl.Equipment.eVirtWire;
import cerent.cms.idl.Equipment.sEnvAlrmInputConfig;
import cerent.cms.model.Attribute;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.ui.AbstractProvTableModel;
import cerent.util.SDebug;
import java.awt.Frame;

public abstract class AbstractAicEnvAlarmTableModel
extends AbstractProvTableModel {
    private Frame _frame;
    protected static final String PREFIX = "AICEnvAlarm.";
    protected EnvAlarmModel[] provModels;
    protected EnvAlarmModel[] alarmStoreModels;
    protected sEnvAlrmInputConfig[] settings = null;
    protected Attribute[] alarmType;
    protected Attribute[] severity;
    protected Attribute[] virtualWire;
    protected int[] alarmSeverity;
    protected boolean[] raised;
    protected ElementAlarmStore alarmStore;
    protected SDebug db;
    protected static final char[] envAlmSeverityNames = new char[]{'N', 'A', 'I', 'M', 'C'};

    public AbstractAicEnvAlarmTableModel(INodeModel iNodeModel, EnvAlarmModel[] envAlarmModelArray, EnvAlarmModel[] envAlarmModelArray2) {
        super(envAlarmModelArray, true, PREFIX);
        this._frame = iNodeModel.getUiToolkit().getApplicationFrame();
        this.provModels = envAlarmModelArray;
        this.alarmStoreModels = envAlarmModelArray2;
        this.alarmType = new Attribute[this.numLines];
        this.severity = new Attribute[this.numLines];
        this.alarmSeverity = new int[this.numLines];
        this.virtualWire = new Attribute[this.numLines];
        this.raised = new boolean[this.numLines];
        this.settings = new sEnvAlrmInputConfig[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.raised[i] = false;
        }
    }

    protected Frame getFrame() {
        return this._frame;
    }

    public abstract boolean isCellEditable(int var1, int var2);

    public abstract Class getColumnClass(int var1);

    public abstract Object getValueAt(int var1, int var2);

    public abstract void setValueAt(Object var1, int var2, int var3);

    protected sEnvAlrmInputConfig defaultSettings() {
        return new sEnvAlrmInputConfig(false, eEnvAlrmType.ENV_ALM_MISC, "", eVirtWire.VIRT_WIRE_NONE, false, envAlmSeverityNames[0]);
    }

    protected int getAlarmSeverity(char c) {
        for (int i = 0; i < envAlmSeverityNames.length; ++i) {
            if (envAlmSeverityNames[i] != c) continue;
            return i;
        }
        return 0;
    }

    protected void refreshLine(int n) {
        block3: {
            try {
                this.settings[n] = this.provModels[n].settings();
                if (this.settings[n] == null) {
                    this.settings[n] = this.defaultSettings();
                }
                this.alarmType[n] = this.getAttributeFor(eEnvAlrmType.class.getName(), this.settings[n].type.value(), this.provModels[n]);
                this.virtualWire[n] = this.getAttributeFor(eVirtWire.class.getName(), this.settings[n].virtualWireOutput.value(), this.provModels[n]);
                this.printSettings("from NE", n);
                this.alarmSeverity[n] = this.getAlarmSeverity(this.settings[n].severity);
                this.severity[n] = this.getAttributeFor(eSeverity.class.getName(), this.alarmSeverity[n], this.provModels[n]);
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (!this.db.on()) break block3;
                this.db.println("Caught CmsObjectNotExistException in refreshLine");
            }
        }
    }

    public void refreshFromModel() throws Exception {
        super.refreshFromModel();
    }

    public void applyToModel() throws Exception {
        if (this.db.on()) {
            this.db.println("applyToModel");
        }
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.rowDirty[i]) continue;
            this.rowDirty[i] = false;
            this.provModels[i].settings(this.settings[i]);
        }
    }

    protected Attribute getAttributeFor(String string, int n, IModel iModel) {
        return ElementDefaults.getAttributeMap(iModel).getAttributeForVal(this.prefix + string, n);
    }

    protected void printSettings(String string, int n) {
        if (this.db.on()) {
            sEnvAlrmInputConfig sEnvAlrmInputConfig2 = this.settings[n];
            this.db.println(string + "[" + n + "] " + (sEnvAlrmInputConfig2.enabled ? "enabled" : "disabled") + " raised/cl=" + sEnvAlrmInputConfig2.raisedWhenClosed + " severity=" + sEnvAlrmInputConfig2.severity + " vw=" + sEnvAlrmInputConfig2.virtualWireOutput.value() + " type=" + sEnvAlrmInputConfig2.type.value() + " desc=" + sEnvAlrmInputConfig2.description);
        }
    }
}

