/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.aic;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEnvAlrmType;
import cerent.cms.idl.Equipment.eVirtWire;
import cerent.cms.model.Attribute;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.aic.AbstractAicEnvAlarmTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;

public class AicEnvAlarmTableModel
extends AbstractAicEnvAlarmTableModel {
    public static final int LINENUMBER_INDEX = 0;
    public static final int ENABLED_INDEX = 1;
    public static final int ALARM_TYPE_INDEX = 2;
    public static final int SEVERITY_INDEX = 3;
    public static final int VIRTUAL_WIRE_INDEX = 4;
    public static final int RAISED_WHEN_INDEX = 5;
    public static final int DESCRIPTION_INDEX = 6;
    private static final SDebug dbprov = new SDebug("EnvAlrmProv");
    private static final String[] provColNames = new String[]{"Input#", "Enabled", "Alarm Type", "Severity", "Virtual Wire", "Raised When", "Description"};

    public AicEnvAlarmTableModel(INodeModel iNodeModel, EnvAlarmModel[] envAlarmModelArray) {
        this(iNodeModel, envAlarmModelArray, envAlarmModelArray);
    }

    public AicEnvAlarmTableModel(INodeModel iNodeModel, EnvAlarmModel[] envAlarmModelArray, EnvAlarmModel[] envAlarmModelArray2) {
        super(iNodeModel, envAlarmModelArray, envAlarmModelArray2);
        this.db = dbprov;
        this.columnNames = provColNames;
    }

    public boolean isCellEditable(int n, int n2) {
        if (!this.enabled || n2 == 0) {
            return false;
        }
        if (this.provModels != null && this.numLines > 0 && ((ModuleModel)this.provModels[0].getAncestorOfType(eClass.E_MODULE)).isProtectModule()) {
            return false;
        }
        return n2 == 1 || this.settings[n].enabled;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public Object getValueAt(int n, int n2) {
        if (this.settings[n] == null) {
            return this.getDefaultValue(n2);
        }
        try {
            switch (n2) {
                case 0: {
                    return Integer.toString(n + 1);
                }
                case 1: {
                    return this.getBoolean(this.settings[n].enabled);
                }
            }
            if (this.settings[n].enabled) {
                switch (n2) {
                    case 2: {
                        return this.alarmType[n];
                    }
                    case 3: {
                        return this.severity[n];
                    }
                    case 4: {
                        return this.virtualWire[n];
                    }
                    case 5: {
                        return this.getPrintableContactStatus(this.settings[n].raisedWhenClosed);
                    }
                    case 6: {
                        return this.settings[n].description;
                    }
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return this.getDefaultValue(n2);
    }

    private Object getDefaultValue(int n) {
        if (n == 1) {
            return this.getBoolean(false);
        }
        return "";
    }

    public void setValueAt(Object object, int n, int n2) {
        if (this.db.on()) {
            this.db.println("setValueAt( " + object + ", " + n + ", " + n2 + ")");
        }
        if (object == null || this.settings[n] == null) {
            return;
        }
        switch (n2) {
            case 2: {
                this.settings[n].type = eEnvAlrmType.from_int(((Attribute)object).getIntValue());
                this.alarmType[n] = (Attribute)object;
                if (!this.db.on()) break;
                this.db.println("new alarm type for alarm[" + n + "] is " + this.settings[n].type);
                break;
            }
            case 3: {
                this.alarmSeverity[n] = ((Attribute)object).getIntValue();
                this.severity[n] = (Attribute)object;
                char c = envAlmSeverityNames[this.alarmSeverity[n]];
                if (this.db.on()) {
                    this.db.println("severity at row " + n + " is " + this.alarmSeverity[n]);
                    this.db.println("\tthe char is " + c);
                }
                this.settings[n].severity = c;
                break;
            }
            case 4: {
                short s = ((Attribute)object).getValue().shortValue();
                this.settings[n].virtualWireOutput = eVirtWire.from_int(s);
                this.virtualWire[n] = (Attribute)object;
                break;
            }
            case 1: {
                this.settings[n].enabled = (Boolean)object;
                if (this.settings[n].type != eEnvAlrmType.ENV_ALM_NORMAL) break;
                this.setValueAt(this.getAttributeFor(eEnvAlrmType.class.getName(), 28, this.provModels[0]), n, 2);
                break;
            }
            case 5: {
                this.settings[n].raisedWhenClosed = "Closed".equals(object);
                break;
            }
            case 6: {
                String string = (String)object;
                if (string.length() > 40) {
                    ErrorMsg.displayWarning((Component)this.getFrame(), (EID)EMC.WID_ENV_ALARM_DESC_TOOLONG_PARAM_1, Integer.toString(40));
                    string = string.substring(0, 40);
                }
                this.settings[n].description = string;
                break;
            }
            default: {
                return;
            }
        }
        this.rowDirty[n] = true;
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() throws Exception {
        if (this.db.on) {
            this.db.println("Refreshing");
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLine(i);
        }
        super.refreshFromModel();
    }
}

