/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ampli.AmpliAlsTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class AmpliAlsPane
extends NodeProvPane
implements TableModelListener {
    protected OpticsModuleModel model;
    protected AmpliAlsTableModel dataModel;
    private InterfaceModel[] lineModels = null;
    protected int numLines = 0;
    protected int thresholdLayer;
    private boolean notInited = true;
    private int ALSPort = 5;
    private int _ampliRole_LINE = 0;
    private int _ampliRole_PRE = 1;
    private int _ampliRole = -1;
    private int ampliRole = 0;
    private UScrollPane scrollPane = null;
    protected static final SDebug db = new SDebug("AmpliAlsPane");

    public AmpliAlsPane(String string, TabbedView tabbedView, OpticsModuleModel opticsModuleModel, int n, InterfaceModel[] interfaceModelArray) {
        super(string, tabbedView);
        this.model = opticsModuleModel;
        this.lineModels = interfaceModelArray;
        this.thresholdLayer = n;
    }

    protected void init() {
        this.numLines = this.lineModels.length;
        this.dataModel = this.getDataModel(this.thresholdLayer);
        this.dataModel.addTableModelListener(this);
        this.table = new JTable(this.dataModel);
        this.scrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        TableColumn tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[0]);
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxForOSRICommand()));
        tableColumn.setPreferredWidth(70);
        tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxForALSCommand()));
        tableColumn.setPreferredWidth(200);
        tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[2]);
        tableColumn.setPreferredWidth(250);
        tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[3]);
        tableColumn.setPreferredWidth(250);
        tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[4]);
        tableColumn.setPreferredWidth(250);
        tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[5]);
        tableColumn.setPreferredWidth(250);
        this._ampliRole = this.model.isOPT_AMP_L() && this.ampliRole == 1 ? this._ampliRole_PRE : this._ampliRole_LINE;
        int n = this.ALSPort = this.model.isOPT_BST() || this.model.isOPT_BST_L() || this.model.isOPT_BST_E() || this.model.isOPT_AMP_L() && this.ampliRole == 2 ? 5 : 1;
        if (this.model.isOPT_PRE() || this.model.isOPT_AMP_L() && this.ampliRole == 1) {
            tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[1]);
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[2]);
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[3]);
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[5]);
            this.table.removeColumn(tableColumn);
        }
        this.registerWithModel();
        this.add((Component)this.scrollPane, "Center");
        this.table.setAutoResizeMode(0);
        this.notInited = false;
    }

    protected void registerWithModel() {
        if (this.model != null) {
            this.model.addObserver((Observer)((Object)this));
        }
    }

    protected JComboBox getComboBoxForALSCommand() {
        JComboBox<String> jComboBox = new JComboBox<String>(this.dataModel.getALSCommandStrings());
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected JComboBox getComboBoxForOSRICommand() {
        JComboBox<String> jComboBox = new JComboBox<String>(this.dataModel.getOSRICommandStrings());
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public void dispose() {
        if (this.model != null) {
            this.model.deleteObserver((Observer)((Object)this));
        }
    }

    public void leavingPage() throws Exception {
        if (this.table != null) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
        super.leavingPage();
    }

    public void enteringPage() throws Exception {
        if (this.model.isOPT_AMP_L()) {
            try {
                this.ampliRole = ((OpticsModuleModel)this.getUiModel()).getAmpliRole().value();
            }
            catch (NoSuchInterface noSuchInterface) {
                this.displayErrorDialog(this, (Exception)((Object)noSuchInterface), EMC.EID_NO_SUCH_INTERFACE_PARAM_1);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                this.displayErrorDialog(this, (Exception)((Object)wrongInterfaceType), EMC.EID_WRONG_INTERFACE_TYPE_PARAM_1);
            }
            if (this.ampliRole == 1 && this._ampliRole == this._ampliRole_LINE || this.ampliRole == 2 && this._ampliRole == this._ampliRole_PRE) {
                this.notInited = true;
            }
            this.ALSPort = this.ampliRole == 2 ? 5 : 1;
        } else {
            int n = this.ALSPort = this.model.isOPT_BST() || this.model.isOPT_BST_L() || this.model.isOPT_BST_E() || this.model.isOPT_AMP_L() && this.ampliRole == 2 ? 5 : 1;
        }
        if (this.notInited) {
            if (this.table != null) {
                this.dataModel.removeTableModelListener(this);
                super.remove((Component)this.scrollPane);
                this.table = null;
                this.scrollPane = null;
            }
            this.init();
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
        this.dataModel.refreshFromModel();
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromReset();
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.notInited = true;
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.dataModel.fireTableDataChanged();
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                AmpliAlsPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        try {
            this.dataModel.refreshLineFromModel(0);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_ROW_PARAM_1, (Object)"1");
        }
    }

    public void applyChangesToModel() throws Exception {
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    protected AmpliAlsTableModel getDataModel(int n) {
        return new AmpliAlsTableModel(this.model, this.lineModels, this.ALSPort);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.AmpliAlsPane;
    }
}

