/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.idl.Optics.eLaserStatus;
import cerent.cms.idl.Optics.eOSRIStatus;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ampli.OpticalAlsTableModel;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Frame;
import java.util.Arrays;
import java.util.List;

public class AmpliAlsTableModel
extends OpticalAlsTableModel {
    public static final String[] columnNames = new String[]{"OSRI", "ALS Mode", "Recovery Pulse Duration ( sec. )", "Recovery Pulse Interval ( sec. )", "Currently Shutdown", "Request Laser Restart"};
    public static final String[] LaserStatusStrings = new String[]{"YES", "NO", "APR"};
    public static final String[] ALSCommandStrings = new String[]{"Disable", "Auto Restart", "Manual Restart", "Manual Restart for Test"};
    public static final String[] OSRICommandStrings = new String[]{"OFF", "ON"};
    public static final String[] OSRIStatusStrings = new String[]{"OSRI Off", "OSRI On", "N/A"};
    public static final int OSRI_MODE_INDEX = 0;
    public static final int ALS_MODE_INDEX = 1;
    public static final int RECOVERY_DURATION_INDEX = 2;
    public static final int RECOVERY_INTERVAL_INDEX = 3;
    public static final int CURRENTLY_SHUTDOWN_INDEX = 4;
    public static final int LASER_RESTART_INDEX = 5;
    public static final int OSRI_STATUS_INDEX = 6;
    private int[] LaserStatus;
    private int[] OSRIStatus;
    private int[] ALSCommand;
    private int[] OSRICommand;
    private boolean[][] isDirty;
    protected Boolean[] LaserRestart;
    int newALSCommand = 0;
    int newOSRICommand = 0;
    private ElementModelsDelegate elementModel;
    private InterfaceModel[] ifModel = null;
    private PortModel[] portModel = null;
    protected Float[] alsPulseWidthVal = null;
    protected Short[] alsRecIntVal = null;
    protected Boolean[] laserShutdownVal = null;
    private int ALSPort = 0;
    private static final SDebug db = new SDebug("AmpliAlsTableModel");

    public AmpliAlsTableModel(OpticsModuleModel opticsModuleModel, InterfaceModel[] interfaceModelArray, int n) {
        super(db, opticsModuleModel);
        this.ifModel = interfaceModelArray;
        this.ALSPort = n;
        this.isDirty = new boolean[1][this.getColumnCount()];
        this.LaserStatus = new int[this.numLines];
        this.OSRIStatus = new int[this.numLines];
        this.ALSCommand = new int[this.numLines];
        this.OSRICommand = new int[this.numLines];
        this.LaserRestart = new Boolean[this.numLines];
        this.alsPulseWidthVal = new Float[this.numLines];
        this.alsRecIntVal = new Short[this.numLines];
        this.laserShutdownVal = new Boolean[this.numLines];
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)opticsModuleModel.getNodeModel();
        this.elementModel = nodeModelDelegate.getElementModelsDelegate();
        this.resetDirtyBits();
    }

    public int getRowCount() {
        return 1;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 5: {
                return Boolean.class;
            }
            case 2: {
                return Float.class;
            }
            case 3: {
                return Short.class;
            }
        }
        return Object.class;
    }

    public String[] getALSCommandStrings() {
        return ALSCommandStrings;
    }

    public String[] getOSRICommandStrings() {
        return OSRICommandStrings;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && AbstractPane.isUserAuthorized(this.model, SecurityLevel.MAINTENANCE)) {
            if (n2 == 1 || n2 == 0) {
                return true;
            }
            if (n2 == 5) {
                return this.TestAlsMode(n);
            }
        }
        return false;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < 1; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 1: {
                    return this.getALSMode(n);
                }
                case 0: {
                    return this.getOSRIMode(n);
                }
                case 2: {
                    return this.getRecPulseDuration(n);
                }
                case 3: {
                    return this.getRecPulseInterval(n);
                }
                case 5: {
                    return this.getLaserRestart(n);
                }
                case 4: {
                    return this.getLaserStatusString(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Barolo AlsTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        try {
            switch (n2) {
                case 1: {
                    this.newALSCommand = this.getIndexOf((String)object, ALSCommandStrings);
                    if (this.ALSCommand[n] == this.newALSCommand) {
                        return;
                    }
                    this.ALSCommand[n] = this.newALSCommand;
                    if (this.ALSCommand[n] != 2 && this.ALSCommand[n] != 3 && this.LaserRestart[n] != Boolean.FALSE) {
                        this.LaserRestart[n] = Boolean.FALSE;
                        this.isDirty[n][5] = true;
                        this.fireTableCellUpdated(n, 5);
                    }
                    break;
                }
                case 0: {
                    this.newOSRICommand = this.getIndexOf((String)object, OSRICommandStrings);
                    if (this.OSRICommand[n] == this.newOSRICommand) {
                        return;
                    }
                    this.OSRICommand[n] = this.newOSRICommand;
                    break;
                }
                case 5: {
                    Boolean bl = (Boolean)object;
                    if (this.LaserRestart[n].equals(bl)) {
                        return;
                    }
                    this.LaserRestart[n] = bl;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            SDebug.printStackTrace((Throwable)classCastException);
            return;
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    public void setOSRIOn() {
        try {
            this.model.setOSRIStatus(eOSRIStatus.OSRI_ON);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setOSRIOff() {
        try {
            this.model.setOSRIStatus(eOSRIStatus.OSRI_OFF);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getOSRIStatus(int n) {
        try {
            eOSRIStatus eOSRIStatus2;
            eOSRIStatus eOSRIStatus3 = eOSRIStatus2 = this.model != null ? this.model.getOSRIStatus() : eOSRIStatus.OSRI_OFF;
            this.OSRIStatus[n] = eOSRIStatus2 == eOSRIStatus.OSRI_OFF ? 0 : (eOSRIStatus2 == eOSRIStatus.OSRI_ON ? 1 : 2);
        }
        catch (Exception exception) {
            this.OSRIStatus[n] = 2;
        }
        return OSRIStatusStrings[this.OSRIStatus[n]];
    }

    public String getLaserStatusString(int n) {
        eLaserStatus eLaserStatus2 = this.getLaserStatus(n);
        if (eLaserStatus2 != null) {
            if (eLaserStatus2 == eLaserStatus.OFF) {
                this.LaserStatus[n] = 0;
            } else if (eLaserStatus2 == eLaserStatus.ON) {
                this.LaserStatus[n] = 1;
            } else if (eLaserStatus2 == eLaserStatus.APR) {
                this.LaserStatus[n] = 2;
            }
        } else {
            return "N/A";
        }
        return LaserStatusStrings[this.LaserStatus[n]];
    }

    private eLaserStatus getLaserStatus(int n) {
        try {
            return this.model != null ? this.model.getLaserStatus() : eLaserStatus.OFF;
        }
        catch (Exception exception) {
            db.severe("Error getting the laser status" + exception);
            return null;
        }
    }

    protected Float getRecPulseDuration(int n) {
        if (this.alsPulseWidthVal[n] == null) {
            try {
                this.alsPulseWidthVal[n] = new Float(this.ifModel[this.ALSPort].getALSRecoveryPulseWidth());
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe("Error in getting ALS Pulse Width:" + noSuchInterface.toString());
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                this.alsPulseWidthVal[n] = new Float(0.0f);
            }
        }
        return this.alsPulseWidthVal[n];
    }

    private Boolean getLaserRestart(int n) {
        if (this.LaserRestart[n] == null) {
            this.LaserRestart[n] = Boolean.FALSE;
        }
        return this.LaserRestart[n];
    }

    protected Short getRecPulseInterval(int n) {
        if (this.alsRecIntVal[n] == null) {
            try {
                this.alsRecIntVal[n] = new Short(this.ifModel[this.ALSPort].getALSRecoveryInterval());
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe("Error in getting ALS Pulse Interval:" + noSuchInterface.toString());
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                this.alsRecIntVal[n] = new Short("0");
            }
        }
        return this.alsRecIntVal[n];
    }

    public String getALSMode(int n) {
        if (this.ALSCommand[n] == -1) {
            try {
                int n2;
                this.ALSCommand[n] = n2 = this.ifModel[this.ALSPort].getALSMode();
            }
            catch (Exception exception) {
                this.ALSCommand[n] = 1;
            }
        }
        return ALSCommandStrings[this.ALSCommand[n]];
    }

    public String getOSRIMode(int n) {
        if (this.OSRICommand[n] == -1) {
            try {
                eOSRIStatus eOSRIStatus2;
                eOSRIStatus eOSRIStatus3 = eOSRIStatus2 = this.model != null ? this.model.getOSRIStatus() : eOSRIStatus.OSRI_OFF;
                this.OSRICommand[n] = eOSRIStatus2 == eOSRIStatus.OSRI_OFF ? 0 : 1;
            }
            catch (Exception exception) {
                this.OSRIStatus[n] = 0;
            }
        }
        return OSRICommandStrings[this.OSRICommand[n]];
    }

    private boolean TestAlsMode(int n) {
        return this.ALSCommand[n] == 2 || this.ALSCommand[n] == 3 && this.getLaserStatus(n) == eLaserStatus.OFF;
    }

    private int getIndexOf(Object object, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        return list.indexOf(object);
    }

    private int unsignedShortToInt(short s) {
        int n = s & 0xFFFF;
        return n;
    }

    private void resetDirtyBits() {
        for (int i = 0; i < 1; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshFromModel() throws Exception {
        this.LaserRestart[0] = null;
        this.refreshLineFromModel(0);
        this.fireTableRowsUpdated(0, 0);
    }

    public void refreshFromReset() {
        this.refreshLineFromModel(0);
    }

    public void refreshLineFromModel(int n) {
        this.resetLineCache(n);
        this.getALSMode(n);
        this.getOSRIMode(n);
        this.getRecPulseDuration(n);
        this.getRecPulseInterval(n);
        this.getLaserRestart(n);
        this.getLaserStatusString(n);
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.LaserStatus[n] = -1;
        this.OSRIStatus[n] = -1;
        this.ALSCommand[n] = -1;
        this.OSRICommand[n] = -1;
        this.alsPulseWidthVal[n] = null;
        this.alsRecIntVal[n] = null;
        this.laserShutdownVal[n] = null;
        this.LaserRestart[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void applyToModel() throws Exception {
        int n = 0;
        if (db.on()) {
            db.println("applyToModel");
        }
        String string = "";
        int n2 = this.model.getEqType();
        string = this.ALSCommand[n] == 0 && (n2 == 130 || n2 == 196 || n2 == 239 || n2 == 240) ? "Attention!  This operation will disable optical safety \nand can cause potential safety hazard.\n\n" : "Selected operation will be service affecting.\n";
        if (CerentDialog.yesNoDialog((Component)this.getFrame(), (String)(string + "Apply changes anyway?"), (String)"Confirmation Dialog")) {
            try {
                if (this.isDirty[n][1]) {
                    this.ifModel[this.ALSPort].setALSMode(this.ALSCommand[n]);
                }
                if (this.isDirty[n][0]) {
                    if (this.OSRICommand[0] == 1) {
                        this.setOSRIOn();
                    } else {
                        this.setOSRIOff();
                    }
                }
                if (this.isDirty[n][5]) {
                    this.ifModel[this.ALSPort].restartLaser();
                }
                this.resetDirtyBits();
                this.refreshLineFromModel(0);
            }
            catch (ConfigError configError) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ERROR_LASER_ON);
                this.refreshLineFromModel(0);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
                this.refreshLineFromModel(0);
            }
            catch (Exception exception) {
                throw new AnnotatedException(ErrorMsg.getString((EID)EMC.EID_ERROR_APPLYING_CHANGES), exception);
            }
        } else {
            this.refreshLineFromModel(0);
        }
    }

    private Frame getFrame() {
        return this.elementModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }
}

