/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Optics.sOpticsAlmThresholds;
import cerent.cms.idl.Optics.sOpticsTCAThresholds;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.oadm.OpticalTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.List;

public class AmpliOpticalThresholdTableModel
extends OpticalTableModel {
    public static final String[] columnNames = new String[]{"Port", "opwrMax (dBm)", "opwrMin (dBm)", "Power Failure Low (dBm)", "VOA High (dBm)", "VOA Low (dBm)", "Power Degrade High (dBm)", "Power Degrade Low (dBm)", "VOA Degrade High (dB)", "VOA Degrade Low (dB)", "VOA Failure Low (dB)", "Power ADD Failure Low (dBm)", "Gain Degrade Low (dB)", "Gain Degrade High (dB)"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int POWER_HIGH_INDEX = 1;
    public static final int POWER_LOW_INDEX = 2;
    public static final int POWER_FAILURE_LOW_INDEX = 3;
    public static final int VOA_HIGH_INDEX = 4;
    public static final int VOA_LOW_INDEX = 5;
    public static final int POWER_DEGRADE_HIGH_INDEX = 6;
    public static final int POWER_DEGRADE_LOW_INDEX = 7;
    public static final int VOA_DEGRADE_HIGH_INDEX = 8;
    public static final int VOA_DEGRADE_LOW_INDEX = 9;
    public static final int VOA_FAILURE_LOW_INDEX = 10;
    public static final int ADD_POWER_FAILURE_LOW_INDEX = 11;
    public static final int GAIN_DEGRADE_LOW_INDEX = 12;
    public static final int GAIN_DEGRADE_HIGH_INDEX = 13;
    protected int thresholdLayer;
    protected sOpticsTCAThresholds[] thresholdsVal;
    protected sOpticsAlmThresholds[] AlmThresholdsVal;
    private boolean[][] isDirty;
    private static final SDebug db = new SDebug("AmpliOpticalThresholdTableModel");

    public AmpliOpticalThresholdTableModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray, int n) {
        super(db, abstractOpticsLineModelArray);
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.thresholdLayer = n;
        this.thresholdsVal = new sOpticsTCAThresholds[this.numLines];
        this.AlmThresholdsVal = new sOpticsAlmThresholds[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.thresholdsVal[i] = null;
            this.AlmThresholdsVal[i] = null;
        }
        this.resetDirtyBits();
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    public boolean isCellEditable(int n, int n2) {
        return this.isUserAuthorized(SecurityLevel.PROVISIONING) && (n2 == 2 || n2 == 1);
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return new Integer(this.getPowerHigh(n));
                }
                case 2: {
                    return new Integer(this.getPowerLow(n));
                }
                case 3: {
                    return new Integer(this.AlmThresholdsVal[n].opticalPowerAlmTh.fail.low);
                }
                case 6: {
                    return new Integer(this.AlmThresholdsVal[n].opticalPowerAlmTh.degrade.high);
                }
                case 7: {
                    return new Integer(this.AlmThresholdsVal[n].opticalPowerAlmTh.degrade.low);
                }
                case 8: {
                    return new Integer(this.AlmThresholdsVal[n].gainAlmTh.degrade.high);
                }
                case 9: {
                    return new Integer(this.AlmThresholdsVal[n].gainAlmTh.degrade.low);
                }
                case 10: {
                    return new Integer(this.AlmThresholdsVal[n].gainAlmTh.fail.low);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("AmpliOpticalThresholdTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        boolean bl = false;
        try {
            switch (n2) {
                case 1: {
                    this.thresholdsVal[n].opticalPowerPMTh.high = Integer.parseInt((String)object);
                    break;
                }
                case 2: {
                    this.thresholdsVal[n].opticalPowerPMTh.low = Integer.parseInt((String)object);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            SDebug.printStackTrace((Throwable)classCastException);
            return;
        }
        this.isDirty[n][n2] = bl ? !this.isDirty[n][n2] : true;
        this.fireTableCellUpdated(n, n2);
    }

    protected int getPowerHigh(int n) {
        this.refreshThresholds(n);
        return this.thresholdsVal[n].opticalPowerPMTh.high;
    }

    protected int getPowerLow(int n) {
        this.refreshThresholds(n);
        return this.thresholdsVal[n].opticalPowerPMTh.low;
    }

    protected void refreshThresholds(int n) {
        if (this.thresholdsVal[n] == null) {
            try {
                switch (this.thresholdLayer) {
                    case 0: {
                        this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_15_MIN);
                        break;
                    }
                    case 1: {
                        this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_DAY);
                    }
                }
                if (db.on()) {
                    db.println("Thresholds val got for line " + n);
                }
            }
            catch (Exception exception) {
                db.println(exception.toString());
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private int getIndexOf(Object object, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        return list.indexOf(object);
    }

    private int unsignedShortToInt(short s) {
        int n = s & 0xFFFF;
        return n;
    }

    private void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) throws Exception {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        try {
            switch (this.thresholdLayer) {
                case 0: {
                    this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_15_MIN);
                    break;
                }
                case 1: {
                    this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_DAY);
                    break;
                }
                case 2: {
                    this.AlmThresholdsVal[n] = this.model[n].getOpticsAlmThresholds();
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            throw new AnnotatedException("Error refreshing row " + (n + 1), exception);
        }
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.portNames[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void applyToModel() throws Exception {
        if (db.on()) {
            db.println("applyToModel");
        }
        int n = 0;
        try {
            block7: for (n = 0; n < this.numLines; ++n) {
                switch (this.thresholdLayer) {
                    case 0: {
                        this.model[n].setOpticsTCAThresholds(this.thresholdsVal[n], eIntervalType.INTERVAL_15_MIN);
                        continue block7;
                    }
                    case 1: {
                        this.model[n].setOpticsTCAThresholds(this.thresholdsVal[n], eIntervalType.INTERVAL_DAY);
                        continue block7;
                    }
                    case 2: {
                        this.model[n].setOpticsAlmThresholds(this.AlmThresholdsVal[n]);
                    }
                }
            }
            this.resetDirtyBits();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

