/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Optics.PM_OPTICS_UNDEFINED;
import cerent.cms.idl.Optics.eOpticalAmplifierControlMode;
import cerent.cms.idl.Optics.eRingDirection;
import cerent.cms.idl.OpticsTopology.eDwdmRingType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsAmplifiedLineModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.ui.IAdminTableAccess;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.oadm.OpticalTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;

public class AmpliParametersTableModel
extends OpticalTableModel
implements PM_OPTICS_UNDEFINED,
IAdminTableAccess {
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int SERVICE_STATE_INDEX = 3;
    public static final int RING_DIRECTION_INDEX = 4;
    public static final int TOTAL_POWER_INDEX = 5;
    public static final int POWREF_INDEX = 6;
    public static final int OFFSET_INDEX = 7;
    public static final int SIGNAL_OUTPOWER_INDEX = 8;
    public static final int TOTAL_OUTPOWER_INDEX = 9;
    public static final int MODE_INDEX = 10;
    public static final int VOA_POWREF_INDEX = 11;
    public static final int VOA_POWCAL_INDEX = 12;
    public static final int VOA_ATTENREF_INDEX = 13;
    public static final int VOA_ATTENCAL_INDEX = 14;
    public static final int DCU_INSLOSS_INDEX = 15;
    public static final int GAIN_INDEX = 16;
    public static final int SETPOINT_GAIN_INDEX = 17;
    public static final int TILT_REFERENCE_INDEX = 18;
    public static final int TILT_CALIB_INDEX = 19;
    public static final int SOAK_TIME_INDEX = 20;
    public static String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "Service State", "Line Direction", "Total Output Power", "Channel Power Ref.", "Offset", "Signal Output Power", "Output Power Set-Point", "Working Mode", "VOA Power Ref.", "VOA Power Calib.", "VOA Attenuation Ref.", "VOA Attenuation Calib.", "DCU Insertion Loss", "Gain", "Gain SetPoint", "Tilt Reference", "Tilt Calibration", "AINS Soak"};
    public static final int OUT_OF_SERVICE = 1;
    public static final int IN_SERVICE = 0;
    public static final int OOS_MT = 2;
    public static final int IS_AINS = 3;
    public static final int WEST_TO_EAST = 1;
    public static final int EAST_TO_WEST = 0;
    public static final int CONSTANT_ATTENUATION = 1;
    public static final int CONSTANT_POWER = 0;
    public static final int VALUE_OUT_OF_RANGE = 3;
    public static final int THR_ADJUST_FAILED = 6;
    public static final int POWER_CALIBRATION_NOT_ALLOWED = 7;
    public static final int OUTPUT_POWER = 0;
    public static final int GAIN = 1;
    public static final int UNDEFINED = -1000000;
    public static final String[] ringDirectionStrings = new String[]{"East to West", "West to East"};
    public static final String[] ModeStrings = new String[]{"Output Power", "Gain", "N/A"};
    private AdminState[] adminState = new AdminState[this.numLines];
    private IServiceState[] serviceState = new IServiceState[this.numLines];
    private int[] expectedWavelength;
    private int[] actualWavelength;
    private int[] ringDirection;
    private int[] actualPower = new int[this.numLines];
    private int[] Mode;
    private String[] VOAAttenCal;
    private String[] VOAPowerCal;
    private String[] SetPointGain;
    private String[] PowerCal;
    private String[] TiltCalib;
    private String[] ChnPower;
    private Attribute[] wavelength;
    private boolean[][] isDirty;
    private eDwdmRingType ringtype;
    private int numChars = 0;
    private boolean[][] Flg_FeatureUnsupported;
    private boolean FlgOkDialog = false;
    private boolean FlgAdminStateChanged = false;
    private String[] actPower;
    private String[] actAseCompPwr;
    private String[] actGain;
    private static final SDebug db = new SDebug("AmpliParametersTableModel");

    public AmpliParametersTableModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(db, abstractOpticsLineModelArray);
        this.ringDirection = new int[this.numLines];
        this.Mode = new int[this.numLines];
        this.VOAAttenCal = new String[this.numLines];
        this.VOAPowerCal = new String[this.numLines];
        this.PowerCal = new String[this.numLines];
        this.TiltCalib = new String[this.numLines];
        this.SetPointGain = new String[this.numLines];
        this.ChnPower = new String[this.numLines];
        this.actPower = new String[this.numLines];
        this.actAseCompPwr = new String[this.numLines];
        this.actGain = new String[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.Flg_FeatureUnsupported = new boolean[this.numLines][this.getColumnCount()];
        for (int i = 0; i < this.numLines; ++i) {
            this.actualPower[i] = -1;
            this.Mode[i] = -1;
            this.ringDirection[i] = -1;
            this.VOAAttenCal[i] = null;
            this.VOAPowerCal[i] = null;
            this.PowerCal[i] = null;
            this.TiltCalib[i] = null;
            this.SetPointGain[i] = null;
            this.ChnPower[i] = null;
        }
        this.changeColumnName(5);
        this.resetDirtyBits();
        this.setFeatureUnsupported();
        this.getRingType();
    }

    private void getRingType() {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.model[0].getNodeModel();
        try {
            this.ringtype = nodeModelDelegate.getDwdmOpticalSetupModel().getDwdmRingType();
        }
        catch (FeatureUnsupported featureUnsupported) {
            this.ringtype = eDwdmRingType.METRO_CORE;
        }
        catch (NullPointerException nullPointerException) {
            this.ringtype = eDwdmRingType.METRO_CORE;
        }
    }

    private boolean isGainParamAvailable(int n) {
        return this.ringtype == eDwdmRingType.METRO_ACCESS || this.ringtype == eDwdmRingType.METRO_CORE && this.Mode[n] == 1;
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    private void changeColumnName(int n) {
        AmpliParametersTableModel.columnNames[n] = this.model[0] instanceof OpticsAmplifiedLineModel ? "Total Output Power" : "Power";
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    public String[] getringDirectionStrings() {
        return ringDirectionStrings;
    }

    private String getSoakTimeString(int n) throws NoSuchInterface {
        return "00:00 (H:M)";
    }

    public boolean isCellEditable(int n, int n2) {
        if (!this.isUserAuthorized(SecurityLevel.PROVISIONING)) {
            return false;
        }
        if (n2 == 6) {
            return false;
        }
        this.getRingType();
        if (n2 == 1 || n2 == 2 || n2 == 4 || n2 == 6 || n2 == 17 && this.ringtype == eDwdmRingType.METRO_ACCESS) {
            return true;
        }
        if (n2 == 7 || n2 == 19 || n2 == 12 || n2 == 14) {
            return !this.Flg_FeatureUnsupported[n][n2];
        }
        return false;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescription(n);
                }
                case 1: {
                    return this.getPortName(n);
                }
                case 2: {
                    return this.getAdminState(n).toString(this.getTerms());
                }
                case 3: {
                    return this.getServiceState(n).toString(this.getTerms());
                }
                case 4: {
                    return this.getRingDirection(n);
                }
                case 5: {
                    return this.actPower[n];
                }
                case 6: {
                    return this.getChnPowerRef(n);
                }
                case 7: {
                    return this.getPowerCal(n);
                }
                case 10: {
                    return this.getMode(n);
                }
                case 11: {
                    return this.getVOARefPower(n);
                }
                case 12: {
                    return this.getVOAPowerCal(n);
                }
                case 13: {
                    return this.getVOAAttenuationRef(n);
                }
                case 14: {
                    return this.getVOAAttenuationCal(n);
                }
                case 15: {
                    return this.getDCUInsLoss(n);
                }
                case 16: {
                    return this.actGain[n];
                }
                case 17: {
                    return this.getSetPointGain(n);
                }
                case 18: {
                    return this.getTiltReference(n);
                }
                case 19: {
                    return this.getTiltCal(n);
                }
                case 20: {
                    return this.getSoakTimeString(n);
                }
                case 9: {
                    return this.getRefPower(n);
                }
                case 8: {
                    return this.actAseCompPwr[n];
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("AmpliParametersTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value row=" + n + " col=" + n2);
        }
        boolean bl = false;
        try {
            switch (n2) {
                case 1: {
                    this.portNames[n] = (String)object;
                    break;
                }
                case 2: {
                    if (((AdminState)object).equals(this.adminState[n])) {
                        return;
                    }
                    this.adminState[n] = (AdminState)object;
                    break;
                }
                case 4: {
                    int n3 = this.getIndexOf((String)object, ringDirectionStrings);
                    if (this.ringDirection[n] == n3) {
                        return;
                    }
                    this.ringDirection[n] = n3;
                    break;
                }
                case 7: {
                    this.PowerCal[n] = (String)object;
                    break;
                }
                case 17: {
                    this.SetPointGain[n] = (String)object;
                    break;
                }
                case 19: {
                    this.TiltCalib[n] = (String)object;
                    break;
                }
                case 14: {
                    this.VOAAttenCal[n] = (String)object;
                    break;
                }
                case 12: {
                    this.VOAPowerCal[n] = (String)object;
                    break;
                }
                case 6: {
                    this.ChnPower[n] = (String)object;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            SDebug.printStackTrace((Throwable)classCastException);
            return;
        }
        this.isDirty[n][n2] = bl ? !this.isDirty[n][n2] : true;
        this.fireTableCellUpdated(n, n2);
    }

    private int getIndexOf(Object object, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        return list.indexOf(object);
    }

    private String getPortDescription(int n) {
        String string;
        Object object;
        try {
            object = this.model[n].getPortModel();
            string = PortHelper.getPortNumString((IPortModel)object);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            string = String.valueOf(n + 1);
        }
        object = string + " (" + this.getType(n) + ")";
        return object;
    }

    protected eAdminState getAdminStateFromModel(int n) throws NoSuchInterface {
        return this.model[n].getAdminStateEnum();
    }

    public AdminState getAdminState(int n) throws Exception {
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.model[n].getAdminStateEnum();
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.model[n].getServiceState();
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    private String getType(int n) {
        try {
            return this.model[n].getPortTypeString();
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    private String getMode(int n) {
        if (this.Mode[n] == -1) {
            try {
                if (this.model[n] != null && this.model[n] instanceof OpticsAmplifiedLineModel) {
                    eOpticalAmplifierControlMode eOpticalAmplifierControlMode2;
                    OpticsAmplifiedLineModel opticsAmplifiedLineModel = (OpticsAmplifiedLineModel)this.model[n];
                    eOpticalAmplifierControlMode eOpticalAmplifierControlMode3 = eOpticalAmplifierControlMode2 = this.model[n] != null ? opticsAmplifiedLineModel.getControlMode() : eOpticalAmplifierControlMode.OUTPUT_POWER;
                    this.Mode[n] = eOpticalAmplifierControlMode2 == eOpticalAmplifierControlMode.GAIN ? 1 : (eOpticalAmplifierControlMode2 == eOpticalAmplifierControlMode.OUTPUT_POWER ? 0 : 2);
                } else {
                    this.Mode[n] = 2;
                }
            }
            catch (Exception exception) {
                this.Mode[n] = 2;
            }
        }
        return ModeStrings[this.Mode[n]];
    }

    private String getActPower(int n) {
        try {
            String string = new Integer(this.model[n].getActualPower()).toString();
            this.numChars = string.startsWith("-") ? 2 : 1;
            string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
            return string;
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    private String getVOARefPower(int n) {
        try {
            int n2 = this.model[n].getVoaReferencePower();
            if (n2 == -1000000) {
                return "N/A";
            }
            String string = new Integer(n2).toString();
            this.numChars = string.startsWith("-") ? 2 : 1;
            string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
            return string;
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    private String getVOAPowerCal(int n) {
        if (this.VOAPowerCal[n] == null) {
            this.Flg_FeatureUnsupported[n][12] = false;
            try {
                int n2 = this.model[n].getVoaCalibrationPower();
                if (n2 == -1000000) {
                    this.VOAPowerCal[n] = "N/A";
                    this.Flg_FeatureUnsupported[n][12] = true;
                    return this.VOAPowerCal[n];
                }
                this.VOAPowerCal[n] = new Integer(n2).toString();
                this.numChars = this.VOAPowerCal[n].startsWith("-") ? 2 : 1;
                this.VOAPowerCal[n] = this.VOAPowerCal[n].length() > this.numChars ? this.VOAPowerCal[n].substring(0, this.VOAPowerCal[n].length() - 1) + "." + this.VOAPowerCal[n].substring(this.VOAPowerCal[n].length() - 1) : (this.numChars == 2 ? this.VOAPowerCal[n].substring(0, 1) + "0." + this.VOAPowerCal[n].substring(1, this.VOAPowerCal[n].length()) : "0." + this.VOAPowerCal[n]);
            }
            catch (Exception exception) {
                this.VOAPowerCal[n] = "N/A";
                this.Flg_FeatureUnsupported[n][12] = true;
            }
        }
        return this.VOAPowerCal[n];
    }

    private String getVOAAttenuationRef(int n) {
        try {
            int n2 = this.model[n].getVoaReferenceAttenuation();
            if (n2 == -1000000) {
                return "N/A";
            }
            String string = new Integer(n2).toString();
            this.numChars = string.startsWith("-") ? 2 : 1;
            string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
            return string;
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    private String getVOAAttenuationCal(int n) {
        if (this.VOAAttenCal[n] == null) {
            this.Flg_FeatureUnsupported[n][14] = false;
            try {
                int n2 = this.model[n].getVoaCalibrationAttenuation();
                if (n2 == -1000000) {
                    this.VOAAttenCal[n] = "N/A";
                    this.Flg_FeatureUnsupported[n][14] = true;
                    return this.VOAAttenCal[n];
                }
                this.VOAAttenCal[n] = new Integer(n2).toString();
                this.numChars = this.VOAAttenCal[n].startsWith("-") ? 2 : 1;
                this.VOAAttenCal[n] = this.VOAAttenCal[n].length() > this.numChars ? this.VOAAttenCal[n].substring(0, this.VOAAttenCal[n].length() - 1) + "." + this.VOAAttenCal[n].substring(this.VOAAttenCal[n].length() - 1) : (this.numChars == 2 ? this.VOAAttenCal[n].substring(0, 1) + "0." + this.VOAAttenCal[n].substring(1, this.VOAAttenCal[n].length()) : "0." + this.VOAAttenCal[n]);
            }
            catch (Exception exception) {
                this.VOAAttenCal[n] = "N/A";
                this.Flg_FeatureUnsupported[n][14] = true;
            }
        }
        return this.VOAAttenCal[n];
    }

    private String getInsertionLoss(int n) {
        try {
            return new Integer(this.model[n].getInsertionLoss()).toString();
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    private String getRefPower(int n) {
        try {
            if (!this.isGainParamAvailable(n)) {
                int n2 = this.model[n].getReferencePower();
                if (n2 == -1000000) {
                    return "N/A";
                }
                String string = new Integer(n2).toString();
                this.numChars = string.startsWith("-") ? 2 : 1;
                string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "N/A";
    }

    public String getChnPowerRef(int n) {
        if (this.ChnPower[n] == null) {
            try {
                if (this.model[n] != null && this.model[n] instanceof OpticsAmplifiedLineModel) {
                    OpticsAmplifiedLineModel opticsAmplifiedLineModel = (OpticsAmplifiedLineModel)this.model[n];
                    int n2 = opticsAmplifiedLineModel.getChnPowerRef();
                    if (n2 == -1000000) {
                        this.ChnPower[n] = "N/A";
                        return this.ChnPower[n];
                    }
                    this.ChnPower[n] = new Integer(n2).toString();
                    this.numChars = this.ChnPower[n].startsWith("-") ? 2 : 1;
                    this.ChnPower[n] = this.ChnPower[n].length() > this.numChars ? this.ChnPower[n].substring(0, this.ChnPower[n].length() - 1) + "." + this.ChnPower[n].substring(this.ChnPower[n].length() - 1) : (this.numChars == 2 ? this.ChnPower[n].substring(0, 1) + "0." + this.ChnPower[n].substring(1, this.ChnPower[n].length()) : "0." + this.ChnPower[n]);
                }
            }
            catch (Exception exception) {
                this.ChnPower[n] = "N/A";
            }
        }
        return this.ChnPower[n];
    }

    public void setChnPower(int n) {
        if (AmpliParametersTableModel.isValidNumber(this.ChnPower[n], "Chn Power.")) {
            float f = Float.parseFloat(this.ChnPower[n]);
            int n2 = (int)(f *= 10.0f);
            try {
                OpticsAmplifiedLineModel opticsAmplifiedLineModel = (OpticsAmplifiedLineModel)this.model[n];
                opticsAmplifiedLineModel.setChnPower(n2);
            }
            catch (ProvisionError provisionError) {
                int n3 = provisionError.getDiscriminator();
                if (n3 == 3) {
                    int n4 = provisionError.getLoValue();
                    String string = new Integer(n4).toString();
                    string = this.StrDivforTen(string);
                    int n5 = provisionError.getHiValue();
                    String string2 = new Integer(n5).toString();
                    string2 = this.StrDivforTen(string2);
                    ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_3, "Per Channel Power ", string, string2);
                    this.ChnPower[n] = null;
                    this.getChnPowerRef(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                }
            }
            catch (Exception exception) {
                this.ChnPower[n] = null;
                this.getChnPowerRef(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
        } else {
            this.ChnPower[n] = null;
            this.getChnPowerRef(n);
            this.fireTableRowsUpdated(0, this.numLines - 1);
        }
    }

    public String getPowerCal(int n) {
        if (this.PowerCal[n] == null) {
            this.Flg_FeatureUnsupported[n][7] = false;
            try {
                int n2 = this.model[n].getCalibratedPower();
                if (n2 == -1000000) {
                    this.PowerCal[n] = "N/A";
                    this.Flg_FeatureUnsupported[n][7] = true;
                    return this.PowerCal[n];
                }
                this.PowerCal[n] = new Integer(n2).toString();
                this.numChars = this.PowerCal[n].startsWith("-") ? 2 : 1;
                this.PowerCal[n] = this.PowerCal[n].length() > this.numChars ? this.PowerCal[n].substring(0, this.PowerCal[n].length() - 1) + "." + this.PowerCal[n].substring(this.PowerCal[n].length() - 1) : (this.numChars == 2 ? this.PowerCal[n].substring(0, 1) + "0." + this.PowerCal[n].substring(1, this.PowerCal[n].length()) : "0." + this.PowerCal[n]);
            }
            catch (Exception exception) {
                this.PowerCal[n] = "N/A";
                this.Flg_FeatureUnsupported[n][7] = true;
            }
        }
        return this.PowerCal[n];
    }

    private void setPowerCal(int n) {
        if (AmpliParametersTableModel.isValidNumber(this.PowerCal[n], "Power Cal.")) {
            float f = Float.parseFloat(this.PowerCal[n]);
            int n2 = (int)(f *= 10.0f);
            try {
                this.model[n].setCalibratedPower(n2);
            }
            catch (ProvisionError provisionError) {
                int n3 = provisionError.getDiscriminator();
                switch (n3) {
                    case 3: {
                        int n4 = provisionError.getLoValue();
                        String string = new Integer(n4).toString();
                        string = this.StrDivforTen(string);
                        int n5 = provisionError.getHiValue();
                        String string2 = new Integer(n5).toString();
                        string2 = this.StrDivforTen(string2);
                        ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_4, "Power Calibration and Power Reference", string, string2);
                        break;
                    }
                    case 6: {
                        ErrorMsg.displayError(this.getFrame(), EMC.EID_THR_ADJ_FAILED_PARAM_2, "The new setpoint would either make the thresholds\n", "inconsistent or set the fail threshold outside the range.");
                        break;
                    }
                    case 7: {
                        ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_POWERCAL_NOT_ALLOWED);
                    }
                }
                this.PowerCal[n] = null;
                this.getPowerCal(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
            catch (Exception exception) {
                this.PowerCal[n] = null;
                this.getPowerCal(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
        } else {
            this.PowerCal[n] = null;
            this.getPowerCal(n);
            this.fireTableRowsUpdated(0, this.numLines - 1);
        }
    }

    private void setVOACal(int n) {
        if (AmpliParametersTableModel.isValidNumber(this.VOAAttenCal[n], "VOA Power Cal.")) {
            float f = Float.parseFloat(this.VOAAttenCal[n]);
            int n2 = (int)(f *= 10.0f);
            try {
                this.model[n].setVOAAttenuation(n2);
            }
            catch (ProvisionError provisionError) {
                int n3 = provisionError.getDiscriminator();
                if (n3 == 3) {
                    int n4 = provisionError.getLoValue();
                    String string = new Integer(n4).toString();
                    string = this.StrDivforTen(string);
                    int n5 = provisionError.getHiValue();
                    String string2 = new Integer(n5).toString();
                    string2 = this.StrDivforTen(string2);
                    ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_4, "VOA Attenuation Calibration and VOA attenuation Reference", string, string2);
                    this.VOAAttenCal[n] = null;
                    this.getVOAAttenuationCal(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                }
            }
            catch (Exception exception) {
                this.VOAAttenCal[n] = null;
                this.getVOAAttenuationCal(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
        } else {
            this.VOAAttenCal[n] = null;
            this.getVOAAttenuationCal(n);
            this.fireTableRowsUpdated(0, this.numLines - 1);
        }
    }

    private void setVOAPowerCal(int n) {
        if (AmpliParametersTableModel.isValidNumber(this.VOAPowerCal[n], "VOA Power Cal.")) {
            float f = Float.parseFloat(this.VOAPowerCal[n]);
            int n2 = (int)(f *= 10.0f);
            try {
                this.model[n].setVOACalibrationPower(n2);
            }
            catch (ProvisionError provisionError) {
                int n3 = provisionError.getDiscriminator();
                if (n3 == 3) {
                    int n4 = provisionError.getLoValue();
                    String string = new Integer(n4).toString();
                    string = this.StrDivforTen(string);
                    int n5 = provisionError.getHiValue();
                    String string2 = new Integer(n5).toString();
                    string2 = this.StrDivforTen(string2);
                    ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_3, "VOA Power", string, string2);
                    this.VOAPowerCal[n] = null;
                    this.getVOAPowerCal(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                }
            }
            catch (Exception exception) {
                this.VOAPowerCal[n] = null;
                this.getVOAPowerCal(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
        } else {
            this.VOAPowerCal[n] = null;
            this.getVOAPowerCal(n);
            this.fireTableRowsUpdated(0, this.numLines - 1);
        }
    }

    private String getAttenuationRef(int n) {
        try {
            String string = new Integer(this.model[n].getVoaRefPower()).toString();
            string = string.length() > 1 ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : "0." + string;
            return string;
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    private String getRingDirection(int n) {
        if (this.ringDirection[n] == -1) {
            try {
                eRingDirection eRingDirection2;
                eRingDirection eRingDirection3 = eRingDirection2 = this.model[n] != null ? this.model[n].getRingDirection() : eRingDirection.EAST_WEST;
                if (eRingDirection2 == eRingDirection.EAST_WEST) {
                    this.ringDirection[n] = 0;
                } else if (eRingDirection2 == eRingDirection.WEST_EAST) {
                    this.ringDirection[n] = 1;
                }
            }
            catch (Exception exception) {
                return "N/A";
            }
        }
        return ringDirectionStrings[this.ringDirection[n]];
    }

    private String getDCUInsLoss(int n) {
        try {
            if (this.model[n] != null && this.model[n] instanceof OpticsAmplifiedLineModel) {
                OpticsAmplifiedLineModel opticsAmplifiedLineModel = (OpticsAmplifiedLineModel)this.model[n];
                String string = new Integer(opticsAmplifiedLineModel.getDCULoss()).toString();
                this.numChars = string.startsWith("-") ? 2 : 1;
                string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "N/A";
    }

    private String getGainValue(int n) {
        try {
            if (this.model[n] != null && this.model[n] instanceof OpticsAmplifiedLineModel && this.isGainParamAvailable(n)) {
                OpticsAmplifiedLineModel opticsAmplifiedLineModel = (OpticsAmplifiedLineModel)this.model[n];
                String string = new Integer(opticsAmplifiedLineModel.getGain()).toString();
                this.numChars = string.startsWith("-") ? 2 : 1;
                string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "N/A";
    }

    private String getComAsePower(int n) {
        try {
            if (this.model[n] != null && this.model[n] instanceof OpticsAmplifiedLineModel) {
                OpticsAmplifiedLineModel opticsAmplifiedLineModel = (OpticsAmplifiedLineModel)this.model[n];
                String string = new Integer(opticsAmplifiedLineModel.getAsePower()).toString();
                this.numChars = string.startsWith("-") ? 2 : 1;
                string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "N/A";
    }

    private String getSetPointGain(int n) {
        if (this.SetPointGain[n] == null) {
            this.SetPointGain[n] = "N/A";
            try {
                if (this.model[n] != null && this.model[n] instanceof OpticsAmplifiedLineModel && this.isGainParamAvailable(n)) {
                    OpticsAmplifiedLineModel opticsAmplifiedLineModel = (OpticsAmplifiedLineModel)this.model[n];
                    int n2 = opticsAmplifiedLineModel.getGainSetPoint();
                    if (n2 == -1000000) {
                        return this.SetPointGain[n];
                    }
                    this.SetPointGain[n] = new Integer(n2).toString();
                    this.numChars = this.SetPointGain[n].startsWith("-") ? 2 : 1;
                    this.SetPointGain[n] = this.SetPointGain[n].length() > this.numChars ? this.SetPointGain[n].substring(0, this.SetPointGain[n].length() - 1) + "." + this.SetPointGain[n].substring(this.SetPointGain[n].length() - 1) : (this.numChars == 2 ? this.SetPointGain[n].substring(0, 1) + "0." + this.SetPointGain[n].substring(1, this.SetPointGain[n].length()) : "0." + this.SetPointGain[n]);
                    return this.SetPointGain[n];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.SetPointGain[n];
    }

    private void setSetPointGain(int n) {
        if (AmpliParametersTableModel.isValidNumber(this.SetPointGain[n], "Gain Set Point")) {
            float f = Float.parseFloat(this.SetPointGain[n]);
            int n2 = (int)(f *= 10.0f);
            try {
                OpticsAmplifiedLineModel opticsAmplifiedLineModel = (OpticsAmplifiedLineModel)this.model[n];
                opticsAmplifiedLineModel.setGainSetPoint(n2);
            }
            catch (ProvisionError provisionError) {
                int n3 = provisionError.getDiscriminator();
                if (n3 == 3) {
                    int n4 = provisionError.getLoValue();
                    String string = new Integer(n4).toString();
                    string = this.StrDivforTen(string);
                    int n5 = provisionError.getHiValue();
                    String string2 = new Integer(n5).toString();
                    string2 = this.StrDivforTen(string2);
                    ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_3, "Gain Set Point", string, string2);
                    this.SetPointGain[n] = null;
                    this.getSetPointGain(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                }
            }
            catch (Exception exception) {
                this.SetPointGain[n] = null;
                this.getSetPointGain(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
        } else {
            this.SetPointGain[n] = null;
            this.getSetPointGain(n);
            this.fireTableRowsUpdated(0, this.numLines - 1);
        }
    }

    private String getTiltReference(int n) {
        try {
            if (this.model[n] != null && this.model[n] instanceof OpticsAmplifiedLineModel) {
                OpticsAmplifiedLineModel opticsAmplifiedLineModel = (OpticsAmplifiedLineModel)this.model[n];
                String string = new Integer(opticsAmplifiedLineModel.getReferenceTilt()).toString();
                this.numChars = string.startsWith("-") ? 2 : 1;
                string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "N/A";
    }

    private String getTiltCal(int n) {
        if (this.TiltCalib[n] == null) {
            this.Flg_FeatureUnsupported[n][19] = false;
            try {
                if (this.model[n] != null && this.model[n] instanceof OpticsAmplifiedLineModel) {
                    OpticsAmplifiedLineModel opticsAmplifiedLineModel = (OpticsAmplifiedLineModel)this.model[n];
                    this.TiltCalib[n] = new Integer(opticsAmplifiedLineModel.getCalibratedTilt()).toString();
                    this.numChars = this.TiltCalib[n].startsWith("-") ? 2 : 1;
                    this.TiltCalib[n] = this.TiltCalib[n].length() > this.numChars ? this.TiltCalib[n].substring(0, this.TiltCalib[n].length() - 1) + "." + this.TiltCalib[n].substring(this.TiltCalib[n].length() - 1) : (this.numChars == 2 ? this.TiltCalib[n].substring(0, 1) + "0." + this.TiltCalib[n].substring(1, this.TiltCalib[n].length()) : "0." + this.TiltCalib[n]);
                }
            }
            catch (Exception exception) {
                this.TiltCalib[n] = "N/A";
                this.Flg_FeatureUnsupported[n][19] = true;
            }
        }
        return this.TiltCalib[n];
    }

    private void setTiltCal(int n) {
        if (AmpliParametersTableModel.isValidNumber(this.TiltCalib[n], "Tilt Calib.")) {
            float f = Float.parseFloat(this.TiltCalib[n]);
            int n2 = (int)(f *= 10.0f);
            try {
                OpticsAmplifiedLineModel opticsAmplifiedLineModel = (OpticsAmplifiedLineModel)this.model[n];
                opticsAmplifiedLineModel.setTiltCalibration(n2);
            }
            catch (ProvisionError provisionError) {
                int n3 = provisionError.getDiscriminator();
                if (n3 == 3) {
                    int n4 = provisionError.getLoValue();
                    String string = new Integer(n4).toString();
                    string = this.StrDivforTen(string);
                    int n5 = provisionError.getHiValue();
                    String string2 = new Integer(n5).toString();
                    string2 = this.StrDivforTen(string2);
                    ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_4, "Tilt Calibration and Tilt Reference", string, string2);
                    this.TiltCalib[n] = null;
                    this.getTiltCal(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                }
            }
            catch (Exception exception) {
                this.TiltCalib[n] = null;
                this.getTiltCal(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
        } else {
            this.TiltCalib[n] = null;
            this.getTiltCal(n);
            this.fireTableRowsUpdated(0, this.numLines - 1);
        }
    }

    private int unsignedShortToInt(short s) {
        int n = s & 0xFFFF;
        return n;
    }

    private void resetDirtyBits() {
        this.FlgOkDialog = false;
        this.FlgAdminStateChanged = false;
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    private void setFeatureUnsupported() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.Flg_FeatureUnsupported[i][j] = false;
            }
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.portNames[n] = this.getPortName(n);
        this.getRingDirection(n);
        this.getMode(n);
        this.VOAAttenCal[n] = this.getVOAAttenuationCal(n);
        this.VOAPowerCal[n] = this.getVOAPowerCal(n);
        this.PowerCal[n] = this.getPowerCal(n);
        this.SetPointGain[n] = this.getSetPointGain(n);
        this.TiltCalib[n] = this.getTiltCal(n);
        this.ChnPower[n] = this.getChnPowerRef(n);
        this.getVOARefPower(n);
        this.getVOAAttenuationRef(n);
        this.actPower[n] = this.getActPower(n);
        this.actGain[n] = this.getGainValue(n);
        this.actAseCompPwr[n] = this.getComAsePower(n);
        this.getRefPower(n);
        this.getType(n);
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.portNames[n] = null;
        this.adminState[n] = null;
        this.serviceState[n] = null;
        this.Mode[n] = -1;
        this.VOAAttenCal[n] = null;
        this.VOAPowerCal[n] = null;
        this.PowerCal[n] = null;
        this.actPower[n] = null;
        this.actGain[n] = null;
        this.actAseCompPwr[n] = null;
        this.TiltCalib[n] = null;
        this.SetPointGain[n] = null;
        this.ringDirection[n] = -1;
        this.ChnPower[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    boolean mediaChanged() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isDirty[i][2]) continue;
        }
        return false;
    }

    boolean statusChangedToOos() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isDirty[i][2] || this.adminState[i].getAdminStateEnum().value() == 3) continue;
            return true;
        }
        return false;
    }

    public void applyToModel() throws Exception {
        int n = 0;
        boolean bl = false;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if ((this.isDirty[n][14] || this.isDirty[n][12] || this.isDirty[n][7] || this.isDirty[n][19] || this.isDirty[n][17]) && !this.FlgOkDialog) {
                    if (CerentDialog.yesNoDialog((Component)this.getFrame(), (String)"Selected operation could be service affecting. Apply changes anyway?", (String)"Confirmation Dialog")) {
                        this.FlgOkDialog = true;
                    } else {
                        this.refreshFromModel();
                        return;
                    }
                }
                if (this.isDirty[n][1]) {
                    this.model[n].setAlias(this.getPortName(n));
                }
                if (this.isDirty(n, 2)) {
                    this.FlgAdminStateChanged = true;
                    this.model[n].setAdminState(this.getAdminState(n).getAdminStateEnum());
                }
                if (this.isDirty[n][14]) {
                    this.setVOACal(n);
                }
                if (this.isDirty[n][12]) {
                    this.setVOAPowerCal(n);
                }
                if (this.isDirty[n][7]) {
                    this.setPowerCal(n);
                }
                if (this.isDirty[n][17]) {
                    this.setSetPointGain(n);
                }
                if (this.isDirty[n][19]) {
                    this.setTiltCal(n);
                }
                if (this.isDirty[n][6]) {
                    this.setChnPower(n);
                }
                if (!this.isDirty[n][4]) continue;
                if (this.ringDirection[n] == 1) {
                    this.model[n].setRingDirection(eRingDirection.WEST_EAST);
                    continue;
                }
                this.model[n].setRingDirection(eRingDirection.EAST_WEST);
            }
            this.resetDirtyBits();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
            this.refreshFromModel();
        }
        catch (Exception exception) {
            if (this.FlgAdminStateChanged) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_CHANGE_ADMIN_STATE_NOTALLOWED);
            } else {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
            }
            this.refreshFromModel();
        }
    }

    private void AdjustAllWavelength(int n, int n2) {
        int n3 = 0;
        for (n3 = 0; n3 < this.numLines; ++n3) {
            if (n3 == n) continue;
            this.expectedWavelength[n3] = n2;
        }
    }

    public static boolean isValidNumber(String string, String string2) {
        try {
            Float.valueOf(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private String StrDivforTen(String string) {
        this.numChars = string.startsWith("-") ? 2 : 1;
        string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
        return string;
    }

    public boolean isAdminStateDirty(int n) {
        return this.isDirty(n, 2);
    }
}

