/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.idl.OpticsTopology.sParameterKey;
import cerent.cms.model.ANS.ANSElement;
import cerent.cms.model.ANS.ANSManager;
import cerent.cms.model.ANS.IANSElement;
import cerent.cms.model.ANS.IANSNode;
import cerent.cms.model.InvalidParams;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.launcher.CmsClassLoader;
import cerent.util.BuildInfo;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.PersistentFileChooserDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observable;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class ANSHelper
extends Model {
    private IANSNode droot;
    private NodeModelDelegate nodeModel;
    private Component parent;

    public ANSHelper(Component component, NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.nodeModel = nodeModelDelegate;
        this.parent = component;
        this.nodeModel.getANSManager().addObserver(this);
    }

    public void applyToNode() throws Exception {
        if (this.droot != null) {
            if (!CerentDialog.yesNoDialog((Component)this.parent, (String)"CAUTION: Changing parameters manually is not recommended.\nIncorrect changes will cause traffic loss.\nUse your DWDM network design application to recalculate\nthe node parameters, then import the new parameters into the node.\nDo you wish to continue?", (String)"Apply NE Update to Node")) {
                return;
            }
            this.nodeModel.getANSManager().applyToNode(this.droot);
            CerentDialog.infoDialog((Component)this.parent, (String)"Note: After applying the changes,\nyou must run automatic node setup (ANS).", (String)"Apply NE Update to Node");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String importDefaults() {
        Object object;
        Object object2;
        Object object3;
        HashMap hashMap;
        block11: {
            Properties properties;
            FileInputStream fileInputStream;
            block10: {
                File file = this.getFile(false);
                if (file == null) {
                    return null;
                }
                fileInputStream = null;
                properties = new Properties();
                fileInputStream = new FileInputStream(file);
                if (this.showProperty(new BufferedReader(new InputStreamReader(new FileInputStream(file))), file.getName()) != 2) break block10;
                String string = null;
                return string;
            }
            properties.load(fileInputStream);
            LinkedList linkedList = new LinkedList();
            hashMap = new HashMap();
            this.parseProperties(properties, hashMap, linkedList);
            if (linkedList.isEmpty() || this.parent == null) break block11;
            object3 = new JTextArea();
            ((JComponent)object3).setOpaque(false);
            ((JTextComponent)object3).setEditable(false);
            ((JTextComponent)object3).setText("Accepted " + hashMap.size() + " properties\n");
            ((JTextArea)object3).append("Found " + linkedList.size() + " error(s)/warning(s)\n");
            ((JTextArea)object3).append("Continue importing this file anyway (invalid entries will be ignored)?");
            object2 = new JList<Object>(linkedList.toArray());
            object = new JPanel(new BorderLayout());
            ((Container)object).add((Component)object3, "North");
            ((Container)object).add(new JScrollPane((Component)object2));
            ((JList)object2).setVisibleRowCount(10);
            int n = JOptionPane.showOptionDialog(this.parent, object, "Import Defaults", 2, 2, null, null, null);
            if (n != 2) break block11;
            String string = null;
            return string;
        }
        try {
            object3 = hashMap.keySet().iterator();
            while (object3.hasNext()) {
                object2 = (sParameterKey)object3.next();
                object = (ANSElement)hashMap.get(object2);
                this.nodeModel.getANSManager().importParameter((sParameterKey)object2, Integer.toString(((ANSElement)object).getIntValue()));
            }
        }
        catch (IOException iOException) {
            SDebug.printStackTrace((Throwable)iOException);
            ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_CANNOT_LOAD_FILE_PARAM_1, (Object)"Ans Wizard Section");
        }
        catch (InvalidParams invalidParams) {
            SDebug.printStackTrace((Throwable)invalidParams);
            ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_INVALID_FILE_VERSION_PARAM_1, (Object)"Ans Wizard Section");
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_CANNOT_LOAD_PROPERTIES);
        }
        return null;
    }

    public String importAnsParams(NsdWizardInfo nsdWizardInfo) {
        String string = nsdWizardInfo.getAnsParams();
        NsdWizardInfo.ColorPane colorPane = null;
        NsdWizardInfo.CtmLog ctmLog = null;
        if (nsdWizardInfo.isCtm()) {
            ctmLog = nsdWizardInfo.getCtmLog();
        } else {
            colorPane = nsdWizardInfo.getLogArea();
        }
        ANSManager aNSManager = this.nodeModel.getANSManager();
        try {
            Object object;
            JList<Object> jList;
            Object object2;
            Properties properties = new Properties();
            properties.load(new StringBufferInputStream(string));
            LinkedList linkedList = new LinkedList();
            HashMap hashMap = new HashMap();
            this.parseProperties(properties, hashMap, linkedList);
            if (!linkedList.isEmpty()) {
                int n;
                if (!nsdWizardInfo.isCtm()) {
                    object2 = new JTextArea();
                    ((JComponent)object2).setOpaque(false);
                    ((JTextComponent)object2).setEditable(false);
                    ((JTextComponent)object2).setText("Accepted " + hashMap.size() + " properties\n");
                    ((JTextArea)object2).append("Found " + linkedList.size() + " error(s)/warning(s)\n");
                    ((JTextArea)object2).append("Continue importing this file anyway (invalid entries will be ignored)?");
                    jList = new JList<Object>(linkedList.toArray());
                    object = new JPanel(new BorderLayout());
                    ((Container)object).add((Component)object2, "North");
                    ((Container)object).add(new JScrollPane(jList));
                    jList.setVisibleRowCount(10);
                    n = JOptionPane.showOptionDialog(this.parent, object, "Import Defaults", 2, 2, null, null, null);
                    if (n == 2) {
                        return null;
                    }
                } else {
                    object2 = ">> This file will be imported even if it contains invalid entries (that will be ignored):\n";
                    jList = null;
                    object = null;
                    object = linkedList.toArray();
                    ctmLog.append((String)object2);
                    for (n = 0; n < ((Object[])object).length; ++n) {
                        jList = ">> " + object[n] + "\n";
                        ctmLog.append((String)((Object)jList));
                    }
                }
            }
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                jList = (sParameterKey)object2.next();
                object = (ANSElement)hashMap.get(jList);
                this.nodeModel.getANSManager().importParameter((sParameterKey)((Object)jList), Integer.toString(((ANSElement)object).getIntValue()));
                String string2 = aNSManager.makeFullPath(aNSManager.parseParam(((ANSElement)object).getFullName(), (sParameterKey)((Object)jList)), (sParameterKey)((Object)jList)).toString();
                if (nsdWizardInfo.isCtm()) {
                    ctmLog.append(">> Importing " + string2 + " with value = " + ((ANSElement)object).getValue().toString() + "\n");
                    continue;
                }
                colorPane.append(Color.BLUE, ">> Importing " + string2 + " with value = " + ((ANSElement)object).getValue().toString() + "\n");
            }
        }
        catch (IOException iOException) {
            SDebug.printStackTrace((Throwable)iOException);
            if (nsdWizardInfo.isCtm()) {
                ctmLog.append(">> Exception: cannot load ans parameters section\n");
            } else {
                ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_CANNOT_LOAD_FILE_PARAM_1, (Object)"Ans Wizard Section");
                colorPane.append(Color.RED, ">> Exception: cannot load ans parameters section\n");
            }
        }
        catch (InvalidParams invalidParams) {
            SDebug.printStackTrace((Throwable)invalidParams);
            if (nsdWizardInfo.isCtm()) {
                ctmLog.append(">> Exception: invalid ans parameters version\n");
            } else {
                ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_INVALID_FILE_VERSION_PARAM_1, (Object)"Ans Wizard Section");
                colorPane.append(Color.RED, ">> Exception: invalid ans parameters version\n");
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            if (nsdWizardInfo.isCtm()) {
                ctmLog.append(">> Exception: cannot load ans parameters section\n");
            }
            ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_CANNOT_LOAD_PROPERTIES);
            colorPane.append(Color.RED, ">> Exception: cannot load ans parameters section\n");
        }
        return null;
    }

    public IANSNode getDefaultsRoot(boolean bl) throws Exception {
        if (this.droot == null || bl) {
            this.droot = this.nodeModel.getANSManager().getDefaultsTree();
        }
        return this.droot;
    }

    public int showProperty(BufferedReader bufferedReader, String string) throws IOException {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            arrayList.add(string2);
        }
        JTextArea jTextArea = new JTextArea();
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setText("Importing File " + string + "\n");
        jTextArea.append("Would you Continue?");
        JList<Object> jList = new JList<Object>(arrayList.toArray());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jTextArea, "North");
        jPanel.add(new JScrollPane(jList));
        jList.setVisibleRowCount(10);
        return JOptionPane.showOptionDialog(this.parent, jPanel, "Import Defaults", 2, 2, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String exportDefaults() {
        File file = this.getFile(true);
        if (file == null) return null;
        FileOutputStream fileOutputStream = null;
        try {
            Properties properties = this.nodeModel.getANSManager().getDefaultsProperties();
            properties.put("dwdm.version", "2.0");
            ClassLoader classLoader = this.getClass().getClassLoader();
            String string = "unknown";
            if (classLoader instanceof CmsClassLoader) {
                string = BuildInfo.sanitize(((CmsClassLoader)classLoader).getSwVersion());
            }
            String string2 = "NE Defaults from build=" + string;
            try {
                fileOutputStream = new FileOutputStream(file);
                properties.store(fileOutputStream, string2);
                String string3 = file.getAbsolutePath();
                return string3;
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_CANNOT_SAVE, (Object)file.getAbsolutePath());
                if (fileOutputStream == null) return null;
                try {
                    fileOutputStream.close();
                    return null;
                }
                catch (Exception exception2) {}
                return null;
                catch (Exception exception3) {
                    SDebug.printStackTrace((Throwable)exception3);
                    ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_CANNOT_UPDATE);
                    return null;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private File getFile(boolean bl) {
        byte by;
        String string;
        String string2;
        if (bl) {
            string2 = "Export NE Update to file";
            string = "Select the file where values should be exported to";
            by = 3;
        } else {
            string2 = "Import NE Update from file";
            string = "Select the file from where values should be imported";
            by = 1;
        }
        return PersistentFileChooserDialog.getFile((Component)this.parent, (String)string2, (Object)string, (byte)by, (String)"ctc", (String)"defaults.history", (int)20);
    }

    private void parseProperties(Properties properties, HashMap hashMap, LinkedList linkedList) throws Exception {
        String string = (String)properties.get("dwdm.version");
        if (string != null) {
            if (new Float(Float.parseFloat(string)).intValue() != 2) {
                throw new InvalidParams("Wrong file version");
            }
        } else {
            throw new InvalidParams("Wrong file version");
        }
        properties.remove("dwdm.version");
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            try {
                ANSElement aNSElement = this.nodeModel.getANSManager().getAnsElem(string2, string3);
                hashMap.put(aNSElement.getKey(), aNSElement);
            }
            catch (ProvisionError provisionError) {
                linkedList.add("unknown value: " + string2);
            }
        }
    }

    public void fillMap(Map map, IANSNode iANSNode) {
        IANSNode[] iANSNodeArray = iANSNode.getChildren();
        ANSManager aNSManager = this.nodeModel.getANSManager();
        for (int i = 0; i < iANSNodeArray.length; ++i) {
            IANSNode iANSNode2 = iANSNodeArray[i];
            if (iANSNode2 instanceof IANSElement) {
                map.put(((IANSElement)iANSNode2).getFullName(), iANSNode2);
                continue;
            }
            this.fillMap(map, iANSNode2);
        }
    }

    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }
}

