/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OptLinkModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PortModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.ComparisonUtil;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class AnsConnColumnRenderer
extends AbstractColumnRenderer {
    public static final int PATCH_FROM = 0;
    public static final int PATCH_TO = 1;
    public static final int PATCH_STAT = 2;
    private static final int COLUMN_NO = 3;
    private static final String OPEN = "(";
    private static final String CLOSE = ")";
    private static final String COMMA = ",";
    private static final String SPACE = " ";
    private static AttributeMaps attributeMap = new AttributeMaps();
    private static final String OPT_LINK_STAT_KEY = "OpticalLinkStatusKey";
    private static final EntityCellRenderer renderer = new EntityCellRenderer();
    private JLabel label;
    private Color[] status_color = new Color[]{Color.black, Color.blue, Color.red};

    public AnsConnColumnRenderer(String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.label = new JLabel();
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        OptLinkModel optLinkModel;
        String string = "N/A";
        JLabel jLabel = this.label;
        try {
            optLinkModel = (OptLinkModel)object;
        }
        catch (Exception exception) {
            this.label.setText("");
            return jLabel;
        }
        switch (n2) {
            case 0: {
                try {
                    string = this.getPatchName((NodeModelDelegate)optLinkModel.getNodeModel(), optLinkModel.getFromPortModel());
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {}
                break;
            }
            case 1: {
                try {
                    string = this.getPatchName((NodeModelDelegate)optLinkModel.getNodeModel(), optLinkModel.getToPortModel());
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {}
                break;
            }
            case 2: {
                string = optLinkModel.getOptLnkStateString();
            }
        }
        this.label.setText(string);
        Color color = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        Color color2 = bl ? jTable.getSelectionForeground() : this.status_color[optLinkModel.getOptLnkState().value() - 1];
        ((Component)jLabel).setBackground(color);
        ((Component)jLabel).setForeground(color2);
        return jLabel;
    }

    private String getPatchName(NodeModelDelegate nodeModelDelegate, PortModel portModel) {
        StringBuffer stringBuffer = new StringBuffer(50);
        if (nodeModelDelegate.isMultishelf()) {
            stringBuffer.append("Shelf ");
            stringBuffer.append(portModel.getShelfId());
            stringBuffer.append(COMMA);
        }
        stringBuffer.append("Slot ");
        stringBuffer.append(portModel.getSlot());
        stringBuffer.append(SPACE);
        stringBuffer.append(OPEN);
        stringBuffer.append(portModel.getModuleModel().getEqTypeName());
        stringBuffer.append(CLOSE);
        stringBuffer.append(COMMA);
        stringBuffer.append("Port ");
        if (portModel instanceof OpticsPortModel) {
            try {
                stringBuffer.append(portModel.getPort());
                stringBuffer.append(SPACE);
                stringBuffer.append(OPEN);
                stringBuffer.append(((OpticsPortModel)portModel).getOpticsLineModel().getPortTypeString());
                stringBuffer.append(CLOSE);
            }
            catch (Exception exception) {
                stringBuffer.append("N/A");
            }
        } else if (portModel instanceof PortModel) {
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            stringBuffer.append(entityCellRenderer.getPortString(portModel, false));
        }
        return stringBuffer.toString();
    }

    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        OptLinkModel optLinkModel = (OptLinkModel)object;
        OptLinkModel optLinkModel2 = (OptLinkModel)object2;
        switch (n) {
            case 0: {
                n2 = ComparisonUtil.compare((int)optLinkModel.getFrom(), (int)optLinkModel2.getFrom());
                break;
            }
            case 1: {
                n2 = ComparisonUtil.compare((int)optLinkModel.getTo(), (int)optLinkModel2.getTo());
                break;
            }
            case 2: {
                n2 = ComparisonUtil.compare((int)optLinkModel.getOptLnkState().value(), (int)optLinkModel2.getOptLnkState().value());
            }
        }
        return n2;
    }

    static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[3];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = AnsConnColumnRenderer.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "From";
                n3 = 400;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "To";
                n3 = 400;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "State";
                n3 = 120;
                bl = true;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new AnsConnColumnRenderer(string, n3, bl, n2);
    }

    public static AttributeMaps getTopologyAttributeMaps() {
        return attributeMap;
    }
}

