/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.DuplicatedPatchCord;
import cerent.cms.model.EndPointInUse;
import cerent.cms.model.EndPointIncompatible;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OptLinkModel;
import cerent.cms.model.OpticalPatchCordModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PortModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.ans.AnsConnTableModel;
import cerent.cms.ui.ans.OptLinkStats;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class AnsConnDataSource
extends AbstractRowDataSource
implements Observer {
    private OpticalPatchCordModel optPatchCordModel = null;
    private NodeModelDelegate nmd = null;
    private boolean inited = false;
    private List optLinkList = new ArrayList();
    private List optCTCLinkList = new ArrayList();
    private List optFiltLinkList = new ArrayList();
    private OptLinkStats filterId = OptLinkStats.LINK_UNDEFINED;
    private static final SDebug db = new SDebug("AnsConnDataSource");

    public AnsConnDataSource(OpticalPatchCordModel opticalPatchCordModel) {
        this.optPatchCordModel = opticalPatchCordModel;
        this.nmd = (NodeModelDelegate)opticalPatchCordModel.getNodeModel();
    }

    public void init() {
        if (!this.inited) {
            this.getOpticalLinkList();
            this.regForEvent();
            this.inited = true;
        }
    }

    private void regForEvent() {
        if (this.nmd != null && this.optPatchCordModel != null) {
            this.optPatchCordModel.addObserver(this);
        }
    }

    private void unRegForEvent() {
        if (this.nmd != null && this.optPatchCordModel != null) {
            this.optPatchCordModel.deleteObserver(this);
        }
    }

    public void createOptLink(OptLinkModel optLinkModel) throws CTCUserException {
        try {
            this.optPatchCordModel.addOpticalLink(optLinkModel.getTo(), optLinkModel.getFrom());
            this.optCTCLinkList.remove(optLinkModel);
        }
        catch (FeatureUnsupported featureUnsupported) {
            throw new CTCUserException("Feature Unsupported for Optical link :\n" + this.fullPatchName(optLinkModel));
        }
        catch (NoSuchInterface noSuchInterface) {
            throw new CTCUserException("NoSuchInterface for Optical link :\n" + this.fullPatchName(optLinkModel));
        }
        catch (EndPointInUse endPointInUse) {
            throw new CTCUserException("EndPointInUse for Optical link :\n" + this.fullPatchName(optLinkModel));
        }
        catch (EndPointIncompatible endPointIncompatible) {
            throw new CTCUserException("EndPointIncompatible for Optical link :\n" + this.fullPatchName(optLinkModel));
        }
        catch (DuplicatedPatchCord duplicatedPatchCord) {
            throw new CTCUserException("DuplicatedPatchCord for Optical link :\n" + this.fullPatchName(optLinkModel));
        }
        finally {
            optLinkModel.UpdateOptLink(OptLinkStats.LINK_FAIL);
        }
    }

    private String fullPatchName(OptLinkModel optLinkModel) {
        try {
            return this.getPatchName(this.nmd, optLinkModel.getFromPortModel()) + " -> " + this.getPatchName(this.nmd, optLinkModel.getToPortModel());
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    public String getPatchName(NodeModelDelegate nodeModelDelegate, PortModel portModel) {
        StringBuffer stringBuffer = new StringBuffer(50);
        if (nodeModelDelegate.isMultishelf()) {
            stringBuffer.append("Shelf ");
            stringBuffer.append(portModel.getShelfId());
            stringBuffer.append(",");
        }
        stringBuffer.append("Slot ");
        stringBuffer.append(portModel.getSlot());
        stringBuffer.append(" ");
        stringBuffer.append("(");
        stringBuffer.append(portModel.getModuleModel().getEqTypeName());
        stringBuffer.append("),");
        stringBuffer.append("Port ");
        if (portModel instanceof OpticsPortModel) {
            try {
                stringBuffer.append(portModel.getPort());
                stringBuffer.append(" (");
                stringBuffer.append(((OpticsPortModel)portModel).getOpticsLineModel().getPortTypeString());
                stringBuffer.append(")");
            }
            catch (Exception exception) {
                stringBuffer.append("N/A");
            }
        } else if (portModel instanceof PortModel) {
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            stringBuffer.append(entityCellRenderer.getPortString(portModel, false));
        }
        return stringBuffer.toString();
    }

    public void createDummyOptLink(int n, int n2) {
        OptLinkModel optLinkModel = new OptLinkModel(this.optPatchCordModel, n2, n);
        this.optCTCLinkList.add(optLinkModel);
        this.updateTable();
    }

    public void updateAll() throws AnnotatedException {
        try {
            this.unRegForEvent();
            this.getOpticalLinkList();
        }
        catch (Exception exception) {
            throw new AnnotatedException("Unable to updateAll", exception);
        }
        finally {
            this.regForEvent();
        }
    }

    public void updateTable() {
        this.updateFilteredList();
        this.fireDataSourceChanged();
    }

    public void deleteOptLink(OptLinkModel optLinkModel) throws AnnotatedException, Busy {
        boolean bl = false;
        Exception exception = null;
        try {
            if (!optLinkModel.isCtcLocal()) {
                this.optPatchCordModel.deleteOpticalLink(optLinkModel.getTo(), optLinkModel.getFrom());
            } else {
                this.optCTCLinkList.remove(optLinkModel);
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (exception != null) {
            if (exception instanceof Busy) {
                throw new Busy("Unable to delete Optical Line");
            }
            throw new AnnotatedException("Unable to delete Optical Line", exception);
        }
    }

    public void deleteLocalOptLink(int n, int n2) {
        OptLinkModel optLinkModel = null;
        Iterator iterator = this.optCTCLinkList.iterator();
        while (iterator.hasNext() && ((optLinkModel = (OptLinkModel)iterator.next()).getFrom() != n || optLinkModel.getTo() != n2)) {
        }
        if (optLinkModel == null) {
            return;
        }
        this.optCTCLinkList.remove(optLinkModel);
    }

    public void deleteOptLink(AnsConnTableModel ansConnTableModel, int[] nArray) {
        if (nArray.length == 0) {
            return;
        }
        ArrayList<OptLinkModel> arrayList = new ArrayList<OptLinkModel>();
        for (int i = 0; i < nArray.length; ++i) {
            OptLinkModel optLinkModel = (OptLinkModel)ansConnTableModel.getValueAt(nArray[i], 0);
            arrayList.add(optLinkModel);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                boolean bl = false;
                Exception exception = null;
                OptLinkModel optLinkModel = (OptLinkModel)iterator.next();
                try {
                    if (!optLinkModel.isCtcLocal()) {
                        this.optPatchCordModel.deleteOpticalLink(optLinkModel.getTo(), optLinkModel.getFrom());
                    } else {
                        this.optCTCLinkList.remove(optLinkModel);
                    }
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
                if (exception == null) continue;
                if (db.on()) {
                    db.println("Unable to removeOpticalLink: " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
            catch (Exception exception) {
                db.finest("exception in deleteOptLink" + exception);
            }
        }
        try {
            this.updateAll();
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Unable to removeOpticalLink: " + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public void calculateAutomaticOpticalLinkList() throws FeatureUnsupported, CannotPerform {
        this.optPatchCordModel.createAutomaticOpticalLinks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOpticalLinkList() {
        try {
            OptLinkModel[] optLinkModelArray = this.optPatchCordModel.getAllOptLinkModel();
            this.optLinkList.clear();
            for (int i = 0; i < optLinkModelArray.length; ++i) {
                OptLinkModel optLinkModel = optLinkModelArray[i];
                this.optLinkList.add(optLinkModel);
            }
        }
        catch (FeatureUnsupported featureUnsupported) {
            db.println("Caught FeatureUnsupported in getOpticalLinkList()");
            if (db.on()) {
                SDebug.printStackTrace((Throwable)featureUnsupported);
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.finest("Exception in getOpticalLinkList() " + (Object)((Object)abstractCmsIOException));
        }
        finally {
            this.updateTable();
        }
    }

    public void setFilter(OptLinkStats optLinkStats) {
        this.filterId = optLinkStats;
        this.updateTable();
    }

    public void dispose() {
        if (db.on()) {
            db.println("OnsConndataSource Dispose");
        }
    }

    public void update(Observable observable, Object object) {
        block3: {
            if (db.on()) {
                db.println("OnsModel::update");
            }
            try {
                this.updateAll();
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                db.println("updateAll(): exception" + exception);
            }
        }
    }

    public Object getObjectAtRow(int n) {
        return this.optFiltLinkList.get(n);
    }

    public int getRowCount() {
        return this.optFiltLinkList.size();
    }

    public Collection getAllObjects() {
        return this.optFiltLinkList;
    }

    private void updateFilteredList() {
        OptLinkModel optLinkModel;
        int n;
        this.optFiltLinkList.clear();
        for (n = 0; n < this.optLinkList.size(); ++n) {
            optLinkModel = (OptLinkModel)this.optLinkList.get(n);
            if (optLinkModel.getOptLnkState().value() == this.filterId.value()) {
                this.optFiltLinkList.add(optLinkModel);
                continue;
            }
            if (this.filterId.value() != OptLinkStats.LINK_UNDEFINED.value()) continue;
            this.optFiltLinkList.add(optLinkModel);
        }
        for (n = 0; n < this.optCTCLinkList.size(); ++n) {
            optLinkModel = (OptLinkModel)this.optCTCLinkList.get(n);
            if (optLinkModel.getOptLnkState().value() == this.filterId.value()) {
                this.optFiltLinkList.add(optLinkModel);
                continue;
            }
            if (this.filterId.value() != OptLinkStats.LINK_UNDEFINED.value()) continue;
            this.optFiltLinkList.add(optLinkModel);
        }
    }
}

