/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.idl.OpticsTopology.eNodeSetupPortAttr;
import cerent.cms.idl.OpticsTopology.eNodeSetupResult;
import cerent.cms.idl.OpticsTopology.sNodeSetupPort;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.EntityModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PortModel;
import cerent.util.ComparisonUtil;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class AnsPathColumnRenderer
extends AbstractColumnRenderer {
    public static final int SLT_ID_INDEX = 0;
    public static final int PARAM_INDEX = 1;
    public static final int STAT_INDEX = 2;
    private static final int COLUMN_NO = 3;
    private static final String OPEN = "(";
    private static final String CLOSE = ")";
    private static final String DASH = ",";
    private static final String SPACE = " ";
    private static AttributeMaps attributeMap = new AttributeMaps();
    private static final String OPT_LINK_STAT_KEY = "OpticalLinkStatusKey";
    private static final String[] nodeSetupOldResult = new String[]{"Not Regulated", "Regulated"};
    private static final String[] nodeSetupResult = new String[]{"Success-Unchanged", "Success-Changed", "Fail-Out of Range", "Not regulated-Port in IS", "Not Applicable State"};
    private static final String[] nodeSetupAttr = new String[]{"Unknown", "Working Mode", "Per Channel Power", "Gain", "Tilt", "LOS-P Thresold", "LOS-O Thresold", "Voa Target Attenuation", "Voa Target Power"};
    private JLabel label;
    private NodeModelDelegate nm;
    private Color[] status_color = new Color[]{Color.black, Color.red};

    public AnsPathColumnRenderer(NodeModelDelegate nodeModelDelegate, String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.nm = nodeModelDelegate;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        sNodeSetupPort sNodeSetupPort2;
        String string = "";
        JLabel jLabel = this.label;
        try {
            sNodeSetupPort2 = (sNodeSetupPort)object;
        }
        catch (Exception exception) {
            this.label.setText("");
            return jLabel;
        }
        Color color = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        switch (n2) {
            case 0: {
                string = this.getSlot(this.nm, sNodeSetupPort2.port);
                break;
            }
            case 1: {
                string = this.getSetupAttr(sNodeSetupPort2);
                break;
            }
            case 2: {
                string = this.getSetupResult(sNodeSetupPort2.result);
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        this.label.setToolTipText("");
        this.label.setText(string);
        ((Component)jLabel).setForeground(this.status_color[sNodeSetupPort2.success ? 0 : 1]);
        ((Component)jLabel).setBackground(color);
        return jLabel;
    }

    private String getSetupResult(eNodeSetupResult eNodeSetupResult2) {
        String string = "Unknown";
        try {
            string = nodeSetupResult[eNodeSetupResult2.value()];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private String getSetupAttr(sNodeSetupPort sNodeSetupPort2) {
        String string = "Unknown";
        try {
            string = sNodeSetupPort2.attr.value() == eNodeSetupPortAttr.PA_UNKNOWN.value() ? nodeSetupOldResult[sNodeSetupPort2.success ? 1 : 0] : nodeSetupAttr[sNodeSetupPort2.attr.value()];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private String getSlot(NodeModelDelegate nodeModelDelegate, int n) {
        OpticsPortModel opticsPortModel;
        StringBuffer stringBuffer = new StringBuffer(50);
        try {
            opticsPortModel = (OpticsPortModel)nodeModelDelegate.getEntityTable().getEntityModelByIndex(n);
        }
        catch (Exception exception) {
            return "N/A";
        }
        if (nodeModelDelegate.isMultishelf()) {
            stringBuffer.append("Shelf ");
            stringBuffer.append(opticsPortModel.getShelfId());
            stringBuffer.append(DASH);
        }
        stringBuffer.append("Slot ");
        stringBuffer.append(opticsPortModel.getSlot());
        stringBuffer.append(SPACE);
        stringBuffer.append(OPEN);
        stringBuffer.append(opticsPortModel.getModuleModel().getEqTypeName());
        stringBuffer.append(CLOSE);
        stringBuffer.append(DASH);
        stringBuffer.append("Port ");
        stringBuffer.append(opticsPortModel.getPort());
        stringBuffer.append(SPACE);
        try {
            stringBuffer.append(OPEN);
            stringBuffer.append(opticsPortModel.getOpticsLineModel().getPortTypeString());
            stringBuffer.append(CLOSE);
        }
        catch (Exception exception) {
            stringBuffer.append("N/A");
        }
        return stringBuffer.toString();
    }

    static int getSlotInt(NodeModelDelegate nodeModelDelegate, int n) {
        EntityModel entityModel = null;
        try {
            entityModel = (EntityModel)nodeModelDelegate.getEntityTableModel().getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return -1;
        }
        if (entityModel != null && entityModel instanceof PortModel) {
            return entityModel.getSlot();
        }
        return -1;
    }

    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        sNodeSetupPort sNodeSetupPort2 = (sNodeSetupPort)object;
        sNodeSetupPort sNodeSetupPort3 = (sNodeSetupPort)object2;
        switch (n) {
            case 0: {
                n2 = new Integer(sNodeSetupPort2.port).compareTo(new Integer(sNodeSetupPort3.port));
                break;
            }
            case 1: {
                n2 = ComparisonUtil.compare((Integer)new Integer(sNodeSetupPort2.attr.value()), (Integer)new Integer(sNodeSetupPort3.attr.value()));
            }
            case 2: {
                n2 = ComparisonUtil.compare((Integer)new Integer(sNodeSetupPort2.result.value()), (Integer)new Integer(sNodeSetupPort3.result.value()));
            }
        }
        return n2;
    }

    static ColumnRenderer[] createTableRenderers(NodeModelDelegate nodeModelDelegate) {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[3];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = AnsPathColumnRenderer.createColumnRenderer(nodeModelDelegate, i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(NodeModelDelegate nodeModelDelegate, int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Port";
                n3 = 400;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "Parameter";
                n3 = 200;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Link status";
                n3 = 200;
                bl = true;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new AnsPathColumnRenderer(nodeModelDelegate, string, n3, bl, n2);
    }

    public static AttributeMaps getTopologyAttributeMaps() {
        return attributeMap;
    }
}

